/* Capstone Unified Disassembler Engine */
/* By Nguyen Anh Quynh <aquynh@gmail.com>, 2013> */

#include <stdio.h>	// debug
#include <string.h>

#include "../../include/ppc.h"
#include "../../utils.h"

#include "PPCMapping.h"

#define GET_INSTRINFO_ENUM
#include "PPCGenInstrInfo.inc"

static name_map reg_name_maps[] = {
	{ PPC_REG_INVALID, NULL },

	{ PPC_REG_CARRY, "ca" },
	{ PPC_REG_CR0, "cr0" },
	{ PPC_REG_CR1, "cr1" },
	{ PPC_REG_CR2, "cr2" },
	{ PPC_REG_CR3, "cr3" },
	{ PPC_REG_CR4, "cr4" },
	{ PPC_REG_CR5, "cr5" },
	{ PPC_REG_CR6, "cr6" },
	{ PPC_REG_CR7, "cr7" },
	{ PPC_REG_CR8, "cr8" },
	{ PPC_REG_CR9, "cr9" },
	{ PPC_REG_CR10, "cr10" },
	{ PPC_REG_CR11, "cr11" },
	{ PPC_REG_CR12, "cr12" },
	{ PPC_REG_CR13, "cr13" },
	{ PPC_REG_CR14, "cr14" },
	{ PPC_REG_CR15, "cr15" },
	{ PPC_REG_CR16, "cr16" },
	{ PPC_REG_CR17, "cr17" },
	{ PPC_REG_CR18, "cr18" },
	{ PPC_REG_CR19, "cr19" },
	{ PPC_REG_CR20, "cr20" },
	{ PPC_REG_CR21, "cr21" },
	{ PPC_REG_CR22, "cr22" },
	{ PPC_REG_CR23, "cr23" },
	{ PPC_REG_CR24, "cr24" },
	{ PPC_REG_CR25, "cr25" },
	{ PPC_REG_CR26, "cr26" },
	{ PPC_REG_CR27, "cr27" },
	{ PPC_REG_CR28, "cr28" },
	{ PPC_REG_CR29, "cr29" },
	{ PPC_REG_CR30, "cr30" },
	{ PPC_REG_CR31, "cr31" },
	{ PPC_REG_CTR, "ctr" },
	{ PPC_REG_F0, "f0" },
	{ PPC_REG_F1, "f1" },
	{ PPC_REG_F2, "f2" },
	{ PPC_REG_F3, "f3" },
	{ PPC_REG_F4, "f4" },
	{ PPC_REG_F5, "f5" },
	{ PPC_REG_F6, "f6" },
	{ PPC_REG_F7, "f7" },
	{ PPC_REG_F8, "f8" },
	{ PPC_REG_F9, "f9" },
	{ PPC_REG_F10, "f10" },
	{ PPC_REG_F11, "f11" },
	{ PPC_REG_F12, "f12" },
	{ PPC_REG_F13, "f13" },
	{ PPC_REG_F14, "f14" },
	{ PPC_REG_F15, "f15" },
	{ PPC_REG_F16, "f16" },
	{ PPC_REG_F17, "f17" },
	{ PPC_REG_F18, "f18" },
	{ PPC_REG_F19, "f19" },
	{ PPC_REG_F20, "f20" },
	{ PPC_REG_F21, "f21" },
	{ PPC_REG_F22, "f22" },
	{ PPC_REG_F23, "f23" },
	{ PPC_REG_F24, "f24" },
	{ PPC_REG_F25, "f25" },
	{ PPC_REG_F26, "f26" },
	{ PPC_REG_F27, "f27" },
	{ PPC_REG_F28, "f28" },
	{ PPC_REG_F29, "f29" },
	{ PPC_REG_F30, "f30" },
	{ PPC_REG_F31, "f31" },
	{ PPC_REG_LR, "lr" },
	{ PPC_REG_R0, "r0" },
	{ PPC_REG_R1, "r1" },
	{ PPC_REG_R2, "r2" },
	{ PPC_REG_R3, "r3" },
	{ PPC_REG_R4, "r4" },
	{ PPC_REG_R5, "r5" },
	{ PPC_REG_R6, "r6" },
	{ PPC_REG_R7, "r7" },
	{ PPC_REG_R8, "r8" },
	{ PPC_REG_R9, "r9" },
	{ PPC_REG_R10, "r10" },
	{ PPC_REG_R11, "r11" },
	{ PPC_REG_R12, "r12" },
	{ PPC_REG_R13, "r13" },
	{ PPC_REG_R14, "r14" },
	{ PPC_REG_R15, "r15" },
	{ PPC_REG_R16, "r16" },
	{ PPC_REG_R17, "r17" },
	{ PPC_REG_R18, "r18" },
	{ PPC_REG_R19, "r19" },
	{ PPC_REG_R20, "r20" },
	{ PPC_REG_R21, "r21" },
	{ PPC_REG_R22, "r22" },
	{ PPC_REG_R23, "r23" },
	{ PPC_REG_R24, "r24" },
	{ PPC_REG_R25, "r25" },
	{ PPC_REG_R26, "r26" },
	{ PPC_REG_R27, "r27" },
	{ PPC_REG_R28, "r28" },
	{ PPC_REG_R29, "r29" },
	{ PPC_REG_R30, "r30" },
	{ PPC_REG_R31, "r31" },
	{ PPC_REG_V0, "v0" },
	{ PPC_REG_V1, "v1" },
	{ PPC_REG_V2, "v2" },
	{ PPC_REG_V3, "v3" },
	{ PPC_REG_V4, "v4" },
	{ PPC_REG_V5, "v5" },
	{ PPC_REG_V6, "v6" },
	{ PPC_REG_V7, "v7" },
	{ PPC_REG_V8, "v8" },
	{ PPC_REG_V9, "v9" },
	{ PPC_REG_V10, "v10" },
	{ PPC_REG_V11, "v11" },
	{ PPC_REG_V12, "v12" },
	{ PPC_REG_V13, "v13" },
	{ PPC_REG_V14, "v14" },
	{ PPC_REG_V15, "v15" },
	{ PPC_REG_V16, "v16" },
	{ PPC_REG_V17, "v17" },
	{ PPC_REG_V18, "v18" },
	{ PPC_REG_V19, "v19" },
	{ PPC_REG_V20, "v20" },
	{ PPC_REG_V21, "v21" },
	{ PPC_REG_V22, "v22" },
	{ PPC_REG_V23, "v23" },
	{ PPC_REG_V24, "v24" },
	{ PPC_REG_V25, "v25" },
	{ PPC_REG_V26, "v26" },
	{ PPC_REG_V27, "v27" },
	{ PPC_REG_V28, "v28" },
	{ PPC_REG_V29, "v29" },
	{ PPC_REG_V30, "v30" },
	{ PPC_REG_V31, "v31" },
	{ PPC_REG_VRSAVE, "vrsave" },

	// extras
	{ PPC_REG_RM, "rm" },
	{ PPC_REG_CTR8, "ctr8" },
	{ PPC_REG_LR8, "lr8" },
	{ PPC_REG_CR1EQ, "cr1eq" },
};

const char *PPC_reg_name(csh handle, unsigned int reg)
{
	if (reg >= PPC_REG_MAX)
		return NULL;

	return reg_name_maps[reg].name;
}

static insn_map insns[] = {
	{ 0, 0, { 0 }, { 0 }, { 0 }, 0, 0 },	// dummy item

	{ PPC_ADD4, PPC_INS_ADD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ADD4TLS, PPC_INS_ADD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ADD4o, PPC_INS_ADD, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ADD8, PPC_INS_ADD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ADD8TLS, PPC_INS_ADD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ADD8TLS_, PPC_INS_ADD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ADD8o, PPC_INS_ADD, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDC, PPC_INS_ADDC, { 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDC8, PPC_INS_ADDC, { 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDC8o, PPC_INS_ADDC, { 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDCo, PPC_INS_ADDC, { 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDE, PPC_INS_ADDE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDE8, PPC_INS_ADDE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDE8o, PPC_INS_ADDE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDEo, PPC_INS_ADDE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDI, PPC_INS_ADDI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ADDI8, PPC_INS_ADDI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ADDIC, PPC_INS_ADDIC, { 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDIC8, PPC_INS_ADDIC, { 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDICo, PPC_INS_ADDIC, { 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDIS, PPC_INS_ADDIS, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ADDIS8, PPC_INS_ADDIS, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ADDME, PPC_INS_ADDME, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDME8, PPC_INS_ADDME, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDME8o, PPC_INS_ADDME, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDMEo, PPC_INS_ADDME, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDZE, PPC_INS_ADDZE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDZE8, PPC_INS_ADDZE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDZE8o, PPC_INS_ADDZE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ADDZEo, PPC_INS_ADDZE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_AND, PPC_INS_AND, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_AND8, PPC_INS_AND, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_AND8o, PPC_INS_AND, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ANDC, PPC_INS_ANDC, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ANDC8, PPC_INS_ANDC, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ANDC8o, PPC_INS_ANDC, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ANDCo, PPC_INS_ANDC, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ANDISo, PPC_INS_ANDIS, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ANDISo8, PPC_INS_ANDIS, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ANDIo, PPC_INS_ANDI, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ANDIo8, PPC_INS_ANDI, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ANDo, PPC_INS_AND, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_B, PPC_INS_B, { 0 }, { 0 }, { 0 }, 1, 0 },
	{ PPC_BA, PPC_INS_BA, { 0 }, { 0 }, { 0 }, 1, 0 },
	{ PPC_BCC, PPC_INS_B, { 0 }, { 0 }, { 0 }, 1, 0 },
	{ PPC_BCCA, PPC_INS_B, { 0 }, { 0 }, { 0 }, 1, 0 },
	{ PPC_BCCL, PPC_INS_B, { PPC_REG_RM, 0 }, { PPC_REG_LR, 0 }, { 0 }, 0, 0 },
	{ PPC_BCCLA, PPC_INS_B, { PPC_REG_RM, 0 }, { PPC_REG_LR, 0 }, { 0 }, 0, 0 },
	{ PPC_BCCTR, PPC_INS_B, { PPC_REG_CTR, 0 }, { 0 }, { 0 }, 1, 1 },
	{ PPC_BCCTR8, PPC_INS_B, { PPC_REG_CTR8, 0 }, { 0 }, { PPC_GRP_MODE64, 0 }, 1, 1 },
	{ PPC_BCCTRL, PPC_INS_B, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_LR, 0 }, { 0 }, 0, 0 },
	{ PPC_BCCTRL8, PPC_INS_B, { PPC_REG_CTR8, PPC_REG_RM, 0 }, { PPC_REG_LR8, 0 }, { PPC_GRP_MODE64, 0 }, 0, 0 },
	{ PPC_BCLR, PPC_INS_B, { PPC_REG_LR, PPC_REG_RM, 0 }, { 0 }, { 0 }, 1, 0 },
	{ PPC_BCLRL, PPC_INS_B, { PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_LR, 0 }, { 0 }, 0, 0 },
	{ PPC_BCLalways, PPC_INS_BCL, { PPC_REG_RM, 0 }, { PPC_REG_LR, 0 }, { 0 }, 0, 0 },
	{ PPC_BCTR, PPC_INS_BCTR, { PPC_REG_CTR, 0 }, { 0 }, { 0 }, 1, 1 },
	{ PPC_BCTR8, PPC_INS_BCTR, { PPC_REG_CTR8, 0 }, { 0 }, { PPC_GRP_MODE64, 0 }, 1, 1 },
	{ PPC_BCTRL, PPC_INS_BCTRL, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_LR, 0 }, { PPC_GRP_MODE32, 0 }, 0, 0 },
	{ PPC_BCTRL8, PPC_INS_BCTRL, { PPC_REG_CTR8, PPC_REG_RM, 0 }, { PPC_REG_LR8, 0 }, { PPC_GRP_MODE64, 0 }, 0, 0 },
	{ PPC_BDNZ, PPC_INS_BDNZ, { PPC_REG_CTR, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDNZ8, PPC_INS_BDNZ, { PPC_REG_CTR8, 0 }, { PPC_REG_CTR8, 0 }, { 0 }, 1, 0 },
	{ PPC_BDNZA, PPC_INS_BDNZA, { PPC_REG_CTR, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDNZAm, PPC_INS_BDNZA, { PPC_REG_CTR, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDNZAp, PPC_INS_BDNZA, { PPC_REG_CTR, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDNZL, PPC_INS_BDNZL, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDNZLA, PPC_INS_BDNZLA, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDNZLAm, PPC_INS_BDNZLA, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDNZLAp, PPC_INS_BDNZLA, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDNZLR, PPC_INS_BDNZLR, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDNZLR8, PPC_INS_BDNZLR, { PPC_REG_CTR8, PPC_REG_LR8, PPC_REG_RM, 0 }, { PPC_REG_CTR8, 0 }, { 0 }, 1, 0 },
	{ PPC_BDNZLRL, PPC_INS_BDNZLRL, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDNZLRLm, PPC_INS_BDNZLRL, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDNZLRLp, PPC_INS_BDNZLRL, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDNZLRm, PPC_INS_BDNZLR, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDNZLRp, PPC_INS_BDNZLR, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDNZLm, PPC_INS_BDNZL, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDNZLp, PPC_INS_BDNZL, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDNZm, PPC_INS_BDNZ, { PPC_REG_CTR, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDNZp, PPC_INS_BDNZ, { PPC_REG_CTR, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDZ, PPC_INS_BDZ, { PPC_REG_CTR, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDZ8, PPC_INS_BDZ, { PPC_REG_CTR8, 0 }, { PPC_REG_CTR8, 0 }, { 0 }, 1, 0 },
	{ PPC_BDZA, PPC_INS_BDZA, { PPC_REG_CTR, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDZAm, PPC_INS_BDZA, { PPC_REG_CTR, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDZAp, PPC_INS_BDZA, { PPC_REG_CTR, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDZL, PPC_INS_BDZL, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDZLA, PPC_INS_BDZLA, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDZLAm, PPC_INS_BDZLA, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDZLAp, PPC_INS_BDZLA, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDZLR, PPC_INS_BDZLR, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDZLR8, PPC_INS_BDZLR, { PPC_REG_CTR8, PPC_REG_LR8, PPC_REG_RM, 0 }, { PPC_REG_CTR8, 0 }, { 0 }, 1, 0 },
	{ PPC_BDZLRL, PPC_INS_BDZLRL, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDZLRLm, PPC_INS_BDZLRL, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDZLRLp, PPC_INS_BDZLRL, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDZLRm, PPC_INS_BDZLR, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDZLRp, PPC_INS_BDZLR, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDZLm, PPC_INS_BDZL, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDZLp, PPC_INS_BDZL, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_BDZm, PPC_INS_BDZ, { PPC_REG_CTR, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BDZp, PPC_INS_BDZ, { PPC_REG_CTR, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 1, 0 },
	{ PPC_BL, PPC_INS_BL, { PPC_REG_RM, 0 }, { PPC_REG_LR, 0 }, { 0 }, 0, 0 },
	{ PPC_BL8, PPC_INS_BL, { PPC_REG_RM, 0 }, { PPC_REG_LR8, 0 }, { 0 }, 0, 0 },
	{ PPC_BL8_NOP, PPC_INS_BL, { PPC_REG_RM, 0 }, { PPC_REG_LR8, 0 }, { 0 }, 0, 0 },
	{ PPC_BL8_NOP_TLS, PPC_INS_BL, { PPC_REG_RM, 0 }, { PPC_REG_LR8, 0 }, { 0 }, 0, 0 },
	{ PPC_BL8_TLS, PPC_INS_BL, { PPC_REG_RM, 0 }, { PPC_REG_LR8, 0 }, { 0 }, 0, 0 },
	{ PPC_BL8_TLS_, PPC_INS_BL, { PPC_REG_RM, 0 }, { PPC_REG_LR8, 0 }, { 0 }, 0, 0 },
	{ PPC_BLA, PPC_INS_BLA, { PPC_REG_RM, 0 }, { PPC_REG_LR, 0 }, { 0 }, 0, 0 },
	{ PPC_BLA8, PPC_INS_BLA, { PPC_REG_RM, 0 }, { PPC_REG_LR8, 0 }, { 0 }, 0, 0 },
	{ PPC_BLA8_NOP, PPC_INS_BLA, { PPC_REG_RM, 0 }, { PPC_REG_LR8, 0 }, { 0 }, 0, 0 },
	{ PPC_BLR, PPC_INS_BLR, { PPC_REG_LR, PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_BLRL, PPC_INS_BLRL, { PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_LR, 0 }, { 0 }, 0, 0 },
	{ PPC_CMPD, PPC_INS_CMPD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CMPDI, PPC_INS_CMPDI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CMPLD, PPC_INS_CMPLD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CMPLDI, PPC_INS_CMPLDI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CMPLW, PPC_INS_CMPLW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CMPLWI, PPC_INS_CMPLWI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CMPW, PPC_INS_CMPW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CMPWI, PPC_INS_CMPWI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CNTLZD, PPC_INS_CNTLZD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CNTLZDo, PPC_INS_CNTLZD, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_CNTLZW, PPC_INS_CNTLZW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CNTLZWo, PPC_INS_CNTLZW, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_CR6SET, PPC_INS_CREQV, { 0 }, { PPC_REG_CR1EQ, 0 }, { 0 }, 0, 0 },
	{ PPC_CR6UNSET, PPC_INS_CRXOR, { 0 }, { PPC_REG_CR1EQ, 0 }, { 0 }, 0, 0 },
	{ PPC_CRAND, PPC_INS_CRAND, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CRANDC, PPC_INS_CRANDC, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CREQV, PPC_INS_CREQV, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CRNAND, PPC_INS_CRNAND, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CRNOR, PPC_INS_CRNOR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CROR, PPC_INS_CROR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CRORC, PPC_INS_CRORC, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CRSET, PPC_INS_CREQV, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CRUNSET, PPC_INS_CRXOR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_CRXOR, PPC_INS_CRXOR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_DCBA, PPC_INS_DCBA, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_DCBF, PPC_INS_DCBF, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_DCBI, PPC_INS_DCBI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_DCBST, PPC_INS_DCBST, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_DCBT, PPC_INS_DCBT, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_DCBTST, PPC_INS_DCBTST, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_DCBZ, PPC_INS_DCBZ, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_DCBZL, PPC_INS_DCBZL, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_DIVD, PPC_INS_DIVD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_DIVDU, PPC_INS_DIVDU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_DIVDUo, PPC_INS_DIVDU, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_DIVDo, PPC_INS_DIVD, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_DIVW, PPC_INS_DIVW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_DIVWU, PPC_INS_DIVWU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_DIVWUo, PPC_INS_DIVWU, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_DIVWo, PPC_INS_DIVW, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_DSS, PPC_INS_DSS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_DSSALL, PPC_INS_DSSALL, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_DST, PPC_INS_DST, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_DST64, PPC_INS_DST, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_DSTST, PPC_INS_DSTST, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_DSTST64, PPC_INS_DSTST, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_DSTSTT, PPC_INS_DSTSTT, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_DSTSTT64, PPC_INS_DSTSTT, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_DSTT, PPC_INS_DSTT, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_DSTT64, PPC_INS_DSTT, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_EIEIO, PPC_INS_EIEIO, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_EQV, PPC_INS_EQV, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_EQV8, PPC_INS_EQV, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_EQV8o, PPC_INS_EQV, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_EQVo, PPC_INS_EQV, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_EXTSB, PPC_INS_EXTSB, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_EXTSB8, PPC_INS_EXTSB, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_EXTSB8_32_64, PPC_INS_EXTSB, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_EXTSB8o, PPC_INS_EXTSB, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_EXTSBo, PPC_INS_EXTSB, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_EXTSH, PPC_INS_EXTSH, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_EXTSH8, PPC_INS_EXTSH, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_EXTSH8_32_64, PPC_INS_EXTSH, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_EXTSH8o, PPC_INS_EXTSH, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_EXTSHo, PPC_INS_EXTSH, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_EXTSW, PPC_INS_EXTSW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_EXTSW_32_64, PPC_INS_EXTSW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_EXTSW_32_64o, PPC_INS_EXTSW, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_EXTSWo, PPC_INS_EXTSW, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_FABSD, PPC_INS_FABS, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FABSDo, PPC_INS_FABS, { 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FABSS, PPC_INS_FABS, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FABSSo, PPC_INS_FABS, { 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FADD, PPC_INS_FADD, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FADDS, PPC_INS_FADDS, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FADDSo, PPC_INS_FADDS, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FADDo, PPC_INS_FADD, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FCFID, PPC_INS_FCFID, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FCFIDS, PPC_INS_FCFIDS, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FCFIDSo, PPC_INS_FCFIDS, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FCFIDU, PPC_INS_FCFIDU, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FCFIDUS, PPC_INS_FCFIDUS, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FCFIDUSo, PPC_INS_FCFIDUS, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FCFIDUo, PPC_INS_FCFIDU, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FCFIDo, PPC_INS_FCFID, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FCMPUD, PPC_INS_FCMPU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FCMPUS, PPC_INS_FCMPU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FCPSGND, PPC_INS_FCPSGN, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FCPSGNDo, PPC_INS_FCPSGN, { 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FCPSGNS, PPC_INS_FCPSGN, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FCPSGNSo, PPC_INS_FCPSGN, { 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FCTID, PPC_INS_FCTID, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FCTIDUZ, PPC_INS_FCTIDUZ, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FCTIDUZo, PPC_INS_FCTIDUZ, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FCTIDZ, PPC_INS_FCTIDZ, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FCTIDZo, PPC_INS_FCTIDZ, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FCTIDo, PPC_INS_FCTID, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FCTIW, PPC_INS_FCTIW, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FCTIWUZ, PPC_INS_FCTIWUZ, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FCTIWUZo, PPC_INS_FCTIWUZ, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FCTIWZ, PPC_INS_FCTIWZ, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FCTIWZo, PPC_INS_FCTIWZ, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FCTIWo, PPC_INS_FCTIW, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FDIV, PPC_INS_FDIV, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FDIVS, PPC_INS_FDIVS, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FDIVSo, PPC_INS_FDIVS, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FDIVo, PPC_INS_FDIV, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FMADD, PPC_INS_FMADD, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FMADDS, PPC_INS_FMADDS, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FMADDSo, PPC_INS_FMADDS, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FMADDo, PPC_INS_FMADD, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FMSUB, PPC_INS_FMSUB, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FMSUBS, PPC_INS_FMSUBS, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FMSUBSo, PPC_INS_FMSUBS, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FMSUBo, PPC_INS_FMSUB, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FMUL, PPC_INS_FMUL, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FMULS, PPC_INS_FMULS, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FMULSo, PPC_INS_FMULS, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FMULo, PPC_INS_FMUL, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FNABSD, PPC_INS_FNABS, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FNABSDo, PPC_INS_FNABS, { 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FNABSS, PPC_INS_FNABS, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FNABSSo, PPC_INS_FNABS, { 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FNEGD, PPC_INS_FNEG, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FNEGDo, PPC_INS_FNEG, { 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FNEGS, PPC_INS_FNEG, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FNEGSo, PPC_INS_FNEG, { 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FNMADD, PPC_INS_FNMADD, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FNMADDS, PPC_INS_FNMADDS, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FNMADDSo, PPC_INS_FNMADDS, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FNMADDo, PPC_INS_FNMADD, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FNMSUB, PPC_INS_FNMSUB, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FNMSUBS, PPC_INS_FNMSUBS, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FNMSUBSo, PPC_INS_FNMSUBS, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FNMSUBo, PPC_INS_FNMSUB, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FRE, PPC_INS_FRE, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FRES, PPC_INS_FRES, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FRESo, PPC_INS_FRES, { 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FREo, PPC_INS_FRE, { 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FRIMD, PPC_INS_FRIM, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FRIMDo, PPC_INS_FRIM, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FRIMS, PPC_INS_FRIM, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FRIMSo, PPC_INS_FRIM, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FRIND, PPC_INS_FRIN, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FRINDo, PPC_INS_FRIN, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FRINS, PPC_INS_FRIN, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FRINSo, PPC_INS_FRIN, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FRIPD, PPC_INS_FRIP, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FRIPDo, PPC_INS_FRIP, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FRIPS, PPC_INS_FRIP, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FRIPSo, PPC_INS_FRIP, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FRIZD, PPC_INS_FRIZ, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FRIZDo, PPC_INS_FRIZ, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FRIZS, PPC_INS_FRIZ, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FRIZSo, PPC_INS_FRIZ, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FRSP, PPC_INS_FRSP, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FRSPo, PPC_INS_FRSP, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FRSQRTE, PPC_INS_FRSQRTE, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FRSQRTES, PPC_INS_FRSQRTES, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FRSQRTESo, PPC_INS_FRSQRTES, { 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FRSQRTEo, PPC_INS_FRSQRTE, { 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FSELD, PPC_INS_FSEL, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FSELDo, PPC_INS_FSEL, { 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FSELS, PPC_INS_FSEL, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FSELSo, PPC_INS_FSEL, { 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FSQRT, PPC_INS_FSQRT, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FSQRTS, PPC_INS_FSQRTS, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FSQRTSo, PPC_INS_FSQRTS, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FSQRTo, PPC_INS_FSQRT, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FSUB, PPC_INS_FSUB, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FSUBS, PPC_INS_FSUBS, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_FSUBSo, PPC_INS_FSUBS, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_FSUBo, PPC_INS_FSUB, { PPC_REG_RM, 0 }, { PPC_REG_CR1, 0 }, { 0 }, 0, 0 },
	{ PPC_ICBI, PPC_INS_ICBI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ISEL, PPC_INS_ISEL, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ISEL8, PPC_INS_ISEL, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ISYNC, PPC_INS_ISYNC, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LA, PPC_INS_LA, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LBZ, PPC_INS_LBZ, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LBZ8, PPC_INS_LBZ, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LBZU, PPC_INS_LBZU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LBZU8, PPC_INS_LBZU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LBZUX, PPC_INS_LBZUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LBZUX8, PPC_INS_LBZUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LBZX, PPC_INS_LBZX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LBZX8, PPC_INS_LBZX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LD, PPC_INS_LD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LDARX, PPC_INS_LDARX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LDBRX, PPC_INS_LDBRX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LDU, PPC_INS_LDU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LDUX, PPC_INS_LDUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LDX, PPC_INS_LDX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LDinto_toc, PPC_INS_LD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LDtoc_restore, PPC_INS_LD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LFD, PPC_INS_LFD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LFDU, PPC_INS_LFDU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LFDUX, PPC_INS_LFDUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LFDX, PPC_INS_LFDX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LFIWAX, PPC_INS_LFIWAX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LFIWZX, PPC_INS_LFIWZX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LFS, PPC_INS_LFS, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LFSU, PPC_INS_LFSU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LFSUX, PPC_INS_LFSUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LFSX, PPC_INS_LFSX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHA, PPC_INS_LHA, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHA8, PPC_INS_LHA, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHAU, PPC_INS_LHAU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHAU8, PPC_INS_LHAU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHAUX, PPC_INS_LHAUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHAUX8, PPC_INS_LHAUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHAX, PPC_INS_LHAX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHAX8, PPC_INS_LHAX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHBRX, PPC_INS_LHBRX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHZ, PPC_INS_LHZ, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHZ8, PPC_INS_LHZ, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHZU, PPC_INS_LHZU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHZU8, PPC_INS_LHZU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHZUX, PPC_INS_LHZUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHZUX8, PPC_INS_LHZUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHZX, PPC_INS_LHZX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LHZX8, PPC_INS_LHZX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LI, PPC_INS_LI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LI8, PPC_INS_LI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LIS, PPC_INS_LIS, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LIS8, PPC_INS_LIS, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LMW, PPC_INS_LMW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LVEBX, PPC_INS_LVEBX, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_LVEHX, PPC_INS_LVEHX, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_LVEWX, PPC_INS_LVEWX, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_LVSL, PPC_INS_LVSL, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_LVSR, PPC_INS_LVSR, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_LVX, PPC_INS_LVX, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_LVXL, PPC_INS_LVXL, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_LWA, PPC_INS_LWA, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LWARX, PPC_INS_LWARX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LWAUX, PPC_INS_LWAUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LWAX, PPC_INS_LWAX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LWAX_32, PPC_INS_LWAX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LWA_32, PPC_INS_LWA, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LWBRX, PPC_INS_LWBRX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LWZ, PPC_INS_LWZ, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LWZ8, PPC_INS_LWZ, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LWZU, PPC_INS_LWZU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LWZU8, PPC_INS_LWZU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LWZUX, PPC_INS_LWZUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LWZUX8, PPC_INS_LWZUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LWZX, PPC_INS_LWZX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_LWZX8, PPC_INS_LWZX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MCRF, PPC_INS_MCRF, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFCR, PPC_INS_MFCR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFCR8, PPC_INS_MFCR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFCTR, PPC_INS_MFCTR, { PPC_REG_CTR, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFCTR8, PPC_INS_MFCTR, { PPC_REG_CTR8, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFFS, PPC_INS_MFFS, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFLR, PPC_INS_MFLR, { PPC_REG_LR, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFLR8, PPC_INS_MFLR, { PPC_REG_LR8, 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFMSR, PPC_INS_MFMSR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFOCRF, PPC_INS_MFOCRF, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFOCRF8, PPC_INS_MFOCRF, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFSPR, PPC_INS_MFSPR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFTB, PPC_INS_MFTB, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFTB8, PPC_INS_MFSPR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFVRSAVE, PPC_INS_MFSPR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFVRSAVEv, PPC_INS_MFSPR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MFVSCR, PPC_INS_MFVSCR, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_MTCRF, PPC_INS_MTCRF, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MTCRF8, PPC_INS_MTCRF, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MTCTR, PPC_INS_MTCTR, { 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_MTCTR8, PPC_INS_MTCTR, { 0 }, { PPC_REG_CTR8, 0 }, { 0 }, 0, 0 },
	{ PPC_MTCTR8loop, PPC_INS_MTCTR, { 0 }, { PPC_REG_CTR8, 0 }, { 0 }, 0, 0 },
	{ PPC_MTCTRloop, PPC_INS_MTCTR, { 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_MTFSB0, PPC_INS_MTFSB0, { PPC_REG_RM, 0 }, { PPC_REG_RM, 0 }, { 0 }, 0, 0 },
	{ PPC_MTFSB1, PPC_INS_MTFSB1, { PPC_REG_RM, 0 }, { PPC_REG_RM, 0 }, { 0 }, 0, 0 },
	{ PPC_MTFSF, PPC_INS_MTFSF, { PPC_REG_RM, 0 }, { PPC_REG_RM, 0 }, { 0 }, 0, 0 },
	{ PPC_MTLR, PPC_INS_MTLR, { 0 }, { PPC_REG_LR, 0 }, { 0 }, 0, 0 },
	{ PPC_MTLR8, PPC_INS_MTLR, { 0 }, { PPC_REG_LR8, 0 }, { 0 }, 0, 0 },
	{ PPC_MTMSR, PPC_INS_MTMSR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MTMSRD, PPC_INS_MTMSRD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MTOCRF, PPC_INS_MTOCRF, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MTOCRF8, PPC_INS_MTOCRF, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MTSPR, PPC_INS_MTSPR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MTVRSAVE, PPC_INS_MTSPR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MTVRSAVEv, PPC_INS_MTSPR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MTVSCR, PPC_INS_MTVSCR, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_MULHD, PPC_INS_MULHD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MULHDU, PPC_INS_MULHDU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MULHDUo, PPC_INS_MULHDU, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_MULHDo, PPC_INS_MULHD, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_MULHW, PPC_INS_MULHW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MULHWU, PPC_INS_MULHWU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MULHWUo, PPC_INS_MULHWU, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_MULHWo, PPC_INS_MULHW, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_MULLD, PPC_INS_MULLD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MULLDo, PPC_INS_MULLD, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_MULLI, PPC_INS_MULLI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MULLI8, PPC_INS_MULLI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MULLW, PPC_INS_MULLW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_MULLWo, PPC_INS_MULLW, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_NAND, PPC_INS_NAND, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_NAND8, PPC_INS_NAND, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_NAND8o, PPC_INS_NAND, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_NANDo, PPC_INS_NAND, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_NEG, PPC_INS_NEG, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_NEG8, PPC_INS_NEG, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_NEG8o, PPC_INS_NEG, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_NEGo, PPC_INS_NEG, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_NOP, PPC_INS_NOP, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_NOP_GT_PWR6, PPC_INS_ORI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_NOP_GT_PWR7, PPC_INS_ORI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_NOR, PPC_INS_NOR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_NOR8, PPC_INS_NOR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_NOR8o, PPC_INS_NOR, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_NORo, PPC_INS_NOR, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_OR, PPC_INS_OR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_OR8, PPC_INS_OR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_OR8o, PPC_INS_OR, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ORC, PPC_INS_ORC, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ORC8, PPC_INS_ORC, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ORC8o, PPC_INS_ORC, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ORCo, PPC_INS_ORC, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_ORI, PPC_INS_ORI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ORI8, PPC_INS_ORI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ORIS, PPC_INS_ORIS, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ORIS8, PPC_INS_ORIS, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_ORo, PPC_INS_OR, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_POPCNTD, PPC_INS_POPCNTD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_POPCNTW, PPC_INS_POPCNTW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_RLDCL, PPC_INS_RLDCL, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_RLDCLo, PPC_INS_RLDCL, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_RLDCR, PPC_INS_RLDCR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_RLDCRo, PPC_INS_RLDCR, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_RLDIC, PPC_INS_RLDIC, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_RLDICL, PPC_INS_RLDICL, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_RLDICL_32_64, PPC_INS_RLDICL, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_RLDICLo, PPC_INS_RLDICL, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_RLDICR, PPC_INS_RLDICR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_RLDICRo, PPC_INS_RLDICR, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_RLDICo, PPC_INS_RLDIC, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_RLDIMI, PPC_INS_RLDIMI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_RLDIMIo, PPC_INS_RLDIMI, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_RLWIMI, PPC_INS_RLWIMI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_RLWIMIo, PPC_INS_RLWIMI, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_RLWINM, PPC_INS_RLWINM, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_RLWINM8, PPC_INS_RLWINM, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_RLWINM8o, PPC_INS_RLWINM, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_RLWINMo, PPC_INS_RLWINM, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_RLWNM, PPC_INS_RLWNM, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_RLWNMo, PPC_INS_RLWNM, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SC, PPC_INS_SC, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_SLBIA, PPC_INS_SLBIA, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_SLBIE, PPC_INS_SLBIE, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_SLBMFEE, PPC_INS_SLBMFEE, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_SLBMTE, PPC_INS_SLBMTE, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_SLD, PPC_INS_SLD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_SLDo, PPC_INS_SLD, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SLW, PPC_INS_SLW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_SLWo, PPC_INS_SLW, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SRAD, PPC_INS_SRAD, { 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_SRADI, PPC_INS_SRADI, { 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_SRADIo, PPC_INS_SRADI, { 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SRADo, PPC_INS_SRAD, { 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SRAW, PPC_INS_SRAW, { 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_SRAWI, PPC_INS_SRAWI, { 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_SRAWIo, PPC_INS_SRAWI, { 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SRAWo, PPC_INS_SRAW, { 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SRD, PPC_INS_SRD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_SRDo, PPC_INS_SRD, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SRW, PPC_INS_SRW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_SRWo, PPC_INS_SRW, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_STB, PPC_INS_STB, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STB8, PPC_INS_STB, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STBU, PPC_INS_STBU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STBU8, PPC_INS_STBU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STBUX, PPC_INS_STBUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STBUX8, PPC_INS_STBUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STBX, PPC_INS_STBX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STBX8, PPC_INS_STBX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STD, PPC_INS_STD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STDBRX, PPC_INS_STDBRX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STDCX, PPC_INS_STDCX, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_STDU, PPC_INS_STDU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STDUX, PPC_INS_STDUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STDX, PPC_INS_STDX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STFD, PPC_INS_STFD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STFDU, PPC_INS_STFDU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STFDUX, PPC_INS_STFDUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STFDX, PPC_INS_STFDX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STFIWX, PPC_INS_STFIWX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STFS, PPC_INS_STFS, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STFSU, PPC_INS_STFSU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STFSUX, PPC_INS_STFSUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STFSX, PPC_INS_STFSX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STH, PPC_INS_STH, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STH8, PPC_INS_STH, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STHBRX, PPC_INS_STHBRX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STHU, PPC_INS_STHU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STHU8, PPC_INS_STHU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STHUX, PPC_INS_STHUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STHUX8, PPC_INS_STHUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STHX, PPC_INS_STHX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STHX8, PPC_INS_STHX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STMW, PPC_INS_STMW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STVEBX, PPC_INS_STVEBX, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_STVEHX, PPC_INS_STVEHX, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_STVEWX, PPC_INS_STVEWX, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_STVX, PPC_INS_STVX, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_STVXL, PPC_INS_STVXL, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_STW, PPC_INS_STW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STW8, PPC_INS_STW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STWBRX, PPC_INS_STWBRX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STWCX, PPC_INS_STWCX, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_STWU, PPC_INS_STWU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STWU8, PPC_INS_STWU, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STWUX, PPC_INS_STWUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STWUX8, PPC_INS_STWUX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STWX, PPC_INS_STWX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_STWX8, PPC_INS_STWX, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_SUBF, PPC_INS_SUBF, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_SUBF8, PPC_INS_SUBF, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_SUBF8o, PPC_INS_SUBF, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFC, PPC_INS_SUBFC, { 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFC8, PPC_INS_SUBFC, { 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFC8o, PPC_INS_SUBFC, { 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFCo, PPC_INS_SUBFC, { 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFE, PPC_INS_SUBFE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFE8, PPC_INS_SUBFE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFE8o, PPC_INS_SUBFE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFEo, PPC_INS_SUBFE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFIC, PPC_INS_SUBFIC, { 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFIC8, PPC_INS_SUBFIC, { 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFME, PPC_INS_SUBFME, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFME8, PPC_INS_SUBFME, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFME8o, PPC_INS_SUBFME, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFMEo, PPC_INS_SUBFME, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFZE, PPC_INS_SUBFZE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFZE8, PPC_INS_SUBFZE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFZE8o, PPC_INS_SUBFZE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFZEo, PPC_INS_SUBFZE, { PPC_REG_CARRY, 0 }, { PPC_REG_CARRY, PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SUBFo, PPC_INS_SUBF, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_SYNC, PPC_INS_SYNC, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_TAILB, PPC_INS_B, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 1, 0 },
	{ PPC_TAILB8, PPC_INS_B, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 1, 0 },
	{ PPC_TAILBA, PPC_INS_BA, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 1, 0 },
	{ PPC_TAILBA8, PPC_INS_BA, { PPC_REG_RM, 0 }, { 0 }, { 0 }, 1, 0 },
	{ PPC_TAILBCTR, PPC_INS_BCTR, { PPC_REG_CTR, PPC_REG_RM, 0 }, { 0 }, { PPC_GRP_MODE32, 0 }, 1, 1 },
	{ PPC_TAILBCTR8, PPC_INS_BCTR, { PPC_REG_CTR8, PPC_REG_RM, 0 }, { 0 }, { PPC_GRP_MODE64, 0 }, 1, 1 },
	{ PPC_TD, PPC_INS_TD, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_TDI, PPC_INS_TDI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_TLBIE, PPC_INS_TLBIE, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_TLBIEL, PPC_INS_TLBIEL, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_TLBSYNC, PPC_INS_TLBSYNC, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_TRAP, PPC_INS_TRAP, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_TW, PPC_INS_TW, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_TWI, PPC_INS_TWI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_VADDCUW, PPC_INS_VADDCUW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VADDFP, PPC_INS_VADDFP, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VADDSBS, PPC_INS_VADDSBS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VADDSHS, PPC_INS_VADDSHS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VADDSWS, PPC_INS_VADDSWS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VADDUBM, PPC_INS_VADDUBM, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VADDUBS, PPC_INS_VADDUBS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VADDUHM, PPC_INS_VADDUHM, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VADDUHS, PPC_INS_VADDUHS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VADDUWM, PPC_INS_VADDUWM, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VADDUWS, PPC_INS_VADDUWS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VAND, PPC_INS_VAND, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VANDC, PPC_INS_VANDC, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VAVGSB, PPC_INS_VAVGSB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VAVGSH, PPC_INS_VAVGSH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VAVGSW, PPC_INS_VAVGSW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VAVGUB, PPC_INS_VAVGUB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VAVGUH, PPC_INS_VAVGUH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VAVGUW, PPC_INS_VAVGUW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCFSX, PPC_INS_VCFSX, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCFSX_0, PPC_INS_VCFSX, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCFUX, PPC_INS_VCFUX, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCFUX_0, PPC_INS_VCFUX, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPBFP, PPC_INS_VCMPBFP, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPBFPo, PPC_INS_VCMPBFP, { 0 }, { PPC_REG_CR6, 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPEQFP, PPC_INS_VCMPEQFP, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPEQFPo, PPC_INS_VCMPEQFP, { 0 }, { PPC_REG_CR6, 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPEQUB, PPC_INS_VCMPEQUB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPEQUBo, PPC_INS_VCMPEQUB, { 0 }, { PPC_REG_CR6, 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPEQUH, PPC_INS_VCMPEQUH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPEQUHo, PPC_INS_VCMPEQUH, { 0 }, { PPC_REG_CR6, 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPEQUW, PPC_INS_VCMPEQUW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPEQUWo, PPC_INS_VCMPEQUW, { 0 }, { PPC_REG_CR6, 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGEFP, PPC_INS_VCMPGEFP, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGEFPo, PPC_INS_VCMPGEFP, { 0 }, { PPC_REG_CR6, 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGTFP, PPC_INS_VCMPGTFP, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGTFPo, PPC_INS_VCMPGTFP, { 0 }, { PPC_REG_CR6, 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGTSB, PPC_INS_VCMPGTSB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGTSBo, PPC_INS_VCMPGTSB, { 0 }, { PPC_REG_CR6, 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGTSH, PPC_INS_VCMPGTSH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGTSHo, PPC_INS_VCMPGTSH, { 0 }, { PPC_REG_CR6, 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGTSW, PPC_INS_VCMPGTSW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGTSWo, PPC_INS_VCMPGTSW, { 0 }, { PPC_REG_CR6, 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGTUB, PPC_INS_VCMPGTUB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGTUBo, PPC_INS_VCMPGTUB, { 0 }, { PPC_REG_CR6, 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGTUH, PPC_INS_VCMPGTUH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGTUHo, PPC_INS_VCMPGTUH, { 0 }, { PPC_REG_CR6, 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGTUW, PPC_INS_VCMPGTUW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCMPGTUWo, PPC_INS_VCMPGTUW, { 0 }, { PPC_REG_CR6, 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCTSXS, PPC_INS_VCTSXS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCTSXS_0, PPC_INS_VCTSXS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCTUXS, PPC_INS_VCTUXS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VCTUXS_0, PPC_INS_VCTUXS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VEXPTEFP, PPC_INS_VEXPTEFP, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VLOGEFP, PPC_INS_VLOGEFP, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMADDFP, PPC_INS_VMADDFP, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMAXFP, PPC_INS_VMAXFP, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMAXSB, PPC_INS_VMAXSB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMAXSH, PPC_INS_VMAXSH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMAXSW, PPC_INS_VMAXSW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMAXUB, PPC_INS_VMAXUB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMAXUH, PPC_INS_VMAXUH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMAXUW, PPC_INS_VMAXUW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMHADDSHS, PPC_INS_VMHADDSHS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMHRADDSHS, PPC_INS_VMHRADDSHS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMINFP, PPC_INS_VMINFP, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMINSB, PPC_INS_VMINSB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMINSH, PPC_INS_VMINSH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMINSW, PPC_INS_VMINSW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMINUB, PPC_INS_VMINUB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMINUH, PPC_INS_VMINUH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMINUW, PPC_INS_VMINUW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMLADDUHM, PPC_INS_VMLADDUHM, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMRGHB, PPC_INS_VMRGHB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMRGHH, PPC_INS_VMRGHH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMRGHW, PPC_INS_VMRGHW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMRGLB, PPC_INS_VMRGLB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMRGLH, PPC_INS_VMRGLH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMRGLW, PPC_INS_VMRGLW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMSUMMBM, PPC_INS_VMSUMMBM, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMSUMSHM, PPC_INS_VMSUMSHM, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMSUMSHS, PPC_INS_VMSUMSHS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMSUMUBM, PPC_INS_VMSUMUBM, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMSUMUHM, PPC_INS_VMSUMUHM, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMSUMUHS, PPC_INS_VMSUMUHS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMULESB, PPC_INS_VMULESB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMULESH, PPC_INS_VMULESH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMULEUB, PPC_INS_VMULEUB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMULEUH, PPC_INS_VMULEUH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMULOSB, PPC_INS_VMULOSB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMULOSH, PPC_INS_VMULOSH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMULOUB, PPC_INS_VMULOUB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VMULOUH, PPC_INS_VMULOUH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VNMSUBFP, PPC_INS_VNMSUBFP, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VNOR, PPC_INS_VNOR, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VOR, PPC_INS_VOR, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VPERM, PPC_INS_VPERM, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VPKPX, PPC_INS_VPKPX, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VPKSHSS, PPC_INS_VPKSHSS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VPKSHUS, PPC_INS_VPKSHUS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VPKSWSS, PPC_INS_VPKSWSS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VPKSWUS, PPC_INS_VPKSWUS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VPKUHUM, PPC_INS_VPKUHUM, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VPKUHUS, PPC_INS_VPKUHUS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VPKUWUM, PPC_INS_VPKUWUM, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VPKUWUS, PPC_INS_VPKUWUS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VREFP, PPC_INS_VREFP, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VRFIM, PPC_INS_VRFIM, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VRFIN, PPC_INS_VRFIN, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VRFIP, PPC_INS_VRFIP, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VRFIZ, PPC_INS_VRFIZ, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VRLB, PPC_INS_VRLB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VRLH, PPC_INS_VRLH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VRLW, PPC_INS_VRLW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VRSQRTEFP, PPC_INS_VRSQRTEFP, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSEL, PPC_INS_VSEL, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSL, PPC_INS_VSL, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSLB, PPC_INS_VSLB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSLDOI, PPC_INS_VSLDOI, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSLH, PPC_INS_VSLH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSLO, PPC_INS_VSLO, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSLW, PPC_INS_VSLW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSPLTB, PPC_INS_VSPLTB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSPLTH, PPC_INS_VSPLTH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSPLTISB, PPC_INS_VSPLTISB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSPLTISH, PPC_INS_VSPLTISH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSPLTISW, PPC_INS_VSPLTISW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSPLTW, PPC_INS_VSPLTW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSR, PPC_INS_VSR, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSRAB, PPC_INS_VSRAB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSRAH, PPC_INS_VSRAH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSRAW, PPC_INS_VSRAW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSRB, PPC_INS_VSRB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSRH, PPC_INS_VSRH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSRO, PPC_INS_VSRO, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSRW, PPC_INS_VSRW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUBCUW, PPC_INS_VSUBCUW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUBFP, PPC_INS_VSUBFP, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUBSBS, PPC_INS_VSUBSBS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUBSHS, PPC_INS_VSUBSHS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUBSWS, PPC_INS_VSUBSWS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUBUBM, PPC_INS_VSUBUBM, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUBUBS, PPC_INS_VSUBUBS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUBUHM, PPC_INS_VSUBUHM, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUBUHS, PPC_INS_VSUBUHS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUBUWM, PPC_INS_VSUBUWM, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUBUWS, PPC_INS_VSUBUWS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUM2SWS, PPC_INS_VSUM2SWS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUM4SBS, PPC_INS_VSUM4SBS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUM4SHS, PPC_INS_VSUM4SHS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUM4UBS, PPC_INS_VSUM4UBS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VSUMSWS, PPC_INS_VSUMSWS, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VUPKHPX, PPC_INS_VUPKHPX, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VUPKHSB, PPC_INS_VUPKHSB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VUPKHSH, PPC_INS_VUPKHSH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VUPKLPX, PPC_INS_VUPKLPX, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VUPKLSB, PPC_INS_VUPKLSB, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VUPKLSH, PPC_INS_VUPKLSH, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_VXOR, PPC_INS_VXOR, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_V_SET0, PPC_INS_VXOR, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_V_SET0B, PPC_INS_VXOR, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_V_SET0H, PPC_INS_VXOR, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_V_SETALLONES, PPC_INS_VSPLTISW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_V_SETALLONESB, PPC_INS_VSPLTISW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_V_SETALLONESH, PPC_INS_VSPLTISW, { 0 }, { 0 }, { PPC_GRP_ALTIVEC, 0 }, 0, 0 },
	{ PPC_WAIT, PPC_INS_WAIT, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_XOR, PPC_INS_XOR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_XOR8, PPC_INS_XOR, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_XOR8o, PPC_INS_XOR, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_XORI, PPC_INS_XORI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_XORI8, PPC_INS_XORI, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_XORIS, PPC_INS_XORIS, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_XORIS8, PPC_INS_XORIS, { 0 }, { 0 }, { 0 }, 0, 0 },
	{ PPC_XORo, PPC_INS_XOR, { 0 }, { PPC_REG_CR0, 0 }, { 0 }, 0, 0 },
	{ PPC_gBC, PPC_INS_BC, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_gBCA, PPC_INS_BCA, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_gBCCTR, PPC_INS_BCCTR, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_gBCCTRL, PPC_INS_BCCTRL, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_LR, PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_gBCL, PPC_INS_BCL, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_LR, PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_gBCLA, PPC_INS_BCLA, { PPC_REG_CTR, PPC_REG_RM, 0 }, { PPC_REG_LR, PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_gBCLR, PPC_INS_BCLR, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
	{ PPC_gBCLRL, PPC_INS_BCLRL, { PPC_REG_CTR, PPC_REG_LR, PPC_REG_RM, 0 }, { PPC_REG_LR, PPC_REG_CTR, 0 }, { 0 }, 0, 0 },
};

static insn_map alias_insns[] = {
};

// given internal insn id, return public instruction info
void PPC_get_insn_id(cs_struct *h, cs_insn *insn, unsigned int id)
{
	int i;

	// consider alias insn first
	for (i = 0; i < ARR_SIZE(alias_insns); i++) {
		if (alias_insns[i].id == id) {
			insn->id = alias_insns[i].mapid;

			if (h->detail) {
				cs_struct handle;
				handle.detail = h->detail;

				memcpy(insn->detail->regs_read, alias_insns[i].regs_use, sizeof(alias_insns[i].regs_use));
				insn->detail->regs_read_count = count_positive(alias_insns[i].regs_use);

				memcpy(insn->detail->regs_write, alias_insns[i].regs_mod, sizeof(alias_insns[i].regs_mod));
				insn->detail->regs_write_count = count_positive(alias_insns[i].regs_mod);

				memcpy(insn->detail->groups, alias_insns[i].groups, sizeof(alias_insns[i].groups));
				insn->detail->groups_count = count_positive(alias_insns[i].groups);

				if (alias_insns[i].branch || alias_insns[i].indirect_branch) {
					// this insn also belongs to JUMP group. add JUMP group
					insn->detail->groups[insn->detail->groups_count] = PPC_GRP_JUMP;
					insn->detail->groups_count++;
				}

				insn->detail->ppc.update_cr0 = cs_reg_write((csh)&handle, insn, PPC_REG_CR0);
				return;
			}
		}
	}

	i = insn_find(insns, ARR_SIZE(insns), id, &h->insn_cache);
	if (i != 0) {
		insn->id = insns[i].mapid;

		if (h->detail) {
			cs_struct handle;
			handle.detail = h->detail;

			memcpy(insn->detail->regs_read, insns[i].regs_use, sizeof(insns[i].regs_use));
			insn->detail->regs_read_count = count_positive(insns[i].regs_use);

			memcpy(insn->detail->regs_write, insns[i].regs_mod, sizeof(insns[i].regs_mod));
			insn->detail->regs_write_count = count_positive(insns[i].regs_mod);

			memcpy(insn->detail->groups, insns[i].groups, sizeof(insns[i].groups));
			insn->detail->groups_count = count_positive(insns[i].groups);

			if (insns[i].branch || insns[i].indirect_branch) {
				// this insn also belongs to JUMP group. add JUMP group
				insn->detail->groups[insn->detail->groups_count] = PPC_GRP_JUMP;
				insn->detail->groups_count++;
			}

			insn->detail->ppc.update_cr0 = cs_reg_write((csh)&handle, insn, PPC_REG_CR0);
		}
	}
}

// given public insn id, return internal insn id
unsigned int PPC_get_insn_id2(unsigned int id)
{
	// consider alias insn first
	unsigned int res;
	res = insn_reverse_id(alias_insns, ARR_SIZE(alias_insns), id);
	if (res)
		return res;

	return insn_reverse_id(insns, ARR_SIZE(insns), id);
}

static name_map insn_name_maps[] = {
	{ PPC_INS_INVALID, NULL },

	{ PPC_INS_ADD, "add" },
	{ PPC_INS_ADDC, "addc" },
	{ PPC_INS_ADDE, "adde" },
	{ PPC_INS_ADDI, "addi" },
	{ PPC_INS_ADDIC, "addic" },
	{ PPC_INS_ADDIS, "addis" },
	{ PPC_INS_ADDME, "addme" },
	{ PPC_INS_ADDZE, "addze" },
	{ PPC_INS_AND, "and" },
	{ PPC_INS_ANDC, "andc" },
	{ PPC_INS_ANDIS, "andis" },
	{ PPC_INS_ANDI, "andi" },
	{ PPC_INS_B, "b" },
	{ PPC_INS_BA, "ba" },
	{ PPC_INS_BCL, "bcl" },
	{ PPC_INS_BCTR, "bctr" },
	{ PPC_INS_BCTRL, "bctrl" },
	{ PPC_INS_BDNZ, "bdnz" },
	{ PPC_INS_BDNZA, "bdnza" },
	{ PPC_INS_BDNZL, "bdnzl" },
	{ PPC_INS_BDNZLA, "bdnzla" },
	{ PPC_INS_BDNZLR, "bdnzlr" },
	{ PPC_INS_BDNZLRL, "bdnzlrl" },
	{ PPC_INS_BDZ, "bdz" },
	{ PPC_INS_BDZA, "bdza" },
	{ PPC_INS_BDZL, "bdzl" },
	{ PPC_INS_BDZLA, "bdzla" },
	{ PPC_INS_BDZLR, "bdzlr" },
	{ PPC_INS_BDZLRL, "bdzlrl" },
	{ PPC_INS_BL, "bl" },
	{ PPC_INS_BLA, "bla" },
	{ PPC_INS_BLR, "blr" },
	{ PPC_INS_BLRL, "blrl" },
	{ PPC_INS_CMPD, "cmpd" },
	{ PPC_INS_CMPDI, "cmpdi" },
	{ PPC_INS_CMPLD, "cmpld" },
	{ PPC_INS_CMPLDI, "cmpldi" },
	{ PPC_INS_CMPLW, "cmplw" },
	{ PPC_INS_CMPLWI, "cmplwi" },
	{ PPC_INS_CMPW, "cmpw" },
	{ PPC_INS_CMPWI, "cmpwi" },
	{ PPC_INS_CNTLZD, "cntlzd" },
	{ PPC_INS_CNTLZW, "cntlzw" },
	{ PPC_INS_CREQV, "creqv" },
	{ PPC_INS_CRXOR, "crxor" },
	{ PPC_INS_CRAND, "crand" },
	{ PPC_INS_CRANDC, "crandc" },
	{ PPC_INS_CRNAND, "crnand" },
	{ PPC_INS_CRNOR, "crnor" },
	{ PPC_INS_CROR, "cror" },
	{ PPC_INS_CRORC, "crorc" },
	{ PPC_INS_DCBA, "dcba" },
	{ PPC_INS_DCBF, "dcbf" },
	{ PPC_INS_DCBI, "dcbi" },
	{ PPC_INS_DCBST, "dcbst" },
	{ PPC_INS_DCBT, "dcbt" },
	{ PPC_INS_DCBTST, "dcbtst" },
	{ PPC_INS_DCBZ, "dcbz" },
	{ PPC_INS_DCBZL, "dcbzl" },
	{ PPC_INS_DIVD, "divd" },
	{ PPC_INS_DIVDU, "divdu" },
	{ PPC_INS_DIVW, "divw" },
	{ PPC_INS_DIVWU, "divwu" },
	{ PPC_INS_DSS, "dss" },
	{ PPC_INS_DSSALL, "dssall" },
	{ PPC_INS_DST, "dst" },
	{ PPC_INS_DSTST, "dstst" },
	{ PPC_INS_DSTSTT, "dststt" },
	{ PPC_INS_DSTT, "dstt" },
	{ PPC_INS_EIEIO, "eieio" },
	{ PPC_INS_EQV, "eqv" },
	{ PPC_INS_EXTSB, "extsb" },
	{ PPC_INS_EXTSH, "extsh" },
	{ PPC_INS_EXTSW, "extsw" },
	{ PPC_INS_FABS, "fabs" },
	{ PPC_INS_FADD, "fadd" },
	{ PPC_INS_FADDS, "fadds" },
	{ PPC_INS_FCFID, "fcfid" },
	{ PPC_INS_FCFIDS, "fcfids" },
	{ PPC_INS_FCFIDU, "fcfidu" },
	{ PPC_INS_FCFIDUS, "fcfidus" },
	{ PPC_INS_FCMPU, "fcmpu" },
	{ PPC_INS_FCPSGN, "fcpsgn" },
	{ PPC_INS_FCTID, "fctid" },
	{ PPC_INS_FCTIDUZ, "fctiduz" },
	{ PPC_INS_FCTIDZ, "fctidz" },
	{ PPC_INS_FCTIW, "fctiw" },
	{ PPC_INS_FCTIWUZ, "fctiwuz" },
	{ PPC_INS_FCTIWZ, "fctiwz" },
	{ PPC_INS_FDIV, "fdiv" },
	{ PPC_INS_FDIVS, "fdivs" },
	{ PPC_INS_FMADD, "fmadd" },
	{ PPC_INS_FMADDS, "fmadds" },
	{ PPC_INS_FMSUB, "fmsub" },
	{ PPC_INS_FMSUBS, "fmsubs" },
	{ PPC_INS_FMUL, "fmul" },
	{ PPC_INS_FMULS, "fmuls" },
	{ PPC_INS_FNABS, "fnabs" },
	{ PPC_INS_FNEG, "fneg" },
	{ PPC_INS_FNMADD, "fnmadd" },
	{ PPC_INS_FNMADDS, "fnmadds" },
	{ PPC_INS_FNMSUB, "fnmsub" },
	{ PPC_INS_FNMSUBS, "fnmsubs" },
	{ PPC_INS_FRE, "fre" },
	{ PPC_INS_FRES, "fres" },
	{ PPC_INS_FRIM, "frim" },
	{ PPC_INS_FRIN, "frin" },
	{ PPC_INS_FRIP, "frip" },
	{ PPC_INS_FRIZ, "friz" },
	{ PPC_INS_FRSP, "frsp" },
	{ PPC_INS_FRSQRTE, "frsqrte" },
	{ PPC_INS_FRSQRTES, "frsqrtes" },
	{ PPC_INS_FSEL, "fsel" },
	{ PPC_INS_FSQRT, "fsqrt" },
	{ PPC_INS_FSQRTS, "fsqrts" },
	{ PPC_INS_FSUB, "fsub" },
	{ PPC_INS_FSUBS, "fsubs" },
	{ PPC_INS_ICBI, "icbi" },
	{ PPC_INS_ISEL, "isel" },
	{ PPC_INS_ISYNC, "isync" },
	{ PPC_INS_LA, "la" },
	{ PPC_INS_LBZ, "lbz" },
	{ PPC_INS_LBZU, "lbzu" },
	{ PPC_INS_LBZUX, "lbzux" },
	{ PPC_INS_LBZX, "lbzx" },
	{ PPC_INS_LD, "ld" },
	{ PPC_INS_LDARX, "ldarx" },
	{ PPC_INS_LDBRX, "ldbrx" },
	{ PPC_INS_LDU, "ldu" },
	{ PPC_INS_LDUX, "ldux" },
	{ PPC_INS_LDX, "ldx" },
	{ PPC_INS_LFD, "lfd" },
	{ PPC_INS_LFDU, "lfdu" },
	{ PPC_INS_LFDUX, "lfdux" },
	{ PPC_INS_LFDX, "lfdx" },
	{ PPC_INS_LFIWAX, "lfiwax" },
	{ PPC_INS_LFIWZX, "lfiwzx" },
	{ PPC_INS_LFS, "lfs" },
	{ PPC_INS_LFSU, "lfsu" },
	{ PPC_INS_LFSUX, "lfsux" },
	{ PPC_INS_LFSX, "lfsx" },
	{ PPC_INS_LHA, "lha" },
	{ PPC_INS_LHAU, "lhau" },
	{ PPC_INS_LHAUX, "lhaux" },
	{ PPC_INS_LHAX, "lhax" },
	{ PPC_INS_LHBRX, "lhbrx" },
	{ PPC_INS_LHZ, "lhz" },
	{ PPC_INS_LHZU, "lhzu" },
	{ PPC_INS_LHZUX, "lhzux" },
	{ PPC_INS_LHZX, "lhzx" },
	{ PPC_INS_LI, "li" },
	{ PPC_INS_LIS, "lis" },
	{ PPC_INS_LMW, "lmw" },
	{ PPC_INS_LVEBX, "lvebx" },
	{ PPC_INS_LVEHX, "lvehx" },
	{ PPC_INS_LVEWX, "lvewx" },
	{ PPC_INS_LVSL, "lvsl" },
	{ PPC_INS_LVSR, "lvsr" },
	{ PPC_INS_LVX, "lvx" },
	{ PPC_INS_LVXL, "lvxl" },
	{ PPC_INS_LWA, "lwa" },
	{ PPC_INS_LWARX, "lwarx" },
	{ PPC_INS_LWAUX, "lwaux" },
	{ PPC_INS_LWAX, "lwax" },
	{ PPC_INS_LWBRX, "lwbrx" },
	{ PPC_INS_LWZ, "lwz" },
	{ PPC_INS_LWZU, "lwzu" },
	{ PPC_INS_LWZUX, "lwzux" },
	{ PPC_INS_LWZX, "lwzx" },
	{ PPC_INS_MCRF, "mcrf" },
	{ PPC_INS_MFCR, "mfcr" },
	{ PPC_INS_MFCTR, "mfctr" },
	{ PPC_INS_MFFS, "mffs" },
	{ PPC_INS_MFLR, "mflr" },
	{ PPC_INS_MFMSR, "mfmsr" },
	{ PPC_INS_MFOCRF, "mfocrf" },
	{ PPC_INS_MFSPR, "mfspr" },
	{ PPC_INS_MFTB, "mftb" },
	{ PPC_INS_MFVSCR, "mfvscr" },
	{ PPC_INS_MTCRF, "mtcrf" },
	{ PPC_INS_MTCTR, "mtctr" },
	{ PPC_INS_MTFSB0, "mtfsb0" },
	{ PPC_INS_MTFSB1, "mtfsb1" },
	{ PPC_INS_MTFSF, "mtfsf" },
	{ PPC_INS_MTLR, "mtlr" },
	{ PPC_INS_MTMSR, "mtmsr" },
	{ PPC_INS_MTMSRD, "mtmsrd" },
	{ PPC_INS_MTOCRF, "mtocrf" },
	{ PPC_INS_MTSPR, "mtspr" },
	{ PPC_INS_MTVSCR, "mtvscr" },
	{ PPC_INS_MULHD, "mulhd" },
	{ PPC_INS_MULHDU, "mulhdu" },
	{ PPC_INS_MULHW, "mulhw" },
	{ PPC_INS_MULHWU, "mulhwu" },
	{ PPC_INS_MULLD, "mulld" },
	{ PPC_INS_MULLI, "mulli" },
	{ PPC_INS_MULLW, "mullw" },
	{ PPC_INS_NAND, "nand" },
	{ PPC_INS_NEG, "neg" },
	{ PPC_INS_NOP, "nop" },
	{ PPC_INS_ORI, "ori" },
	{ PPC_INS_NOR, "nor" },
	{ PPC_INS_OR, "or" },
	{ PPC_INS_ORC, "orc" },
	{ PPC_INS_ORIS, "oris" },
	{ PPC_INS_POPCNTD, "popcntd" },
	{ PPC_INS_POPCNTW, "popcntw" },
	{ PPC_INS_RLDCL, "rldcl" },
	{ PPC_INS_RLDCR, "rldcr" },
	{ PPC_INS_RLDIC, "rldic" },
	{ PPC_INS_RLDICL, "rldicl" },
	{ PPC_INS_RLDICR, "rldicr" },
	{ PPC_INS_RLDIMI, "rldimi" },
	{ PPC_INS_RLWIMI, "rlwimi" },
	{ PPC_INS_RLWINM, "rlwinm" },
	{ PPC_INS_RLWNM, "rlwnm" },
	{ PPC_INS_SC, "sc" },
	{ PPC_INS_SLBIA, "slbia" },
	{ PPC_INS_SLBIE, "slbie" },
	{ PPC_INS_SLBMFEE, "slbmfee" },
	{ PPC_INS_SLBMTE, "slbmte" },
	{ PPC_INS_SLD, "sld" },
	{ PPC_INS_SLW, "slw" },
	{ PPC_INS_SRAD, "srad" },
	{ PPC_INS_SRADI, "sradi" },
	{ PPC_INS_SRAW, "sraw" },
	{ PPC_INS_SRAWI, "srawi" },
	{ PPC_INS_SRD, "srd" },
	{ PPC_INS_SRW, "srw" },
	{ PPC_INS_STB, "stb" },
	{ PPC_INS_STBU, "stbu" },
	{ PPC_INS_STBUX, "stbux" },
	{ PPC_INS_STBX, "stbx" },
	{ PPC_INS_STD, "std" },
	{ PPC_INS_STDBRX, "stdbrx" },
	{ PPC_INS_STDCX, "stdcx" },
	{ PPC_INS_STDU, "stdu" },
	{ PPC_INS_STDUX, "stdux" },
	{ PPC_INS_STDX, "stdx" },
	{ PPC_INS_STFD, "stfd" },
	{ PPC_INS_STFDU, "stfdu" },
	{ PPC_INS_STFDUX, "stfdux" },
	{ PPC_INS_STFDX, "stfdx" },
	{ PPC_INS_STFIWX, "stfiwx" },
	{ PPC_INS_STFS, "stfs" },
	{ PPC_INS_STFSU, "stfsu" },
	{ PPC_INS_STFSUX, "stfsux" },
	{ PPC_INS_STFSX, "stfsx" },
	{ PPC_INS_STH, "sth" },
	{ PPC_INS_STHBRX, "sthbrx" },
	{ PPC_INS_STHU, "sthu" },
	{ PPC_INS_STHUX, "sthux" },
	{ PPC_INS_STHX, "sthx" },
	{ PPC_INS_STMW, "stmw" },
	{ PPC_INS_STVEBX, "stvebx" },
	{ PPC_INS_STVEHX, "stvehx" },
	{ PPC_INS_STVEWX, "stvewx" },
	{ PPC_INS_STVX, "stvx" },
	{ PPC_INS_STVXL, "stvxl" },
	{ PPC_INS_STW, "stw" },
	{ PPC_INS_STWBRX, "stwbrx" },
	{ PPC_INS_STWCX, "stwcx" },
	{ PPC_INS_STWU, "stwu" },
	{ PPC_INS_STWUX, "stwux" },
	{ PPC_INS_STWX, "stwx" },
	{ PPC_INS_SUBF, "subf" },
	{ PPC_INS_SUBFC, "subfc" },
	{ PPC_INS_SUBFE, "subfe" },
	{ PPC_INS_SUBFIC, "subfic" },
	{ PPC_INS_SUBFME, "subfme" },
	{ PPC_INS_SUBFZE, "subfze" },
	{ PPC_INS_SYNC, "sync" },
	{ PPC_INS_TD, "td" },
	{ PPC_INS_TDI, "tdi" },
	{ PPC_INS_TLBIE, "tlbie" },
	{ PPC_INS_TLBIEL, "tlbiel" },
	{ PPC_INS_TLBSYNC, "tlbsync" },
	{ PPC_INS_TRAP, "trap" },
	{ PPC_INS_TW, "tw" },
	{ PPC_INS_TWI, "twi" },
	{ PPC_INS_VADDCUW, "vaddcuw" },
	{ PPC_INS_VADDFP, "vaddfp" },
	{ PPC_INS_VADDSBS, "vaddsbs" },
	{ PPC_INS_VADDSHS, "vaddshs" },
	{ PPC_INS_VADDSWS, "vaddsws" },
	{ PPC_INS_VADDUBM, "vaddubm" },
	{ PPC_INS_VADDUBS, "vaddubs" },
	{ PPC_INS_VADDUHM, "vadduhm" },
	{ PPC_INS_VADDUHS, "vadduhs" },
	{ PPC_INS_VADDUWM, "vadduwm" },
	{ PPC_INS_VADDUWS, "vadduws" },
	{ PPC_INS_VAND, "vand" },
	{ PPC_INS_VANDC, "vandc" },
	{ PPC_INS_VAVGSB, "vavgsb" },
	{ PPC_INS_VAVGSH, "vavgsh" },
	{ PPC_INS_VAVGSW, "vavgsw" },
	{ PPC_INS_VAVGUB, "vavgub" },
	{ PPC_INS_VAVGUH, "vavguh" },
	{ PPC_INS_VAVGUW, "vavguw" },
	{ PPC_INS_VCFSX, "vcfsx" },
	{ PPC_INS_VCFUX, "vcfux" },
	{ PPC_INS_VCMPBFP, "vcmpbfp" },
	{ PPC_INS_VCMPEQFP, "vcmpeqfp" },
	{ PPC_INS_VCMPEQUB, "vcmpequb" },
	{ PPC_INS_VCMPEQUH, "vcmpequh" },
	{ PPC_INS_VCMPEQUW, "vcmpequw" },
	{ PPC_INS_VCMPGEFP, "vcmpgefp" },
	{ PPC_INS_VCMPGTFP, "vcmpgtfp" },
	{ PPC_INS_VCMPGTSB, "vcmpgtsb" },
	{ PPC_INS_VCMPGTSH, "vcmpgtsh" },
	{ PPC_INS_VCMPGTSW, "vcmpgtsw" },
	{ PPC_INS_VCMPGTUB, "vcmpgtub" },
	{ PPC_INS_VCMPGTUH, "vcmpgtuh" },
	{ PPC_INS_VCMPGTUW, "vcmpgtuw" },
	{ PPC_INS_VCTSXS, "vctsxs" },
	{ PPC_INS_VCTUXS, "vctuxs" },
	{ PPC_INS_VEXPTEFP, "vexptefp" },
	{ PPC_INS_VLOGEFP, "vlogefp" },
	{ PPC_INS_VMADDFP, "vmaddfp" },
	{ PPC_INS_VMAXFP, "vmaxfp" },
	{ PPC_INS_VMAXSB, "vmaxsb" },
	{ PPC_INS_VMAXSH, "vmaxsh" },
	{ PPC_INS_VMAXSW, "vmaxsw" },
	{ PPC_INS_VMAXUB, "vmaxub" },
	{ PPC_INS_VMAXUH, "vmaxuh" },
	{ PPC_INS_VMAXUW, "vmaxuw" },
	{ PPC_INS_VMHADDSHS, "vmhaddshs" },
	{ PPC_INS_VMHRADDSHS, "vmhraddshs" },
	{ PPC_INS_VMINFP, "vminfp" },
	{ PPC_INS_VMINSB, "vminsb" },
	{ PPC_INS_VMINSH, "vminsh" },
	{ PPC_INS_VMINSW, "vminsw" },
	{ PPC_INS_VMINUB, "vminub" },
	{ PPC_INS_VMINUH, "vminuh" },
	{ PPC_INS_VMINUW, "vminuw" },
	{ PPC_INS_VMLADDUHM, "vmladduhm" },
	{ PPC_INS_VMRGHB, "vmrghb" },
	{ PPC_INS_VMRGHH, "vmrghh" },
	{ PPC_INS_VMRGHW, "vmrghw" },
	{ PPC_INS_VMRGLB, "vmrglb" },
	{ PPC_INS_VMRGLH, "vmrglh" },
	{ PPC_INS_VMRGLW, "vmrglw" },
	{ PPC_INS_VMSUMMBM, "vmsummbm" },
	{ PPC_INS_VMSUMSHM, "vmsumshm" },
	{ PPC_INS_VMSUMSHS, "vmsumshs" },
	{ PPC_INS_VMSUMUBM, "vmsumubm" },
	{ PPC_INS_VMSUMUHM, "vmsumuhm" },
	{ PPC_INS_VMSUMUHS, "vmsumuhs" },
	{ PPC_INS_VMULESB, "vmulesb" },
	{ PPC_INS_VMULESH, "vmulesh" },
	{ PPC_INS_VMULEUB, "vmuleub" },
	{ PPC_INS_VMULEUH, "vmuleuh" },
	{ PPC_INS_VMULOSB, "vmulosb" },
	{ PPC_INS_VMULOSH, "vmulosh" },
	{ PPC_INS_VMULOUB, "vmuloub" },
	{ PPC_INS_VMULOUH, "vmulouh" },
	{ PPC_INS_VNMSUBFP, "vnmsubfp" },
	{ PPC_INS_VNOR, "vnor" },
	{ PPC_INS_VOR, "vor" },
	{ PPC_INS_VPERM, "vperm" },
	{ PPC_INS_VPKPX, "vpkpx" },
	{ PPC_INS_VPKSHSS, "vpkshss" },
	{ PPC_INS_VPKSHUS, "vpkshus" },
	{ PPC_INS_VPKSWSS, "vpkswss" },
	{ PPC_INS_VPKSWUS, "vpkswus" },
	{ PPC_INS_VPKUHUM, "vpkuhum" },
	{ PPC_INS_VPKUHUS, "vpkuhus" },
	{ PPC_INS_VPKUWUM, "vpkuwum" },
	{ PPC_INS_VPKUWUS, "vpkuwus" },
	{ PPC_INS_VREFP, "vrefp" },
	{ PPC_INS_VRFIM, "vrfim" },
	{ PPC_INS_VRFIN, "vrfin" },
	{ PPC_INS_VRFIP, "vrfip" },
	{ PPC_INS_VRFIZ, "vrfiz" },
	{ PPC_INS_VRLB, "vrlb" },
	{ PPC_INS_VRLH, "vrlh" },
	{ PPC_INS_VRLW, "vrlw" },
	{ PPC_INS_VRSQRTEFP, "vrsqrtefp" },
	{ PPC_INS_VSEL, "vsel" },
	{ PPC_INS_VSL, "vsl" },
	{ PPC_INS_VSLB, "vslb" },
	{ PPC_INS_VSLDOI, "vsldoi" },
	{ PPC_INS_VSLH, "vslh" },
	{ PPC_INS_VSLO, "vslo" },
	{ PPC_INS_VSLW, "vslw" },
	{ PPC_INS_VSPLTB, "vspltb" },
	{ PPC_INS_VSPLTH, "vsplth" },
	{ PPC_INS_VSPLTISB, "vspltisb" },
	{ PPC_INS_VSPLTISH, "vspltish" },
	{ PPC_INS_VSPLTISW, "vspltisw" },
	{ PPC_INS_VSPLTW, "vspltw" },
	{ PPC_INS_VSR, "vsr" },
	{ PPC_INS_VSRAB, "vsrab" },
	{ PPC_INS_VSRAH, "vsrah" },
	{ PPC_INS_VSRAW, "vsraw" },
	{ PPC_INS_VSRB, "vsrb" },
	{ PPC_INS_VSRH, "vsrh" },
	{ PPC_INS_VSRO, "vsro" },
	{ PPC_INS_VSRW, "vsrw" },
	{ PPC_INS_VSUBCUW, "vsubcuw" },
	{ PPC_INS_VSUBFP, "vsubfp" },
	{ PPC_INS_VSUBSBS, "vsubsbs" },
	{ PPC_INS_VSUBSHS, "vsubshs" },
	{ PPC_INS_VSUBSWS, "vsubsws" },
	{ PPC_INS_VSUBUBM, "vsububm" },
	{ PPC_INS_VSUBUBS, "vsububs" },
	{ PPC_INS_VSUBUHM, "vsubuhm" },
	{ PPC_INS_VSUBUHS, "vsubuhs" },
	{ PPC_INS_VSUBUWM, "vsubuwm" },
	{ PPC_INS_VSUBUWS, "vsubuws" },
	{ PPC_INS_VSUM2SWS, "vsum2sws" },
	{ PPC_INS_VSUM4SBS, "vsum4sbs" },
	{ PPC_INS_VSUM4SHS, "vsum4shs" },
	{ PPC_INS_VSUM4UBS, "vsum4ubs" },
	{ PPC_INS_VSUMSWS, "vsumsws" },
	{ PPC_INS_VUPKHPX, "vupkhpx" },
	{ PPC_INS_VUPKHSB, "vupkhsb" },
	{ PPC_INS_VUPKHSH, "vupkhsh" },
	{ PPC_INS_VUPKLPX, "vupklpx" },
	{ PPC_INS_VUPKLSB, "vupklsb" },
	{ PPC_INS_VUPKLSH, "vupklsh" },
	{ PPC_INS_VXOR, "vxor" },
	{ PPC_INS_WAIT, "wait" },
	{ PPC_INS_XOR, "xor" },
	{ PPC_INS_XORI, "xori" },
	{ PPC_INS_XORIS, "xoris" },
	{ PPC_INS_BC, "bc" },
	{ PPC_INS_BCA, "bca" },
	{ PPC_INS_BCCTR, "bcctr" },
	{ PPC_INS_BCCTRL, "bcctrl" },
	{ PPC_INS_BCLA, "bcla" },
	{ PPC_INS_BCLR, "bclr" },
	{ PPC_INS_BCLRL, "bclrl" },
};

// special alias insn
static name_map alias_insn_names[] = {
};

const char *PPC_insn_name(csh handle, unsigned int id)
{
	if (id >= PPC_INS_MAX)
		return NULL;

	// handle special alias first
	int i;
	for (i = 0; i < ARR_SIZE(alias_insn_names); i++) {
		if (alias_insn_names[i].id == id)
			return alias_insn_names[i].name;
	}

	return insn_name_maps[id].name;
}

ppc_reg PPC_map_insn(const char *name)
{
	// handle special alias first
	int i;

	for (i = 0; i < ARR_SIZE(alias_insn_names); i++) {
		if (!strcasecmp(alias_insn_names[i].name, name))
			return alias_insn_names[i].id;
	}

	// NOTE: skip first NULL name in insn_name_maps
	i = name2id(&insn_name_maps[1], ARR_SIZE(insn_name_maps) - 1, name);

	return (i != -1)? i : PPC_REG_INVALID;
}

// map internal raw register to 'public' register
ppc_reg PPC_map_register(unsigned int r)
{
	static unsigned int map[] = {
		0, 0, PPC_REG_CARRY, PPC_REG_CTR, 0, PPC_REG_LR,
		0, PPC_REG_VRSAVE, PPC_REG_CR0, 0, PPC_REG_CR0,
		PPC_REG_CR1, PPC_REG_CR2, PPC_REG_CR3, PPC_REG_CR4, PPC_REG_CR5,
		PPC_REG_CR6, PPC_REG_CR7, PPC_REG_CTR, PPC_REG_F0, PPC_REG_F1,
		PPC_REG_F2, PPC_REG_F3, PPC_REG_F4, PPC_REG_F5, PPC_REG_F6,
		PPC_REG_F7, PPC_REG_F8, PPC_REG_F9, PPC_REG_F10, PPC_REG_F11,
		PPC_REG_F12, PPC_REG_F13, PPC_REG_F14, PPC_REG_F15, PPC_REG_F16,
		PPC_REG_F17, PPC_REG_F18, PPC_REG_F19, PPC_REG_F20, PPC_REG_F21,
		PPC_REG_F22, PPC_REG_F23, PPC_REG_F24, PPC_REG_F25, PPC_REG_F26,
		PPC_REG_F27, PPC_REG_F28, PPC_REG_F29, PPC_REG_F30, PPC_REG_F31,
		0, PPC_REG_LR, PPC_REG_R0, PPC_REG_R1, PPC_REG_R2,
		PPC_REG_R3, PPC_REG_R4, PPC_REG_R5, PPC_REG_R6, PPC_REG_R7,
		PPC_REG_R8, PPC_REG_R9, PPC_REG_R10, PPC_REG_R11, PPC_REG_R12,
		PPC_REG_R13, PPC_REG_R14, PPC_REG_R15, PPC_REG_R16, PPC_REG_R17,
		PPC_REG_R18, PPC_REG_R19, PPC_REG_R20, PPC_REG_R21, PPC_REG_R22,
		PPC_REG_R23, PPC_REG_R24, PPC_REG_R25, PPC_REG_R26, PPC_REG_R27,
		PPC_REG_R28, PPC_REG_R29, PPC_REG_R30, PPC_REG_R31, PPC_REG_V0,
		PPC_REG_V1, PPC_REG_V2, PPC_REG_V3, PPC_REG_V4, PPC_REG_V5,
		PPC_REG_V6, PPC_REG_V7, PPC_REG_V8, PPC_REG_V9, PPC_REG_V10,
		PPC_REG_V11, PPC_REG_V12, PPC_REG_V13, PPC_REG_V14, PPC_REG_V15,
		PPC_REG_V16, PPC_REG_V17, PPC_REG_V18, PPC_REG_V19, PPC_REG_V20,
		PPC_REG_V21, PPC_REG_V22, PPC_REG_V23, PPC_REG_V24, PPC_REG_V25,
		PPC_REG_V26, PPC_REG_V27, PPC_REG_V28, PPC_REG_V29, PPC_REG_V30,
		PPC_REG_V31, PPC_REG_R0, PPC_REG_R1, PPC_REG_R2, PPC_REG_R3,
		PPC_REG_R4, PPC_REG_R5, PPC_REG_R6, PPC_REG_R7, PPC_REG_R8,
		PPC_REG_R9, PPC_REG_R10, PPC_REG_R11, PPC_REG_R12, PPC_REG_R13,
		PPC_REG_R14, PPC_REG_R15, PPC_REG_R16, PPC_REG_R17, PPC_REG_R18,
		PPC_REG_R19, PPC_REG_R20, PPC_REG_R21, PPC_REG_R22, PPC_REG_R23,
		PPC_REG_R24, PPC_REG_R25, PPC_REG_R26, PPC_REG_R27, PPC_REG_R28,
		PPC_REG_R29, PPC_REG_R30, PPC_REG_R31, PPC_REG_CR0, PPC_REG_CR2,
		PPC_REG_CR6, PPC_REG_CR10, PPC_REG_CR14, PPC_REG_CR18, PPC_REG_CR22,
		PPC_REG_CR26, PPC_REG_CR30, PPC_REG_CR1, PPC_REG_CR5, PPC_REG_CR9,
		PPC_REG_CR13, PPC_REG_CR17, PPC_REG_CR21, PPC_REG_CR25, PPC_REG_CR29,
		PPC_REG_CR0, PPC_REG_CR4, PPC_REG_CR8, PPC_REG_CR12, PPC_REG_CR16,
		PPC_REG_CR20, PPC_REG_CR24, PPC_REG_CR28, PPC_REG_CR3, PPC_REG_CR7,
		PPC_REG_CR11, PPC_REG_CR15, PPC_REG_CR19, PPC_REG_CR23, PPC_REG_CR27,
		PPC_REG_CR31, };

	if (r < ARR_SIZE(map))
		return map[r];

	// cannot find this register
	return 0;
}
