(* 
  HereDoc

  initial release        Alain Frisch  <Alain.Frisch@ens.fr>
  better typing scheme   Rmi Vanicat  <vanicat@labri.u-bordeaux.fr>
*)

type t = Obj.t (* type of t document anything in reality *)

exception Closure

let fail_on_closure = ref false
let set_fail_on_closure b = fail_on_closure := b

let rec iter f (o : t) =
  if (Obj.is_block o) then
    if (Obj.tag o) = Obj.string_tag then 
      f ((Obj.obj o) : string)
    else 
      if (Obj.tag o) <> Obj.closure_tag then
      	let s = Obj.size o in 
      	for i = 0 to pred s do
      	  iter f (Obj.obj (Obj.field o i))
      	done
      else
	if !fail_on_closure then raise Closure else ()


let length o =
  let l = ref 0 in
  iter (fun s -> l := !l  + String.length s) o;
  !l

let to_string o =
  let buf = String.create (length o) in
  let i = ref 0 in
  iter (fun s -> 
	  let l = String.length s in
	  String.unsafe_blit s 0 buf !i l;
	  i := !i + l
       ) o;
  buf

let repr x = Obj.repr x

let empty = repr 0

(** Postponed text **)

let postponed_texts = (Hashtbl.create 32 : (string , unit -> unit) Hashtbl.t)

let postponed id f =
  let r = ref empty in
  Hashtbl.add postponed_texts id (fun () -> r := f ());
  repr r

let activate id =
  let l = Hashtbl.find_all postponed_texts id in
  List.iter (fun f -> f ()) l
