----
-- Copyright (c) 2012-2018 Apple Inc. All rights reserved.
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
-- http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
----

---------------------------------------------------
-- Upgrade database schema from VERSION 65 to 66 --
---------------------------------------------------

ALTER TABLE JOB ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE CALENDAR_HOME ALTER COLUMN RESOURCE_ID TYPE bigint;

ALTER TABLE CALENDAR ALTER COLUMN RESOURCE_ID TYPE bigint;

ALTER TABLE CALENDAR_HOME_METADATA ALTER COLUMN RESOURCE_ID TYPE bigint;
ALTER TABLE CALENDAR_HOME_METADATA ALTER COLUMN TRASH TYPE bigint;
ALTER TABLE CALENDAR_HOME_METADATA ALTER COLUMN DEFAULT_EVENTS TYPE bigint;
ALTER TABLE CALENDAR_HOME_METADATA ALTER COLUMN DEFAULT_TASKS TYPE bigint;
ALTER TABLE CALENDAR_HOME_METADATA ALTER COLUMN DEFAULT_POLLS TYPE bigint;

ALTER TABLE CALENDAR_METADATA ALTER COLUMN RESOURCE_ID TYPE bigint;

ALTER TABLE CALENDAR_MIGRATION ALTER COLUMN CALENDAR_HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE CALENDAR_MIGRATION ALTER COLUMN REMOTE_RESOURCE_ID TYPE bigint;
ALTER TABLE CALENDAR_MIGRATION ALTER COLUMN LOCAL_RESOURCE_ID TYPE bigint;

ALTER TABLE NOTIFICATION_HOME ALTER COLUMN RESOURCE_ID TYPE bigint;

ALTER TABLE NOTIFICATION ALTER COLUMN RESOURCE_ID TYPE bigint;
ALTER TABLE NOTIFICATION ALTER COLUMN NOTIFICATION_HOME_RESOURCE_ID TYPE bigint;

ALTER TABLE CALENDAR_BIND ALTER COLUMN CALENDAR_HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE CALENDAR_BIND ALTER COLUMN CALENDAR_RESOURCE_ID TYPE bigint;
ALTER TABLE CALENDAR_BIND ALTER COLUMN BIND_REVISION TYPE bigint;

ALTER TABLE CALENDAR_OBJECT ALTER COLUMN RESOURCE_ID TYPE bigint;
ALTER TABLE CALENDAR_OBJECT ALTER COLUMN CALENDAR_RESOURCE_ID TYPE bigint;
ALTER TABLE CALENDAR_OBJECT ALTER COLUMN ORIGINAL_COLLECTION TYPE bigint;

ALTER TABLE TIME_RANGE ALTER COLUMN INSTANCE_ID TYPE bigint;
ALTER TABLE TIME_RANGE ALTER COLUMN CALENDAR_RESOURCE_ID TYPE bigint;
ALTER TABLE TIME_RANGE ALTER COLUMN CALENDAR_OBJECT_RESOURCE_ID TYPE bigint;

ALTER TABLE PERUSER ALTER COLUMN TIME_RANGE_INSTANCE_ID TYPE bigint;

ALTER TABLE CALENDAR_OBJECT_MIGRATION ALTER COLUMN CALENDAR_HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE CALENDAR_OBJECT_MIGRATION ALTER COLUMN REMOTE_RESOURCE_ID TYPE bigint;
ALTER TABLE CALENDAR_OBJECT_MIGRATION ALTER COLUMN LOCAL_RESOURCE_ID TYPE bigint;

ALTER TABLE ATTACHMENT ALTER COLUMN ATTACHMENT_ID TYPE bigint;
ALTER TABLE ATTACHMENT ALTER COLUMN CALENDAR_HOME_RESOURCE_ID TYPE bigint;

ALTER TABLE ATTACHMENT_CALENDAR_OBJECT ALTER COLUMN ATTACHMENT_ID TYPE bigint;
ALTER TABLE ATTACHMENT_CALENDAR_OBJECT ALTER COLUMN CALENDAR_OBJECT_RESOURCE_ID TYPE bigint;

ALTER TABLE ATTACHMENT_MIGRATION ALTER COLUMN CALENDAR_HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE ATTACHMENT_MIGRATION ALTER COLUMN REMOTE_RESOURCE_ID TYPE bigint;
ALTER TABLE ATTACHMENT_MIGRATION ALTER COLUMN LOCAL_RESOURCE_ID TYPE bigint;

ALTER TABLE RESOURCE_PROPERTY ALTER COLUMN RESOURCE_ID TYPE bigint;

ALTER TABLE ADDRESSBOOK_HOME ALTER COLUMN RESOURCE_ID TYPE bigint;
ALTER TABLE ADDRESSBOOK_HOME ALTER COLUMN ADDRESSBOOK_PROPERTY_STORE_ID TYPE bigint;

ALTER TABLE ADDRESSBOOK_HOME_METADATA ALTER COLUMN RESOURCE_ID TYPE bigint;

ALTER TABLE SHARED_ADDRESSBOOK_BIND ALTER COLUMN ADDRESSBOOK_HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE SHARED_ADDRESSBOOK_BIND ALTER COLUMN OWNER_HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE SHARED_ADDRESSBOOK_BIND ALTER COLUMN BIND_REVISION TYPE bigint;

ALTER TABLE ADDRESSBOOK_OBJECT ALTER COLUMN RESOURCE_ID TYPE bigint;
ALTER TABLE ADDRESSBOOK_OBJECT ALTER COLUMN ADDRESSBOOK_HOME_RESOURCE_ID TYPE bigint;

ALTER TABLE ABO_MEMBERS ALTER COLUMN GROUP_ID TYPE bigint;
ALTER TABLE ABO_MEMBERS ALTER COLUMN ADDRESSBOOK_ID TYPE bigint;
ALTER TABLE ABO_MEMBERS ALTER COLUMN MEMBER_ID TYPE bigint;
ALTER TABLE ABO_MEMBERS ALTER COLUMN REVISION TYPE bigint;

ALTER TABLE ABO_FOREIGN_MEMBERS ALTER COLUMN GROUP_ID TYPE bigint;
ALTER TABLE ABO_FOREIGN_MEMBERS ALTER COLUMN ADDRESSBOOK_ID TYPE bigint;

ALTER TABLE SHARED_GROUP_BIND ALTER COLUMN ADDRESSBOOK_HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE SHARED_GROUP_BIND ALTER COLUMN GROUP_RESOURCE_ID TYPE bigint;
ALTER TABLE SHARED_GROUP_BIND ALTER COLUMN BIND_REVISION TYPE bigint;

ALTER TABLE CALENDAR_OBJECT_REVISIONS ALTER COLUMN CALENDAR_HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE CALENDAR_OBJECT_REVISIONS ALTER COLUMN CALENDAR_RESOURCE_ID TYPE bigint;
ALTER TABLE CALENDAR_OBJECT_REVISIONS ALTER COLUMN REVISION TYPE bigint;

ALTER TABLE ADDRESSBOOK_OBJECT_REVISIONS ALTER COLUMN ADDRESSBOOK_HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE ADDRESSBOOK_OBJECT_REVISIONS ALTER COLUMN OWNER_HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE ADDRESSBOOK_OBJECT_REVISIONS ALTER COLUMN OBJECT_RESOURCE_ID TYPE bigint;
ALTER TABLE ADDRESSBOOK_OBJECT_REVISIONS ALTER COLUMN REVISION TYPE bigint;

ALTER TABLE NOTIFICATION_OBJECT_REVISIONS ALTER COLUMN NOTIFICATION_HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE NOTIFICATION_OBJECT_REVISIONS ALTER COLUMN REVISION TYPE bigint;

ALTER TABLE TEST_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE TEST_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE APN_PURGING_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE APN_PURGING_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE IMIP_INVITATION_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE IMIP_INVITATION_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE IMIP_POLLING_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE IMIP_POLLING_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE IMIP_REPLY_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE IMIP_REPLY_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE PUSH_NOTIFICATION_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE PUSH_NOTIFICATION_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE GROUP_CACHER_POLLING_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE GROUP_CACHER_POLLING_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE GROUP_REFRESH_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE GROUP_REFRESH_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE GROUP_DELEGATE_CHANGES_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE GROUP_DELEGATE_CHANGES_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE GROUPS ALTER COLUMN GROUP_ID TYPE bigint;

ALTER TABLE GROUP_MEMBERSHIP ALTER COLUMN GROUP_ID TYPE bigint;

ALTER TABLE GROUP_ATTENDEE_RECONCILE_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE GROUP_ATTENDEE_RECONCILE_WORK ALTER COLUMN JOB_ID TYPE bigint;
ALTER TABLE GROUP_ATTENDEE_RECONCILE_WORK ALTER COLUMN RESOURCE_ID TYPE bigint;
ALTER TABLE GROUP_ATTENDEE_RECONCILE_WORK ALTER COLUMN GROUP_ID TYPE bigint;

ALTER TABLE GROUP_ATTENDEE ALTER COLUMN GROUP_ID TYPE bigint;
ALTER TABLE GROUP_ATTENDEE ALTER COLUMN RESOURCE_ID TYPE bigint;

ALTER TABLE GROUP_SHAREE_RECONCILE_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE GROUP_SHAREE_RECONCILE_WORK ALTER COLUMN JOB_ID TYPE bigint;
ALTER TABLE GROUP_SHAREE_RECONCILE_WORK ALTER COLUMN CALENDAR_ID TYPE bigint;
ALTER TABLE GROUP_SHAREE_RECONCILE_WORK ALTER COLUMN GROUP_ID TYPE bigint;

ALTER TABLE GROUP_SHAREE ALTER COLUMN GROUP_ID TYPE bigint;
ALTER TABLE GROUP_SHAREE ALTER COLUMN CALENDAR_ID TYPE bigint;

ALTER TABLE DELEGATE_GROUPS ALTER COLUMN GROUP_ID TYPE bigint;

ALTER TABLE CALENDAR_OBJECT_SPLITTER_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE CALENDAR_OBJECT_SPLITTER_WORK ALTER COLUMN JOB_ID TYPE bigint;
ALTER TABLE CALENDAR_OBJECT_SPLITTER_WORK ALTER COLUMN RESOURCE_ID TYPE bigint;

ALTER TABLE CALENDAR_OBJECT_UPGRADE_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE CALENDAR_OBJECT_UPGRADE_WORK ALTER COLUMN JOB_ID TYPE bigint;
ALTER TABLE CALENDAR_OBJECT_UPGRADE_WORK ALTER COLUMN RESOURCE_ID TYPE bigint;

ALTER TABLE FIND_MIN_VALID_REVISION_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE FIND_MIN_VALID_REVISION_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE REVISION_CLEANUP_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE REVISION_CLEANUP_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE INBOX_CLEANUP_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE INBOX_CLEANUP_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE CLEANUP_ONE_INBOX_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE CLEANUP_ONE_INBOX_WORK ALTER COLUMN JOB_ID TYPE bigint;
ALTER TABLE CLEANUP_ONE_INBOX_WORK ALTER COLUMN HOME_ID TYPE bigint;

ALTER TABLE INBOX_REMOVE_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE INBOX_REMOVE_WORK ALTER COLUMN JOB_ID TYPE bigint;
ALTER TABLE INBOX_REMOVE_WORK ALTER COLUMN HOME_ID TYPE bigint;

ALTER TABLE SCHEDULE_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE SCHEDULE_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE SCHEDULE_REFRESH_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE SCHEDULE_REFRESH_WORK ALTER COLUMN HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE SCHEDULE_REFRESH_WORK ALTER COLUMN RESOURCE_ID TYPE bigint;

ALTER TABLE SCHEDULE_REFRESH_ATTENDEES ALTER COLUMN RESOURCE_ID TYPE bigint;

ALTER TABLE SCHEDULE_AUTO_REPLY_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE SCHEDULE_AUTO_REPLY_WORK ALTER COLUMN HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE SCHEDULE_AUTO_REPLY_WORK ALTER COLUMN RESOURCE_ID TYPE bigint;

ALTER TABLE SCHEDULE_ORGANIZER_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE SCHEDULE_ORGANIZER_WORK ALTER COLUMN HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE SCHEDULE_ORGANIZER_WORK ALTER COLUMN RESOURCE_ID TYPE bigint;

ALTER TABLE SCHEDULE_ORGANIZER_SEND_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE SCHEDULE_ORGANIZER_SEND_WORK ALTER COLUMN HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE SCHEDULE_ORGANIZER_SEND_WORK ALTER COLUMN RESOURCE_ID TYPE bigint;

ALTER TABLE SCHEDULE_REPLY_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE SCHEDULE_REPLY_WORK ALTER COLUMN HOME_RESOURCE_ID TYPE bigint;
ALTER TABLE SCHEDULE_REPLY_WORK ALTER COLUMN RESOURCE_ID TYPE bigint;

ALTER TABLE PRINCIPAL_PURGE_POLLING_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE PRINCIPAL_PURGE_POLLING_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE PRINCIPAL_PURGE_CHECK_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE PRINCIPAL_PURGE_CHECK_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE PRINCIPAL_PURGE_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE PRINCIPAL_PURGE_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE PRINCIPAL_PURGE_HOME_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE PRINCIPAL_PURGE_HOME_WORK ALTER COLUMN JOB_ID TYPE bigint;
ALTER TABLE PRINCIPAL_PURGE_HOME_WORK ALTER COLUMN HOME_RESOURCE_ID TYPE bigint;

ALTER TABLE MIGRATION_CLEANUP_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE MIGRATION_CLEANUP_WORK ALTER COLUMN JOB_ID TYPE bigint;
ALTER TABLE MIGRATION_CLEANUP_WORK ALTER COLUMN HOME_RESOURCE_ID TYPE bigint;

ALTER TABLE HOME_CLEANUP_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE HOME_CLEANUP_WORK ALTER COLUMN JOB_ID TYPE bigint;

ALTER TABLE MIGRATED_HOME_CLEANUP_WORK ALTER COLUMN WORK_ID TYPE bigint;
ALTER TABLE MIGRATED_HOME_CLEANUP_WORK ALTER COLUMN JOB_ID TYPE bigint;

-- update the version
update CALENDARSERVER set VALUE = '66' where NAME = 'VERSION';
