#define HAVE_PTHREAD_H 1

#include <unistd.h>
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <cabocha.h>
#include <stdlib.h>
#include "thread.h"

namespace CaboCha {

class ParserThread : public MeCab::thread {
 public:
  void run() {
    //     CaboCha::Tree *tree = new CaboCha::Tree;
    for (int i = 0; i < sentences_->size(); ++i) {
      CaboCha::Tree *tree = new CaboCha::Tree;
      tree->set_sentence((*sentences_)[i].c_str());
      parser_->parse(tree);
      // std::cout << (*sentences_)[i] << std::endl;
      //      std::cout << tree->toString(FORMAT_TREE);
      delete tree;
    }
  }

  ParserThread(std::vector<std::string> *sentences,
               CaboCha::Parser *parser)
      : sentences_(sentences) {
    parser_ = parser;
  }

 private:
  std::vector<std::string> *sentences_;
  CaboCha::Parser *parser_;
};
}

int main (int argc, char **argv) {
  std::ifstream ifs("/home/taku/tmp/rwcp.3000.text.utf8");
  std::string line;
  std::vector<std::string> sentences;
  while (std::getline(ifs, line)) {
    sentences.push_back(line);
  }
  std::cout << sentences.size()<< std::endl;

  const int kMaxThreadSize = 2;
  CaboCha::Parser *parser = CaboCha::createParser(argc, argv);
  if (!parser) {
    std::cout << "error: " << CaboCha::getLastError() << std::endl;
    return -1;
  }

  std::vector<CaboCha::ParserThread *> threads(kMaxThreadSize);
  for (int i = 0; i < kMaxThreadSize; ++i) {
    threads[i] = new CaboCha::ParserThread(&sentences, parser);
  }

  for (int i = 0; i < kMaxThreadSize; ++i) {
    std::cout << "start" << i << std::endl;
    threads[i]->start();
  }

  for (int i = 0; i < kMaxThreadSize; ++i) {
    threads[i]->join();
    std::cout << "end" << i << std::endl;
    delete threads[i];
  }

  delete parser;
  return 0;
}
