#ifndef _hey_readline_h_
#define _hey_readline_h_

/*
** File: hey_readline.h
** Desc: Contains the general hooks for reading a line
** Auth: Colm MacCarthaigh (colmmacc@redbrick.dcu.ie)
** Date: 5/9/01
**
** $Id: hey_readline.h,v 1.2 2001/12/30 23:26:06 c-hey Exp $
*/

#include "config.h"

/* the expanded prompt */
extern char * hey_rlprompt;

#ifdef HAVE_LIBREADLINE

/* line we are one */
extern int hey_line;

/* total number of lines */
extern int hey_linetotal;

/* has the last line been appended ? */
extern int hey_lastdone;

#endif

/* initialise readline stuff */
extern void hey_readline_init(void);

/* we are done reading lines */
extern void hey_readline_fini(void);

/* actually read a line from standard input */
extern char *hey_readline(void);

/* generate the hey prompt */
extern char *hey_generate_prompt(void);

/* redisplays a hey's buffer after SIGCONT */
extern void hey_redisplay(void);

#endif 
