/*
** File: hey_main.c
** Desc: main() function for hey
** Auth: Cian Synnott <pooka@redbrick.dcu.ie>
** Date: Tue Nov 10 18:50:57 GMT 1998
**
** $Id: hey_main.c,v 1.8 2004/02/19 21:50:34 c-hey Exp $
*/

#include "hey_arg.h"
#include "hey_format.h"
#include "hey_signal.h"
#include "hey_logins.h"
#include "hey_readline.h"
#include "hey_edit.h"
#include "aux.h"

#define COMMANDLEN 64

/* the initial mesg status */
mesg_flag init_mesg_status;


/* Clean up, just to be nice */
void hey_cleanup(void) {

	/* set mesg status back */
	if (init_mesg_status == MESG_N) {
 		if (!set_mesg(MESG_N)) {
			printerr("hey: error going mesg n\n");
		}            
		if (!mesg_warning_suppress) {
			printerr("hey: warning - you are not accepting messages on this terminal\n");
		}           
  	}

	dyn_pageFree(hey_page);
	g_listFree(hey_userlist);
	return;
}	


int main(int argc, char *argv[]) {
	char command[COMMANDLEN];
	hey_user *u; 
	FILE *pipe;
	char *ptr;


	/* Setup signal handlers and parse environment & options */
	hey_signal_setup();
	hey_terminal_setup();
	hey_get_env();
	hey_parse_options(argc, argv);

	/* Warn if a user isn't logged on/doesn't exist */
	u = (hey_user *) g_listTraverse(hey_userlist);	
	do {
		/* Firstly, do they exist? */
		if (!hey_user_exists(u)) {
			printerr("hey: warning - %s does not exist\n", u->name);
			continue;
		}

		/* Check if they're logged in on terminal specified (if any) */
		switch (hey_user_login(u)) {
			case NOT_LOGGED_ON:
				printerr("hey: warning - %s is not logged in", u->name);
				if (u->tty[0]) printerr(" on %s", u->tty);
				printerr(".\n");
				break;

			case NOT_MESG_Y:
				printerr("hey: warning - %s has messages disabled", u->name);
				if (u->tty[0]) printerr(" on %s", u->tty);
				printerr(".\n");
				break;
		
		}

	} while ((u = (hey_user *) g_listTraverse(NULL)) != NULL);


	/* Read user input and then format it */
#ifndef HAVE_LIBREADLINE
	hey_user_input();
#endif
#ifdef HAVE_LIBREADLINE
	if (isatty(STDIN_FILENO))
	{
		hey_rl_input();
	}
	else
	{
		hey_user_input();
	}
#endif

	hey_format_input();

	/* deal with their mesg status */
	init_mesg_status = my_mesg();
	if (init_mesg_status == MESG_N) {
		if(!set_mesg(MESG_Y)) {
			printerr_exit("hey: error going mesg y\n");
		}
	}

	/* call hey_cleanup when we exit */
	atexit(hey_cleanup);

	/* Iterate through user list */
	u = (hey_user *) g_listTraverse(hey_userlist);	

	do {
		
		if (!u->exists) { 
			printerr("hey: %s does not exist\n", u->name);
			continue;
		}
		else if (!u->login) {
			printerr("hey: %s is not logged in", u->name);
			if (u->tty[0]) printerr(" on %s", u->tty);
			printerr(".\n");
			continue;
		}
		else if (!u->mesg) {
			printerr("hey: %s has messages disabled", u->name);
			if (u->tty[0]) printerr(" on %s", u->tty);
			printerr(".\n");
			continue;
		}

		/* Prepare to cycle through the page & print it out */
		if (!(ptr = dyn_pageRead(hey_page))) 
			printerr_exit("hey: no input or input lost. (formatted page)\n"
					"\nIf you did input something "
					"and this happened, please make a\n"
					"copy of your data and send it to "
					"c-hey@redbrick.dcu.ie for debugging.\n"
					"Thanks.\n\n");
	
		/* Open the pipe to write */
		snprintf(command, COMMANDLEN, "%s %s ", WRITE_PROG, u->name);
		if (u->tty[0]) strncat(command, u->tty, COMMANDLEN - 1);
		if (!(pipe = popen(command, "w"))) 
			printerr_exit("hey: couldn't open pipe to write.\n");

		/* Print out the page to write */
		do {
			fprintf(pipe, "%s\n", ptr);
		} while ((ptr = dyn_pageRead(NULL)));

		/* Close the pipe */
		if(pclose(pipe) == -1) {
			perror("hey: failure");
			exit(1);
		}

		/* Success message */
		printf("hey: %s", u->name);
		if (u->tty[0]) printf(".%s", u->tty);
		printf(" - %s\n", hey_success);
	
	} while ((u = (hey_user *) g_listTraverse(NULL)) != NULL);
   
	return 0;
}

