#ifndef _hey_logins_h_
#define _hey_logins_h_

/*
** File: hey_logins.h 
** Desc: Routines to check if a username exists/is logged in
** Auth: Cian Synnott <pooka@redbrick.dcu.ie>
** Date: Mon Nov 16 03:33:41 GMT 1998
**
** $Id: hey_logins.h,v 1.2 2001/12/30 23:26:06 c-hey Exp $
*/

#include <pwd.h>

#include "hey_arg.h"

/* Does a user exist on the system ? */
extern int hey_user_exists(hey_user *u); 

/* Are they logged on (and on the tty specified)? */
extern int hey_user_login(hey_user *u);

/* Mesg flags */
typedef enum _mesg_flag {MESG_N,MESG_Y} mesg_flag;

/* Am I mesg y? */
extern mesg_flag my_mesg();

/* set my mesg status */
extern int set_mesg(mesg_flag);

/* Possible return values for hey_user_login */
enum {
	NOT_LOGGED_ON,
	NOT_MESG_Y,
	LOGGED_ON
};

#endif
