#ifndef _hey_edit_h_
#define _hey_edit_h_

/*
** File: hey_readline.h
** Desc: Readiing functions for c-hey
** Auth: Colm Mac Carthaigh <colmmacc@redbrick.dcu.ie>
** Date: Sun Nov 15 19:49:44 GMT 1998
**
** $Id: hey_edit.h,v 1.2 2001/12/30 23:26:06 c-hey Exp $
*/

/* Read user input into hey_page, also allocates it & suchlike */
extern void hey_rl_input(void);

/* bindable functions */

/* move count lines up */
extern int hey_lineup(int count, int key);

/* move count lines down */
extern int hey_linedown(int count, int key);

/* for when we hit return */
extern int hey_return(int count, int key);

/*
** refreshes the screen
**
** if count is non-zero it reprint everything
** and go to old cursor position
**
*/
extern int hey_refresh(int count, int key);

/* wrapper for the arrow keys */
extern int hey_arrows(int count, int key);

/* wrapper to bind keys */
extern int hey_bindkeys(void);

#endif 
