#ifndef _hey_arg_h_
#define _hey_arg_h_

/*
** File: hey_arg.h
** Desc: Parse the arguments to hey, including constructing the list
**       of usernames etc. Also handle the environment variables 
**       supported. 
** Auth: Cian Synnott <pooka@redbrick.dcu.ie>
** Date: Mon Nov  9 19:19:20 GMT 1998
**
** $Id: hey_arg.h,v 1.4 2003/08/11 01:21:45 c-hey Exp $
*/

#include <string.h>		/* string handling functions for env */
#include <stdlib.h>		/* getenv() & it's ilk */
#include <stdio.h>		/* dunno.. testing or NULL probably */
#include <unistd.h>		/* For getopt -- oh, may want to check that for 
						** portability*/

#include "g_list.h" 	/* For to construct a list of users with :o) */
#include "utent.h"
#include "config.h"

#ifdef UT_NAMESIZE
#define NAMELEN UT_NAMESIZE
#else
#define NAMELEN 16
#endif

#define TTYLEN  8
/* 
** List to hold all of the users 
*/
extern g_list *hey_userlist;

/* 
** Structure to hold one user from the command line, plus their optional 
** bits 
*/
typedef struct _hey_user_ {
	char name [NAMELEN + 1]; /* + 1 for adding \0 termination */
	char tty  [TTYLEN + 1];  /* Same */
	char exists;
	char login;
	char mesg;
} hey_user;

/* 
** Values settable via environment variables.
*/
extern int   hey_wrap;				/* word-wrapping limit */
extern int   hey_nousers;			/* number of users getting heyed */
extern char *hey_title;				/* 'title' message for the hey */
extern char *hey_footer;			/* 'footer' message for the hey */
extern char *hey_borders;			/* string containing the border chars */
extern char *hey_success;			/* string to output on success */
extern char *hey_eof;               		/* replacement EOF */
extern char *hey_prompt;                        /* string to use as hey prompt */
extern int   hey_maxnames;			/* maximum number of names in prompt */

/*
** Suppress the potentialy annoying mesg status warning
*/
extern int	mesg_warning_suppress;


/* defaults for those variables */
#define DEFAULT_HEY_WRAP 70
#define DEFAULT_HEY_TITLE ""
#define DEFAULT_HEY_FOOTER ""
#define DEFAULT_HEY_BORDERS "o  OO"
#define DEFAULT_HEY_SUCCESS "groovy"
#define DEFAULT_HEY_PROMPT NULL
#define DEFAULT_HEY_MAXNAMES 3

/* Macros to access different parts of the border ... */
#define B_DFLT(x)   ( ((x) == ' ') ? hey_borders[0] : (x) )
#define B_TOP 		B_DFLT(hey_borders[1])	
#define B_BOT		B_DFLT(hey_borders[2])
#define B_RHT		B_DFLT(hey_borders[3])
#define B_LFT		B_DFLT(hey_borders[4])
#define B_TOPLFT	(strlen (hey_borders) > 5) ? B_DFLT(hey_borders[5]) : hey_borders[0]
#define B_TOPRHT	(strlen (hey_borders) == 9) ? B_DFLT(hey_borders[6]) : B_TOPLFT 
#define B_BOTLFT	(strlen (hey_borders) == 9) ? B_DFLT(hey_borders[7]) : B_TOPLFT
#define B_BOTRHT	(strlen (hey_borders) == 9) ? B_DFLT(hey_borders[8]) : B_TOPLFT

/* parse all the input arguments */
extern void  hey_parse_options(int argc, char *argv[]);

/* Checks for hey environment variables, and failing that sets them to their
** default values. */
extern void hey_get_env(void);		

#endif
