#ifndef _dyn_page_h_
#define _dyn_page_h_

/*
** File: dyn_page.h
** Desc: A dynamic buffer, and functions to manipulate it ...
** Auth: Cian Synnott <pooka@redbrick.dcu.ie>
** Date: Tue Nov 10 21:59:10 GMT 1998
**
** $Id: dyn_page.h,v 1.2 2001/12/30 23:26:06 c-hey Exp $
*/

/* 
** The actual buffer structure 
*/
typedef struct _dyn_page_ {
	char **buff;
	int rows;
	int cols;
} dyn_page;

/* 
** Functions to act on it 
*/

/* Allocate a page structure, giving it the width at which to wrap lines 
** appended to it. */
extern dyn_page *dyn_pageAlloc(int width);

/* Free one */
extern void dyn_pageFree(dyn_page *page);

/* How many lines, or what width, is the page ... */
extern int dyn_pageLines(dyn_page *page);
extern int dyn_pageWidth(dyn_page *page);

/* Append a line to the page, wrapping as necessary */
extern int dyn_pageAppend(dyn_page *page, char *line);

/* Extract a line by index */
extern char *dyn_pageLineAt(dyn_page *page, int line);

/* Modify a line by index */
extern int dyn_pageLineMod(dyn_page *page, char *line, int lineno);

/* Step along the page, returning the next line on subsequent calls that are
** passed NULL. Standard iterator ... */
extern char *dyn_pageRead(dyn_page *page);

#endif
