#add parent dir to find package. Only needed for source code build, pip install doesn't need it.
import os, inspect
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(os.path.dirname(currentdir))
os.sys.path.insert(0,parentdir)

import gym
import numpy as np
import pybullet as p
import pybullet_envs
import time

def relu(x):
    return np.maximum(x, 0)

class SmallReactivePolicy:
    """
    Simple multi-layer perceptron policy, no internal state
    """
    def __init__(self, observation_space, action_space):
        assert weights_dense1_w.shape == (observation_space.shape[0], 128)
        assert weights_dense2_w.shape == (128, 64)
        assert weights_final_w.shape  == (64, action_space.shape[0])

    def act(self, ob):
        x = ob
        x = relu(np.dot(x, weights_dense1_w) + weights_dense1_b)
        x = relu(np.dot(x, weights_dense2_w) + weights_dense2_b)
        x = np.dot(x, weights_final_w) + weights_final_b
        return x

def main():
    env = gym.make("HopperBulletEnv-v0")
    env.render(mode="human")
    
    pi = SmallReactivePolicy(env.observation_space, env.action_space)
    env.reset()
    for i in range (p.getNumBodies()):
        print(p.getBodyInfo(i))
        if (p.getBodyInfo(i)[1].decode() == "hopper"):
           torsoId=i
           print("found torso")
           print(p.getNumJoints(torsoId))
           for j in range (p.getNumJoints(torsoId)):
              print(p.getJointInfo(torsoId,j))#LinkState(torsoId,j))
    while 1:
        frame = 0
        score = 0
        restart_delay = 0
        #disable rendering during reset, makes loading much faster
        obs = env.reset()
    
        while 1:
            time.sleep(0.01)
            a = pi.act(obs)
            obs, r, done, _ = env.step(a)
            score += r
            frame += 1
            distance=5
            yaw = 0
            humanPos = p.getLinkState(torsoId,4)[0]
            p.resetDebugVisualizerCamera(distance,yaw,-20,humanPos);

            still_open = env.render("human")
            if still_open==False:
                return
            if not done: continue
            if restart_delay==0:
                print("score=%0.2f in %i frames" % (score, frame))
                restart_delay = 60*2  # 2 sec at 60 fps
            else:
                restart_delay -= 1
                if restart_delay==0: break

weights_dense1_w = np.array([
[ +0.6734, +1.1364, +0.6117, +0.5185, +0.5099, -0.2038, -0.0045, -0.1448, +0.5081, +1.1685, -0.7904, -0.4623, +0.0027, -0.0473, -0.1144, +0.5095, -0.1913, +0.2021, +0.3485, +0.1104, -0.4992, +0.5207, -0.1013, -0.6947, +0.1624, +0.3533, -0.2485, -0.0012, +0.1674, +0.1253, +1.5485, +0.3576, +0.8236, +0.7361, +0.6604, -0.0834, +0.1212, -0.8404, -0.8337, +0.3709, -0.4218, -0.1011, -1.1418, -0.0554, +0.6676, +0.4739, -0.2105, +0.3187, -0.4321, -0.7018, +0.1845, +0.2525, +0.0205, +0.9391, +0.6123, +0.6868, +0.5116, +0.3483, +0.1148, +0.6747, -0.1590, +0.1879, +0.4836, +0.1997, +0.5105, -0.2695, +0.0645, +0.5566, +0.0502, +0.2292, -0.4234, -0.3778, -0.7639, -0.6084, -0.0375, -0.4799, +0.6465, -0.4097, +0.1091, -0.0681, -0.1813, +0.3625, +0.6067, +0.1837, +0.1600, -0.1706, +0.0531, -0.3710, +0.1320, +0.5035, +0.1106, +0.9955, -0.2657, +0.6051, -0.2525, -0.9118, -0.6031, +0.2025, -0.2774, +0.3985, -0.0809, +0.3601, -0.0410, -0.5067, +0.4987, +0.4126, -0.1393, -0.6596, +0.8182, -0.2352, -0.9337, +0.1438, +0.3871, -0.1844, -0.4010, -0.3338, +0.1597, +0.2381, -0.4403, +0.5105, +1.0354, -0.1503, +0.2731, +0.6555, +0.2048, +0.4932, -0.0067, +0.0413],
[ -0.0031, -0.2183, +0.2275, -0.4836, +0.1347, +0.3581, +0.0921, +0.1900, -0.1721, +0.0150, -0.2146, +0.5346, +0.2407, -0.0791, +0.5115, -0.0763, +0.2025, +0.2792, +0.4087, +0.2082, +0.0086, -0.2742, +0.3703, +0.4297, -0.3141, -0.3896, +0.4101, -0.3967, -0.2173, -0.0532, +0.2521, +0.3938, -0.3727, +0.6136, +0.0902, -0.4617, -0.3266, -0.2273, +0.0031, +0.4605, +0.1221, +0.3603, -0.1018, +0.1839, +0.3198, -0.1404, -0.1751, -0.1030, -0.5847, +0.2526, -0.1280, +0.1644, +0.2988, -0.1793, -0.2120, +0.3398, -0.4582, +0.0758, -0.2848, -0.1537, -0.2718, -0.2207, +0.0109, +0.1374, -0.0281, -0.0494, -0.0093, +0.0098, +0.2691, +0.1589, +0.2483, +0.1394, +0.2531, +0.3884, +0.0740, -0.4444, +0.1441, +0.0768, +0.2154, +0.4015, -0.2109, -0.0985, -0.1066, -0.0167, -0.0204, -0.2345, +0.3131, +0.1026, +0.1873, +0.2644, +0.2253, -0.0173, +0.1014, +0.0781, +0.0455, -0.0489, -0.3541, -0.1257, -0.1248, +0.4402, -0.0682, -0.3045, +0.1751, +0.0397, -0.3392, -0.2758, +0.1542, -0.0460, -0.0622, +0.2255, +0.2442, +0.2070, +0.3175, -0.0913, -0.2772, +0.7036, -0.0876, +0.0907, +0.3794, +0.4784, -0.5111, +0.0982, -0.0145, +0.0397, -0.3429, -0.2727, -0.1384, +0.0512],
[ +0.2192, +0.0688, -0.1092, +0.1436, -0.2598, -0.0012, -0.2220, -0.2450, -0.0783, -0.0078, +0.3065, +0.1604, -0.0593, -0.0759, -0.4101, -0.1819, +0.4160, +0.0141, +0.0059, -0.2494, -0.0616, -0.3100, -0.3231, -0.3935, +0.1965, -0.0352, -0.0119, +0.3883, -0.5905, -0.0536, -0.0617, -0.2884, +0.1134, +0.1539, +0.2002, -0.3158, -0.5476, -0.4131, -0.1966, +0.1083, -0.3329, +0.1219, +0.2977, -0.7132, -0.1963, -0.2359, -0.4734, +0.0130, -0.1034, -0.1376, -0.1824, +0.1999, -0.3775, -0.0697, +0.1875, -0.0673, -0.0673, -0.0555, -0.3243, +0.2020, +0.1416, +0.1995, -0.1931, -0.6125, -0.3465, +0.0640, +0.3529, -0.4684, +0.2335, -0.0449, -0.1216, +0.1921, +0.0636, -0.0420, +0.1371, -0.1246, -0.2963, +0.0264, +0.3962, -0.3106, -0.2107, -0.2983, +0.0386, -0.0458, -0.3277, -0.1686, -0.3064, +0.2433, +0.3454, +0.0046, +0.0885, -0.2479, +0.2886, -0.0804, +0.0110, -0.1369, -0.1210, +0.1901, +0.0001, -0.1155, +0.2887, -0.0943, -0.1167, +0.1746, +0.0379, +0.0964, -0.2615, -0.0209, -0.0680, +0.0031, -0.0905, -0.0618, -0.5630, -0.0664, -0.1976, -0.2367, -0.2360, -0.2243, +0.2448, +0.2446, -0.0012, -0.6920, -0.0880, -0.4630, -0.5512, +0.0312, +0.1522, -0.1278],
[ -0.2378, +0.2783, +0.0848, -0.3973, -0.5359, +0.2541, +0.1616, +0.1856, +0.6054, +0.0894, +0.2599, -0.0082, -0.5433, -0.3567, -0.1134, -0.2706, -0.9177, +0.1949, +0.4099, -0.3198, +0.3856, -0.0285, -0.0692, +0.0882, -0.1052, -0.0122, -0.0271, -0.4122, -0.0921, -0.2014, +0.0314, -0.0638, -0.0986, +0.1912, +0.6157, -0.0856, +0.0450, +0.3492, -0.0958, -0.1261, +0.1242, +0.0930, +0.1372, -0.1914, +0.4377, +0.0586, +0.2271, -0.1985, -0.1012, -0.2074, +0.2934, -0.2271, -0.4235, -0.0077, -0.2304, -1.1012, -0.1832, -0.1528, -0.4307, -0.4059, -0.4289, +0.1290, -0.1688, -0.0446, +0.2036, -0.5397, -0.3280, +0.3672, -0.3012, -0.1896, +0.0923, +0.1472, -0.0703, -0.0328, -0.1597, -0.3102, -0.4221, +0.3261, +0.4840, +0.0083, +0.2617, -0.2548, -0.5314, -0.4192, +0.6303, +0.2605, -0.6675, -0.0837, -0.8402, -0.4546, +0.2169, +0.0480, +0.2543, +0.0004, +0.2982, -0.2037, -0.4812, +0.0583, -0.8738, +0.0586, -0.3745, -0.5477, -0.2971, -0.1551, -0.4880, -0.1060, +0.2188, -0.4043, -0.0349, -0.1349, -0.4093, -0.4371, +0.3101, +0.5219, -0.0655, -0.2546, -0.6408, +0.2019, +0.1351, +0.0971, -0.4105, +0.1299, -0.6688, -0.0550, -0.2388, -0.4246, +0.1126, -0.5573],
[ +0.3232, -0.0110, -0.0201, -0.2022, +0.1144, -0.2510, -0.3709, +0.4360, -0.4248, +0.1316, -0.5286, -0.0186, +0.2077, +0.2049, +0.2458, -0.3234, -0.0890, +0.2950, +0.0363, +0.0579, -0.0995, +0.1529, -0.0182, -0.2339, +0.0239, -0.3706, +0.2179, +0.1782, +0.1137, +0.3492, -0.1769, +0.1565, +0.2168, -0.0898, +0.4457, +0.4303, +0.3227, +0.1329, -0.0832, +0.0037, -0.1080, -0.1041, +0.0529, +0.2101, -0.1206, +0.1770, -0.1607, -0.2222, -0.3057, +0.0691, -0.1493, -0.1024, +0.1907, +0.0748, +0.3616, -0.5097, -0.4243, +0.1401, -0.4711, -0.4066, -0.4260, -0.3973, -0.3461, +0.2407, +0.1542, -0.3836, -0.2245, -0.0567, +0.3746, -0.3234, +0.4039, +0.0513, -0.1164, +0.3607, -0.1126, +0.0400, +0.2217, +0.1035, +0.0252, -0.1768, -0.4746, -0.3228, -0.3284, -0.0242, +0.0163, -0.2037, +0.0809, -0.0400, -0.0311, +0.3103, -0.1519, +0.0303, +0.3008, +0.1998, -0.1943, +0.2562, +0.5656, -0.0671, +0.3937, +0.4006, +0.3835, -0.0457, +0.5424, +0.2108, -0.0296, -0.1178, -0.0066, -0.5670, -0.1310, +0.2254, +0.0798, +0.0547, -0.0507, -0.2947, +0.0727, -0.4834, +0.0126, +0.2459, +0.2963, +0.2442, +0.1020, +0.0645, +0.6951, -0.4037, -0.1358, +0.4485, -0.1978, -0.0996],
[ +0.3579, +0.4973, -0.5223, +0.4582, -0.3209, -0.1405, -0.3946, +0.4934, -0.2217, +0.4501, +0.2339, -0.5480, +0.0177, -0.7866, -0.0221, +0.0816, -0.6471, +0.2561, -0.0114, +0.7428, -0.0908, +0.1886, -0.0973, +0.3981, -0.2908, +0.3556, -1.2527, -0.7678, -0.1662, -0.0463, +0.8122, -0.7603, +0.8625, -0.3672, -0.0821, +0.4161, +0.6106, +0.3156, -0.3068, +0.9691, +0.4397, +0.2930, -0.3802, -0.0977, -0.2970, -0.5699, +0.3788, +1.1378, -0.6848, -1.0195, +0.2025, +1.3364, -0.0277, -0.2723, -0.5642, +0.3973, -0.1903, +0.6823, -0.2150, +0.6972, -0.0855, -0.1414, +0.7036, -1.0000, -0.1264, -0.1947, +0.9226, +0.1346, -0.4493, -0.3550, -1.0708, +0.2620, +0.0332, -0.3827, -1.0002, +0.9836, +0.2433, -1.1610, +0.3742, -0.0695, -0.5658, -0.2597, +0.3667, +1.2486, -0.5875, -0.1238, +0.9558, +0.6116, -0.4355, +0.3359, -1.2784, +0.1217, -0.0572, -0.4791, -0.5930, -1.4577, -0.6798, +0.6478, -0.4734, +1.3337, +0.0625, -0.1462, -0.4832, -0.2721, -0.3731, +1.0106, -0.5080, -0.7930, +0.3208, -0.5621, +0.3719, +0.0714, +0.1665, +0.0678, -0.0667, -0.0222, +0.3113, -0.8660, +0.9910, -0.3596, -0.9364, -0.2329, -0.0983, -0.0231, -0.9173, -0.4387, -0.1335, +0.0457],
[ +0.3956, -0.3152, +0.2209, +0.5020, -0.1946, +0.1046, +0.2062, +0.3388, +0.0394, -0.3347, +0.0989, -0.3360, -0.5885, -0.2084, -0.0802, +0.1041, +0.4200, -0.5033, +0.2403, +0.3485, -0.1897, +0.1247, -0.3015, -0.5448, -0.2833, -0.2345, +0.3037, -0.0964, -0.0418, +0.4569, +0.5159, +0.1612, -0.1066, -0.1735, +0.1562, -0.1419, +0.0397, -0.5056, +0.5741, +0.1335, -0.5054, +0.2876, +0.2772, -0.4229, +0.3375, +0.1689, -0.0673, -0.1658, -0.0537, +0.0839, +0.0286, +0.2321, +0.0324, -0.3339, +0.3598, +0.2639, -0.1830, +0.0786, +0.0150, -0.5155, -0.2999, -0.3272, -0.1231, +0.0314, -0.2119, -0.2094, +0.1294, -0.1965, +0.0588, -0.6383, -0.0198, -0.1309, +0.5456, +0.1369, +0.5467, +0.1478, +0.0873, +0.0337, -0.1971, -0.4118, +0.2234, +0.3570, -0.0030, -0.4428, +0.2950, +0.0275, -0.0361, -0.2056, +0.1671, -0.5099, +0.1179, -0.0046, -0.3599, +0.2915, -0.1620, -0.4229, +0.0425, -0.2419, +0.5708, +0.2975, +0.2598, -0.5877, -0.2703, -0.1468, -0.5714, +0.1464, -0.3119, -0.0598, +0.4885, -0.0556, -0.2712, +0.1269, -0.3214, -0.2681, -0.1313, -0.0982, -0.1379, -0.0300, -0.1540, -0.3185, -0.0519, -0.2397, -0.0479, -0.2774, +0.3924, -0.2064, -0.1053, +0.4871],
[ -0.1492, +0.3323, -0.4775, -0.5605, -0.8677, +0.7841, +0.7171, +0.8697, +0.2130, +0.4039, +0.9357, -0.8427, +0.0227, +0.2223, -0.4140, -0.7540, -0.2611, +0.5574, +0.2121, -0.3201, +0.0518, +0.3469, +0.3044, +0.6718, +0.4063, +0.9037, +0.2910, -0.5208, +0.2262, +0.5543, -0.1615, -0.2219, -0.7828, +0.0647, +0.2140, +0.9491, +0.0749, +0.2561, +0.2599, -0.2359, +0.4074, -0.2257, +0.0635, +0.1117, +0.5031, -0.2702, -0.0526, +0.1067, -0.1765, +0.0509, +0.2734, -0.2659, -1.0558, -0.3635, +0.4609, +0.0294, -0.6205, +1.3626, -0.1060, +0.2375, -0.4266, +0.6304, -0.9487, -0.2076, +0.3588, -0.2924, +0.2451, +0.5756, -0.1227, +0.1409, -0.2573, +0.8268, -0.3649, +0.7991, -0.2339, -0.2500, -0.2263, +0.0482, +0.9563, -0.2986, +0.5015, +0.2141, -0.3226, +0.3428, +1.1022, +0.3828, -0.1544, +0.4925, -0.0866, +0.2472, -0.0740, -0.0906, +0.6950, +0.4435, -0.2513, +0.0544, +0.1793, +0.9038, +0.3841, -0.3180, -0.2950, +0.0953, +0.4973, -0.3028, -0.0141, +0.0051, +0.9349, +0.0603, -0.1071, +0.2711, +0.0975, +0.6570, +0.1094, +0.1404, +0.9337, -0.2258, -0.5518, +0.0847, +0.8611, +0.0640, -0.3152, +0.3464, -0.2628, +0.2387, -0.1313, -0.3580, +1.7605, -0.7844],
[ -0.1598, -0.0421, -0.4126, -0.4364, -0.2147, +0.4256, -0.0339, -0.3245, -0.4184, +0.0827, -0.5233, -0.3281, -0.3892, -0.5833, -0.0462, -0.5472, +0.0374, +0.0243, -0.3826, -0.1234, -0.6757, -0.2869, -0.2674, +0.0504, +0.2552, +0.0059, -0.0716, -0.0678, -0.2011, +0.1214, -0.0007, +0.2210, -0.3461, +0.0562, -0.5642, +0.1014, -0.5826, -0.1434, -0.1884, -0.4357, -0.0456, -0.1590, -0.3123, -0.1467, -0.2865, +0.2239, -0.1522, -0.4315, -0.0772, +0.2507, -0.6389, -0.3853, -0.1505, +0.5287, +0.1969, +0.3432, +0.1255, +0.3163, -0.3674, +0.3488, +0.0463, +0.2907, -0.2616, -0.1169, -0.0705, +0.3281, +0.0255, +0.2221, -0.0777, -0.3293, -0.3078, -0.6078, -0.1859, -0.2359, -0.1811, -0.3349, -0.1777, -0.0656, -0.6531, -0.3420, -0.3709, -0.1240, -0.2513, +0.1877, +0.0152, +0.0720, +0.1846, -0.1148, -0.1539, +0.0653, +0.0752, -0.7600, -0.0605, +0.0614, -0.5569, -0.2471, -0.0556, -0.6890, -0.2103, -0.2875, -0.2620, +0.0966, -0.4809, +0.2514, +0.0813, -0.4869, -0.1030, -0.3295, -0.0645, -0.3906, -0.0294, +0.0987, -0.0403, -0.8376, -0.4490, -0.1942, -0.0488, -0.6031, -0.2849, -0.3964, +0.3836, -0.2380, -0.0565, -0.0857, +0.3379, -0.1756, +0.1558, -0.0667],
[ -0.6008, -0.1594, -1.3237, -0.1536, +1.9008, -0.6173, -0.1694, -0.5906, -0.9055, +0.0241, -0.5906, +1.1458, +0.2310, +0.1497, -0.8268, +0.4505, +1.4660, -0.6533, +0.7903, -0.0505, -0.3790, -0.1951, -0.2461, +0.1151, +1.0092, -0.2464, -0.0728, +1.2368, -0.0530, -0.4323, -0.4228, -0.4808, +0.1259, +0.3584, -0.7628, +0.4720, +0.0326, +0.3357, +0.5799, +0.0110, -0.6230, -0.9810, +0.2532, +0.7874, -0.8300, +0.0061, +0.0040, -0.0170, +0.2485, +0.8276, +0.6964, +0.1540, +0.0615, +0.7226, -0.6115, +0.6827, +0.5075, +1.0073, +0.5858, -0.6826, -0.1033, -0.0188, -0.6122, -0.7580, +0.2348, +1.5513, -0.0221, -0.2869, -0.2070, -0.4511, -0.2812, -1.5290, +1.2652, -0.6644, +0.8840, +0.9897, -0.4561, -0.0053, -1.3338, +0.8146, -0.2168, -0.1642, -0.3823, -0.7818, -0.6392, -0.1877, -0.4944, -0.4896, -0.7634, +0.5820, +0.4216, -0.8257, -0.0432, -0.1807, -0.3475, -0.4825, +1.3182, -1.1372, -1.3308, +0.4233, +0.5569, +0.2234, +0.0889, +0.9940, +0.4986, -1.1977, -0.5440, +1.1946, +0.1312, +0.2419, +0.2770, +0.3172, +0.8566, +0.4982, -1.1142, +0.5097, -0.2901, -0.5129, -0.4256, +0.1067, +0.6052, +0.0384, +0.4465, +0.5017, +0.0892, +0.0556, -0.3456, +0.6560],
[ +0.3583, +1.0694, +1.0793, +0.1956, +0.9347, -0.1516, +0.2906, -0.0810, +1.0637, +0.6084, -0.5063, -0.0255, +1.2826, +0.2770, -0.5689, +0.2976, +0.7089, +0.1910, -0.3054, +0.9237, -0.8452, +0.5122, -0.0839, -0.9952, -0.5889, +0.8015, +0.0731, -0.2068, +0.3829, +0.3838, +0.4355, +0.2167, +0.3566, -0.2521, +0.9746, -0.8775, +0.1110, -1.1838, -0.8276, -0.4934, -1.3759, -0.0209, -1.5168, -0.3727, +0.1119, +1.3367, +0.4088, +0.3294, -0.5456, +0.2210, +0.6118, +0.2596, -1.0670, +1.3099, +1.0417, +0.9949, +0.8502, +0.9434, -0.2738, +0.4274, +0.4289, +0.2027, +1.1081, +0.1081, +1.6702, +0.4582, +0.2781, -0.2702, -0.3890, -0.4782, -0.3262, -0.6193, +0.4284, -0.8390, +0.1704, -0.8469, -0.1431, +0.8059, +0.0640, -1.1101, +1.0580, +1.1130, +1.0080, -0.0662, +0.9241, -0.1041, +0.1315, -0.4465, +0.2591, +0.2863, +0.1199, -0.2631, +0.3084, +0.8540, +0.2204, -0.7237, -0.2178, +0.6342, -0.0101, +0.5942, -0.5495, +0.3994, +0.5621, -0.2694, +0.9952, +0.0877, +0.0722, +0.6375, -0.4122, -0.2261, +0.2578, -0.1989, +0.4453, +0.0418, -0.6586, -0.0630, +0.1367, +0.0375, -0.3982, +0.6956, +0.4349, +0.7847, +0.9856, -0.2118, -0.1211, +0.2099, +0.6343, -0.2238],
[ +0.2576, +0.1708, +0.5942, -0.8994, -0.0868, +0.7046, +0.8070, +0.3142, +0.4562, +0.5703, -0.5525, +0.0864, +0.2016, -0.9636, +0.7642, -0.4136, +0.3538, +0.0215, -0.0008, -0.4398, +0.5139, +0.4963, -0.8291, +0.6681, +0.2463, +0.1906, -0.0195, -0.1146, -0.0489, -1.0220, +0.3947, +0.0897, +0.3557, -0.0899, +0.7004, +0.0732, +0.4142, -0.5701, -0.1690, +0.0402, -0.3416, -0.9773, +0.0455, -0.1412, -0.8012, -0.3097, -0.9837, +0.4047, -0.7972, -0.2902, -0.3245, +0.0464, -0.2058, +0.6175, +0.9464, +0.2569, -0.5419, -0.0480, +0.4761, +0.4906, -1.0051, -0.0336, +0.1762, +0.7865, +0.5313, +0.2276, +0.3898, -0.5483, -0.7494, -0.5172, -0.6968, -0.7780, +0.6258, -0.1979, -0.3625, +0.0796, -0.5390, -0.2714, +0.4319, -0.9952, +0.1555, +0.7258, +0.3754, -0.5892, -0.0937, +0.9012, +1.3195, -0.2689, -1.6369, +0.4650, +0.1741, -0.2305, -0.7181, -0.3967, +1.0093, +0.1660, +0.0568, +0.1924, +0.0595, +0.4189, -1.1472, -0.9761, -0.4957, +0.0854, +0.8852, +0.2884, +0.2345, -0.1550, +0.9522, -0.1306, -0.1394, -1.3291, +0.0207, +0.3611, -0.0699, -0.0948, +1.7921, +0.1665, -0.5039, -0.4613, -0.1789, +0.4391, -0.5099, -0.5557, -0.2059, +0.1237, +0.0259, -0.1886],
[ +0.2817, -0.0454, +0.1386, -0.1673, +0.2426, -0.0467, -0.1203, +0.3156, -0.0052, +0.3391, +0.1706, +0.1125, -0.1778, -0.5539, +0.2748, -0.0129, -0.2321, +0.5550, +0.1019, -0.9796, -0.2074, -1.3227, -0.7212, +0.4632, +0.0566, -0.4680, -0.5681, -0.5756, -1.4594, -0.3052, +0.2753, -0.6632, +0.0368, +0.2291, -0.0578, +0.3663, -0.1122, +0.0024, +0.5366, -0.3653, +0.2721, -0.0873, -0.1185, -0.3832, -0.5141, -0.0425, -0.0007, +0.2201, -0.0954, -0.4895, -0.3387, +0.5406, +0.1037, +0.0756, -0.2258, +0.1772, +0.1323, +0.2892, -0.5137, +0.2084, -0.1640, -0.7629, +0.4224, +0.3344, -0.5014, +0.1077, -0.4575, +0.3734, +0.2012, -0.2691, -0.3532, +0.5112, +0.2323, +0.2361, -0.6075, +0.0756, -0.6252, -0.2803, +0.1436, +0.1922, +0.1045, +0.2936, +0.0511, +0.0997, +0.1260, -0.7201, +0.2040, -0.6068, -0.2572, -1.1220, -0.4336, +0.1953, +0.2289, +0.0583, -0.0825, +0.0174, +0.2520, +0.3962, +0.1735, -0.1254, -0.2769, -0.0927, -0.8869, +0.2688, +0.0637, -0.0104, +0.1743, +0.6607, +0.3604, +0.0411, +0.6830, -0.2192, +0.6120, +0.5902, -0.0692, +0.0640, -0.4776, -0.3384, +0.3360, -0.2106, -0.2018, -0.1111, +0.4084, -1.0131, +0.1918, +0.1225, +0.1328, -0.1810],
[ -0.5625, +0.6491, -0.2732, +0.4952, -0.1584, +0.2908, -0.6854, -0.4982, -0.0942, -0.2324, +0.2329, +0.3380, +0.4047, +0.8220, +0.1344, +0.2586, -0.2234, +0.1572, -0.5163, +0.5888, +0.3405, -0.3463, +0.9772, +0.1675, -0.6181, +0.4957, +0.6584, -0.1368, -0.1735, +0.4557, +0.6991, -0.0403, +0.2271, +0.2258, +0.2296, -0.0160, -0.4586, -0.4367, +0.5504, +0.5095, -0.0341, +0.4141, +0.0418, -0.2047, +0.3971, +0.3569, +0.6946, +0.1311, +0.3614, -0.0544, +0.7212, +0.0162, +0.0360, -0.3230, +0.4143, -0.2461, +0.1784, -0.2672, -0.7151, +0.0920, +0.2453, -0.1601, -0.1728, +0.0921, +0.3203, +0.1281, +0.7218, -0.2275, +0.6779, -0.4679, +0.2388, -0.2174, +0.1108, -0.2124, +0.1118, +0.1878, +0.6509, -0.2355, -0.3070, -0.1175, -0.8563, +0.7712, +0.7216, +0.2705, -0.3359, +0.0834, +0.3364, -0.9102, -0.0050, -0.2038, -0.3887, -0.0003, +0.3009, +0.5568, +0.4128, -0.1470, -0.4033, +0.4556, -0.0164, +0.6296, -0.6479, -0.6349, -0.4118, -0.1700, +0.5044, +0.6149, +0.5285, +0.2198, -0.5983, +1.1778, +0.1033, -0.1016, +0.5921, -0.3015, -0.4725, -0.1732, -0.0215, +0.7037, +0.5043, -0.7740, -0.4181, -0.1432, +0.4241, +0.5390, -0.8923, +0.8941, -0.2442, -0.1354],
[ -0.3359, -0.1083, -0.8409, +0.2590, +0.3363, +0.1838, -0.3840, +0.3864, +0.2034, -0.3445, +0.0949, -0.1383, +0.3539, -0.5850, -0.0659, +0.4438, +0.3457, -0.7643, +0.0728, -0.0271, +0.1040, -0.1681, +0.3348, +0.5446, -0.6685, +0.4041, -0.0872, -0.2793, +0.2181, +0.0853, -0.0353, -0.5413, -0.1816, -0.1187, +0.1640, -0.2443, +0.1492, -0.2037, -0.0081, +0.0258, +0.2739, +0.0343, -0.1295, +0.0078, +0.0392, +0.4218, +0.3354, +0.6948, +0.0345, -0.7231, +0.8704, +0.1680, -0.1541, -0.5035, -0.0281, +0.0994, +0.3783, +0.2794, -0.4267, -0.6257, -0.2330, -0.3536, -0.1162, -0.0411, +0.1763, +0.1975, +0.1464, +0.0609, -0.2487, +0.3408, -0.7077, +0.0542, -0.3465, +0.0497, +0.1247, +0.1681, -0.4003, -0.2574, +0.1809, -0.0013, -0.1649, -0.3992, +0.3628, +0.0089, +0.3263, -0.3100, +0.2304, -0.2072, -0.2944, -0.4202, -0.0603, -0.0752, -0.2653, +0.2389, +0.6501, +0.0928, -0.8089, +0.1342, +0.3140, -0.2359, -0.3699, +0.0832, -0.4305, -0.5970, +0.3982, +0.7136, +0.3347, -0.1750, -0.5559, +0.1141, +0.0591, -0.1708, -0.3083, -0.4088, +0.5476, -0.0705, -0.1452, +0.2297, +0.1725, -0.4675, -0.2641, +0.2952, +0.2449, -0.3262, -0.2343, -0.2551, +0.2011, +0.3487]
])

weights_dense1_b = np.array([ +0.0032, +0.0591, +0.1871, -0.0873, +0.0194, -0.1684, -0.0091, +0.0135, -0.0694, -0.3312, +0.0673, -0.1489, +0.1365, +0.0575, -0.1155, -0.0904, -0.1321, +0.0492, -0.2257, -0.2418, -0.0204, -0.1910, -0.0512, -0.0482, -0.2969, -0.3574, -0.1852, -0.1644, -0.2957, -0.1906, -0.0170, -0.0760, +0.0006, -0.1286, -0.0746, +0.0039, -0.1005, -0.0535, +0.0375, -0.2162, -0.1251, -0.0368, +0.0101, -0.3220, -0.1152, -0.3656, -0.2491, +0.0638, -0.0312, +0.0054, -0.2318, -0.2900, -0.1189, -0.0725, +0.0490, -0.0679, +0.0117, +0.0926, -0.0824, +0.0479, +0.0756, -0.0462, +0.1529, +0.0081, -0.0984, -0.1227, -0.0247, -0.1277, -0.0633, -0.1953, +0.1023, +0.1582, -0.0400, -0.1115, -0.1625, -0.2216, -0.0195, -0.0650, +0.0701, -0.1573, -0.1187, -0.0801, -0.1424, +0.1873, -0.2309, -0.1815, -0.0408, -0.1173, +0.0185, -0.1408, -0.0938, -0.2810, +0.2447, -0.4046, -0.1790, -0.0165, +0.1334, +0.0500, +0.0283, -0.0321, -0.2388, -0.0726, -0.3444, -0.3250, -0.1338, -0.0579, -0.1647, -0.0691, -0.0835, +0.0734, +0.1667, -0.1478, -0.2212, -0.0899, -0.0050, -0.2379, +0.0709, +0.0464, +0.1569, -0.2669, -0.2181, -0.4331, +0.0534, -0.0648, -0.1026, -0.1509, -0.2278, -0.0437])

weights_dense2_w = np.array([
[ -0.5294, -0.0896, +0.1998, -1.0655, -1.0578, -0.2702, +0.0052, +0.1819, -0.2272, -1.3830, +0.0185, +0.0236, +0.0611, +0.3201, -0.1723, +0.2887, -0.4885, +0.3460, -0.0437, -0.4517, +0.1636, +0.0027, -0.5574, -0.4712, -0.2482, +0.1202, +0.6143, -0.6510, -0.5672, -0.7578, -0.2628, -0.5118, +0.2114, +0.3419, +0.3262, -0.1558, +0.4818, -0.4314, -0.4611, -0.3294, +0.2443, -0.4138, +0.2451, -0.2765, -0.4818, +0.0854, -0.0011, +0.0080, -0.3759, -0.1235, -0.2526, +0.3319, -0.7957, -0.3891, +0.6225, +0.7334, -0.3936, -0.2982, +0.2974, -0.2766, +0.0199, -1.0206, -0.4054, -0.0960],
[ -0.5329, -0.7876, -0.4974, +0.3381, +0.3092, +0.0208, -0.2402, -0.3306, -0.7425, +0.1489, +0.0271, -0.1945, +0.0315, +0.1836, +0.2294, -0.6615, -0.1362, +0.2090, -0.5984, -0.0163, +0.0886, +0.0679, +0.3041, -0.0070, -0.0550, +0.3623, -0.0483, -0.2679, +0.2927, +0.2728, +0.2955, -0.0641, +0.2888, +0.0278, +0.1980, +0.0714, +0.1605, +0.1879, +0.0666, -0.0505, +0.3625, +0.3155, -0.1965, -0.0301, +0.1697, -0.0102, -0.4709, -0.4190, +0.0265, -1.0402, -0.0718, +0.3172, -0.1062, -0.2538, -0.4556, -0.2825, -0.0534, -0.1540, +0.0872, +0.1585, -0.4927, -0.0311, +0.2163, -0.8230],
[ -0.0620, -0.4689, -0.0407, -1.5569, -0.1551, -0.2028, -0.3836, -0.0306, -0.0718, -0.9097, -0.1025, +0.1040, +0.1657, +0.1093, -0.2807, +0.3353, -0.6893, +0.6661, +0.1312, -0.8763, -1.5289, -1.4383, +0.1129, +0.2337, -0.0876, -0.8757, +0.0550, -0.3456, +0.1468, -0.6056, -0.8811, -0.3539, +0.6850, +0.1739, +0.0344, -0.0354, -0.2883, -0.1680, -0.3950, -0.7221, -1.8289, -0.2404, -0.2498, +0.1401, +0.3679, -0.1029, -0.2085, -0.9932, -0.1101, -0.4335, -0.1423, -0.3566, -0.4630, +0.1845, +0.3527, -0.4799, -1.7876, +0.3755, +0.2791, +0.1744, -0.3218, -0.4807, -0.2936, +0.2639],
[ -0.1966, +0.5649, -0.2069, +0.3588, -0.8745, +0.8721, +0.0814, +0.1852, +0.1873, -0.0432, -0.7933, -0.2585, -0.1218, -0.4980, +0.3300, +0.3064, -1.0648, -0.6760, +0.0998, +0.6166, -0.2364, +0.0741, -1.5132, -1.1618, -0.0384, +0.1799, -0.5393, +0.2645, -0.2358, +0.0418, +0.3921, -0.8185, +0.5272, +0.4155, -0.2473, +0.0026, -0.4362, -0.1113, -0.1036, -1.0282, -0.2206, +0.5201, -0.1124, +0.3642, +0.0213, +0.1247, +0.0868, +0.3541, -0.0376, -0.0735, +0.4899, -0.5098, -0.7578, -0.3030, +0.2886, -0.7427, -0.4035, +0.0161, -0.4715, +0.0235, +0.5217, -0.2785, +0.0707, -0.2289],
[ -0.7238, +0.4670, -0.0149, +0.2279, -0.1295, +0.0670, -0.2468, +0.4984, +0.6797, +0.2095, -0.2371, -1.1373, -0.0913, -0.6137, -0.1067, +0.0817, -0.4967, -0.3839, -0.0531, -0.3020, -0.2330, -0.1719, -0.2915, -0.3750, -0.1896, -0.0480, -0.2671, +0.5401, -0.0648, -0.8036, +0.2070, -0.9393, +0.1914, +0.2418, -0.0981, -0.4760, -0.0516, -0.8327, +0.1371, -0.7785, -0.1945, -0.6666, -0.0209, +0.0864, -0.7345, -0.3576, -0.2442, +0.3027, -0.4184, +0.2634, +0.2169, +1.1403, -0.4589, +0.0943, -0.0657, -0.2680, -0.6890, -1.2024, -0.2191, -0.1494, -0.0415, -0.9274, +0.3765, +0.2284],
[ +0.0721, +0.2423, +0.2696, -0.8249, -0.0644, -0.3427, -0.2876, -0.2066, +0.2195, +0.1008, +0.1247, +0.2757, -0.1372, -0.0132, +0.1199, -0.1206, +0.1263, +0.0607, -0.1235, -0.3237, +0.5096, -0.0538, +0.4292, -0.2570, -0.2744, -0.1671, +0.0643, +0.2648, -0.1993, +0.0420, +0.1681, +0.3126, -0.3654, -0.2719, +0.3103, +0.2754, +0.0040, -0.4387, -0.0634, +0.2868, +0.0613, -0.1423, +0.0911, -0.6027, -0.2560, -0.0131, -0.5504, -0.6812, +0.0176, +0.1782, -0.0082, -0.2754, +0.1471, +0.2872, -0.5940, +0.1319, +0.0220, +0.3727, +0.2380, +0.0558, +0.1206, +0.2882, +0.0155, +0.2597],
[ -0.1229, -0.7953, -0.2690, -0.8715, -0.8578, +0.0133, +0.2098, -0.0996, -0.0174, +0.5429, -0.3021, -0.1241, +0.0091, -1.2123, +0.0488, -0.4687, -0.6124, -0.7139, -0.2042, -0.4138, -0.3101, -0.1909, +0.1478, -0.5427, -0.2557, -0.1813, +0.4605, -0.6159, -0.1311, -0.3425, -0.9877, -1.2896, -0.4583, +0.2293, -1.0717, +0.0631, +0.0908, -0.1255, -0.8500, +0.0157, +0.1026, -0.6678, -0.4511, -0.1720, -0.1051, -0.0788, -1.1285, -0.7684, -0.5400, -0.0879, -1.3907, +0.8072, +0.3826, +0.5732, -0.6696, +0.3482, -0.2598, -0.9451, +0.0000, +0.1565, -0.9628, -0.5438, -0.2299, +0.0864],
[ -0.3683, +0.2445, -0.6280, -0.6619, -0.3666, -0.4500, -0.5599, -0.6186, +0.0152, -0.2720, +0.0609, -0.3384, -0.0136, +0.1575, +0.3848, -0.5577, +0.7921, -0.4193, +0.0182, +0.3805, +0.0310, +0.2653, -0.0866, +0.3095, -0.2329, -0.1241, +0.1641, -0.2871, +0.0675, -0.2960, +0.1917, -0.3727, +0.0599, +0.4283, -0.7127, -0.0708, -0.0144, +0.3581, -0.7382, -0.1784, -0.3748, -0.1627, -0.5114, -0.2711, +0.0602, -0.2263, -0.1847, -0.1914, -0.2189, -0.3361, +0.0516, -1.3228, +0.0331, +0.3685, +0.2941, -0.4427, +0.2907, -0.7059, -0.1141, -0.0540, +0.0532, -0.1200, +0.0966, -0.0749],
[ -1.1537, -0.0967, -0.3476, -0.2341, +0.5311, -0.1617, -0.3381, +0.1348, +0.2100, -1.0730, -0.0577, -0.0237, -0.0373, -0.5123, +0.2998, -0.3247, +0.5258, +0.3037, -0.0538, +0.3679, -0.3760, +0.0351, +0.5999, +0.4626, -0.1599, -1.1580, -0.1344, +0.6217, -0.2474, -0.6322, -0.7804, -0.2596, +0.6680, -0.1191, -0.0805, +0.2087, -0.1946, -0.2961, -0.2653, -0.1915, +0.1113, -0.6597, +0.0847, -0.0599, +0.6311, -0.8174, -0.8733, -0.5911, +0.1962, -0.1327, -0.1959, +0.7040, +0.6005, +0.1157, -0.4948, -0.5988, +0.4162, -0.3101, +0.0050, +0.6379, +0.0811, -0.0415, +0.2975, +0.4097],
[ -0.0605, -1.4543, +0.3715, +0.0582, -0.1646, +0.0919, -0.8151, -0.0222, -0.5294, -0.4140, -0.4782, -0.0889, -0.2930, -0.7260, -0.1270, -0.2699, -0.2068, -0.4855, -0.0244, +0.5308, +0.2588, +0.0277, +0.1398, -0.0020, -0.0209, +0.4305, +0.5735, -0.4727, -0.1810, -0.1060, +0.1201, +0.2439, -0.2472, -0.0717, +0.1351, +0.3603, +0.3060, -0.3795, -0.2812, -0.2544, +0.1106, -0.0701, +0.2985, -0.1396, -0.2122, +0.4243, -0.2770, -0.5565, -0.2525, +0.0816, -0.4047, -0.2782, -0.7214, -0.1042, -0.1084, +0.1894, +0.8661, -0.1578, +0.3679, +0.2941, +0.0799, -0.3008, -0.1891, -0.4522],
[ -0.1581, -0.8760, -0.6871, +0.1299, -0.4920, -0.2449, +0.2764, -1.4836, -0.7051, +0.3574, -0.2647, -0.2578, -0.0707, +0.1505, -0.0393, -0.5107, +0.0504, +0.2922, -0.1558, +0.0842, -0.0566, +0.0806, +0.2948, +0.1275, +0.0113, +0.0670, +0.5678, +0.0579, -0.0082, -0.0575, +0.2882, +0.0579, +0.1669, -0.5888, -0.1277, -0.1875, -0.2031, +0.2563, -0.4510, +0.1176, -0.6062, +0.0932, -0.4625, +0.0489, -0.4213, +0.1625, +0.0889, +0.3401, -0.4626, -0.1120, -0.3998, -0.3627, +0.5388, +0.3221, +0.0293, +0.4626, -0.4754, -0.7499, -0.5847, -0.3559, +0.3759, +0.6087, -0.6434, -0.3520],
[ +0.2500, +0.1920, -0.0041, +0.3031, +0.1244, +0.2579, -0.3249, +0.6266, +0.0798, -0.6341, +0.1762, -0.0811, -0.2604, -0.4294, -0.1638, -0.0724, -0.2681, -0.0688, -0.1879, +0.4750, +0.4832, +0.2947, +0.2664, +0.2740, -0.0683, +0.2160, -0.1307, +0.1062, +0.0801, -1.2182, +0.3045, +0.1882, -0.0800, -0.3235, -0.5861, -0.2444, -0.0772, +0.1528, -0.1473, +0.0380, -0.0192, -0.1198, +0.1908, -0.5856, -0.3644, -0.0235, +0.4902, -0.6515, -0.3490, +0.0620, +0.2643, +0.1549, -0.0580, -0.1879, +0.1547, -0.5689, +0.2646, +0.2184, -0.1865, -0.6921, +0.3484, -0.0395, -0.0506, +0.0883],
[ +0.3222, -0.6081, -0.8570, +0.1662, -1.6457, -0.1301, +0.4362, -0.3683, -1.2053, +0.0051, +0.4562, +0.1176, +0.0681, +0.0442, +0.0929, -0.1070, +0.0833, -0.9221, -0.1152, -1.3000, +0.1766, +0.5323, -1.3052, -0.8361, -0.1032, +0.1584, -0.3473, -0.1487, -0.5833, -0.0997, -0.1513, +0.0293, +0.3824, -0.0470, -0.3443, -0.4211, -0.2198, -0.0394, -0.7857, +0.6342, -0.0022, -0.2827, -1.2328, +0.8836, -0.1748, +0.0327, -0.2512, -0.3752, -0.1145, -0.8466, -0.6688, -0.2503, +0.0641, -0.0112, -0.5286, -0.6550, -0.8791, +0.1105, -0.4148, +0.6753, +0.4758, -0.0569, +0.0966, -0.9476],
[ -0.4199, -0.6072, -0.4537, -0.4169, -0.8892, +0.2855, +0.5756, -0.0186, -0.5130, -0.1059, -0.7573, -0.0568, -0.0684, -0.6527, -0.0938, -0.0042, -0.3279, -0.4445, +0.0217, +0.0967, -0.7654, -0.2576, -1.3607, -0.5645, +0.1616, +0.0616, -0.7005, -0.2452, +0.2257, -0.5849, +0.6963, -1.0530, -1.3240, -0.1119, -0.9036, -0.0479, -0.4890, +0.5005, -1.4962, +0.2961, -1.2472, -0.2179, +0.0196, +0.5316, -0.0054, -0.0947, -0.6427, -0.0188, -0.4429, +0.5082, -0.0946, -0.4850, +0.3228, +0.1117, +0.3974, +0.0178, -0.0763, -1.3113, -0.5316, +0.0163, -0.2001, -0.2488, +0.3841, -0.1722],
[ -0.1212, -0.3952, +0.0911, -0.5135, -0.2093, -0.7678, +0.1495, +0.0407, +0.3257, +0.0601, -0.2006, +0.3888, -0.1896, +0.1708, -0.2838, -0.6900, +0.0937, +0.2306, +0.0376, -0.3426, -0.2854, -0.3829, +0.4875, +0.0551, +0.0143, -0.2186, +0.0469, -0.8389, -0.7003, +0.2505, -0.5086, +0.1452, -0.3577, -0.5950, -0.1434, -0.3216, -0.7059, +0.1497, -0.1612, +0.4857, -0.2867, -0.1537, -0.2302, -0.6386, +0.3762, +0.2766, +0.1610, -0.6457, +0.4320, -0.3433, +0.0201, -0.1067, +0.2527, +0.2581, -0.0995, -0.1953, -0.0237, +0.8414, +0.4549, -0.1515, -0.1875, -0.1065, -0.2381, -0.4321],
[ -0.3393, -0.3520, -0.9045, +0.6000, +0.5172, -0.1926, -0.1635, +0.1719, -0.6527, +0.2668, +0.3255, -0.0443, +0.0438, -0.4045, -0.2399, -0.4114, -0.7029, -0.0357, -0.4091, -0.0354, -0.1053, +0.0729, -0.6477, -0.2433, -0.0480, +0.2689, +0.2895, +0.0905, -0.3754, -0.9434, +0.5497, -0.0091, +0.2105, -0.1584, +0.0904, -0.3422, +0.2668, -0.1983, +0.4242, -0.2503, -0.4326, -0.3479, -0.4545, +0.8625, -0.3452, +0.6519, +0.1031, +0.3487, -0.3660, -0.0598, +0.2381, +0.8141, -0.2223, -0.1759, -0.0212, -0.0058, -0.2119, +0.0731, -0.0786, -0.3202, -0.2608, -0.7982, +0.4981, +0.1286],
[ -0.5110, +0.3147, +0.1463, -0.0389, -0.3521, +0.3138, -0.4345, -0.1397, +0.4069, +0.4113, -0.1701, +0.0171, -0.0710, -0.0741, -0.1748, +0.1410, +0.1965, -0.9863, -0.1121, +0.2325, -0.0745, +0.0503, -0.3608, -1.0871, -0.1174, +0.2476, -1.4639, +0.1530, +0.3929, +0.2179, -0.1187, -0.2966, -0.0866, +0.1865, -0.9683, -0.2727, -0.0255, -0.4145, +0.1239, -0.0952, -0.0126, +0.2078, +0.0525, -1.2549, -0.4354, -0.1329, -0.1288, -0.0279, -0.1269, +0.0084, +0.4687, +0.1488, -0.3704, +0.3366, +0.1487, -0.7377, -0.4681, -0.2716, -0.2919, +0.0930, -0.2879, -0.4733, -0.1250, +0.3180],
[ -0.2212, -0.1165, +0.0573, -0.0257, +0.4105, -0.3042, -0.2197, +0.1105, -0.0834, -0.3845, +0.0174, +0.0070, +0.0297, +0.0073, -0.5144, +0.3017, +0.1921, +0.4018, -0.2265, -0.2572, +0.2103, -0.5301, -0.0210, +0.7838, +0.1188, +0.0774, +0.4195, -0.8113, +0.3870, +0.2450, -0.8158, +0.7872, +0.0218, +0.1636, -0.1837, +0.0628, +0.4486, -0.0948, +0.1513, -0.8843, -0.5782, -0.1950, +0.2832, -0.2192, +0.6143, -0.0574, +0.2811, -0.4833, +0.1312, +0.2647, -0.0071, +0.3059, -0.0858, -0.6766, +0.1089, +0.3099, -0.2368, +0.2549, +0.4027, -0.1061, -1.1896, -0.6198, -0.3528, +0.1676],
[ +0.0035, -0.4849, -0.7783, -0.0504, +0.2348, -0.0571, +0.4417, +0.0601, -0.8799, +0.1450, -0.0952, -0.3266, +0.0411, -0.7422, +0.0060, -0.2092, -0.1885, -1.2113, -0.0374, +0.0568, +0.1130, -0.0895, +0.0957, +0.1047, +0.1396, -0.0320, -0.2089, +0.1098, -0.4008, +0.0389, +0.0482, -0.2914, -0.9251, +0.4323, +0.1206, +0.0567, +0.0699, +0.0587, +0.0422, +0.2053, +0.0602, -0.7918, +0.1464, +0.3530, -1.2250, -0.2547, +0.3194, -0.8625, -0.4735, +0.4783, +0.0043, +0.1931, +0.1671, +0.0328, -0.0747, +0.6361, +0.2269, -0.5492, +0.1361, -0.1751, -0.0100, -0.2549, -1.0106, -0.9024],
[ +0.2591, -1.0195, -0.4721, -0.9731, +0.0299, +0.2645, +0.3216, -0.1474, -0.4643, -0.0471, -0.2468, +0.2281, +0.0187, -0.0859, +0.0399, +0.0137, -0.4151, -0.7058, -0.4788, +0.3670, -0.3171, -0.5478, -0.3702, -0.2157, +0.0541, -1.3574, -0.5394, -0.1754, +0.4716, -0.3429, +0.6257, -0.6191, -0.0252, -0.3959, +0.5052, +0.1172, -0.0161, +0.0461, -0.3518, -0.6841, +0.0599, +0.7104, -1.4835, +0.2076, -0.3105, -0.2433, -0.0676, +0.2361, +0.1693, -0.5076, -0.1233, -0.1134, -0.2816, -0.5818, +0.0513, -0.9941, +0.4563, -0.2065, -0.7186, -0.5165, -0.6421, -0.1892, +0.1439, -0.2584],
[ +0.0525, +0.2656, -0.3646, -0.8030, -0.2153, -0.0913, -0.3868, +0.3407, -0.1766, +0.4419, -0.3384, +0.2972, -0.0482, +0.2394, +0.2429, -0.1640, +0.4954, -0.0242, -0.5130, +0.2863, +0.6940, +0.1821, +0.3729, -0.3485, -0.2009, +0.4411, +0.0800, +0.1678, -0.6286, -0.4632, -0.0660, +0.1633, -0.7075, -0.4767, +0.0660, +0.3576, -0.1382, +0.4100, -0.1458, +0.2652, +0.0179, -0.2446, -0.6880, -0.2835, -0.6586, +0.3138, -0.0370, -0.5427, -0.0139, +0.0475, +0.0476, +0.2838, +0.1937, +0.0958, -0.6775, -0.0984, -0.4858, +0.2718, +0.0920, -0.1442, -0.3254, +0.4006, +0.3794, -0.1053],
[ -0.7993, +0.2057, -0.0825, -0.5901, +0.4015, +0.7778, +0.2741, +0.3809, -0.0990, -0.1496, +0.4271, +0.2286, +0.1506, -0.0415, +0.5997, -0.6465, +0.0393, +0.3040, +0.2443, -0.2178, -1.3364, -0.4051, +0.3383, -0.0159, +0.1492, +0.0452, -0.1428, -0.2160, +0.2785, +0.6410, -0.6244, +0.3319, -0.4489, -0.1197, -1.1882, +0.3110, +0.5941, +0.1675, +0.2606, -0.9117, +0.3474, -0.4273, +0.6581, -0.0334, -0.5226, -1.0439, -2.6607, -0.2681, +0.5722, -0.1204, -0.8560, -0.5789, -0.4583, +0.1208, -1.2444, -0.3378, -0.9704, -0.0412, +0.1563, -0.1445, -1.2344, -0.5351, -0.2627, -0.0315],
[ -0.2311, +0.0027, -0.9287, -0.1228, -0.8419, +0.1478, -0.3367, -0.2493, -0.1044, -0.0661, -0.5176, +0.1812, -0.1505, +0.3252, +0.0689, -0.1895, -0.6359, +0.3539, +0.0074, +0.2096, -0.1721, -0.6680, -0.1181, +0.0884, -0.1903, -0.3968, +0.2160, -0.8183, -0.1148, -0.5661, +0.1892, -1.3805, +0.4477, -0.0261, +0.0525, +0.2808, -0.5591, +0.5135, -0.3758, +0.1060, +0.6081, -0.3552, -1.2404, +0.0532, +0.2700, +0.0979, -0.6299, -0.0514, +0.3286, +0.1688, -0.4352, -0.8093, -0.0033, +0.2607, +0.2893, -0.3395, -0.5950, +0.0470, -0.4043, -0.8434, -0.4925, -0.6462, -0.3282, -0.0198],
[ +0.3055, +0.4763, +0.3049, -0.9238, +0.2499, -0.8889, +0.0817, +0.1527, +0.3570, -1.2277, +0.5060, +0.5231, -0.0977, +0.7970, -0.3972, -0.0988, +0.7831, -0.4279, +0.0235, +0.3373, +0.6341, +0.2142, -0.1506, +0.6003, -0.3704, -0.0476, +0.2141, -0.4490, -0.3270, -0.4279, -0.2669, +1.0325, -0.7446, -0.5226, +0.2484, -0.3719, +0.0762, -0.2644, +0.4603, +0.3430, +0.0474, +0.0505, -0.0625, -0.1566, -1.0823, +0.0666, +0.1685, -1.7572, +0.5213, -0.0229, +0.4925, -0.9132, +0.2729, -0.0375, -0.0308, -0.0809, -0.0612, +0.5318, -0.3841, -0.3973, +0.0513, +0.3254, +0.0226, +0.0897],
[ -0.4901, +0.4057, +0.4243, -0.1017, -0.5561, +0.0413, -0.1884, +0.0115, +0.3556, +0.4905, +0.4599, +0.3225, -0.2060, -1.0437, -0.1747, +0.4379, -0.2705, -0.4107, -0.2775, +0.2060, +0.1902, +0.1741, -0.0650, -0.7355, -0.0770, -0.1194, -0.3411, -0.3670, -0.3807, +0.3297, -0.3163, +0.2963, +0.5599, +0.6562, -0.2402, -0.0244, +0.2263, -0.0590, +0.2397, +0.4873, +0.0771, +0.5808, +0.4708, -0.1900, -0.6152, +0.4273, +0.5762, -0.3754, -0.2344, +0.3123, -0.1155, -0.3437, -1.0409, -0.1489, -0.1104, +0.3270, +0.3800, +0.3680, +0.2113, -0.5376, +0.1063, +0.0841, -0.5439, -0.1957],
[ -1.9974, -0.0211, -0.2446, -0.3544, -0.7249, -0.3924, -0.5035, -0.2175, -0.1627, -0.8428, -0.1119, -0.0274, -0.0418, -0.1262, +0.3002, -0.1632, -0.2389, +0.3389, +0.0569, +0.0202, -1.0143, +0.3537, -0.1440, +0.3140, -0.1313, -0.3848, +0.7528, -0.6598, -1.0451, +0.5417, -0.0634, +0.1701, -0.6359, +0.3913, +0.9036, +0.8082, -0.6004, -0.0083, -0.8911, -0.0479, +0.1066, -0.4130, +0.2471, +0.5112, +0.3424, +0.2349, +0.2216, -0.1641, +0.0944, -0.3781, -0.2863, +0.2887, -0.1032, +0.2387, +0.1109, -0.1010, +0.6019, -0.6929, -1.1630, +0.1658, -0.0167, -0.2142, +0.3414, -0.6920],
[ +0.6931, +0.0145, +0.3552, -0.1500, -0.6177, +0.2065, +0.1103, -0.1340, +0.5208, +0.3153, -0.4249, +0.2061, -0.1484, -0.2901, +0.2288, -0.3281, -1.4010, -0.6546, -0.0633, +0.1697, -0.6311, -0.4404, -0.1730, -0.9839, -0.0577, +0.3237, -0.0267, -0.2236, +0.3860, +0.3659, +0.2307, +0.5690, -1.0721, -1.0289, +0.3124, -0.4391, -1.4334, +0.3776, -0.7681, -0.3304, +0.0015, +0.0868, -2.1094, -1.2462, +0.0804, +0.1231, -0.2476, -0.5150, -0.3384, -0.1315, -0.3313, +0.2172, +0.3345, +0.0750, +0.0769, +0.7963, -0.0705, +0.0998, +0.0840, -0.3474, -0.0533, +0.1124, -0.0993, -0.2206],
[ +0.0738, +0.4493, +0.0851, -0.2606, -0.4232, +0.1632, +0.0389, +0.0128, +0.3265, -0.1896, +0.3890, +0.2983, -0.1198, -1.0363, -0.0076, +0.2032, -0.7419, -1.0515, -0.1930, -0.0945, -0.0872, -0.1580, -0.2602, -1.4956, -0.1525, +0.4170, -0.9875, +0.3425, +0.3709, +0.1006, +0.0766, +0.0740, -0.3491, +0.1276, -0.2520, -0.0348, -0.6866, +0.0363, +0.4659, -0.2804, -0.3475, -0.1448, +0.0616, -0.8020, -0.2784, +0.2680, +0.3337, -0.0333, -0.5948, +0.4099, +0.2169, -0.4844, -0.6288, -0.1061, +0.1890, -0.2980, +0.0414, +0.2023, +0.0107, -0.6235, -0.0916, -0.2670, -0.2182, -0.4410],
[ +0.3507, +0.5252, -0.1627, -1.4898, +0.2313, +0.5587, +0.2386, +0.3379, +0.0982, +0.0413, +0.3709, +0.4906, +0.0007, -0.4149, +0.4735, -0.1098, -0.5601, +0.2028, +0.3657, -0.4582, -1.6526, -0.4622, +0.3676, -0.5300, +0.1754, +0.0149, +0.1038, -0.2189, +0.1419, +0.4394, -0.3616, +0.2069, -0.7841, -0.3796, -0.7757, +0.5907, +0.1856, +0.1489, +0.4881, -1.1035, +0.0189, -0.1605, +0.6046, -0.6840, -0.5543, -0.0317, -1.1382, +0.0052, +0.3898, +0.5780, -0.1522, -0.3236, -0.4997, +0.1208, +0.3768, +0.5135, -0.2755, -0.1092, +0.2018, -0.2345, -1.4905, -0.1996, -0.2652, -0.1369],
[ -0.0105, +0.5400, +0.0687, +0.3213, -0.9347, +0.3641, -0.1674, -0.4105, +0.1847, -0.2406, -0.4423, -0.6186, -0.1456, -0.2169, +0.3144, -0.1460, +0.1520, +0.2036, +0.1390, +0.0801, -0.5625, -0.1819, -0.3711, -0.2140, -0.2649, -0.0028, +0.4067, -0.8796, -0.1423, -0.3487, -0.1759, -0.5259, -0.4894, +0.2141, -0.0896, +0.6119, +0.2727, +0.4561, -0.0039, -0.5774, -0.9105, -0.0751, +0.9462, +0.2550, +0.2783, -0.2219, -0.1080, -0.2208, -0.6883, +0.1096, -0.7935, -0.3954, +0.1652, +0.1019, -0.4601, +0.4553, -0.6417, -0.1358, -0.4737, +0.3128, -0.3267, -0.0540, -0.0633, +0.0747],
[ -0.2253, -1.2597, -0.2355, +0.7981, +0.4423, -0.6973, +0.1781, -0.4507, -0.4586, -0.6728, -0.0542, -0.9978, -0.0401, -0.1790, +0.0617, -1.1232, -0.1113, +0.1408, +0.1287, -0.2249, +0.2728, +0.4372, +0.1111, +0.0541, +0.0471, +0.6102, -0.1691, +0.0115, +0.4568, +0.0321, -0.8153, -0.2889, +0.2773, -0.3295, +0.4547, +0.0681, +0.3247, +0.0053, -0.2419, -0.1754, +0.4957, -0.6494, -0.1602, -0.1358, +0.2751, -1.3709, -0.3958, -1.4701, -0.0427, -1.6050, -0.3034, +0.2151, -0.6053, -1.0677, -0.5643, -0.7845, +0.3169, -0.8565, -0.3574, +0.2891, +0.1122, -0.2884, +0.0601, -0.4517],
[ +0.5794, +0.2631, +0.0298, -0.1887, -0.6058, +0.4974, +0.0394, +0.2606, -0.0979, +0.2046, -0.1194, +0.2263, -0.2702, -0.1877, +0.2569, -0.2315, -0.9000, -0.3146, -0.0264, +0.4439, -0.2352, -0.9247, +0.1092, -0.2865, +0.1680, +0.1662, -0.0617, +0.2461, +0.3578, +0.3580, +0.0366, +0.3635, -0.5039, -0.2711, +0.0653, +0.0065, -1.0248, -0.0090, +0.2204, -0.5041, -0.0247, -0.2344, -0.6278, -0.8120, -0.0303, +0.3207, -0.2989, +0.1933, -0.1498, +0.0319, +0.1813, -0.8244, -0.5803, +0.2969, +0.0516, -0.7916, +0.2017, +0.0585, +0.1980, -0.1696, +0.3148, +0.1424, -1.3858, -0.2667],
[ -0.1941, -0.6240, -2.0568, -0.4370, -0.2328, -0.0722, +0.1253, +0.2146, -0.3976, +0.1229, -0.1581, -0.0012, +0.1981, -0.0432, +0.3407, -0.6734, +0.3886, +0.6251, -0.5550, -0.1302, +0.4913, +0.2797, -0.5856, -0.5146, +0.0478, -0.3227, -1.5350, -0.0298, -0.0659, +0.3368, +0.3931, -0.0328, -0.9625, -0.2308, +0.2069, -0.8179, -0.0210, -0.2816, -0.0345, -1.0297, +0.2480, +0.3974, -0.8667, +0.1481, +0.3191, +0.2165, -0.3631, -0.5387, -0.0522, -0.0564, +0.2433, +0.3049, -1.3699, -0.0584, -0.2832, -0.6592, +0.0884, -0.2148, +0.0559, -0.9336, -0.2033, -0.4094, +0.3269, -0.4964],
[ +0.0753, +0.1742, +0.0289, +0.2070, +0.1448, -0.2884, -0.3095, +0.1798, +0.0199, -0.2820, +0.1938, -0.3718, -0.3645, -0.3529, -0.3720, -0.0512, +0.0513, +0.2669, -0.2589, +0.1347, -0.1360, +0.0911, +0.3276, +0.1716, -0.2404, +0.1529, +0.1362, -0.5175, -0.2299, -0.7689, -0.3936, +0.5067, +0.1310, -0.1135, -0.3412, +0.1108, +0.1786, +0.0673, -0.0204, -0.3017, -0.2068, -0.0664, +0.4354, -0.2405, -0.2007, -0.0767, +0.2006, -0.2971, -0.1813, +0.1541, +0.2968, -0.1119, +0.0695, -0.1098, -0.1175, +0.0256, -0.3372, +0.1161, -0.0643, -0.0223, -0.1124, +0.0984, -0.2127, +0.2459],
[ -1.0418, -0.7575, -0.4414, -0.7391, +0.5002, -0.1492, -0.4713, -0.9001, -0.1078, -0.1626, +0.1688, -0.3508, -0.0691, +0.0143, +0.4832, -0.5588, +0.1924, +0.2538, -0.1200, -0.0766, -0.5754, -0.1720, +0.6831, -0.3890, -0.0020, -0.6173, +0.5652, -0.2394, +0.5254, +0.6080, -0.6162, -1.4693, +0.4980, +0.4190, +0.0770, +0.7358, -0.1511, -0.4138, -0.0947, +0.1821, +0.0477, -0.9686, -0.0194, -0.2626, +0.6581, -0.2775, -0.4984, -0.2816, +0.4898, -0.7165, -0.2212, +0.3316, +0.3437, -0.3604, -1.0851, -1.0551, -0.5356, -0.8371, +0.0848, -0.4796, -0.3950, +0.3524, +0.6147, +0.0963],
[ -0.1117, +0.0358, +0.3472, -0.1657, -0.6318, -0.5969, +0.4199, -0.1558, +0.0856, -0.3948, -0.8222, -0.4227, -0.0461, -0.0458, -0.4246, -0.1711, -0.0217, +0.0392, -0.2153, +0.5657, +0.5179, +0.1690, -1.1408, -0.8345, -0.0868, +0.5821, +0.0440, -0.6810, -0.2952, +0.3344, +0.1719, -0.2792, -0.0611, -0.4510, -0.2232, -1.1814, -0.3142, +0.1828, -0.1726, -0.0683, +0.0175, +0.4286, -0.1024, +0.0233, -1.0238, +0.4454, +0.2450, +0.1602, -0.6960, -0.7975, -0.1214, -0.0340, -0.4455, +0.1809, -0.8249, +0.1098, -0.5579, +0.3200, +0.1753, -0.1689, +0.0027, +0.0572, +0.0126, -0.2266],
[ -0.1541, +0.2923, -0.2675, +0.0141, -0.2878, -0.2558, -0.6803, -0.4920, -0.0482, +0.2163, -0.2285, -0.1143, +0.1724, -0.2392, +0.0384, -0.7696, -0.5254, -0.2088, +0.4050, +0.1970, -0.2508, +0.1567, -0.1317, +0.2986, +0.1892, -0.7880, -0.0051, -0.1918, +0.1953, -0.0103, +0.2693, -0.5871, -0.7306, -0.0499, +0.0851, -0.5956, +0.4699, -0.0072, -0.1728, +0.1598, +0.0234, -1.2646, -0.1123, +0.0051, -0.0769, -1.4065, -0.1744, -0.0151, -0.2550, -0.1064, +0.1078, +0.0256, -0.4517, +0.2327, -0.0821, -0.1661, +0.0991, -0.4721, +0.2160, +0.3123, -0.2508, -0.8949, -0.6991, +0.3514],
[ +0.0703, -0.1692, -1.4867, -0.0076, -0.2931, -0.1692, +0.2276, +0.2554, +0.4607, -0.0033, -0.5308, -0.1111, -0.2342, -1.2702, -0.0528, +0.0717, -0.3220, -1.3547, +0.1024, +0.0170, +0.4253, +0.2123, -0.1259, -0.3122, -0.0105, -0.1530, -0.0172, +0.1871, -0.2647, -0.4114, -0.3456, +0.0040, -0.6042, -0.3889, -0.4615, -0.4490, +0.2165, +0.5019, +0.1494, +0.4083, -0.3297, -0.4118, -0.4185, -0.1609, -1.2773, -0.6846, +0.5723, -0.8063, -1.1917, +0.1809, +0.1200, +0.3350, -0.3911, -0.6569, -0.5049, -0.2564, +0.2318, -0.2522, +0.4132, -0.0193, +0.2003, +0.4302, -0.8441, -0.4850],
[ -0.0068, +0.1774, +0.0754, -0.1137, +0.1380, -0.1756, +0.0479, +0.1636, -0.0450, -0.0059, +0.0132, +0.0796, -0.0633, +0.1532, -0.5575, +0.0712, +0.3744, +0.0354, -0.0290, +0.4456, +0.2901, +0.4112, +0.3827, +0.4580, -0.1335, +0.3195, +0.4608, +0.6066, -0.3994, -0.8452, -0.9019, +0.8846, -0.7821, -0.3973, -0.7044, -0.5552, +0.1131, +0.1128, +0.2313, -0.0934, -0.1934, -0.2593, -0.1353, -0.4150, -0.3226, +0.3543, -0.1122, -0.7826, -0.3823, -0.1661, +0.3273, -0.2386, +0.3994, +0.2439, -0.1369, +0.1377, +0.6842, -0.1323, -0.1286, -0.7267, -0.1476, +0.2956, -1.1468, -1.1240],
[ +0.4587, -0.7120, -1.2147, +0.4533, +0.2276, +0.1187, +0.0242, -0.1101, -0.4575, +0.4281, -0.1702, +0.4025, -0.3204, -0.3382, +0.0152, -0.3671, +0.5063, +0.0993, -0.5994, +0.7286, -0.1769, +0.0241, -0.1544, -1.1380, -0.0154, -0.1003, +0.2631, -0.3019, -0.4871, -0.4790, +0.1549, +0.0706, -0.4589, +0.1127, +0.0359, -1.3804, +0.1469, +0.2458, +0.1503, -0.8209, +0.2133, +0.3083, -0.9755, -0.1969, +0.7787, +0.3313, +0.1551, -0.1931, +0.1911, -0.5686, +0.1347, +0.0831, -0.1930, +0.1631, -0.2833, -0.7028, -0.1118, +0.1533, -0.3999, -0.4258, -0.9083, -0.2582, +0.1941, +0.0233],
[ +0.0318, -0.8817, -1.4912, -0.0615, -0.2420, -1.2041, +0.2243, +0.0201, -0.4026, -0.0492, -1.1668, -0.4146, -0.1817, -0.3084, -0.1083, +0.1698, +0.2102, +0.4088, -0.0380, +0.1766, +0.1979, +0.1506, -0.0227, -0.3307, +0.0935, +0.1202, +0.1487, +0.3542, -0.3225, -0.8973, -0.2828, +0.2174, +0.0593, -0.3961, +0.5630, -0.6109, -0.2253, +0.4927, -1.3722, +0.5185, -0.2207, +0.0805, -0.4203, -0.4720, -0.6695, +0.5880, +0.2328, -0.2068, -0.6150, -0.2285, -0.7370, -0.7668, +0.3113, +0.2548, -0.5908, +0.0268, +0.0115, -0.6208, -0.2927, -0.3607, +0.1788, +0.1785, +0.3288, -0.2640],
[ +0.3848, -0.7088, -0.5749, +0.1465, -1.2500, +0.0894, +0.0777, +0.1599, -0.1955, +0.1559, -0.7550, +0.0516, -0.1624, +0.1289, -0.0537, -0.6007, -0.3695, -0.0942, -0.0091, +0.1988, +0.3324, -0.2406, -0.5028, -0.7058, -0.0122, +0.1081, +0.2517, +0.1361, -0.5815, +0.0485, +0.0734, +0.0126, +0.1104, +0.3183, +0.3643, -0.0232, +0.1123, +0.0566, -0.0732, -1.0371, -0.2023, -0.3095, -0.0496, +0.2435, +0.0358, +0.1252, -0.0470, +0.1997, +0.1537, +0.2705, -0.1455, -0.4738, -0.1437, -0.2477, -0.0010, +0.1878, -0.3148, +0.3925, +0.0561, -0.6492, +0.2474, +0.0362, -0.0897, -0.0669],
[ +0.4270, +0.3770, +0.1042, -0.1881, -0.1886, -0.3124, -0.1310, +0.4075, +0.1730, +0.1946, +0.0432, +0.4997, -0.2206, +0.0528, -0.2293, +0.0143, +0.3952, +0.0471, -0.4042, +0.2191, +0.2432, +0.2490, +0.3498, +0.1874, -0.1504, +0.4387, +0.1808, +0.4898, -0.3061, -0.3669, -0.6956, +0.2347, -0.3228, -0.6154, +0.1517, -0.1794, -0.5862, +0.2166, -0.0318, +0.1555, -0.5109, -0.2037, -0.0856, -0.7037, -0.3461, +0.5705, +0.3204, -0.3547, -0.2938, +0.1567, +0.1097, -0.0829, +0.1561, +0.1868, -0.1200, +0.0785, +0.3374, +0.6903, +0.3010, -0.6605, +0.1897, +0.5542, -0.3416, -0.4434],
[ +0.0792, -0.0354, +0.1346, -0.0867, -0.3061, -0.1105, -0.1961, +0.3380, +0.2322, +0.1389, +0.3620, +0.1611, +0.1719, +0.1811, -0.2072, +0.0334, -0.3774, -0.2193, +0.2164, +0.1568, +0.0684, +0.2052, +0.0536, -0.1594, +0.0561, +0.2893, -0.5556, +0.3248, -0.6442, -0.5264, -0.0596, +0.3401, -0.4276, -0.0385, -0.1273, +0.0564, +0.0775, +0.3581, -0.1403, +0.1570, -0.0367, -0.1462, +0.1820, -0.0586, -2.0140, +0.2617, +0.2951, -0.0837, -0.2212, +0.1362, -0.1088, +0.5008, -0.5582, +0.0823, -0.2323, -1.4969, +0.0935, +0.1385, +0.2140, -0.0230, -0.1270, -0.1048, +0.0824, +0.2496],
[ +0.2433, -0.2738, -0.6610, -0.0505, -0.2477, +0.3417, +0.5587, -0.5406, -1.0247, -0.2288, +0.3152, +0.1982, +0.0772, +0.1352, -0.4929, +0.2685, -0.2318, +0.0696, +0.0467, -0.2719, -0.2102, +0.3232, +0.6245, -0.0790, -0.0616, +0.0617, -0.1172, -0.1969, -0.2093, -0.2784, +0.6245, +0.0007, +0.4830, -0.2599, +0.4948, +0.6130, -1.0589, +0.6332, -0.0488, +0.2545, -1.2056, -0.5316, -0.0954, +0.3171, -0.2520, +0.2887, +0.0818, -0.1944, -0.2920, -0.1329, -0.5170, -0.2719, +0.0334, -0.2360, +0.4558, +0.3121, +0.4630, -0.5016, +0.2215, -0.5113, +0.4688, +0.3660, +0.3881, -0.0949],
[ -0.2656, +0.3331, +0.1076, +0.4581, -0.1431, -0.3597, -0.5184, +0.3444, -0.1091, -0.8341, +0.1024, -0.4100, -0.1841, -0.2893, +0.2359, -0.1603, +0.1739, +0.0252, -0.2123, -0.0169, -0.5213, +0.0193, +0.4833, -0.1353, -0.0798, -0.3748, +0.0164, -0.6037, -0.1706, -1.1654, +0.0855, -0.3299, +0.1365, -0.0167, +0.1727, +0.2777, -0.2126, -0.2516, -0.4917, -0.4254, -0.5338, +0.2868, +0.4736, +0.4043, +0.1799, +0.5764, -0.4045, +0.4918, +0.0200, +0.2983, +0.1779, +0.1119, -0.0803, +0.0530, -0.0388, -0.0848, -1.1362, -0.7623, -0.6830, +0.2258, -0.3375, -0.5304, -0.0166, -0.0452],
[ +0.3656, -0.0786, -1.3351, +0.4419, -1.4259, +0.3107, +0.1254, -0.3197, -1.0404, -0.0778, -0.7287, -0.8611, -0.0762, -0.8058, -0.1075, +0.0800, -0.3792, +0.0459, -0.0407, -0.0736, -0.0587, +0.0415, +0.0496, -0.1451, -0.0132, -0.0385, +0.1978, -0.3532, -0.2219, -0.6179, +0.8095, -0.9253, -0.0623, -0.8459, -0.2542, +0.1622, -0.5230, +0.4588, -0.5261, -0.4698, -0.3448, -0.7056, +0.0831, +0.5875, -0.4304, -1.2342, +0.1449, +0.3140, -0.8756, -0.6573, +0.2131, -0.5328, -0.0440, -0.2245, +0.0357, +0.4620, -0.5595, -0.3738, -0.7502, +0.1694, -0.1364, +0.0650, +0.0636, +0.0344],
[ -0.0606, +0.0726, +0.0580, -0.7201, +0.0616, -0.2663, -0.5110, -0.3657, -0.3247, +0.2932, +0.0176, -0.2670, +0.0671, +0.0998, +0.4772, -1.4650, -0.3015, -0.4687, -0.4883, +0.2534, +0.3658, +0.0559, -0.4296, -0.1036, -0.0094, -0.2585, +0.0756, +0.2631, +0.2918, -0.1307, -0.0181, +0.0034, -0.2567, -0.5368, +0.2606, -0.3876, +0.5663, -0.4215, +0.2809, +0.0201, +0.4246, +0.1693, -1.1285, -0.0438, -1.0839, -0.1515, -0.0892, -0.7921, -0.0792, +0.4657, +0.4911, +0.0949, +0.0362, +0.2820, -1.4115, -0.3908, +0.0311, -1.3656, -0.6728, +0.2379, -0.1602, -0.6410, +0.6788, -0.0510],
[ -0.5191, +0.3638, +0.0075, -0.0052, +0.3951, +0.1660, -0.0268, -0.1166, +0.8735, +0.3597, -0.3420, +0.1475, +0.2089, -0.2733, -0.1302, +0.0650, -0.1682, -0.6237, -0.1886, +0.1425, +0.1127, -0.0607, -0.8113, -0.4995, +0.0277, -0.1803, -0.2508, +0.0372, -0.3036, -0.4915, +0.1037, +0.0229, -0.2382, -0.2354, -0.1711, +0.1846, -0.8776, -0.0200, -0.4414, -0.1533, +0.0448, -0.2010, +0.0688, -0.3020, -0.0526, +0.1589, +0.3231, +0.2847, -0.8578, +0.2167, +0.0969, -0.2852, -0.6027, +0.1368, +0.1651, -0.2152, +0.1624, +0.3639, +0.1221, -0.4960, +0.1362, -0.0557, -0.4168, -0.2864],
[ +0.6175, +0.2864, -0.3944, -1.0445, -0.5126, +0.4037, +0.2065, +0.1380, +0.2727, +0.3778, +0.0995, +0.2318, -0.0628, +0.3280, -0.0223, +0.0671, -0.7848, +0.3413, +0.1067, -0.3424, -0.6270, -0.2365, -0.3945, -0.1812, -0.0288, -0.4210, -0.2331, +0.4286, +0.9716, +0.3043, -0.3778, +0.2830, -0.3521, +0.2004, +0.2613, -0.1126, -0.5060, -0.5227, -0.0945, -0.8172, -0.5810, +0.3176, -0.0357, -0.6075, -0.5641, -0.2488, -0.0749, -0.1395, +0.5087, +0.4870, +0.3374, -0.4190, -0.2451, +0.4110, +0.3360, -0.0793, +0.2368, +0.1880, +0.1418, -0.5637, -0.6581, -0.2530, -1.2775, -0.5173],
[ +0.2575, +0.5610, -0.5591, +0.4868, -0.6510, -0.4951, -0.1665, -0.7622, -0.4095, +0.0202, -0.4084, +0.7634, +0.0548, -0.1287, -0.5385, -0.5446, -1.2329, -0.5231, +0.0580, +0.1868, -0.5969, -0.4468, -0.3048, -0.6629, -0.0188, -0.4573, -0.2831, -1.3261, -0.3051, -0.4240, +0.2223, -1.0709, +0.0737, -0.0383, +0.1114, +0.4315, -0.8949, +0.2700, -0.0884, -0.0519, +0.1506, -0.5043, -0.9217, +0.1245, -1.1364, +0.3721, -0.0370, +0.0862, -0.4580, -0.1029, +0.0867, -0.1142, -0.1955, +0.2370, -0.1568, -0.8279, -0.0199, -0.5395, +0.0016, -0.5594, +0.1911, -0.2403, +0.4911, -1.0443],
[ -1.3302, -0.9338, +0.3871, -1.1495, -0.3531, -0.1944, -0.8389, -0.8362, -0.3735, -0.1939, -0.3993, -1.1031, -0.2929, -0.3900, +0.1848, -0.8209, -0.7968, -0.8029, -0.1552, -0.2470, -0.0961, -0.9054, -0.8644, -0.2718, +0.1205, -0.7466, +0.5260, -0.8186, +0.2249, -0.1852, +0.1637, +0.2386, -0.3861, -0.1152, +0.7676, -0.3567, +0.2007, -0.0614, +0.1410, +0.2211, -0.2671, +0.0567, +0.1667, -0.3056, -0.5998, -1.5851, -0.1660, -0.1601, +0.2225, +0.6939, +0.1670, +0.4183, +0.0228, +0.5104, -0.9676, -0.6234, +0.1827, -0.2717, -0.2918, +0.1188, -0.0111, -0.6147, +0.4209, +0.0278],
[ +0.1161, +0.2482, +0.2554, +0.4476, +0.0995, -0.4997, +0.2332, +0.9127, +0.3242, -0.8211, +0.0737, -0.1947, -0.1772, -0.6136, -0.5493, +0.2106, +0.1126, -0.3909, -0.0581, -0.0024, +0.1720, -0.2446, -0.1968, -0.1427, -0.1429, +0.2843, -0.5226, +0.4872, -0.0392, -0.2645, -0.6053, -0.5143, +0.4939, -0.1568, -0.1001, -1.0052, -0.5236, -0.1548, -0.4120, +0.2023, -0.5504, -0.2983, +0.0447, -1.5144, -0.1567, +0.2201, +0.1278, -0.2537, +0.1308, -0.1034, +0.6555, -1.3159, -0.5089, -0.1758, -0.3958, -0.5218, -0.1935, +0.2361, +0.2255, -0.7272, -0.0587, -0.2821, -0.3442, -0.7232],
[ -0.3517, -0.0203, -0.3070, -1.2829, +0.3473, +0.4040, -0.1731, -0.2593, +0.0120, -1.7168, +0.0700, +0.0111, -0.0112, +0.0938, -0.2550, -0.0387, -0.9967, -0.0670, -0.1163, -0.0396, -0.6377, -0.9166, +0.1814, -0.1000, -0.2425, -0.0557, -0.3294, +0.4148, +0.3240, +0.1026, -0.1858, -0.0817, -0.0452, +0.2382, -0.6017, +0.0693, +0.1167, -0.9697, +0.0599, -1.1097, -0.0638, +0.7294, +0.2900, -0.6312, -0.5011, +0.2075, +0.0598, -0.4969, -0.1090, -0.1907, +0.0369, +0.0796, -1.7630, -0.1289, +0.1517, -1.3118, -0.8149, -0.2056, +0.1837, -0.0746, -0.6321, -0.6908, -0.0132, +0.0751],
[ -0.6365, -0.6129, -0.0568, -0.9972, -0.1083, -0.5357, -0.1754, -0.4249, -0.3845, -0.4516, +0.1213, +0.6502, +0.1079, +0.2016, -0.2369, +0.2815, -0.3741, -0.0515, +0.1369, -0.3568, +0.1390, -0.7787, -0.1987, -1.0299, +0.1383, +0.1656, -0.7985, -0.6206, +0.3338, +0.0575, -0.7736, -0.2891, +0.1845, -0.3902, -0.4144, +0.4074, +0.1418, -0.3710, +0.2686, +0.0234, -0.2382, -0.4719, -0.0803, -0.5591, +0.3811, -1.2136, -0.8015, -0.3746, -0.0117, -1.8425, +0.0330, -0.2085, +0.1446, -0.1752, -0.5046, -1.0435, +0.1141, -0.0602, +0.4022, +0.4310, +0.2164, -0.1623, -0.1944, -0.1913],
[ -0.5695, -0.3372, -0.2433, -1.2988, -0.6181, +0.0353, +0.4011, -0.3847, -0.0820, +0.1582, -0.4111, +0.0552, +0.0906, +0.0849, +0.0692, +0.1922, -0.0549, -1.7126, -0.2257, +0.1049, +0.0016, -0.6541, -1.0900, -0.2897, -0.2057, -0.7505, -0.7495, +0.1641, +0.3909, -0.1974, +0.1989, -0.0289, -0.6525, +0.2379, +0.2185, -0.7424, +0.3704, -1.3808, -0.4839, -0.1950, -0.3002, -0.1963, +0.0819, -1.7138, -0.7822, -1.4837, -0.1470, +0.0372, -0.0416, +0.0395, -0.2169, +0.4130, +0.1063, +0.7070, -0.0286, -1.1673, -0.3685, -0.7736, +0.0467, +0.2205, +0.0719, -0.5629, -0.1000, -0.7227],
[ -0.0742, +0.2908, +0.0301, +0.2182, -0.0747, -0.1263, -0.1355, +0.2109, -0.2850, -0.5664, +0.1393, -0.3777, -0.1310, +0.1102, +0.3325, -0.1378, -0.0709, +0.1402, +0.0943, -0.0407, -0.3467, +0.0916, +0.2023, -0.1731, -0.1292, +0.1054, -0.0246, -0.2775, +0.0886, +0.3904, +0.0465, -0.5304, -0.0224, +0.1768, -0.2666, +0.2306, +0.1383, -0.7646, +0.0099, -1.2146, -0.9118, -0.5281, +0.1534, +0.3789, -0.0579, -0.1973, -0.1614, +0.6662, -0.3768, +0.3651, +0.4518, +0.1664, -0.1549, +0.1844, +0.1412, +0.0283, -0.7128, -0.8330, -1.7285, -0.1793, -0.2031, -0.1453, +0.2164, +0.2915],
[ -0.4528, +0.3647, +0.1067, -0.1699, -0.5783, +0.1129, -0.1196, -1.6987, +0.2552, +0.0092, -0.2868, -0.1119, -0.0707, -0.0441, +0.3715, +0.1826, -0.7670, -0.7732, +0.0356, -0.3435, -0.8718, -1.0227, -0.6381, -0.2767, -0.1146, -0.9304, -0.2226, +0.4722, +0.2540, -0.7784, +0.5070, +0.1428, -0.6285, -0.1488, -0.6175, +0.2040, +0.2312, -0.1978, +0.0764, -0.3868, +0.9002, +0.2344, -0.5108, -0.2623, -0.8658, -0.6194, +0.1982, -0.6725, -1.8083, +0.2282, +0.1429, +0.3556, -0.0452, +0.3160, -0.3793, -0.6729, +0.7203, +0.1603, -0.3994, -0.2190, -0.7442, -0.0352, -0.7935, -0.1473],
[ -0.8168, -0.0091, -0.0508, -0.4927, -0.6616, +0.4340, -0.2432, +0.4167, +0.3489, +0.8354, +0.2251, +0.0112, -0.0185, -0.6260, -0.2298, -0.0221, -0.6862, -0.2349, +0.2170, +0.1041, -0.6343, -0.8665, +0.1858, -1.4852, -0.0523, -0.8654, -0.5574, -0.3615, -0.3560, -0.3082, -1.4751, -0.5826, +0.1229, +0.0924, -0.1141, -0.0477, +0.1553, -0.3143, -0.5285, -0.7833, +0.2824, -0.4220, +0.1819, -0.2719, -0.0280, -0.6713, -0.8150, -0.5180, -0.1413, +0.2325, -0.3501, +0.0866, -0.2519, +0.3551, -0.4227, -0.1018, -0.9312, -0.2401, +0.4466, -0.2421, -0.4953, -0.9608, -0.3090, +0.0437],
[ -0.3678, -0.0514, +0.8817, -0.7280, -0.1600, +0.8120, -0.4446, -0.1063, -0.5102, +0.1453, -0.0061, -0.1726, +0.0986, +0.2938, +0.1933, +0.3513, +0.5222, +0.1550, -0.0421, +0.1425, -0.1413, +0.1639, -0.8166, -0.1317, -0.4997, -0.0874, -0.3524, -0.8873, -0.9856, +0.6431, +0.1933, +0.0048, -0.0601, +1.0241, +0.3887, -0.7046, +0.4948, -0.7165, +0.0877, +0.0682, +0.6019, +0.5806, +0.3123, -0.1842, -0.1036, +0.3439, -0.4009, -0.4758, +0.2913, +0.0956, +0.6178, -1.4622, -0.1621, -0.7775, -0.0004, +0.2367, -0.2088, -0.9526, -0.1860, +0.1470, +0.1572, -0.1658, +0.1708, +0.5259],
[ -0.2214, +0.1985, -0.1847, +0.5871, -0.3763, +0.0672, -0.1033, -0.0671, +0.1542, +0.0275, -0.5201, +0.1248, +0.1134, -0.3788, +0.0484, -0.5302, -0.0118, -0.8965, +0.0713, +0.0392, +0.1628, -0.0572, -1.8384, -0.3889, -0.2469, +0.4550, -0.0606, +0.0431, -0.0217, -0.4960, +0.1855, -0.1257, +0.2440, +0.0600, +0.2227, -0.6121, -0.2051, +0.0859, -0.4757, -0.2172, -0.1453, +0.1773, -0.3348, +0.1459, +0.1331, -0.0931, +0.0132, +0.2765, -0.3224, -0.7257, -0.0038, -0.1957, -0.6276, -0.1183, +0.0673, +0.3088, -0.0822, +0.1390, +0.4112, +0.0519, +0.3311, +0.2228, -0.4378, -0.5721],
[ -0.0147, -0.0421, +0.0189, -0.4632, -0.1887, +0.1763, +0.2966, -0.2942, -0.1684, +0.0008, +0.3991, -0.1310, +0.2420, +0.3445, +0.0718, -0.2459, -0.4664, -0.7893, +0.0726, -1.0375, -0.7542, -0.5141, +0.3281, -0.5370, -0.4788, -0.4261, +0.1905, +0.0993, +0.4738, +0.1131, +0.1462, -0.1149, -0.8987, -0.3439, -0.0783, +0.3170, +0.2363, -0.2870, -0.1533, -0.1604, +0.2246, -0.9061, -0.3147, +0.0034, -0.0893, -0.1349, -0.3582, +0.0769, +0.3767, -0.1624, -0.3113, -0.3842, +0.2768, +0.5184, +0.1937, +0.6202, +0.2389, +0.0061, +0.2531, -0.1111, -0.3178, -0.1828, -0.2073, -0.2022],
[ -0.1047, -0.1899, -0.0452, -1.5021, -0.0903, -0.5365, -0.7039, -0.8838, +0.0651, -0.0976, -0.5219, -0.2925, +0.1947, -0.0408, +0.0430, -0.5362, -0.3390, -0.2032, -0.3870, -1.5461, -0.4847, -0.8721, +0.0815, +0.0294, +0.0019, -0.1992, -0.0342, -0.7489, +0.3711, -0.1925, -0.3552, -0.0407, -0.0402, -0.4258, -0.1176, -0.6723, +0.4815, -0.2728, +0.1984, -0.4091, -0.3322, -0.0223, -0.4487, -0.6132, -0.7094, -0.5729, -0.3616, -1.4608, -0.1466, -0.2963, -0.1808, +1.0996, -1.1116, +0.0384, +0.1127, -1.0002, -0.3117, -0.4126, +0.1461, -0.2834, +0.1687, -1.2180, +0.8404, +0.3414],
[ -0.2871, -0.2753, +0.3318, -0.0631, -0.0329, -0.2655, +0.1154, +0.1341, -0.3528, -0.4633, -0.4270, +0.1776, +0.1154, -0.0745, -0.3922, +0.0375, +0.0055, +0.4779, -0.1397, -0.5729, -0.1113, +0.0881, -0.0655, -0.4586, -0.0322, +0.1184, -0.5583, -0.4987, -0.0660, -0.1451, +0.1862, -0.8150, +0.8184, -0.0894, -0.3762, -0.5304, -0.5791, +0.0317, -0.2269, +0.2771, -0.1284, -0.3164, -0.5405, +0.1469, -0.8860, +0.4223, +0.1829, -0.3194, -0.4208, +0.4972, -0.7205, -0.7719, -0.3450, +0.5980, -0.1395, -0.3528, -0.1897, +0.1412, +0.1881, -0.0785, +0.3184, -0.3845, -0.3870, -0.1074],
[ -0.0549, -0.1759, -1.4543, -0.4064, -0.4019, +0.0416, +0.2107, -0.9047, -0.5796, +0.0453, -0.2060, +0.7131, +0.1083, +0.0712, +0.0948, -0.7550, -1.0484, -0.1334, -0.3905, +0.3899, -0.6879, -0.9365, +0.3175, -0.2515, -0.0216, -0.6523, -0.5432, -0.3200, +0.2436, +0.4666, +0.2695, +0.6725, -0.3633, -0.4047, +0.0874, +0.2482, +0.0669, +0.0321, -0.0457, +0.2833, +0.4448, -0.1799, +0.0688, +0.0473, +0.0295, +0.4890, -0.1082, -0.2163, +0.2725, -0.0772, -0.0288, +0.4464, -0.2413, +0.0908, +0.3795, -0.7329, +0.0918, -0.0568, +0.4359, -0.1642, -0.4720, -0.6958, +0.3310, -0.9285],
[ -0.3428, +0.3394, +0.2910, +0.0395, +0.1968, -0.3811, -0.3117, +0.2441, +0.2823, -0.4930, +0.1645, +0.1595, -0.2763, +0.2406, -0.3192, -0.4154, -0.2809, +0.0606, -0.1039, +0.2498, -0.4704, -0.1710, -0.3512, -0.0781, -0.1085, -0.2105, -0.1707, +0.1695, +0.2557, -0.8382, -0.4814, -0.3560, +0.0130, -0.0411, -0.5253, +0.1622, +0.0977, -0.3241, +0.3357, -1.1972, -1.0786, +0.0531, -0.0801, -0.1700, -0.1637, -0.3555, +0.0159, +0.3452, -0.2490, -0.0398, +0.3255, +0.0474, -0.2646, +0.2222, -0.0094, -0.4791, -0.7316, -0.1143, -0.5465, -0.2249, -0.4003, -0.4671, -0.0495, +0.1696],
[ -0.4032, -0.7569, -0.6099, -0.1711, -0.8909, +0.2922, +0.1176, -0.3625, -1.0356, +0.2123, -0.6401, +0.1968, -0.3508, +0.1569, -0.0021, -0.8648, -0.0136, +0.0362, -0.4099, +0.0140, -0.3279, +0.0350, +0.1094, -0.4495, -0.1535, -0.8482, -0.3956, +0.0348, -0.8475, -0.1615, +0.4068, +0.2318, -0.3285, -0.4544, +0.3332, +0.4241, -0.1228, +0.1105, +0.2951, -0.1227, -0.0585, -0.1504, +0.0110, -0.4835, +0.0051, +0.2351, -0.7890, -0.3031, -0.1653, -0.0390, -0.2326, -0.3724, +0.1074, +0.0847, -0.0288, -0.0392, +0.1232, +0.3832, -0.0923, +0.2702, -0.0836, -0.6782, +0.1941, -0.5479],
[ -0.0042, -0.1946, -0.1632, +0.2652, -0.3281, -0.5539, +0.1933, -0.5138, -0.7291, -0.0916, +0.0651, -0.0960, -0.0087, -0.6420, -0.1012, -1.2801, +0.0314, +0.3125, -0.1892, +0.0743, -0.2332, +0.0198, +0.1641, +0.1603, +0.0527, -0.1782, +0.2653, -0.9144, -0.2789, +0.2436, -0.0685, +0.8306, -0.1436, -0.3050, -0.1886, +0.1350, -1.0503, -0.2253, -0.2741, +0.2681, -0.4613, -0.7832, +0.5836, +0.0801, -0.5491, +0.1075, +0.3780, +0.3248, -0.2623, +0.0749, +0.1353, -0.6015, +0.3448, -0.0809, +0.0375, +0.2001, -0.2588, -0.2804, -0.2702, +0.2283, +0.1124, +0.4594, -0.4324, +0.1485],
[ +0.1532, +0.2848, -0.2427, +0.4166, +0.0042, -0.3085, +0.1124, +0.2537, +0.1375, -0.2485, -0.0234, -0.0071, -0.0783, -0.2518, +0.1560, -0.5850, +0.1183, -0.0517, -0.1053, +0.3356, +0.3028, +0.2722, +0.1897, +0.2332, -0.3597, +0.5258, -0.0684, -0.0984, -0.2643, -0.5880, +0.1289, +0.0015, -0.1563, -1.0911, -0.2512, -0.4506, +0.0817, +0.1627, -1.0543, +0.6363, -0.2562, -0.5514, -0.2316, +0.0717, -0.1111, -0.1945, +0.1628, -0.0464, -0.4399, -0.2649, +0.1594, +0.0358, -0.1435, +0.1108, +0.1648, +0.4697, -0.0951, +0.1059, -0.5489, -0.4333, -0.0550, -0.2629, -0.9481, -0.0023],
[ -0.1565, +0.0574, -0.2594, +0.1234, +0.1356, -0.2661, +0.3433, +0.2905, -0.1498, -0.0338, +0.3885, -0.0082, +0.0051, -0.8434, +0.2996, -0.1082, -0.2098, -0.4112, -0.1268, -0.1134, +0.2039, +0.0491, -0.0465, -0.5719, -0.1081, -0.0628, -0.5965, +0.3252, -0.0130, -0.3893, -0.0323, +0.1651, -0.5723, +0.4407, +0.0223, -0.1040, -0.2432, +0.0811, -0.1804, +0.2986, +0.0872, -0.0198, +0.1289, -0.7460, -0.4659, +0.3831, -0.0848, -0.8659, -0.4278, +0.1593, -0.2717, -0.2745, -0.4147, -0.4569, -0.4038, -0.3464, +0.0218, -0.1718, +0.2309, +0.1343, +0.2253, -0.1355, -0.4830, -0.4628],
[ +0.0450, -0.7682, -0.5959, +0.1884, -0.3429, -0.2553, +0.7554, -0.1022, +0.4099, -0.1219, -0.2093, -0.0878, +0.0561, -0.5284, +0.0385, -0.7532, +0.5020, -0.9372, -0.1928, -0.3592, -0.0536, -0.1005, -0.1540, -0.2265, -0.1188, +0.1608, +0.1528, +0.2769, +0.5073, -0.1996, -0.1063, +0.1040, -0.8756, -0.0927, -0.0733, -0.4302, -0.4747, +0.4669, -1.0292, -0.2093, -1.6550, -0.7398, -0.0037, -0.0352, -0.7409, +0.0588, +0.1492, +0.1683, -0.3111, +0.1539, -0.2438, -0.8038, +0.1800, +0.0742, +0.2182, +0.2555, +0.1701, -0.2382, -0.0567, -0.2451, -0.3627, -0.0496, -0.0007, +0.0642],
[ -0.0198, -0.7084, -1.7288, +0.0023, -0.6159, -0.3045, +0.2740, -0.6177, -0.9246, -0.7641, -0.0082, -0.1067, -0.1914, -0.1873, +0.3149, -0.3414, +0.2478, +0.5272, +0.0465, -0.2181, +0.2295, +0.1319, -0.0236, -0.2259, -0.3665, +0.1407, +0.5191, -0.2611, -0.0468, +0.2089, -0.1337, -1.2692, +0.2063, -0.2235, +0.2870, -1.0765, +0.2921, +0.0708, -0.8893, +0.1605, -0.4512, -0.1917, -0.1650, -0.1710, +0.2144, -0.1577, -0.0188, -0.2185, -0.2129, -0.3773, -1.1166, -0.8290, +0.2877, +0.1461, -0.1932, +0.4364, -0.2597, -0.6060, +0.3258, -0.1753, +0.3740, +0.1653, +0.3116, +0.1972],
[ -0.5676, -0.1738, +0.0645, -1.0766, +0.5088, -0.2353, +0.1632, +0.0342, +0.6782, -0.1393, -0.1100, -0.4369, +0.1336, +0.2995, -0.5347, +0.4146, -0.0427, -0.2986, -0.0927, +0.0586, +0.5212, -0.0742, -0.0939, -0.4191, -0.0830, -0.0546, -0.3702, +0.6367, +0.0227, -0.0992, -0.2374, -0.0286, -0.3807, +0.0304, -0.2574, +0.0564, +0.0096, +0.1621, +0.1392, -0.3874, -0.0431, +0.2932, +0.3008, -0.3351, -1.0291, +0.9737, +0.1879, +0.4559, -0.2085, +0.1174, +0.6974, +0.1809, -1.4216, -0.7912, -1.2257, +0.1453, -0.2233, +0.3229, +0.4583, +0.0773, -0.7117, -0.3845, +0.1082, +0.0987],
[ +0.0781, -0.0814, +0.8480, +0.2264, -0.4587, -0.3083, +0.1459, +0.4196, +0.3756, -0.1326, +0.0951, -0.2471, -0.1196, -0.8551, +0.0014, -0.2029, +0.2577, +0.2734, -0.0681, -0.4470, +0.5168, +0.1951, +0.0949, -1.0213, -0.0389, +0.2296, +0.4116, +0.1783, -0.4069, -0.2838, -0.1370, +0.0335, -0.0403, -0.0137, +0.4868, +0.1037, +0.3783, +0.1564, -0.1589, +0.3586, +0.0252, -0.2580, +0.1670, -0.4183, -0.0371, +0.0142, +0.2253, -1.0320, -0.2583, -0.1020, -0.2032, -1.3460, +0.5840, -0.0893, -0.6009, +0.5548, -0.0857, -0.0794, +0.3571, +0.0167, +0.0949, +0.1082, -0.2736, -0.3984],
[ +0.1488, +0.0836, -0.1156, -0.0946, -0.6624, +0.3870, +0.1203, +0.2345, +0.5957, -0.0864, +0.0939, +0.3911, -0.3770, -0.7077, -0.1206, -0.2049, -0.5693, -1.1134, -0.1524, +0.1622, -0.1211, -0.6374, -0.6248, -1.2622, +0.0899, -0.1572, -0.2152, +0.6604, +0.7116, -0.3532, +0.2550, +0.6011, -0.1052, +0.2644, -0.0520, -0.2045, -1.3817, +0.4718, +0.1422, -0.1959, -0.4853, +0.3969, -0.1666, -1.0437, -0.2013, -0.4767, -0.2118, +0.4010, -0.4163, +0.5423, -0.0842, -0.4901, -0.3661, +0.3607, +0.4009, +0.0245, +0.2585, +0.3218, +0.3151, -0.4333, -0.9903, -0.3832, -0.6528, -0.9357],
[ +0.2625, -0.3163, -0.7011, -0.4750, -0.2169, -0.4875, -0.7199, +0.4407, +0.0992, +0.3363, -0.3765, +0.1178, -0.1361, +0.0589, -0.2783, -0.0918, +0.8017, -0.1301, -0.0942, +0.5582, +0.3169, -0.1525, -1.0656, -0.9893, +0.0477, +0.0623, -0.8920, +0.7155, +0.1733, +0.6024, -0.1510, -0.2588, -0.9339, +0.0646, +0.1528, -1.4100, -0.4579, +0.1205, +0.1494, -0.5505, +0.2527, +0.6798, -0.0354, +0.1972, -0.0864, -0.0724, +0.4457, -0.1612, -0.0747, -0.8515, +0.5947, +0.0358, -1.5359, -0.0754, +0.1504, +0.1272, -0.2733, -0.6504, +0.1311, -0.6455, +0.3241, -0.7097, -0.2899, +0.1537],
[ -1.1608, -0.5298, -0.8712, +0.1991, -0.3332, +0.3643, +0.0401, -0.4816, +0.3851, +0.2349, -0.6814, +0.1716, -0.2337, -0.0912, +0.4335, -0.1547, -0.4001, +0.3222, -0.1337, +0.3072, +0.2498, -0.2764, -0.8538, -0.2515, -0.0439, +0.1265, -0.5853, +0.0693, -0.4379, +0.1737, +0.3439, -0.7150, +0.3867, +0.3087, +0.4529, -0.6548, -0.2920, -0.0996, -0.9976, -0.3262, +0.7263, +0.7688, -0.9637, +0.0227, +0.3281, +0.2599, -0.6599, -0.0804, +0.2021, -0.4105, -0.8758, +0.5409, -0.3671, -0.0064, +0.3239, -0.5062, -0.1013, +0.0167, -0.2186, -0.4367, -1.0176, -0.3509, -0.0338, -0.1166],
[ -0.2009, -0.0097, -0.3805, +0.5547, +0.0211, -0.1902, +0.2175, +0.2475, -0.1842, -0.5084, +0.4752, +0.4515, -0.0791, -0.5530, -0.1438, +0.0275, +0.0589, +0.2926, +0.0454, -0.1496, +0.1475, -0.1997, +0.1834, -0.5198, +0.0427, -0.2978, -0.2438, +0.0810, +0.3660, +0.0816, -0.5628, -0.0037, +0.4582, +0.5978, -0.0285, +0.1455, -0.7267, -0.5732, -0.0079, -0.0751, -0.8395, -1.2686, +0.2954, -0.2310, +0.4056, -0.0743, -0.2228, +0.0327, +0.2061, +0.2131, -0.2174, +0.1368, -0.5607, -0.1470, +0.2396, -0.4317, +0.5534, -0.3621, -0.1064, -1.2382, +0.3209, -0.1634, -0.9480, +0.3144],
[ -0.1292, -0.5636, -0.0849, +0.2092, -0.1442, -0.2223, +0.1724, -0.6844, -0.8701, -0.3775, -0.3263, -0.2123, +0.0666, -0.6740, +0.4411, -0.6332, +0.3243, +0.2527, -0.0565, +0.1122, +0.4365, +0.2004, +0.5247, +0.2099, -0.0063, +0.1774, +0.5491, -0.4683, -0.0755, +0.6953, +0.0733, -0.6102, +0.1488, -0.2186, +0.4960, +0.2464, -0.2218, -0.2068, -0.5311, +0.4264, +0.5527, +0.2815, -0.3011, -0.2885, +0.1760, -0.4510, +0.2082, -0.3399, -0.2715, -0.2917, -0.4012, -0.6663, +0.6144, +0.3065, -0.6742, +0.2289, +0.0560, -0.6837, +0.0275, -0.1482, +0.6406, +0.1464, +0.0440, +0.3607],
[ -0.2100, -0.3766, -0.3248, -0.0815, -0.0021, -0.0053, +0.1080, +0.1588, -0.0212, +0.0710, -0.1382, +0.0091, +0.0343, -0.8511, -1.4211, +0.4568, -0.2851, -0.6204, +0.1094, -0.5432, -0.0860, -0.2730, -0.6808, -0.3779, -0.1227, -0.1347, +0.0673, +0.0427, -0.4947, -0.0973, -0.3803, -0.1468, +0.1988, -0.2611, -0.6531, -0.1605, -0.9337, +0.5437, +0.0989, +0.1534, -0.4737, -0.8900, -0.6949, -0.1503, -0.9317, +0.3230, +0.2311, -0.3696, -0.4520, -0.7193, +0.6298, -0.2834, +0.5434, -0.5763, +0.3341, -0.1008, +0.2521, -0.1212, -0.2856, +0.0286, +0.1565, -0.1973, -0.9579, +0.2266],
[ -0.3733, -0.5246, -1.0401, -1.1247, +0.5040, +0.1447, -0.3600, -0.5734, -0.9212, -0.3597, +0.2485, -0.3560, -0.0752, -0.8746, +0.4507, -0.5267, +0.1474, +0.3419, +0.0363, -0.7705, -1.6857, -1.1070, +0.2625, -1.0731, +0.1143, +0.1023, -0.9064, -0.5451, -0.5312, +0.0702, -0.2498, -1.3055, +0.1746, +0.5512, -1.0339, +0.1665, -0.0061, +0.3917, +0.3936, -0.0938, -0.3131, -0.5685, +0.1470, -0.5130, +0.4499, -0.3169, -0.1906, -0.3272, +0.1276, +0.3542, -0.8497, +0.0924, +0.2336, +0.0205, +0.5533, -0.6078, -0.0380, -0.9867, +0.3744, -0.4039, -0.2097, -0.6184, -0.4652, +0.0281],
[ -0.7440, -1.0423, +0.2391, -0.7264, +0.6529, +0.1477, -0.6196, -0.4762, +0.0692, -0.4353, +0.6195, -0.3501, +0.0457, +0.5445, +0.3201, +0.5907, +0.1408, +0.5189, +0.2457, -0.1996, -0.0750, -0.8873, -0.3630, -0.2106, -0.0367, +0.3119, -0.3941, -0.7667, +0.2979, -0.1940, -1.1527, -0.7601, +0.3334, +0.7463, +0.0006, +0.5900, +0.4330, -0.2191, +0.1961, -0.1740, -0.0606, -1.9663, -0.0980, -0.3602, +0.2108, -0.8138, +0.2321, -0.0849, +0.5843, -0.1114, +0.1376, +0.0711, -0.2334, -0.4425, -0.4017, -0.9668, -0.2785, -1.0386, +0.1323, -0.3491, -0.1183, -0.1991, +0.1755, +0.2324],
[ -1.6279, -0.5764, -0.5582, -0.1969, -0.2668, +0.0346, -0.5277, -0.4330, -0.3943, +0.3645, -0.1540, +0.0062, -0.0567, -0.0784, +0.1743, -0.9562, -0.4454, +0.0533, -0.1731, +0.1988, +0.1024, +0.5358, -0.4556, -1.0002, -0.1435, -0.2930, -0.4634, -0.2278, -0.3642, +0.3626, +0.5493, +0.1137, -0.1669, -0.4225, +0.0216, +0.4361, -0.1621, -0.1015, -0.0550, -0.3966, +0.5804, +0.1967, -0.3464, +0.0925, +0.3493, +0.1171, -0.3405, -0.0503, +0.1499, -0.3313, -0.0033, +0.0960, -0.6710, +0.2601, -0.1169, -1.5937, -0.0615, -0.1506, -0.2239, +0.1024, -0.2309, -0.4043, +0.4463, -1.0894],
[ -0.2373, -1.4598, -0.1174, -0.1045, +0.4946, -0.5140, +0.0110, -0.6460, -1.3452, +0.4370, -1.0515, -0.7801, -0.2640, +0.0359, -0.0097, -0.4043, +0.1002, -0.0268, -0.0773, -0.0390, +0.0679, -0.2875, -0.9561, -0.2837, -0.1344, +0.1141, +0.2607, -0.1805, -0.2482, +0.4783, -0.0732, -0.3817, +0.3229, -0.1179, +0.3825, -0.3490, +0.6231, -0.3663, -0.2762, +0.1450, -0.0651, +0.3529, -0.6646, -0.0485, +0.6340, -0.1721, -0.0388, +0.1370, +0.3559, -0.1751, -0.3544, -0.2360, +0.1969, -0.0265, -0.5621, +0.1465, -0.5286, -0.0378, -0.3572, -0.2107, +0.1881, -0.3776, -0.1373, -0.2395],
[ -0.0932, -0.1324, -0.7774, +0.7236, -0.0517, +0.2264, -0.0171, -0.3843, -1.8551, -0.2552, +0.2186, -0.1668, -0.0405, -0.7226, +0.3290, -0.4577, +0.6845, +0.2283, +0.0772, +0.3389, -0.1607, +0.2051, +0.2808, -0.1648, -0.1542, -0.1327, +0.3047, -0.1349, -0.3720, +0.5004, +0.1875, -0.3262, +0.7620, +0.2608, -0.6428, +0.5077, -0.8593, +0.1150, -0.6590, +0.5739, -0.3998, -0.2555, +0.4572, +0.5381, +0.2333, -0.3406, +0.3267, -0.2062, -0.4765, +0.0695, -0.7520, +0.3144, +0.2924, +0.0593, -0.2462, -0.2207, +0.1864, -0.6530, +0.3565, -0.2062, -0.0916, +0.1603, -0.1901, +0.0146],
[ +0.5634, +0.0527, -0.4892, +0.2440, -0.1720, +0.2785, -0.4833, +0.1367, -0.1087, -0.1074, -0.2101, +0.2272, -0.2405, +0.2242, +0.4896, -0.5147, +0.1469, +0.2632, -0.2786, -0.5737, -0.2000, -0.3146, +0.1852, -1.6770, -0.0606, -0.6669, -0.6540, +0.3910, +0.1855, +0.2526, -0.2044, +0.2109, -0.5512, -0.2409, +0.1259, +0.5317, -0.5607, -0.0788, +0.0273, -0.1690, +0.1662, +0.0275, -0.4170, -0.7013, -0.0454, +0.4406, -0.5298, -0.3473, +0.0638, -0.3749, +0.2545, +0.5678, +0.5063, +0.3236, -0.7996, +0.3285, -0.1605, +0.6192, +0.1014, +0.1821, -0.5310, -0.5324, +0.1416, -0.3316],
[ -1.1046, -0.7047, -0.2575, -0.7403, -0.7298, -0.2453, -0.3595, -0.4102, -0.3522, +0.5069, -0.3525, +0.0370, +0.0301, +0.2036, +0.1020, -0.2437, +0.2750, +0.4183, -0.0769, -0.2143, +0.4041, -0.1546, -0.3924, -0.4053, -0.1305, -1.6502, -0.5113, -0.4471, -1.4570, +0.0472, +0.2965, +0.2012, -1.2503, -0.4947, +0.0608, +0.0305, +0.2824, -0.0230, -0.5519, +0.3479, +0.1785, -0.3687, -0.1119, -0.2599, -0.3071, -0.4963, -0.8701, +0.0014, +0.2138, -0.1607, -0.7962, -0.3856, +0.0298, +0.2767, -0.5021, -0.8125, +0.1187, -0.2955, +0.0602, +0.2604, +0.1913, -0.7938, +0.4153, -0.4320],
[ -0.1053, -0.4955, -0.7817, +0.4661, -0.5876, -0.0594, +0.3703, +0.0458, -0.2497, +0.1020, +0.4331, -0.1484, -0.1813, -0.4629, +0.4557, +0.1618, -0.1633, -0.0155, -0.0498, +0.2643, +0.4639, +0.2317, +0.0692, +0.2114, +0.0785, +0.3615, +0.3779, -0.1974, -0.2165, +0.0856, +0.0563, +0.1860, -0.7703, +0.0791, +0.0535, +0.1625, +0.1107, +0.1564, +0.0604, +0.5328, +0.2965, -0.4956, -0.0350, -0.8169, -0.1578, -0.3033, +0.3697, -0.2652, -0.0895, +0.2893, -1.2192, -0.3056, -0.5532, -0.6461, -0.9112, -0.5628, +0.5037, +0.0736, +0.1086, +0.0716, +0.5142, +0.1312, -1.4517, -0.9905],
[ -0.9468, -0.7466, -0.6471, -0.1362, -0.8800, +0.5892, +0.5213, -0.6689, +0.2229, -1.6990, -0.1504, -0.1068, +0.0205, +0.2356, +0.5575, -0.4093, -0.0981, -0.9981, +0.0432, -0.6207, -0.0574, -0.1144, -1.5140, -0.3693, -0.1618, +0.3839, -0.1877, -0.2322, +0.0598, +0.2673, +0.3659, -1.0235, +0.0875, +0.3404, -1.0691, -1.6803, -0.2115, -0.6276, -0.5968, -0.7992, +0.0821, -0.6022, -0.0708, +0.2164, +0.5098, -0.1063, -0.2642, +0.3782, +0.3025, -0.7081, +0.1065, -0.5805, -1.1473, -0.4245, +0.3123, +0.2769, +0.4162, -0.4652, -0.7961, +0.0205, +0.1451, -0.4086, -0.1521, -0.2852],
[ -0.7144, -0.0732, -0.2513, -0.5200, +0.2989, +1.0393, -0.0999, +0.6432, -0.2806, -0.3070, +0.5141, -0.0163, -0.0070, -0.5330, +0.1894, -0.1748, -0.2329, +0.3600, +0.4255, -0.6582, -1.3598, -0.8585, +0.1014, -0.4106, -0.0970, +0.1253, -0.1873, -0.3545, +0.2180, +0.3920, -0.5099, +0.0616, -0.3497, +0.2023, -0.8214, -0.1101, +0.6518, -0.4036, +0.1847, -1.2271, +0.2813, -1.0571, +0.6299, +0.2067, -0.6461, -0.6766, -1.4846, +0.0878, +0.6149, -0.1618, -0.3680, -0.4017, -0.7612, -0.2911, -3.0760, -0.0799, -0.6366, -0.2699, +0.3534, +0.0080, -1.2127, -0.5772, -0.8138, -0.3230],
[ +0.0332, +0.2400, -0.4718, +0.1539, +0.1194, -0.0690, +0.2228, +0.1942, +0.1187, +0.2018, +0.4571, +0.3205, -0.2239, -0.5064, +0.1089, -0.1322, -0.4595, -0.4284, -0.1388, -0.0142, -0.0337, -0.1693, +0.3553, -0.6581, -0.0025, -0.1231, -0.4583, +0.2712, +0.1195, +0.1075, -0.1298, +0.1162, +0.2405, +0.1785, -0.0615, -0.0789, -0.5330, -0.1870, -0.0264, -0.0452, -0.1919, -0.0952, +0.3738, -0.2498, -0.2696, +0.4355, +0.1340, -0.4136, -0.2625, +0.1043, +0.2227, -0.2964, +0.0329, -0.0459, +0.3446, -0.3150, -0.0285, -0.1389, -0.0620, -0.3741, -0.0209, +0.0344, -0.4535, +0.3100],
[ -0.3163, -0.4723, -0.0250, -0.0141, +0.4464, -0.1986, -0.6116, -0.0829, -0.1127, -0.1741, +0.3716, -0.5599, -0.0702, +0.4810, +0.2091, -0.0865, +0.1534, -0.2891, -0.3830, -0.1924, -0.0542, -0.0241, -0.1366, +0.0385, -0.1856, +0.5328, -0.4052, -0.5755, -0.2612, +0.0013, -0.0076, -0.2590, +0.3901, -0.4172, -0.1419, +0.0362, +0.1212, -0.3479, -0.1679, -0.0086, -0.1725, +0.0736, +0.0087, +0.1469, +0.0006, +0.1689, -0.3634, -0.1821, +0.3467, -0.2033, -0.1277, +0.1919, +0.1260, -0.1244, -0.2993, -0.0904, -0.1687, +0.3754, +0.2097, -0.5879, -0.0770, +0.0359, +0.2110, -0.1712],
[ -0.3661, -0.2717, +0.1113, +0.2665, -0.0972, -0.5824, +0.2890, -0.1308, -0.0929, -0.0011, +0.2813, -0.1148, +0.0119, -0.0529, -0.0646, -1.4966, +0.4980, +0.0945, +0.1389, -0.4049, -0.2027, -0.0673, +0.1332, +0.7332, +0.1248, -0.0770, +0.6605, -0.8541, -0.0439, -0.1973, -0.4820, -0.0423, -0.2129, -0.0853, -0.6524, -0.0321, -0.0372, +0.3873, +0.0421, -0.4772, -0.5575, -0.5932, +0.1917, +0.2110, +0.1637, -0.3029, -0.2104, -0.0282, -0.7481, +0.0828, +0.0379, +0.2106, -0.0853, -0.2235, -0.1073, +0.5198, -0.2518, -1.3097, -0.3292, +0.1675, +0.0255, -0.1867, -0.6809, -0.4100],
[ +0.3530, -0.2818, -0.8931, -0.6490, -0.0029, -0.0079, +0.6413, -0.4325, -0.2703, -0.5681, +0.2736, -0.2060, -0.2772, +0.0567, -0.1602, +0.0456, -0.2931, +0.1224, +0.0146, +0.6612, +0.0332, -0.2383, -0.3551, -0.4960, +0.0080, +0.0682, +0.2126, +0.0375, -0.1039, +0.2998, -0.4285, +0.1969, +0.2692, +0.2157, +0.1096, +0.1654, -0.6327, +0.4191, -1.3065, +0.1224, +0.5497, +0.2013, +0.1524, +0.0798, -0.0325, -0.2407, -0.2019, -0.7491, -0.3803, -0.1791, -1.0558, +0.3998, -0.2989, +0.1077, -0.4348, +0.0519, -0.2329, -0.1133, +0.0053, +0.2635, -0.4516, -0.0578, -0.3698, -0.1016],
[ +0.6371, -0.1203, +0.0076, -0.8131, -0.0454, -0.8196, -0.9530, +0.0536, -0.0904, -0.6379, +0.0735, +0.4852, -0.0525, +0.5745, +0.1264, -0.3008, -0.7915, -0.0787, +0.1571, +0.1630, -0.3364, -0.1717, +0.5771, -0.6814, -0.2517, -0.3498, -0.3729, -0.4342, -0.5237, -0.6116, -0.1791, -0.0410, +0.0610, -0.2450, -0.8010, +0.5793, -0.5352, +0.1076, -0.1877, -0.1534, +0.3871, +0.0020, +0.1915, -0.3309, +0.0250, -0.5323, -1.2959, -0.9239, +0.2443, +0.0734, -0.2273, +0.0469, +0.2829, +0.2647, -0.5502, -0.4885, -1.0957, +0.1740, +0.1821, -0.6767, -0.2402, -0.3386, +0.1601, +0.3032],
[ -0.9192, +0.1419, -0.0422, -0.8396, -1.4337, -0.4047, +0.4867, -0.1729, +0.0987, +0.2949, -0.1027, +0.1376, +0.0276, -0.3454, +0.1000, +0.1415, +0.1384, -0.4045, -0.3747, -0.0164, +0.2935, -0.1466, -0.1396, +0.0236, -0.0539, +0.1790, -0.2958, +0.2800, -0.6574, +0.0546, -0.3582, -1.0463, +0.1917, +0.1586, -1.2121, -0.7189, -0.4901, +0.6121, -0.2627, +0.1610, -0.0404, +0.1463, -0.2310, -0.3012, +0.1397, +0.8620, -0.0025, -0.9045, -0.4128, -0.1460, +0.3187, -2.0256, -0.4127, +0.2568, +0.7488, -0.0511, -0.1044, +0.0262, +0.2524, +0.0832, +0.2267, +0.2748, -0.4902, +0.3688],
[ +0.1430, +0.0566, +0.6816, -0.3206, -1.4961, +0.1194, +0.6902, +0.0898, -0.2031, +0.1232, +0.0439, +0.1807, -0.0578, -0.0846, -0.1607, +0.0681, -0.0610, -0.5653, +0.0072, -0.5820, -0.0853, -0.3235, -0.4972, +0.0032, -0.2038, -0.2900, -0.1359, +0.0540, -0.0303, -0.6849, -0.9005, -0.1212, +0.0606, +0.1388, -0.4231, -1.0739, +0.1928, +0.0319, +0.0958, +0.0125, -0.1298, -0.2588, +0.1088, -0.5559, -0.3151, +0.0548, +0.3297, -0.5271, -0.7640, -0.0341, +0.1411, -0.4929, -0.1423, -0.0565, +0.2080, +0.0836, -0.3868, -0.1338, +0.1035, -1.4365, +0.1114, -0.2450, -0.7043, +0.3546],
[ +0.2535, -0.0369, +0.4675, +0.1631, -1.1942, -0.2561, -0.0358, -1.2841, -0.7228, -0.7758, -1.0097, -0.9734, +0.0736, +0.0120, +0.2161, -0.4861, +0.1287, +0.5726, -0.1021, +0.0230, +0.2227, +0.0172, -0.3978, +0.2238, -0.0154, -0.0980, +0.2639, +0.4450, -0.1750, +0.1290, +0.3401, +0.0108, +0.3784, -0.5999, +0.7053, -0.2275, -0.1755, -0.8104, +0.1894, +0.4153, +0.3092, +0.1734, -0.3326, -0.1536, -0.1178, -0.6143, -0.1548, -0.2079, +0.0667, +0.1950, -0.4622, -0.4300, +0.4255, -0.0521, -1.0740, -0.2555, -0.3026, -1.4444, -0.7026, +0.3971, +0.2106, +0.2773, -0.1475, +0.1711],
[ -0.7103, -0.2924, -0.1677, +0.5409, -0.8698, +0.1309, +0.1154, -0.6516, -0.9558, -0.9140, -0.0917, +0.0043, -0.1487, +0.0357, +0.3957, -0.1346, +0.6243, +0.0267, -0.1561, -0.9322, +0.5103, -0.2402, +0.2321, -1.1931, -0.1977, +0.0085, -1.2352, +0.2785, -0.5084, +0.3258, +0.3364, +0.2619, -0.0041, -0.1554, -0.0281, -0.4433, +0.2035, -0.0982, -0.0065, +0.4423, +0.2874, -0.4494, -0.0345, -0.3386, -0.4039, -0.8893, -0.1554, -0.2474, -0.1889, -0.1272, +0.2077, -1.2152, +0.4811, +0.1376, +0.1043, +0.3282, +0.0409, +0.0068, +0.1769, +0.1182, +0.4116, -0.3562, +0.0513, -0.5300],
[ -0.1572, -1.5188, -1.5678, -0.4130, -0.4267, -0.1431, +0.1554, -0.3178, -0.7728, +0.2314, -0.2010, +0.2888, +0.1788, -0.1780, +0.0944, -0.9144, +0.5334, +0.2888, -0.2076, +0.1253, +0.2449, +0.1610, -0.2281, +0.0742, -0.0978, +0.2734, -0.3029, -0.2320, +0.1220, +0.0550, +0.1580, -0.1043, -0.2656, -0.0400, +0.2219, -0.6095, +0.1252, -0.1372, +0.3713, -0.5300, +0.1172, +0.2025, -0.4247, +0.0746, +0.1929, +0.0514, +0.2209, -0.5462, -0.2288, -0.7486, +0.2197, +0.1359, -0.7125, -0.8333, -0.5579, -0.8019, -0.5522, -0.2105, +0.1643, -1.0014, -0.4503, -0.6657, +0.4036, -0.0555],
[ -0.0590, -0.3719, -0.5114, +0.2530, -0.7208, -0.0563, +0.3854, +0.3026, +0.0735, +0.3427, +0.6002, -0.1396, -0.1402, +0.1080, +0.1864, +0.3067, -1.0581, -1.9660, -0.2471, -0.0337, +0.0124, -0.2047, -0.6474, -0.8498, +0.0491, +0.0070, -0.1226, +0.0656, -0.2951, +0.0360, -0.9327, -0.2177, -1.0216, +0.6137, -0.5219, -0.3685, -0.0321, -0.2387, +0.6478, -0.0755, -0.0629, -0.7876, +0.2509, -0.3656, -0.1480, +0.1127, +0.5233, -1.2403, +0.1726, +0.3162, +0.3171, -0.6025, -0.6811, -0.9313, -0.1579, -0.1299, +0.1423, -0.1796, +0.2760, -0.4841, +0.1697, -0.1206, -1.3476, -0.4628],
[ -0.3120, -0.7815, -0.7293, +0.2830, -1.2078, +0.3774, +0.5226, -0.7750, -0.7630, +0.6087, +0.6374, +0.2126, -0.1801, -0.1649, -0.0703, +0.0150, -0.5099, -0.8238, +0.2890, -0.5040, +0.0895, -0.2675, -1.6283, -0.6663, +0.1520, +0.1787, -0.1078, +0.0191, +0.2750, -0.6022, -0.2075, +0.1815, -0.0741, +0.4324, -1.1463, -0.3964, +0.4130, -0.8703, -0.1329, -0.4860, -0.3910, +0.1145, +0.1338, -0.1027, +0.2230, +0.2237, +0.0151, +0.3517, -0.5960, -0.1026, +0.0241, +0.0157, -0.3517, -0.0960, +0.2909, +0.2758, -0.2046, -0.0833, -0.1670, -0.4800, +0.3463, -0.9654, -0.4277, -0.4589],
[ -0.1478, +0.1582, -0.2973, -0.1952, -0.1098, +0.5831, +0.6361, +0.3629, -0.1146, -0.6157, +0.5632, +0.4363, +0.0612, -0.9039, +0.1119, -0.5786, -0.5540, +0.0398, +0.1752, -0.5577, -0.6667, -0.2905, +0.2213, -0.0194, +0.3635, -0.6965, +0.0050, +0.0740, +0.1895, +0.1548, -0.5477, +0.4813, -0.6568, +0.7340, -1.0991, +0.0799, +0.1582, +0.0278, +0.5434, -0.1960, +0.4060, -0.6551, -0.0725, -0.4377, -0.7184, +0.1424, -0.8283, +0.7254, +0.4389, +0.5734, +0.2364, -0.5897, -0.0238, -0.0007, +0.3947, -0.0760, +0.1847, +0.1770, +0.0928, +0.3543, -0.4835, -0.3019, -0.9959, +0.0583],
[ +0.1443, +0.2220, +0.1527, -0.3340, +0.2000, -0.1948, -0.2900, +0.3642, +0.1534, -0.0776, +0.1768, -0.1703, -0.2562, -0.2758, -0.4396, +0.0234, -0.1917, +0.1102, -0.2345, -0.1229, +0.0281, +0.0845, +0.1131, +0.4417, +0.0569, -0.3473, +0.0394, -0.0056, +0.0946, +0.0011, -0.7753, +0.1805, -0.1408, +0.1301, +0.0846, -0.4318, -0.3021, +0.0477, +0.0908, +0.0013, -0.3767, +0.2696, +0.4063, -0.3381, -0.7599, +0.1141, +0.3743, -1.1590, +0.0345, +0.2245, +0.2459, -0.2822, -0.4002, -0.7271, -0.1023, -0.3171, -0.1637, +0.2897, +0.1085, -0.4487, -0.0477, +0.1013, +0.0479, +0.0018],
[ -1.0487, -0.2101, +0.2740, +0.0018, -0.1096, -0.8838, -0.4168, -0.3155, -0.2515, -0.1041, -0.0137, +0.3740, -0.1076, +0.2306, -0.4726, +0.0436, -0.3551, +0.3825, -0.2449, +0.4380, -0.7459, +0.2044, -0.5208, -0.7803, -0.0959, -0.2527, +0.0630, -0.9097, -0.0458, -1.0599, +0.3440, -0.3823, +0.0603, -0.7298, +0.3327, +0.3867, -0.2603, +0.0369, +0.6102, -0.0971, -0.0400, -0.2093, -0.3939, +0.2720, +0.4138, +0.0643, -1.0037, -0.2460, +0.1148, -0.3138, -0.1753, -0.0530, -0.8875, +0.3475, -0.3792, -0.8626, -0.3554, -0.2610, +0.0977, -0.1185, -0.3172, -0.0645, +0.0849, +0.3102],
[ +0.6196, -0.2248, +0.3701, +0.3871, +0.1780, -0.8845, -1.1825, -0.2375, -0.3429, +0.1191, +0.4072, -0.4555, -0.1496, +0.1067, +0.0234, -0.8369, -0.0937, -0.0319, -0.2486, +0.0657, -0.6954, +0.2187, +0.3412, +0.2551, -0.3422, -0.0815, -0.2930, -0.2226, -1.1675, +0.5878, -0.5601, +0.1259, -0.0683, -0.2040, -0.0079, -0.1074, -0.1578, -0.1415, -0.1203, -0.9654, +0.7452, +0.0246, -0.3484, -0.0277, +0.1140, +0.1730, -1.0210, -0.5052, +0.3313, -0.2379, +0.1376, +0.1366, +0.3220, +0.2231, -0.7424, -0.1786, -1.4978, -1.3279, -0.3878, -0.0794, -1.7559, -0.0926, +0.2841, +0.0046],
[ -0.0346, +0.2532, +0.3598, -0.0466, +0.0500, +0.0986, -0.4646, -0.2297, -0.4361, -1.7196, +0.2609, -0.4030, -0.2188, -0.2671, -0.1898, +0.1210, +0.6077, +0.1553, +0.0702, +0.1467, -0.2473, +0.1862, +0.3394, +0.2467, -0.4418, -0.1372, +0.5745, -0.3004, +0.1039, +0.1269, -0.4942, +0.1940, +0.5131, -0.2525, -0.7989, +0.2016, +0.3945, -0.1058, -0.6304, -0.6872, -0.1522, +0.6897, -0.0695, +0.1169, -0.0974, +0.0709, -0.2866, +0.2668, -0.0795, +0.3041, -0.1889, +0.1018, +0.2852, +0.4602, -0.1846, +0.5833, -0.1721, +0.6602, -0.6977, -0.2847, -0.0483, +0.0897, -0.0469, +0.1863],
[ -0.0781, -0.3706, +0.2251, +0.2849, +0.0941, -0.2094, +0.6678, -0.0101, +0.0424, -0.0293, +0.2295, -0.1194, +0.0675, +0.0213, -0.1025, +0.3390, +0.1805, -0.2866, +0.2053, +0.2851, +0.4197, -0.1941, -0.4910, +0.2821, -0.2832, -0.1295, -0.0805, +0.1562, +0.2949, -0.3321, -0.7247, -0.4742, +0.3879, +0.2745, -0.3844, -0.6716, -0.3245, +0.4906, -0.2705, -0.2982, -0.1698, -0.7898, +0.1142, -0.1942, -0.3603, -0.1740, +0.3400, -0.0506, -0.3486, -0.2486, -0.0503, -0.3264, -0.5077, -0.0445, +0.1496, +0.2111, -0.6167, -0.3732, -0.9418, -0.7983, +0.0077, -0.2045, -0.7608, +0.1405],
[ +0.2049, +0.1535, +0.2128, -0.4164, -0.2544, -0.6106, -0.7504, -0.3578, -0.2596, -1.0701, +0.0292, -0.1886, -0.1032, -0.5208, +0.0134, -0.3110, -0.7516, +0.4388, +0.0340, +0.0624, +0.0834, -0.0516, -0.1133, -0.7225, -0.2224, -0.5351, -0.0026, -0.6803, -0.0265, -0.1342, -0.2246, +0.2535, -0.5135, -0.4462, +0.3514, -0.0025, +0.1148, -0.5111, -0.2767, -0.1291, +0.2889, +0.1646, +0.4116, -0.5003, -0.1414, +0.4581, -0.0032, +0.2815, -0.1550, -0.1487, -0.2589, -0.7931, -1.5351, +0.6082, -0.8509, -0.5817, +0.3463, +0.1935, +0.4886, +0.3674, -0.1345, -0.5708, -0.5943, -1.0342],
[ -0.4535, -0.7263, +0.1911, -0.1976, -0.0240, -0.2905, -0.3329, -0.2344, +0.1119, -0.7598, +0.2671, -0.0547, +0.0231, -0.1666, -0.1475, -0.9600, -0.2575, -0.5557, -0.0586, +0.1305, -0.7248, -0.1328, -0.0749, -0.1792, -0.0993, +0.0632, +0.0370, -0.0350, -0.2100, -1.0003, -0.2526, +0.4889, -0.0268, -1.0811, -1.0744, -0.2632, +0.6099, +0.1728, -0.3989, -0.4078, +0.4547, -2.1630, +0.0652, -0.1967, +0.0211, -0.7390, -1.2135, -0.2196, -0.0140, -0.4225, -0.0909, +0.3659, +0.2051, +0.1075, -0.2806, -0.2124, -0.0317, +0.0040, -1.0535, -0.0977, -0.0551, -0.4167, -0.4222, -0.5449],
[ -0.5821, +0.1573, +0.3883, -0.0208, +0.0267, -0.1548, +0.0036, +0.0238, +0.2573, -0.2390, +0.1001, -0.4440, +0.1714, +0.4488, -0.0916, -0.0133, +0.0881, +0.1937, +0.0243, +0.0557, -0.0183, -0.3184, -0.0971, +0.1885, -0.1141, -0.0808, +0.2792, +0.3806, +0.1167, -0.0970, -1.1862, -0.3819, -0.0736, -0.2230, -0.2072, -0.4767, +0.3344, -0.4753, +0.4085, -0.9508, -1.3361, -0.5341, -0.2721, -0.2227, -0.2407, -0.2488, +0.0815, +0.0050, -0.0188, +0.1103, +0.3057, -0.1838, +0.1879, +0.0258, -0.0092, +0.2777, -2.1384, -0.0154, -0.0746, +0.1013, -0.0875, -0.4639, -0.1884, +0.3613],
[ -0.3665, -0.1782, +0.0419, -0.2690, -0.3408, +0.7867, +0.3313, -0.9157, +0.4388, -0.4855, -1.2508, -0.4405, -0.2233, +0.0522, +0.4611, -0.3997, -0.5933, -1.3610, -0.3253, -0.1574, +0.0802, -0.4449, -0.6778, -0.3988, -0.2578, -0.7707, -0.7587, -0.0789, -0.0164, +1.0809, +0.1280, -0.4027, -1.1598, +0.7488, -0.6504, +0.0912, +0.5017, -0.1733, -0.5198, -0.7894, -0.0064, -1.4117, +0.1238, -1.8378, -0.0063, +0.7132, -0.0657, -0.0301, +1.1850, -0.3432, -0.5329, +0.2786, -0.8299, -0.5956, +0.0208, -0.4721, +0.2628, -0.3157, +0.1742, -0.8047, +0.0856, +0.2113, -0.6971, -0.1566],
[ -0.6693, -0.1809, +0.0884, -0.1358, +0.5172, -0.0687, -0.0120, -0.3826, -0.5306, -0.0103, +0.8560, -0.3482, +0.0860, +0.3675, -0.5334, -0.0405, +0.2357, -0.2945, -0.4034, +0.3049, -0.6580, -0.2272, -0.5667, -0.0805, -0.0008, +0.3024, -0.2402, -0.5567, +0.2349, -0.4490, -0.3248, +0.3113, -0.0458, +0.5295, -0.8893, -0.1700, +0.1197, -0.0317, +0.2407, -0.3567, -0.3077, -0.4958, +0.3886, +0.4175, -0.0700, -0.4049, +0.3392, -0.1947, +0.7443, +0.2133, +0.3215, +0.0441, -0.5935, -0.3116, -0.0350, -0.7650, -0.6026, -0.3508, -0.1284, -0.9857, -0.1828, -0.2976, -0.2231, -1.0016],
[ +0.0507, -0.0567, +0.2445, -0.0756, -0.0082, +0.4970, -0.0516, -0.0301, +0.3676, -0.1720, +0.0047, -0.3551, -0.0340, -0.0532, -0.4424, -0.3569, -0.0102, -0.1321, +0.1088, -0.2266, -0.8376, -0.6879, +0.5277, +0.1749, +0.0183, -1.0760, -0.5535, +0.1199, +0.0335, -0.4466, +0.0450, -0.9575, -0.7582, +0.5908, -0.6280, +0.5010, -0.0937, +0.4709, +0.1345, -0.1088, -0.4050, -0.9498, +0.1079, -0.0437, -0.1768, -0.8175, +0.3442, -0.0402, -1.4693, +0.2791, +0.1296, -0.0762, +0.0142, -0.9085, +0.3446, +0.1278, -0.0685, -0.5707, +0.4476, +0.0823, -0.4022, -0.5325, -0.5841, -0.2564],
[ +0.0898, -1.1540, -0.9679, -0.3278, +0.1902, -0.3525, +0.0045, -0.2419, -0.9443, +0.2821, -0.4016, -0.3287, -0.0096, -0.2795, +0.3097, -0.2414, +0.1993, -0.0236, -0.2561, -0.1521, +0.1322, +0.0188, +0.2566, -0.7166, -0.0330, +0.1491, -0.1133, +0.1535, -0.2132, -0.2450, -0.3134, -0.0497, -0.4828, -0.0163, +0.0998, -0.0427, +0.0128, +0.4167, -0.4010, +0.3123, +0.1781, -0.0243, -0.1447, -0.4638, -0.6196, +0.1720, -0.1308, -0.7977, -0.4340, -0.3038, -0.9074, -0.1848, +0.1264, +0.0249, -0.5808, -0.0785, -0.1180, -0.6689, +0.4223, -0.0547, +0.3043, +0.1254, +0.2954, -0.2502],
[ +0.0870, +0.0780, -0.0389, +0.1600, -0.0364, +0.2506, +0.0564, +0.2378, +0.0033, -0.1340, -0.1532, +0.3440, -0.4366, -0.1984, +0.0098, +0.1903, +0.0752, -0.1213, +0.0378, -0.1293, +0.0029, -0.1710, +0.1367, -0.0665, -0.0351, -0.1341, -0.1123, -0.2100, -0.0160, -0.0597, -0.2886, +0.1219, -0.0732, +0.2243, -0.3820, -0.1373, -0.0118, +0.0217, +0.2059, +0.0855, -0.0949, -0.0514, -0.0669, -0.3338, -0.4548, -0.0133, +0.0292, -0.0179, +0.1236, +0.2291, +0.2861, -0.2900, -0.0856, -0.2934, +0.0034, -0.3797, +0.0143, +0.0729, +0.0875, +0.2393, -0.0385, -0.1214, +0.0479, -0.0652],
[ -0.7501, -1.1375, -0.2978, -0.8633, -0.8919, +0.2189, -0.5857, -0.2409, +0.0604, -0.0567, -0.1097, +0.2126, +0.0844, -0.3906, +0.3503, -0.9469, +0.0383, -0.3880, +0.1532, -0.7949, +0.2010, -0.3122, -0.3812, -1.0744, -0.0195, -0.4764, +0.2610, -0.7452, +0.1366, +0.2796, +0.2770, -0.2790, -0.7372, -0.2902, -0.7949, -0.1160, -0.1794, -0.6606, -0.0722, -0.1698, +0.1217, +0.2441, +0.2072, -0.3946, +0.1858, -0.1417, -0.9906, -0.2096, -0.0386, -0.3452, +0.3401, -0.3946, -0.0491, +0.0953, -0.5440, -0.9668, -1.4922, +0.0952, +0.2255, -0.0070, -0.0929, -0.6225, +0.2984, -0.1608],
[ +0.0875, -0.8502, +0.2431, -1.4256, -0.0134, -0.5211, +0.1531, -0.3139, -0.2330, -0.0786, -0.0809, -0.1122, -0.1306, -0.0140, +0.4723, -0.6809, -1.0225, +0.1196, +0.1491, -0.2224, -1.9714, -1.6552, -0.0284, -0.6446, +0.1878, -0.0111, +0.2549, -0.5032, +0.2373, -0.2167, +0.0885, -0.0815, -0.8509, -0.9426, -0.4842, +0.2617, +0.0947, +0.8169, -0.0459, +0.1221, -0.0595, -0.5754, -0.5843, -1.3281, +0.1531, -1.3252, -0.7069, -0.5561, +0.1954, +0.0952, -0.5631, +0.2066, +0.7464, +0.1565, -1.3679, -0.5306, +0.1436, -0.5271, -0.1679, -0.0539, +0.5787, -0.2023, +0.3189, -0.4968],
[ +0.0315, -1.1600, -0.1894, +0.1841, -0.0069, -0.9793, -0.0278, -0.9642, -1.0357, +0.5406, -0.1473, +0.2056, -0.3358, +0.3904, -0.0970, -1.3872, +0.2364, +0.2908, +0.0140, -0.1797, -0.0895, +0.1147, +0.0184, +0.2090, -0.2029, -0.0183, +0.3583, -0.6774, -0.3236, +0.4919, +0.1323, -0.3519, +0.2735, -0.4859, +0.1274, +0.0592, +0.0293, -0.0612, -0.2484, +0.0962, -0.4288, +0.5136, -0.6259, +0.2224, +0.2347, +0.0524, -0.0633, +0.0179, +0.0616, -0.9062, -0.1752, -0.0501, +0.3795, +0.4146, +0.0351, +0.3203, -0.0841, -1.0873, -1.3012, -0.3519, +0.3106, +0.3838, +0.1764, -0.1131],
[ -0.0067, +0.0395, -0.7516, -0.2958, -0.1750, +0.4141, -0.3325, -0.3768, -0.4620, +0.8233, +0.3492, -0.0237, +0.0106, -0.8323, +0.3937, -0.1977, -0.4075, -0.2006, -0.0474, +0.3061, +0.0789, -0.2584, -0.0647, +0.1114, +0.0884, +0.4178, -0.6012, -0.1629, +0.4286, +0.4013, -0.9800, -0.6920, +0.3876, +0.7810, -0.7333, -0.0620, -0.2162, -0.4436, -0.1308, +0.0799, -0.0925, -1.3182, +0.3494, -0.7913, +0.1979, +0.5827, +0.2238, +0.0280, +0.0497, -0.0354, -0.0631, +0.8220, -0.1120, -0.2673, +0.1897, -0.6081, -0.1298, -0.7712, -0.2133, -0.6315, -0.3532, -0.9268, +0.2826, +0.2492],
[ -0.6092, -0.1699, +0.0756, -1.0743, +0.7791, -0.0013, +0.0261, +0.0341, +0.0039, -1.3614, +0.0474, +0.1043, -0.1149, -0.3031, -0.1387, -0.2534, -0.1865, -0.0783, +0.0465, +0.1722, +0.0714, -0.3566, -0.3526, -0.3374, -0.2516, +0.0578, -1.6820, +0.6733, +0.1903, +0.3942, +0.0378, -0.0427, -0.0685, +0.2141, -0.7520, -0.5861, -0.1980, -0.8542, -0.2299, -0.4345, -0.1855, -0.1432, +0.3582, -0.4741, -0.5136, +0.3023, -0.0360, -0.0623, +0.1555, -0.1655, +0.2128, -0.4508, -1.2209, -0.0260, +0.0659, -1.1528, +0.2362, -0.5791, -0.2722, -0.1899, -0.1704, +0.0203, -0.7536, +0.2306],
[ -0.1456, +0.4228, -0.2169, -0.1864, +0.2956, +0.0975, -0.4902, -0.4168, -0.0061, -0.0129, +0.5856, +0.0718, -0.1802, -0.3765, +0.3940, -0.0377, -0.1783, +0.1068, +0.1506, +0.1025, -0.4088, +0.1379, +0.4524, -0.2770, +0.0499, +0.0828, +0.0832, +0.1792, -0.0652, +0.3557, +0.1142, +0.1000, +0.5156, -0.0644, -0.2629, -0.4445, +0.2076, +0.1216, +0.3907, +0.0722, -0.0435, -0.1319, +0.2939, +0.1871, -0.1707, -0.1241, +0.0260, -0.0176, +0.7158, +0.0326, +0.2360, -0.0155, -0.2790, -0.0850, -0.0872, +0.0258, +0.1475, -0.2429, -0.3992, -0.5970, -0.0884, +0.0104, +0.2510, -0.3747],
[ -0.1019, +0.0217, +0.0604, +0.2556, +0.0670, -0.2470, -0.0896, +0.0972, -0.5061, -0.0539, -0.1494, -0.6850, -0.1314, +0.4489, +0.3238, -0.1830, -0.3250, -0.4818, +0.1131, +0.0809, -0.1849, +0.0768, -0.4203, -0.1073, +0.0289, +0.0777, -0.2676, -0.1635, +0.2819, -1.1156, +0.4612, -0.5983, +0.2212, -0.2626, -0.3611, -0.8076, +0.0604, +0.1751, -0.1189, -0.8877, +0.1995, -0.5779, +0.1674, +0.1556, -0.4025, -0.7868, -0.6574, -0.0562, -0.3712, -0.0835, +0.2261, -0.0039, -0.0864, +0.1381, -0.2375, -0.1138, +0.0788, -0.7128, -2.4133, +0.2474, -0.5965, +0.0887, -0.3717, +0.1583],
[ -0.0173, -0.8841, -0.1036, -0.4535, -0.0171, -0.5824, -0.0683, -0.1105, -0.6359, +0.0860, -0.4490, +0.1697, -0.1639, +0.2569, +0.2831, +0.2610, -0.6809, -0.4909, -0.5067, -0.2111, +0.0006, -0.9312, -0.1564, -0.0030, -0.4018, -1.0880, -0.2422, -0.5496, +0.4572, -0.2074, +0.5928, -0.6699, +0.2007, -0.1501, +0.6496, +0.0006, -0.8182, +0.1627, -0.9395, -0.1071, -0.1078, +0.5001, -0.9152, -0.0298, +0.2665, -0.2468, +0.3327, +0.1171, +0.2442, -0.4903, -0.3593, +0.0516, -0.2479, +0.0401, +0.2455, +0.1927, +0.4553, -0.4156, +0.4963, -0.4824, -0.7662, +0.1025, -0.1231, -0.0549],
[ -0.5653, -0.0579, +0.0711, +0.1978, +0.1483, -0.2487, +0.5816, -0.2505, -1.0865, -0.3124, +0.4662, +0.3429, +0.1187, +0.3957, -0.3051, -0.2266, -0.5454, -0.4433, +0.1236, -0.2226, +0.1168, -0.1802, -0.2434, -1.0033, -0.3189, +0.1394, -0.7433, +0.5946, +0.1073, -0.4106, -0.5485, -0.5361, +0.3073, +0.3227, -0.6396, -0.2144, +0.3187, -1.2617, +0.1526, -0.4829, +0.1673, -0.4504, +0.3942, -0.6261, +0.1535, +0.1946, -0.2928, -1.2917, -0.4011, +0.0209, -0.2192, +0.1189, -0.2842, -0.3277, -0.0050, +0.1858, -0.7773, -0.1619, -0.2147, -0.6281, +0.3831, -0.8085, -0.6315, +0.4716],
[ -0.8026, -0.3107, +0.0903, +0.0076, +0.4653, +0.2245, +0.1581, +0.3757, +0.3310, -1.2516, -0.1040, -0.6431, +0.0373, +0.0716, +0.1643, -0.6158, -0.0895, +0.2540, -0.1583, -0.0699, +0.1837, +0.4705, -0.9086, -0.0468, -0.2022, +0.2916, -0.3869, +0.1620, -0.2646, -0.1511, -0.2067, -0.3882, -0.6044, -0.1775, -0.8657, +0.2309, +0.3567, +0.0654, +0.5363, +0.0686, -0.0198, -0.9192, -0.1272, +0.5987, -0.0621, -0.3943, -0.0519, -0.5483, +0.0777, -0.5409, -0.0296, +0.0010, +0.2560, -0.1014, -0.8840, -0.4932, -0.2339, -1.0472, -0.4789, -0.2379, -0.6807, -0.0958, +0.2527, -0.5875],
[ +0.0894, +0.2394, +0.4565, +0.5095, -0.9334, -1.2892, -0.8885, +0.0167, +1.0713, -0.3041, -0.7280, +0.2223, -0.5221, -0.0032, -0.0743, +0.1534, +0.5751, -0.1298, -0.1282, -0.4674, +0.5752, +0.2239, +0.4114, +0.3252, -0.1642, +0.2532, +0.3494, -0.8035, -0.2348, +0.3177, -0.5218, +0.0481, -0.3052, -0.9177, +0.1627, +0.6603, -0.7468, +0.0274, +0.0626, +0.0355, -0.2757, +0.2697, +0.4732, -0.2061, -0.0190, +0.5470, -0.5898, -0.8168, -0.0884, -0.4522, -0.1064, -0.8207, +0.2726, +0.1109, -0.2514, +0.1580, +0.6825, +0.7124, +0.8108, +0.2258, -0.1274, +0.2130, -0.3830, -0.9575],
[ +0.0671, +0.2013, -0.4460, -1.0518, -0.0167, +0.1024, +0.0547, +0.3296, +0.0516, +0.0503, +0.1956, -0.0536, +0.0108, -0.2160, +0.1852, -0.0177, -0.4770, -0.2327, -0.2887, +0.2862, -0.0357, +0.0026, -0.6428, -0.5677, -0.0354, -0.0304, -0.1272, +0.1630, -0.1319, -0.1122, +0.3381, +0.0000, -1.0265, +0.1319, -0.2374, -0.1598, -0.0059, +0.1722, +0.2300, +0.1748, -0.0167, -0.0891, +0.0350, -0.4563, -0.5325, +0.0078, -0.2475, +0.1184, +0.0133, +0.2512, +0.3639, -1.5981, -0.5117, -0.2703, +0.0222, -0.5620, -0.1466, -0.1626, -0.3288, -0.0070, +0.0508, -0.3687, -0.4245, -0.2751]
])

weights_dense2_b = np.array([ +0.0266, +0.3395, +0.0968, +0.0097, +0.0443, -0.1722, -0.2537, +0.1501, +0.0233, -0.0174, +0.1783, -0.0513, -0.1531, -0.2145, +0.0299, -0.1589, +0.1143, +0.1132, -0.2700, -0.0481, +0.2876, +0.1824, +0.2418, +0.1009, -0.1451, +0.1637, +0.1703, +0.0336, -0.1405, -0.0162, -0.1158, +0.1691, -0.0223, -0.1828, +0.2352, +0.0209, -0.1362, -0.2636, +0.1271, -0.0936, -0.1436, +0.0606, +0.1311, -0.0989, -0.2877, +0.2593, +0.0781, -0.1118, -0.1264, +0.2478, +0.2398, -0.1515, +0.0959, -0.0821, -0.1740, +0.1116, -0.0682, +0.1743, +0.1746, -0.1950, -0.0951, +0.2190, -0.0294, +0.1950])

weights_final_w = np.array([
[ -0.6826, +0.0812, +0.5225],
[ -0.2533, +0.7043, +0.6677],
[ +0.0684, +0.6807, +0.4726],
[ +0.4605, +0.3736, -0.3187],
[ +0.4913, +0.0049, +0.4186],
[ +0.3066, +0.3756, -0.3588],
[ -0.3078, +0.3643, -0.0335],
[ -0.5433, +0.5926, -0.1254],
[ -0.2532, +0.7950, -0.1380],
[ -0.6121, -0.3012, +0.0149],
[ +0.3181, +0.0973, +0.1705],
[ +0.2236, -0.1020, +0.3147],
[ -0.0038, -0.3193, +0.1068],
[ +0.3799, -0.0215, -0.0715],
[ +0.3440, -0.2333, -0.1001],
[ +0.1852, +0.7445, +0.4295],
[ +0.4888, -0.0469, -0.1287],
[ +0.0297, -0.3913, -0.5198],
[ -0.0092, -0.1013, +0.2193],
[ +0.2590, +0.0846, +0.0886],
[ +0.0744, +0.4771, -0.3553],
[ +0.2019, +0.1670, -0.1630],
[ -0.4549, -0.6127, +0.5951],
[ -0.2582, -0.6401, -0.6541],
[ +0.0248, +0.0646, +0.1598],
[ +0.2109, -0.0794, -0.2444],
[ +0.2435, -0.4159, -0.2927],
[ -0.0713, +0.2441, -0.4683],
[ -0.0737, +0.2075, +0.4609],
[ +0.3240, -0.4084, -0.4554],
[ +0.3463, +0.4490, -0.2689],
[ +0.5252, -0.3714, +0.2808],
[ +0.5561, +0.1137, -0.0258],
[ +0.6168, +0.0587, -0.1059],
[ -0.0737, -0.6782, -0.4729],
[ -0.6030, -0.2577, +0.4194],
[ +0.4061, -0.1966, +0.2603],
[ -0.1265, +0.3940, +0.0447],
[ +0.2460, +0.3328, +0.1654],
[ -0.1878, +0.6672, +0.0333],
[ +0.5618, -0.1013, -0.2911],
[ +0.8250, -0.0788, -0.3731],
[ +0.2661, -0.2775, +0.2854],
[ -0.1036, +0.2179, -0.6408],
[ -0.5371, -0.7837, +0.1141],
[ +0.4754, -0.0923, +0.1714],
[ +0.0448, +0.4901, -0.1578],
[ +0.8797, +0.3316, +0.4349],
[ +0.1514, -0.4129, -0.3333],
[ +0.2847, +0.2285, +0.1408],
[ +0.0045, +0.3333, +0.0694],
[ +0.1553, -0.5147, +0.0549],
[ -1.0765, -0.5130, +0.1472],
[ +0.0808, -0.2612, +0.2591],
[ +0.5104, +0.3062, +0.3979],
[ -0.0758, -0.4512, -0.4422],
[ +0.3236, +0.4479, -0.1759],
[ +0.2181, -0.0028, +0.5615],
[ -0.0254, -0.1924, +0.4608],
[ -0.1566, +0.5634, -0.2498],
[ -0.0042, +0.5403, +0.0272],
[ +0.1206, +0.3941, -1.1469],
[ +0.7642, -1.0114, +0.4905],
[ +0.5071, +0.2270, +0.0046]
])

weights_final_b = np.array([ +0.4868, -0.0987, -0.0946])

if __name__=="__main__":
    main()
