// distribution boxbackup-0.11.1 (svn version: 2821_2827)
// Box Backup, http://www.boxbackup.org/
// 
// Copyright (c) 2003-2010, Ben Summers and contributors.
// All rights reserved.
// 
// Note that this project uses mixed licensing. Any file with this license
// attached, or where the code LICENSE-GPL appears on the first line, falls
// under the "Box Backup GPL" license. See the file COPYING.txt for more
// information about this license.
// 
// ---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
// 
// [http://www.gnu.org/licenses/old-licenses/gpl-2.0.html#SEC4]
// 
// As a special exception to the GPLv2, the Box Backup Project gives
// permission to link any code falling under this license (the Box Backup
// GPL) with any software that can be downloaded from
// the OpenSSL website [http://www.openssl.org] under either the
// "OpenSSL License" or the "Original SSLeay License", and to distribute
// the linked executables under the terms of the "Box Backup GPL" license.
// 
// As a special exception to the GPLv2, the Box Backup Project gives
// permission to link any code falling under this license (the Box Backup
// GPL) with any version of Microsoft's Volume Shadow Copy Service 7.2 SDK
// or Microsoft Windows Software Development Kit (SDK), including
// vssapi.lib, that can be downloaded from the Microsoft website
// [*.microsoft.com], and to distribute the linked executables under the
// terms of the "Box Backup GPL" license.
// --------------------------------------------------------------------------
//
// File
//		Name:    BackupStoreFileWire.h
//		Purpose: On the wire / disc formats for backup store files
//		Created: 12/1/04
//
// --------------------------------------------------------------------------

#ifndef BACKUPSTOREFILEWIRE__H
#define BACKUPSTOREFILEWIRE__H

#include "MD5Digest.h"

// set packing to one byte
#ifdef STRUCTURE_PACKING_FOR_WIRE_USE_HEADERS
#include "BeginStructPackForWire.h"
#else
BEGIN_STRUCTURE_PACKING_FOR_WIRE
#endif

typedef struct
{
	int32_t mMagicValue;	// also the version number
	int64_t mNumBlocks;		// number of blocks contained in the file
	int64_t mContainerID;
	int64_t mModificationTime;
	int32_t mMaxBlockClearSize;		// Maximum clear size that can be expected for a block
	int32_t mOptions;		// bitmask of options used
	// Then a BackupStoreFilename
	// Then a BackupClientFileAttributes
} file_StreamFormat;

typedef struct
{
	int32_t mMagicValue;	// different magic value
	int64_t mOtherFileID;	// the file ID of the 'other' file which may be referenced by the index
	uint64_t mEntryIVBase;	// base value for block IV
	int64_t mNumBlocks;		// repeat of value in file header
} file_BlockIndexHeader;

typedef struct
{
	int32_t mSize;			// size in clear
	uint32_t mWeakChecksum;	// weak, rolling checksum
	uint8_t mStrongChecksum[MD5Digest::DigestLength];	// strong digest based checksum
} file_BlockIndexEntryEnc;

typedef struct
{
	union
	{
		int64_t mEncodedSize;		// size encoded, if > 0
		int64_t mOtherBlockIndex;	// 0 - block number in other file, if <= 0
	};
	uint8_t mEnEnc[sizeof(file_BlockIndexEntryEnc)];	// Encoded section
} file_BlockIndexEntry;

// Use default packing
#ifdef STRUCTURE_PACKING_FOR_WIRE_USE_HEADERS
#include "EndStructPackForWire.h"
#else
END_STRUCTURE_PACKING_FOR_WIRE
#endif

// header for blocks of compressed data in files
#define HEADER_CHUNK_IS_COMPRESSED		1	// bit
#define HEADER_ENCODING_SHIFT			1	// shift value
#define HEADER_BLOWFISH_ENCODING		1	// value stored in bits 1 -- 7
#define HEADER_AES_ENCODING				2	// value stored in bits 1 -- 7


#endif // BACKUPSTOREFILEWIRE__H

