// distribution boxbackup-0.11.1 (svn version: 2821_2827)
// Box Backup, http://www.boxbackup.org/
// 
// Copyright (c) 2003-2010, Ben Summers and contributors.
// All rights reserved.
// 
// Note that this project uses mixed licensing. Any file with this license
// attached, or where the code LICENSE-GPL appears on the first line, falls
// under the "Box Backup GPL" license. See the file COPYING.txt for more
// information about this license.
// 
// ---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
// 
// [http://www.gnu.org/licenses/old-licenses/gpl-2.0.html#SEC4]
// 
// As a special exception to the GPLv2, the Box Backup Project gives
// permission to link any code falling under this license (the Box Backup
// GPL) with any software that can be downloaded from
// the OpenSSL website [http://www.openssl.org] under either the
// "OpenSSL License" or the "Original SSLeay License", and to distribute
// the linked executables under the terms of the "Box Backup GPL" license.
// 
// As a special exception to the GPLv2, the Box Backup Project gives
// permission to link any code falling under this license (the Box Backup
// GPL) with any version of Microsoft's Volume Shadow Copy Service 7.2 SDK
// or Microsoft Windows Software Development Kit (SDK), including
// vssapi.lib, that can be downloaded from the Microsoft website
// [*.microsoft.com], and to distribute the linked executables under the
// terms of the "Box Backup GPL" license.
// --------------------------------------------------------------------------
//
// File
//		Name:    BackupClientMakeExcludeList.cpp
//		Purpose: Makes exclude lists from bbbackupd config location entries
//		Created: 28/1/04
//
// --------------------------------------------------------------------------

#include "Box.h"

#include "BackupClientMakeExcludeList.h"
#include "Configuration.h"
#include "ExcludeList.h"

#include "MemLeakFindOn.h"


// --------------------------------------------------------------------------
//
// Function
//		Name:    BackupClientMakeExcludeList(const Configuration &, const char *, const char *)
//		Purpose: Given a Configuration object corresponding to a bbackupd Location, and the
//				 two names of the keys for definite and regex entries, return a ExcludeList.
//				 Or 0 if it isn't required.
//		Created: 28/1/04
//
// --------------------------------------------------------------------------
ExcludeList *BackupClientMakeExcludeList(const Configuration &rConfig, const char *DefiniteName, const char *RegexName,
	const char *AlwaysIncludeDefiniteName, const char *AlwaysIncludeRegexName)
{
	// Check that at least one of the entries exists
	if(!rConfig.KeyExists(DefiniteName) && !rConfig.KeyExists(RegexName))
	{
		// Neither exists -- return 0 as an Exclude list isn't required.
		return 0;
	}
	
	// Create the exclude list
	ExcludeList *pexclude = new ExcludeList;

	try
	{
		// Definite names to add?
		if(rConfig.KeyExists(DefiniteName))
		{
			pexclude->AddDefiniteEntries(rConfig.GetKeyValue(DefiniteName));
		}
		// Regular expressions to add?
		if(rConfig.KeyExists(RegexName))
		{
			pexclude->AddRegexEntries(rConfig.GetKeyValue(RegexName));
		}
		
		// Add a "always include" list?
		if(AlwaysIncludeDefiniteName != 0 && AlwaysIncludeRegexName != 0)
		{
			// This will accept NULL as a valid argument, so safe to do this.
			pexclude->SetAlwaysIncludeList(
					BackupClientMakeExcludeList(rConfig, AlwaysIncludeDefiniteName, AlwaysIncludeRegexName)
				);
		}
	}
	catch(...)
	{
		// Clean up
		delete pexclude;
		throw;
	}

	return pexclude;
}



