//
// Tizen C++ SDK
// Copyright (c) 2012-2013 Samsung Electronics Co., Ltd.
//
// Licensed under the Flora License, Version 1.1 (the License);
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://floralicense.org/license/
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an AS IS BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

#ifndef _GLES_CUBE11_H_
#define _BOX2D_TESTBED_H_

#include <new>
#include <FBase.h>
#include <FGraphics.h>
#include <FApp.h>
#include <FGraphicsOpengl.h>
#include <FSystem.h>
#include <FUi.h>

#include "Test.h"

class Box2dTestBed
	: public Tizen::App::Application
	, public Tizen::Base::Runtime::ITimerEventListener
	, public Tizen::Ui::IKeyEventListener
	, public Tizen::Ui::ITouchEventListener
	, public Tizen::Ui::IActionEventListener
{
public:
	static Tizen::App::Application* CreateInstance(void);

	Box2dTestBed(void);
	~Box2dTestBed(void);

	virtual bool OnAppInitializing(Tizen::App::AppRegistry& appRegistry);
	virtual bool OnAppTerminating(Tizen::App::AppRegistry& appRegistry, bool forcedTermination = false);
	virtual void OnForeground(void);
	virtual void OnBackground(void);
	virtual void OnLowMemory(void);
	virtual void OnBatteryLevelChanged(Tizen::System::BatteryLevel batteryLevel);

	virtual void OnTimerExpired(Tizen::Base::Runtime::Timer& timer);

	virtual void OnKeyPressed(const Tizen::Ui::Control& source, Tizen::Ui::KeyCode keyCode);
	virtual void OnKeyReleased(const Tizen::Ui::Control& source, Tizen::Ui::KeyCode keyCode);
	virtual void OnKeyLongPressed(const Tizen::Ui::Control& source, Tizen::Ui::KeyCode keyCode);

	virtual void OnTouchCanceled (const Tizen::Ui::Control &source, const Tizen::Graphics::Point &currentPosition, const Tizen::Ui::TouchEventInfo &touchInfo);
	virtual void OnTouchFocusIn (const Tizen::Ui::Control &source, const Tizen::Graphics::Point &currentPosition, const Tizen::Ui::TouchEventInfo &touchInfo);
	virtual void OnTouchFocusOut (const Tizen::Ui::Control &source, const Tizen::Graphics::Point &currentPosition, const Tizen::Ui::TouchEventInfo &touchInfo);
	virtual void OnTouchMoved (const Tizen::Ui::Control &source, const Tizen::Graphics::Point &currentPosition, const Tizen::Ui::TouchEventInfo &touchInfo);
	virtual void OnTouchPressed (const Tizen::Ui::Control &source, const Tizen::Graphics::Point &currentPosition, const Tizen::Ui::TouchEventInfo &touchInfo);
	virtual void OnTouchReleased (const Tizen::Ui::Control &source, const Tizen::Graphics::Point &currentPosition, const Tizen::Ui::TouchEventInfo &touchInfo);

	virtual void OnActionPerformed(const Tizen::Ui::Control& source, int actionId);

	bool Draw(void);

	void DrawString(Tizen::Base::String text);

private:
	bool InitEGL(void);
	bool InitGL(void);
	void Cleanup(void);
	void DestroyGL(void);

	void SetTest(int number);
	b2Vec2 ConvertScreenToWorld(int32 x, int32 y);
	void Resize(void);
	void UICreating(void);

private:
	Tizen::Graphics::Opengl::EGLDisplay __eglDisplay;
	Tizen::Graphics::Opengl::EGLSurface __eglSurface;
	Tizen::Graphics::Opengl::EGLConfig  __eglConfig;
	Tizen::Graphics::Opengl::EGLContext __eglContext;

	Tizen::Base::Runtime::Timer*        __pTimer;

	Tizen::Ui::Controls::Form*          __pForm;
	Tizen::Ui::Controls::Label* 		__pTestTitle;
	Tizen::Ui::Controls::Label* 		__pFPSLabel;
	Tizen::Ui::Controls::Label* 		__pHelpLabel;
	// Keyboard
	Tizen::Ui::Controls::Panel* 		__pKeyboardPanel;

	static const int ID_PREV_BUTTON  = 101;
	static const int ID_RESET_BUTTON  = 102;
	static const int ID_NEXT_BUTTON  = 103;
	static const int ID_PAUSE_BUTTON  = 104;
	static const int ID_EXIT_BUTTON  = 105;
	static const int ID_FUNC_BUTTON  = 106;
	static const int ID_BOMB_BUTTON  = 107;
	static const int ID_ZOOM_PLUS_BUTTON  = 108;
	static const int ID_ZOOM_MINUS_BUTTON  = 109;

	static const int ID_KEYBOARD  = 200;

	static const int ID_Q_OPTION  = 201;
	static const int ID_W_OPTION  = 202;
	static const int ID_E_OPTION  = 203;
	static const int ID_P_OPTION  = 204;
	static const int ID_A_OPTION  = 205;
	static const int ID_S_OPTION  = 206;
	static const int ID_D_OPTION  = 207;
	static const int ID_F_OPTION  = 208;
	static const int ID_J_OPTION  = 209;
	static const int ID_K_OPTION  = 210;
	static const int ID_L_OPTION  = 211;
	static const int ID_B_OPTION  = 212;
	static const int ID_C_OPTION  = 213;
	static const int ID_M_OPTION  = 214;

	static const int T_WIDTH = 1280;
	static const int T_HEIGHT = 720;

	Tizen::Base::String __hints;

	int 		__prevX;
	int 		__prevY;
	int 		__testNumber;
	bool 		__isBodyAtPoint;
	bool 		__pinballArmsUp;
	Test* 		__pTest;
	float32 	__viewZoom;
	Settings 	__settings;
};

#endif
