/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import java.io.IOException;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPSearchResponse
implements JDAPProtocolOp {
    protected String m_object_name = null;
    protected BERElement m_element = null;
    protected LDAPAttribute[] m_attributes = null;

    public JDAPSearchResponse(BERElement bERElement) throws IOException {
        this.m_element = bERElement;
        BERTag bERTag = (BERTag)bERElement;
        BERSequence bERSequence = (BERSequence)bERTag.getValue();
        BEROctetString bEROctetString = (BEROctetString)bERSequence.elementAt(0);
        byte[] byArray = null;
        byArray = bEROctetString.getValue();
        if (byArray == null) {
            this.m_object_name = null;
        } else {
            try {
                this.m_object_name = new String(byArray, "UTF8");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        BERSequence bERSequence2 = (BERSequence)bERSequence.elementAt(1);
        if (bERSequence2.size() > 0) {
            this.m_attributes = new LDAPAttribute[bERSequence2.size()];
            for (int i = 0; i < bERSequence2.size(); ++i) {
                this.m_attributes[i] = new LDAPAttribute(bERSequence2.elementAt(i));
            }
        }
    }

    public BERElement getBERElement() {
        return this.m_element;
    }

    public String getObjectName() {
        return this.m_object_name;
    }

    public LDAPAttribute[] getAttributes() {
        return this.m_attributes;
    }

    public int getType() {
        return 4;
    }

    public String toString() {
        String string = "";
        if (this.m_attributes != null) {
            for (int i = 0; i < this.m_attributes.length; ++i) {
                if (i != 0) {
                    string = string + ",";
                }
                string = string + this.m_attributes[i].toString();
            }
        }
        return "SearchResponse {entry='" + this.m_object_name + "', attributes='" + string + "'}";
    }
}

