/*-*- mode:c;indent-tabs-mode:nil;c-basic-offset:2;tab-width:8;coding:utf-8 -*-│
│ vi: set et ft=c ts=2 sts=2 sw=2 fenc=utf-8                               :vi │
╞══════════════════════════════════════════════════════════════════════════════╡
│ Copyright 2022 Justine Alexandra Roberts Tunney                              │
│                                                                              │
│ Permission to use, copy, modify, and/or distribute this software for         │
│ any purpose with or without fee is hereby granted, provided that the         │
│ above copyright notice and this permission notice appear in all copies.      │
│                                                                              │
│ THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL                │
│ WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED                │
│ WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE             │
│ AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL         │
│ DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR        │
│ PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER               │
│ TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR             │
│ PERFORMANCE OF THIS SOFTWARE.                                                │
╚─────────────────────────────────────────────────────────────────────────────*/
#include <errno.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "blink/assert.h"
#include "blink/log.h"
#include "blink/thread.h"
#include "blink/tunables.h"

static int g_errfd;

int WriteErrorString(const char *buf) {
  return WriteError(0, buf, strlen(buf));
}

int WriteError(int fd, const char *buf, int len) {
  int rc, cs;
#ifdef HAVE_PTHREAD_SETCANCELSTATE
  unassert(!pthread_setcancelstate(PTHREAD_CANCEL_DISABLE, &cs));
#endif
  do rc = write(fd > 0 ? fd : g_errfd, buf, len);
  while (rc == -1 && errno == EINTR);
#ifdef HAVE_PTHREAD_SETCANCELSTATE
  unassert(!pthread_setcancelstate(cs, 0));
#endif
  return rc;
}

void WriteErrorInit(void) {
  if (g_errfd) return;
  g_errfd = fcntl(2, F_DUPFD_CLOEXEC, kMinBlinkFd);
  if (g_errfd == -1) exit(200);
}
