/*-*- mode:c;indent-tabs-mode:nil;c-basic-offset:2;tab-width:8;coding:utf-8 -*-│
│vi: set net ft=c ts=2 sts=2 sw=2 fenc=utf-8                                :vi│
╞══════════════════════════════════════════════════════════════════════════════╡
│ Copyright 2023 Justine Alexandra Roberts Tunney                              │
│                                                                              │
│ Permission to use, copy, modify, and/or distribute this software for         │
│ any purpose with or without fee is hereby granted, provided that the         │
│ above copyright notice and this permission notice appear in all copies.      │
│                                                                              │
│ THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL                │
│ WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED                │
│ WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE             │
│ AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL         │
│ DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR        │
│ PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER               │
│ TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR             │
│ PERFORMANCE OF THIS SOFTWARE.                                                │
╚─────────────────────────────────────────────────────────────────────────────*/
#include <stdlib.h>
#include <string.h>

#include "blink/fspath.h"

char *JoinPath(const char *x, const char *y) {
  char *z, *p;
  size_t n, m;
  if (!y || !*y) {
    return x ? strdup(x) : 0;
  }
  if (!x || !*x || *y == '/' || (*x == '.' && !x[1])) {
    return strdup(y);
  }
  n = strlen(x);
  m = strlen(y);
  if (!(z = (char *)malloc(n + 1 + m + 1))) return 0;
  memcpy(z, x, n);
  p = z + n;
  if (x[n - 1] != '/') {
    *p++ = '/';
  }
  memcpy(p, y, m + 1);
  return z;
}

char *ExpandUser(const char *path) {
  const char *home;
  if (*path == '~' && (home = getenv("HOME"))) {
    return JoinPath(home, path);
  } else {
    return strdup(path);
  }
}
