/*
			(c) Copyright 1998-2000 - Tord Jansson
			======================================

		This file is part of the BladeEnc MP3 Encoder, based on
		ISO's reference code for MPEG Layer 3 compression, and might
		contain smaller or larger sections that are directly taken
		from ISO's reference code.

		All changes to the ISO reference code herein are either
		copyrighted by Tord Jansson (tord.jansson@swipnet.se)
		or sublicensed to Tord Jansson by a third party.

	BladeEnc is free software; you can redistribute this file
	and/or modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.



	------------    Changes    ------------

	2000-11-06  Andre Piotrowski

	-	speed up: (for 'encode.c') traversed 'enwindow[]' needed for 'WIND_SB_CHANGE_LEVEL 3'
*/

#include	"tables.h"
#include	"huffman.h"




/*	========================================================================================  */
/*      L3 parameter tables                                                                   */
/*	========================================================================================  */





#if NEW_L3PARM_TABLES

l3_parm_block			l3_parm[3] =
{

	{	/* sfreq_idx_44100 */

		{	/* psy_longBlock_44100_62 */

			63, /* cbmax_l */

			{	/* numlines_l */
				  1,  1,  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  1,  2,  2,  2,
				  2,  2,  2,  2,  2,  2,  2,  2,  2,
				  2,  3,  3,  3,  3,  3,  3,  3,  4,
				  4,  4,  5,  5,  5,  6,  6,  7,  7,
				  7,  9,  9,  9, 10, 10, 11, 14, 14,
				 15, 20, 20, 21, 27, 27, 36, 73, 18
			},
			{	/* minval */
				 24.5, 24.5, 24.5, 24.5, 24.5, 20.0, 20.0, 20.0, 20.0,
				 20.0, 20.0, 20.0, 18.0, 18.0, 18.0, 12.0,  6.0,  6.0,
				  3.0,  3.0,  3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0
			},
			{	/* qthr_l */
				   4.532,   4.532,   4.532,   0.904,   0.904,   0.090,   0.090,   0.029,   0.029,
				   0.029,   0.009,   0.009,   0.009,   0.009,   0.009,   0.018,   0.018,   0.018,
				   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,
				   0.018,   0.027,   0.027,   0.027,   0.027,   0.027,   0.027,   0.027,   0.036,
				   0.036,   0.036,   0.045,   0.045,   0.045,   0.054,   0.054,   0.063,   0.063,
				   0.063,   0.081,   0.081,   0.081,   0.180,   0.180,   0.198,   0.400,   0.400,
				   0.429,   1.808,   1.808,   1.898,  24.416,  24.416,  32.554, 660.124, 162.770
			},

#if !CALC_NORM   /* do we compute more exact values? */
			{	/* norm_l */
				 0.951, 0.700, 0.681, 0.675, 0.667, 0.665, 0.664, 0.664, 0.664,
				 0.655, 0.616, 0.597, 0.578, 0.541, 0.575, 0.856, 0.846, 0.840,
				 0.822, 0.800, 0.753, 0.704, 0.674, 0.640, 0.609, 0.566, 0.535,
				 0.531, 0.615, 0.686, 0.650, 0.612, 0.567, 0.520, 0.513, 0.557,
				 0.584, 0.570, 0.579, 0.585, 0.548, 0.536, 0.550, 0.532, 0.504,
				 0.496, 0.517, 0.527, 0.516, 0.497, 0.489, 0.502, 0.501, 0.491,
				 0.497, 0.504, 0.504, 0.495, 0.486, 0.484, 0.483, 0.475, 0.515
			},
#endif
			{	/* bval_l */
				  0.000,  0.431,  0.861,  1.292,  1.723,  2.153,  2.584,  3.015,  3.445,
				  3.876,  4.279,  4.670,  5.057,  5.416,  5.774,  6.422,  7.026,  7.609,
				  8.168,  8.710,  9.207,  9.662, 10.099, 10.515, 10.917, 11.293, 11.652,
				 11.997, 12.394, 12.850, 13.277, 13.681, 14.062, 14.411, 14.751, 15.119,
				 15.508, 15.883, 16.263, 16.654, 17.020, 17.374, 17.744, 18.104, 18.447,
				 18.782, 19.130, 19.487, 19.838, 20.179, 20.510, 20.852, 21.196, 21.531,
				 21.870, 22.214, 22.558, 22.898, 23.232, 23.564, 23.897, 24.229, 24.442 
			}

		},

		{	/* psy_shortBlock_44100_38 */

			39, /* cbmax_s */

			{	/* numlines_s */
				  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  2,  2,
				  2,  2,  2,  2,  3,  3,  3,
				  3,  3,  4,  4,  5,  5,  5,
				  7,  7,  7, 19,  0,  0,  0
			},
			{	/* qthr_s */
				   4.532,   0.904,   0.029,   0.009,   0.009,   0.009,   0.009,
				   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,
				   0.009,   0.009,   0.009,   0.009,   0.009,   0.018,   0.018,
				   0.018,   0.018,   0.018,   0.018,   0.027,   0.027,   0.054,
				   0.054,   0.054,   0.114,   0.114,   0.452,   0.452,   0.452,
				   6.330,   6.330,   6.330, 171.813,   0.000,   0.000,   0.000
			},
#if !CALC_NORM   /* do we compute more exact values? */
			{	/* norm_s */
				 1.000, 0.983, 0.983, 0.982, 0.985, 0.983, 0.978,
				 0.967, 0.948, 0.930, 0.914, 0.870, 0.845, 0.800,
				 0.749, 0.701, 0.653, 0.590, 0.616, 0.860, 0.823,
				 0.762, 0.688, 0.612, 0.594, 0.658, 0.706, 0.660,
				 0.606, 0.565, 0.560, 0.579, 0.567, 0.534, 0.514,
				 0.520, 0.518, 0.507, 0.447, 0.000, 0.000, 0.000
			},
#endif
			{	/* SNR_s */
				 -8.240, -8.240, -8.240, -8.240, -8.240, -8.240, -8.240,
				 -8.240, -8.240, -8.240, -7.447, -7.447, -7.447, -7.447,
				 -7.447, -7.447, -7.447, -7.447, -7.447, -7.447, -6.990,
				 -6.990, -6.990, -6.990, -6.990, -6.990, -6.990, -6.990,
				 -6.990, -6.990, -6.020, -6.020, -6.020, -6.020, -5.229,
				 -5.229, -5.229, -5.229, -4.559,  0.000,  0.000,  0.000
			},
			{	/* bval_s */
				  0.000,  1.723,  3.445,  5.057,  6.422,  7.609,  8.710,
				  9.662, 10.515, 11.293, 12.009, 12.625, 13.210, 13.748,
				 14.241, 14.695, 15.125, 15.508, 15.891, 16.537, 17.112,
				 17.621, 18.073, 18.470, 18.849, 19.271, 19.741, 20.177,
				 20.576, 20.950, 21.316, 21.699, 22.078, 22.438, 22.782,
				 23.133, 23.484, 23.828, 24.173,  0.000,  0.000,  0.000
			}

		},

		{	/* psy_data3_44100_20 */

			{	/* cbw_l */
				  3,  3,  4,  3,  3,  1,  3,
				  3,  3,  3,  3,  3,  4,  3,
				  3,  3,  3,  3,  2,  2,  2
			},
			{	/* bu_l */
				  0,  4,  7, 11, 14, 17, 18,
				 21, 24, 27, 30, 33, 36, 40,
				 43, 46, 49, 52, 55, 57, 59
			},
			{	/* bo_l */
				  4,  7, 11, 14, 17, 18, 21,
				 24, 27, 30, 33, 36, 40, 43,
				 46, 49, 52, 55, 57, 59, 61
			},
			{	/* w1_l */
				 1.000, 0.944, 0.389, 0.833, 0.278, 0.861, 0.083,
				 0.417, 0.750, 0.194, 0.426, 0.463, 0.180, 0.900,
				 0.532, 0.376, 0.550, 0.448, 0.597, 0.357, 0.278
			},
			{	/* w2_l */
				 0.056, 0.611, 0.167, 0.722, 0.139, 0.917, 0.583,
				 0.250, 0.805, 0.574, 0.537, 0.819, 0.100, 0.468,
				 0.623, 0.450, 0.552, 0.403, 0.643, 0.722, 0.960
			}

		},

		{	/* psy_data4_44100_11 */

			{	/* cbw_s */
				  2,  2,  3,  3,  4,  5,
				  3,  4,  3,  3,  3,  2
			},
			{	/* bu_s */
				  0,  3,  5,  8, 11, 15,
				 20, 23, 27, 30, 33, 36
			},
			{	/* bo_s */
				  2,  5,  8, 11, 15, 20,
				 23, 27, 30, 33, 36, 38
			},
			{	/* w1_s */
				 1.000, 0.833, 0.167, 0.500, 0.833, 0.833,
				 0.750, 0.417, 0.944, 0.625, 0.700, 0.833
			},
			{	/* w2_s */
				 0.167, 0.833, 0.500, 0.167, 0.167, 0.250,
				 0.583, 0.055, 0.375, 0.300, 0.167, 1.000
			}

		}

	},

	{	/* sfreq_idx_48000 */

		{	/* psy_longBlock_48000_61 */

			62, /* cbmax_l */

			{	/* numlines_l */
				  1,  1,  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  1,  1,  2,  2,
				  2,  2,  2,  2,  2,  2,  2,  2,  2,
				  2,  2,  3,  3,  3,  3,  3,  4,  4,
				  4,  4,  4,  5,  5,  5,  6,  7,  7,
				  8,  8,  8, 10, 10, 10, 13, 13, 14,
				 18, 18, 20, 25, 25, 35, 67, 67,  0
			},
			{	/* minval */
				 24.5, 24.5, 24.5, 24.5, 24.5, 20.0, 20.0, 20.0, 20.0,
				 20.0, 20.0, 18.0, 18.0, 18.0, 12.0, 12.0,  6.0,  6.0,
				  3.0,  3.0,  3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0
			},
			{	/* qthr_l */
				   4.532,   4.532,   4.532,   0.904,   0.904,   0.090,   0.090,   0.029,   0.029,
				   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,   0.018,   0.018,
				   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,
				   0.018,   0.018,   0.027,   0.027,   0.027,   0.027,   0.027,   0.036,   0.036,
				   0.036,   0.036,   0.036,   0.045,   0.045,   0.045,   0.054,   0.063,   0.063,
				   0.072,   0.072,   0.072,   0.180,   0.180,   0.180,   0.372,   0.372,   0.400,
				   1.627,   1.627,   1.808,  22.607,  22.607,  31.650, 605.867, 605.867,   0.000
			},
#if !CALC_NORM   /* do we compute more exact values? */
			{	/* norm_l */
				 0.970, 0.755, 0.738, 0.730, 0.724, 0.723, 0.723, 0.723, 0.718,
				 0.690, 0.660, 0.641, 0.600, 0.584, 0.532, 0.537, 0.857, 0.858,
				 0.853, 0.824, 0.778, 0.740, 0.709, 0.676, 0.632, 0.592, 0.553,
				 0.510, 0.513, 0.608, 0.673, 0.637, 0.586, 0.571, 0.616, 0.640,
				 0.598, 0.538, 0.512, 0.528, 0.517, 0.493, 0.499, 0.525, 0.541,
				 0.528, 0.510, 0.506, 0.525, 0.536, 0.518, 0.501, 0.497, 0.497,
				 0.495, 0.494, 0.497, 0.494, 0.487, 0.483, 0.482, 0.524, 0.000
			},
#endif
			{	/* bval_l */
				  0.000,  0.469,  0.938,  1.406,  1.875,  2.344,  2.813,  3.281,  3.750,
				  4.199,  4.625,  5.047,  5.438,  5.828,  6.188,  6.522,  7.174,  7.801,
				  8.402,  8.966,  9.484,  9.966, 10.426, 10.866, 11.279, 11.669, 12.042,
				 12.386, 12.721, 13.115, 13.562, 13.984, 14.371, 14.741, 15.140, 15.563,
				 15.962, 16.324, 16.665, 17.020, 17.373, 17.708, 18.045, 18.398, 18.762,
				 19.120, 19.466, 19.807, 20.159, 20.522, 20.874, 21.214, 21.553, 21.892,
				 22.231, 22.569, 22.909, 23.248, 23.583, 23.915, 24.246, 24.576,  0.000
			}

		},

		{	/* psy_shortBlock_48000_37 */

			38, /* cbmax_s */

			{	/* numlines_s */
				  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  2,  2,
				  2,  2,  2,  2,  2,  3,  3,
				  3,  4,  4,  5,  5,  5,  7,
				  7, 11, 17,  0,  0,  0,  0
			},
			{	/* qthr_s */
				   4.532,   0.904,   0.029,   0.009,   0.009,   0.009,   0.009,
				   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,
				   0.009,   0.009,   0.009,   0.009,   0.009,   0.018,   0.018,
				   0.018,   0.018,   0.018,   0.018,   0.018,   0.054,   0.054,
				   0.054,   0.114,   0.114,   0.452,   0.452,   0.452,   6.330,
				   6.330,   9.947, 153.727,   0.000,   0.000,   0.000,   0.000
			},
#if !CALC_NORM   /* do we compute more exact values? */
			{	/* norm_s */
				 1.000, 0.989, 0.989, 0.981, 0.985, 0.984, 0.980,
				 0.968, 0.954, 0.929, 0.906, 0.883, 0.844, 0.792,
				 0.747, 0.689, 0.644, 0.592, 0.553, 0.850, 0.811,
				 0.736, 0.665, 0.610, 0.544, 0.528, 0.621, 0.673,
				 0.635, 0.626, 0.636, 0.615, 0.579, 0.551, 0.552,
				 0.559, 0.528, 0.479, 0.000, 0.000, 0.000, 0.000
			},
#endif
			{	/* SNR_s */
				 -8.240, -8.240, -8.240, -8.240, -8.240, -8.240, -8.240,
				 -8.240, -8.240, -8.240, -7.447, -7.447, -7.447, -7.447,
				 -7.447, -7.447, -7.447, -7.447, -7.447, -7.447, -6.990,
				 -6.990, -6.990, -6.990, -6.990, -6.990, -6.990, -6.990,
				 -6.990, -6.990, -6.020, -6.020, -6.020, -6.020, -5.229,
				 -5.229, -5.229, -5.229,  0.000,  0.000,  0.000,  0.000
			},
			{	/* bval_s */
				  0.000,  1.875,  3.750,  5.438,  6.857,  8.109,  9.237,
				 10.202, 11.083, 11.865, 12.554, 13.195, 13.781, 14.309,
				 14.803, 15.250, 15.667, 16.068, 16.409, 17.045, 17.607,
				 18.097, 18.528, 18.931, 19.295, 19.636, 20.038, 20.486,
				 20.900, 21.306, 21.722, 22.128, 22.513, 22.877, 23.241,
				 23.616, 23.974, 24.313,  0.000,  0.000,  0.000,  0.000
			}

		},

		{	/* psy_data3_48000_20 */

			{	/* cbw_l */
				  3,  3,  4,  3,  3,  2,  3,
				  2,  3,  3,  3,  3,  4,  3,
				  3,  3,  3,  2,  3,  2,  1
			},
			{	/* bu_l */
				  0,  4,  7, 11, 14, 17, 19,
				 22, 24, 27, 30, 33, 36, 40,
				 43, 46, 49, 52, 54, 57, 59
			},
			{	/* bo_l */
				  4,  7, 11, 14, 17, 19, 22,
				 24, 27, 30, 33, 36, 40, 43,
				 46, 49, 52, 54, 57, 59, 60
			},
			{	/* w1_l */
				 1.000, 0.944, 0.389, 0.833, 0.278, 0.361, 0.583,
				 0.917, 0.250, 0.583, 0.352, 0.389, 0.375, 0.856,
				 0.611, 0.840, 0.783, 0.816, 0.114, 0.687, 0.548
			},
			{	/* w2_l */
				 0.056, 0.611, 0.167, 0.722, 0.639, 0.417, 0.083,
				 0.750, 0.417, 0.648, 0.611, 0.625, 0.144, 0.389,
				 0.160, 0.217, 0.184, 0.886, 0.313, 0.452, 0.908
			}

		},

		{	/* psy_data4_48000_11 */

			{	/* cbw_s */
				  2,  2,  3,  3,  4,  4,
				  3,  4,  4,  2,  3,  2
			},
			{	/* bu_s */
				  0,  3,  5,  8, 11, 15,
				 19, 22, 26, 30, 32, 35
			},
			{	/* bo_s */
				  2,  5,  8, 11, 15, 19,
				 22, 26, 30, 32, 35, 37
			},
			{	/* w1_s */
				 1.000, 0.833, 0.167, 0.500, 0.833, 0.833,
				 0.417, 0.083, 0.055, 0.958, 0.433, 0.833
			},
			{	/* w2_s */
				 0.167, 0.833, 0.500, 0.167, 0.167, 0.583,
				 0.917, 0.944, 0.042, 0.567, 0.167, 0.618
			}

		}

	},

	{	/* sfreq_idx_32000 */

		{	/* psy_longBlock_32000_58 */

			59, /* cbmax_l */

			{	/* numlines_l */
				  2,  2,  2,  2,  2,  2,  2,  2,  2,
				  2,  2,  2,  2,  2,  2,  2,  2,  2,
				  3,  3,  3,  3,  3,  3,  3,  3,  3,
				  4,  4,  4,  5,  5,  5,  5,  5,  6,
				  6,  6,  8,  8,  8, 10, 10, 10, 12,
				 12, 13, 14, 14, 16, 20, 20, 23, 27,
				 27, 32, 37, 37, 12,  0,  0,  0,  0
			},
			{	/* minval */
				 24.5, 24.5, 24.5, 20.0, 20.0, 20.0, 20.0, 20.0, 18.0,
				 18.0, 12.0, 12.0,  6.0,  6.0,  6.0,  3.0,  3.0,  3.0,
				  3.0,  3.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
				  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0
			},
			{	/* qthr_l */
				   4.532,   4.532,   1.809,   0.181,   0.181,   0.057,   0.018,   0.018,   0.018,
				   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,
				   0.027,   0.027,   0.027,   0.027,   0.027,   0.027,   0.027,   0.027,   0.027,
				   0.036,   0.036,   0.036,   0.045,   0.045,   0.045,   0.045,   0.045,   0.054,
				   0.054,   0.054,   0.072,   0.072,   0.072,   0.090,   0.090,   0.090,   0.109,
				   0.109,   0.118,   0.252,   0.252,   0.288,   0.572,   0.572,   0.658,   2.441,
				   2.441,   2.893,  33.458,  33.458,  10.851,   0.000,   0.000,   0.000,   0.000
			},
#if !CALC_NORM   /* do we compute more exact values? */
			{	/* norm_l */
				 0.997, 0.893, 0.881, 0.873, 0.872, 0.871, 0.860, 0.839, 0.812,
				 0.784, 0.741, 0.697, 0.674, 0.651, 0.633, 0.611, 0.589, 0.575,
				 0.654, 0.724, 0.701, 0.673, 0.631, 0.592, 0.553, 0.510, 0.506,
				 0.562, 0.598, 0.589, 0.607, 0.620, 0.580, 0.532, 0.517, 0.517,
				 0.509, 0.506, 0.522, 0.531, 0.519, 0.512, 0.509, 0.498, 0.494,
				 0.501, 0.508, 0.502, 0.493, 0.497, 0.506, 0.510, 0.504, 0.496,
				 0.493, 0.490, 0.482, 0.458, 0.500, 0.000, 0.000, 0.000, 0.000
			},
#endif
			{	/* bval_l */
				  0.313,  0.938,  1.563,  2.188,  2.813,  3.438,  4.045,  4.625,  5.173,
				  5.698,  6.185,  6.634,  7.070,  7.492,  7.905,  8.305,  8.695,  9.064,
				  9.484,  9.966, 10.426, 10.866, 11.279, 11.669, 12.042, 12.386, 12.721,
				 13.091, 13.488, 13.873, 14.268, 14.679, 15.067, 15.424, 15.771, 16.120,
				 16.466, 16.807, 17.158, 17.518, 17.869, 18.215, 18.563, 18.902, 19.239,
				 19.580, 19.925, 20.269, 20.606, 20.944, 21.288, 21.635, 21.980, 22.319,
				 22.656, 22.993, 23.326, 23.656, 23.937,  0.000,  0.000,  0.000,  0.000
			}

		},

		{	/* psy_shortBlock_32000_41 */

			42, /* cbmax_s */

			{	/* numlines_s */
				  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  1,  1,
				  1,  1,  1,  1,  1,  2,  2,
				  2,  2,  2,  2,  2,  2,  3,
				  3,  3,  3,  3,  4,  4,  4,
				  5,  5,  6,  7,  7,  8, 10
			},
			{	/* qthr_s */
				   4.532,   0.904,   0.090,   0.029,   0.009,   0.009,   0.009,
				   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,   0.009,
				   0.009,   0.009,   0.009,   0.009,   0.009,   0.018,   0.018,
				   0.018,   0.018,   0.018,   0.018,   0.018,   0.018,   0.027,
				   0.027,   0.027,   0.027,   0.027,   0.072,   0.072,   0.072,
				   0.143,   0.143,   0.172,   0.633,   0.633,   0.723,   9.043
			},
#if !CALC_NORM   /* do we compute more exact values? */
			{	/* norm_s */
				 1.000, 0.985, 0.983, 0.983, 0.981, 0.975, 0.959,
				 0.944, 0.933, 0.920, 0.892, 0.863, 0.839, 0.786,
				 0.755, 0.698, 0.673, 0.605, 0.629, 0.883, 0.858,
				 0.829, 0.767, 0.705, 0.637, 0.564, 0.550, 0.603,
				 0.635, 0.592, 0.533, 0.518, 0.568, 0.594, 0.568,
				 0.536, 0.522, 0.542, 0.539, 0.519, 0.514, 0.518
			},
#endif
			{	/* SNR_s */
				 -8.240, -8.240, -8.240, -8.240, -8.240, -8.240, -8.240,
				 -8.240, -8.240, -8.240, -7.447, -7.447, -7.447, -7.447,
				 -7.447, -7.447, -7.447, -7.447, -7.447, -7.447, -6.990,
				 -6.990, -6.990, -6.990, -6.990, -6.990, -6.990, -6.990,
				 -6.990, -6.990, -6.020, -6.020, -6.020, -6.020, -5.229,
				 -5.229, -5.229, -5.229, -4.559, -4.559, -3.980, -3.980
			},
			{	/* bval_s */
				  0.000,  1.250,  2.500,  3.750,  4.909,  5.958,  6.857,
				  7.700,  8.500,  9.237,  9.895, 10.500, 11.083, 11.604,
				 12.107, 12.554, 13.000, 13.391, 13.781, 14.474, 15.096,
				 15.667, 16.177, 16.636, 17.057, 17.429, 17.786, 18.177,
				 18.597, 18.994, 19.352, 19.693, 20.066, 20.462, 20.841,
				 21.201, 21.549, 21.911, 22.275, 22.625, 22.971, 23.321
			}

		},

		{	/* psy_data3_32000_20 */

			{	/* cbw_l */
				  1,  2,  2,  1,  2,  2,  3,
				  2,  3,  3,  4,  4,  4,  3,
				  4,  3,  4,  3,  3,  2,  2
			},
			{	/* bu_l */
				  0,  2,  4,  6,  7,  9, 11,
				 14, 16, 19, 22, 26, 30, 34,
				 37, 41, 44, 48, 51, 54, 56
			},
			{	/* bo_l */
				  2,  4,  6,  7,  9, 11, 14,
				 16, 19, 22, 26, 30, 34, 37,
				 41, 44, 48, 51, 54, 56, 58
			},
			{	/* w1_l */
				 1.000, 0.472, 0.694, 0.917, 0.139, 0.361, 0.583,
				 0.917, 0.250, 0.130, 0.167, 0.611, 0.522, 0.967,
				 0.083, 0.383, 0.005, 0.726, 0.519, 0.739, 0.116
			},
			{	/* w2_l */
				 0.528, 0.305, 0.083, 0.861, 0.639, 0.417, 0.083,
				 0.750, 0.870, 0.833, 0.389, 0.478, 0.033, 0.917,
				 0.617, 0.995, 0.274, 0.480, 0.261, 0.884, 1.000
			}

		},

		{	/* psy_data4_32000_11 */

			{	/* cbw_s */
				  2,  2,  3,  3,  4,  5,
				  4,  5,  4,  4,  3,  1
			},
			{	/* bu_s */
				  0,  3,  5,  8, 11, 15,
				 20, 24, 29, 33, 37, 40
			},
			{	/* bo_s */
				  2,  5,  8, 11, 15, 20,
				 24, 29, 33, 37, 40, 41
			},
			{	/* w1_s */
				 1.000, 0.833, 0.167, 0.500, 0.833, 0.833,
				 0.750, 0.750, 0.944, 0.625, 0.528, 0.062
			},
			{	/* w2_s */
				 0.167, 0.833, 0.500, 0.167, 0.167, 0.250,
				 0.250, 0.055, 0.375, 0.472, 0.937, 1.000
			}

		}

	}

};

#else   /* NEW_L3PARM_TABLES */

psyDataElem				psy_longBlock_48000_61[62] =
{
	{ 1 ,24.5 ,   4.532 ,0.970 ,   0.000 },
	{ 1 ,24.5 ,   4.532 ,0.755 ,   0.469 },
	{ 1 ,24.5 ,   4.532 ,0.738 ,   0.938 },
	{ 1 ,24.5 ,   0.904 ,0.730 ,   1.406 },
	{ 1 ,24.5 ,   0.904 ,0.724 ,   1.875 },
	{ 1 ,20.0 ,   0.090 ,0.723 ,   2.344 },
	{ 1 ,20.0 ,   0.090 ,0.723 ,   2.813 },
	{ 1 ,20.0 ,   0.029 ,0.723 ,   3.281 },
	{ 1 ,20.0 ,   0.029 ,0.718 ,   3.750 },
	{ 1 ,20.0 ,   0.009 ,0.690 ,   4.199 },
	{ 1 ,20.0 ,   0.009 ,0.660 ,   4.625 },
	{ 1 ,18.0 ,   0.009 ,0.641 ,   5.047 },
	{ 1 ,18.0 ,   0.009 ,0.600 ,   5.438 },
	{ 1 ,18.0 ,   0.009 ,0.584 ,   5.828 },
	{ 1 ,12.0 ,   0.009 ,0.532 ,   6.188 },
	{ 1 ,12.0 ,   0.009 ,0.537 ,   6.522 },
	{ 2 , 6.0 ,   0.018 ,0.857 ,   7.174 },
	{ 2 , 6.0 ,   0.018 ,0.858 ,   7.801 },
	{ 2 , 3.0 ,   0.018 ,0.853 ,   8.402 },
	{ 2 , 3.0 ,   0.018 ,0.824 ,   8.966 },
	{ 2 , 3.0 ,   0.018 ,0.778 ,   9.484 },
	{ 2 , 3.0 ,   0.018 ,0.740 ,   9.966 },
	{ 2 , 0.0 ,   0.018 ,0.709 ,  10.426 },

	{ 2 , 0.0 ,   0.018 ,0.676 ,  10.866 },
	{ 2 , 0.0 ,   0.018 ,0.632 ,  11.279 },
	{ 2 , 0.0 ,   0.018 ,0.592 ,  11.669 },
	{ 2 , 0.0 ,   0.018 ,0.553 ,  12.042 },
	{ 2 , 0.0 ,   0.018 ,0.510 ,  12.386 },
	{ 2 , 0.0 ,   0.018 ,0.513 ,  12.721 },
	{ 3 , 0.0 ,   0.027 ,0.608 ,  13.115 },
	{ 3 , 0.0 ,   0.027 ,0.673 ,  13.562 },
	{ 3 , 0.0 ,   0.027 ,0.637 ,  13.984 },
	{ 3 , 0.0 ,   0.027 ,0.586 ,  14.371 },
	{ 3 , 0.0 ,   0.027 ,0.571 ,  14.741 },
	{ 4 , 0.0 ,   0.036 ,0.616 ,  15.140 },
	{ 4 , 0.0 ,   0.036 ,0.640 ,  15.563 },
	{ 4 , 0.0 ,   0.036 ,0.598 ,  15.962 },
	{ 4 , 0.0 ,   0.036 ,0.538 ,  16.324 },
	{ 4 , 0.0 ,   0.036 ,0.512 ,  16.665 },
	{ 5 , 0.0 ,   0.045 ,0.528 ,  17.020 },
	{ 5 , 0.0 ,   0.045 ,0.517 ,  17.373 },
	{ 5 , 0.0 ,   0.045 ,0.493 ,  17.708 },
	{ 6 , 0.0 ,   0.054 ,0.499 ,  18.045 },
	{ 7 , 0.0 ,   0.063 ,0.525 ,  18.398 },
	{ 7 , 0.0 ,   0.063 ,0.541 ,  18.762 },
	{ 8 , 0.0 ,   0.072 ,0.528 ,  19.120 },
	{ 8 , 0.0 ,   0.072 ,0.510 ,  19.466 },
	{ 8 , 0.0 ,   0.072 ,0.506 ,  19.807 },
	{10 , 0.0 ,   0.180 ,0.525 ,  20.159 },
	{10 , 0.0 ,   0.180 ,0.536 ,  20.522 },
	{10 , 0.0 ,   0.180 ,0.518 ,  20.874 },
	{13 , 0.0 ,   0.372 ,0.501 ,  21.214 },
	{13 , 0.0 ,   0.372 ,0.497 ,  21.553 },
	{14 , 0.0 ,   0.400 ,0.497 ,  21.892 },
	{18 , 0.0 ,   1.627 ,0.495 ,  22.231 },
	{18 , 0.0 ,   1.627 ,0.494 ,  22.569 },
	{20 , 0.0 ,   1.808 ,0.497 ,  22.909 },
	{25 , 0.0 ,  22.607 ,0.494 ,  23.248 },
	{25 , 0.0 ,  22.607 ,0.487 ,  23.583 },
	{35 , 0.0 ,  31.650 ,0.483 ,  23.915 },
	{67 , 0.0 , 605.867 ,0.482 ,  24.246 },
	{67 , 0.0 , 605.867 ,0.524 ,  24.576 } 
};

psyDataElem				psy_longBlock_44100_62[63] =
{
	{ 1 ,24.5 ,   4.532 ,0.951 ,   0.000 },
	{ 1 ,24.5 ,   4.532 ,0.700 ,   0.431 },
	{ 1 ,24.5 ,   4.532 ,0.681 ,   0.861 },
	{ 1 ,24.5 ,   0.904 ,0.675 ,   1.292 },
	{ 1 ,24.5 ,   0.904 ,0.667 ,   1.723 },
	{ 1 ,20.0 ,   0.090 ,0.665 ,   2.153 },
	{ 1 ,20.0 ,   0.090 ,0.664 ,   2.584 },
	{ 1 ,20.0 ,   0.029 ,0.664 ,   3.015 },
	{ 1 ,20.0 ,   0.029 ,0.664 ,   3.445 },
	{ 1 ,20.0 ,   0.029 ,0.655 ,   3.876 },
	{ 1 ,20.0 ,   0.009 ,0.616 ,   4.279 },
	{ 1 ,20.0 ,   0.009 ,0.597 ,   4.670 },
	{ 1 ,18.0 ,   0.009 ,0.578 ,   5.057 },
	{ 1 ,18.0 ,   0.009 ,0.541 ,   5.416 },
	{ 1 ,18.0 ,   0.009 ,0.575 ,   5.774 },
	{ 2 ,12.0 ,   0.018 ,0.856 ,   6.422 },
	{ 2 , 6.0 ,   0.018 ,0.846 ,   7.026 },
	{ 2 , 6.0 ,   0.018 ,0.840 ,   7.609 },
	{ 2 , 3.0 ,   0.018 ,0.822 ,   8.168 },
	{ 2 , 3.0 ,   0.018 ,0.800 ,   8.710 },
	{ 2 , 3.0 ,   0.018 ,0.753 ,   9.207 },
	{ 2 , 3.0 ,   0.018 ,0.704 ,   9.662 },
	{ 2 , 0.0 ,   0.018 ,0.674 ,  10.099 },
	{ 2 , 0.0 ,   0.018 ,0.640 ,  10.515 },
	{ 2 , 0.0 ,   0.018 ,0.609 ,  10.917 },
	{ 2 , 0.0 ,   0.018 ,0.566 ,  11.293 },
	{ 2 , 0.0 ,   0.018 ,0.535 ,  11.652 },
	{ 2 , 0.0 ,   0.018 ,0.531 ,  11.997 },
	{ 3 , 0.0 ,   0.027 ,0.615 ,  12.394 },
	{ 3 , 0.0 ,   0.027 ,0.686 ,  12.850 },
	{ 3 , 0.0 ,   0.027 ,0.650 ,  13.277 },
	{ 3 , 0.0 ,   0.027 ,0.612 ,  13.681 },
	{ 3 , 0.0 ,   0.027 ,0.567 ,  14.062 },
	{ 3 , 0.0 ,   0.027 ,0.520 ,  14.411 },
	{ 3 , 0.0 ,   0.027 ,0.513 ,  14.751 },
	{ 4 , 0.0 ,   0.036 ,0.557 ,  15.119 },
	{ 4 , 0.0 ,   0.036 ,0.584 ,  15.508 },
	{ 4 , 0.0 ,   0.036 ,0.570 ,  15.883 },
	{ 5 , 0.0 ,   0.045 ,0.579 ,  16.263 },
	{ 5 , 0.0 ,   0.045 ,0.585 ,  16.654 },
	{ 5 , 0.0 ,   0.045 ,0.548 ,  17.020 },
	{ 6 , 0.0 ,   0.054 ,0.536 ,  17.374 },
	{ 6 , 0.0 ,   0.054 ,0.550 ,  17.744 },
	{ 7 , 0.0 ,   0.063 ,0.532 ,  18.104 },
	{ 7 , 0.0 ,   0.063 ,0.504 ,  18.447 },
	{ 7 , 0.0 ,   0.063 ,0.496 ,  18.782 },
	{ 9 , 0.0 ,   0.081 ,0.517 ,  19.130 },
	{ 9 , 0.0 ,   0.081 ,0.527 ,  19.487 },
	{ 9 , 0.0 ,   0.081 ,0.516 ,  19.838 },
	{10 , 0.0 ,   0.180 ,0.497 ,  20.179 },
	{10 , 0.0 ,   0.180 ,0.489 ,  20.510 },
	{11 , 0.0 ,   0.198 ,0.502 ,  20.852 },
	{14 , 0.0 ,   0.400 ,0.501 ,  21.196 },
	{14 , 0.0 ,   0.400 ,0.491 ,  21.531 },
	{15 , 0.0 ,   0.429 ,0.497 ,  21.870 },
	{20 , 0.0 ,   1.808 ,0.504 ,  22.214 },
	{20 , 0.0 ,   1.808 ,0.504 ,  22.558 },
	{21 , 0.0 ,   1.898 ,0.495 ,  22.898 },
	{27 , 0.0 ,  24.416 ,0.486 ,  23.232 },
	{27 , 0.0 ,  24.416 ,0.484 ,  23.564 },
	{36 , 0.0 ,  32.554 ,0.483 ,  23.897 },
	{73 , 0.0 , 660.124 ,0.475 ,  24.229 },
	{18 , 0.0 , 162.770 ,0.515 ,  24.442 } 
};

psyDataElem				psy_longBlock_32000_58[59] =
{
	{ 2 ,24.5 ,   4.532 ,0.997 ,   0.313 },
	{ 2 ,24.5 ,   4.532 ,0.893 ,   0.938 },
	{ 2 ,24.5 ,   1.809 ,0.881 ,   1.563 },
	{ 2 ,20.0 ,   0.181 ,0.873 ,   2.188 },
	{ 2 ,20.0 ,   0.181 ,0.872 ,   2.813 },
	{ 2 ,20.0 ,   0.057 ,0.871 ,   3.438 },
	{ 2 ,20.0 ,   0.018 ,0.860 ,   4.045 },
	{ 2 ,20.0 ,   0.018 ,0.839 ,   4.625 },
	{ 2 ,18.0 ,   0.018 ,0.812 ,   5.173 },
	{ 2 ,18.0 ,   0.018 ,0.784 ,   5.698 },
	{ 2 ,12.0 ,   0.018 ,0.741 ,   6.185 },
	{ 2 ,12.0 ,   0.018 ,0.697 ,   6.634 },
	{ 2 , 6.0 ,   0.018 ,0.674 ,   7.070 },
	{ 2 , 6.0 ,   0.018 ,0.651 ,   7.492 },
	{ 2 , 6.0 ,   0.018 ,0.633 ,   7.905 },
	{ 2 , 3.0 ,   0.018 ,0.611 ,   8.305 },
	{ 2 , 3.0 ,   0.018 ,0.589 ,   8.695 },
	{ 2 , 3.0 ,   0.018 ,0.575 ,   9.064 },
	{ 3 , 3.0 ,   0.027 ,0.654 ,   9.484 },
	{ 3 , 3.0 ,   0.027 ,0.724 ,   9.966 },
	{ 3 , 0.0 ,   0.027 ,0.701 ,  10.426 },
	{ 3 , 0.0 ,   0.027 ,0.673 ,  10.866 },
	{ 3 , 0.0 ,   0.027 ,0.631 ,  11.279 },
	{ 3 , 0.0 ,   0.027 ,0.592 ,  11.669 },
	{ 3 , 0.0 ,   0.027 ,0.553 ,  12.042 },
	{ 3 , 0.0 ,   0.027 ,0.510 ,  12.386 },
	{ 3 , 0.0 ,   0.027 ,0.506 ,  12.721 },
	{ 4 , 0.0 ,   0.036 ,0.562 ,  13.091 },
	{ 4 , 0.0 ,   0.036 ,0.598 ,  13.488 },
	{ 4 , 0.0 ,   0.036 ,0.589 ,  13.873 },
	{ 5 , 0.0 ,   0.045 ,0.607 ,  14.268 },
	{ 5 , 0.0 ,   0.045 ,0.620 ,  14.679 },
	{ 5 , 0.0 ,   0.045 ,0.580 ,  15.067 },
	{ 5 , 0.0 ,   0.045 ,0.532 ,  15.424 },
	{ 5 , 0.0 ,   0.045 ,0.517 ,  15.771 },
	{ 6 , 0.0 ,   0.054 ,0.517 ,  16.120 },
	{ 6 , 0.0 ,   0.054 ,0.509 ,  16.466 },
	{ 6 , 0.0 ,   0.054 ,0.506 ,  16.807 },
	{ 8 , 0.0 ,   0.072 ,0.522 ,  17.158 },
	{ 8 , 0.0 ,   0.072 ,0.531 ,  17.518 },
	{ 8 , 0.0 ,   0.072 ,0.519 ,  17.869 },
	{10 , 0.0 ,   0.090 ,0.512 ,  18.215 },
	{10 , 0.0 ,   0.090 ,0.509 ,  18.563 },
	{10 , 0.0 ,   0.090 ,0.498 ,  18.902 },
	{12 , 0.0 ,   0.109 ,0.494 ,  19.239 },
	{12 , 0.0 ,   0.109 ,0.501 ,  19.580 },
	{13 , 0.0 ,   0.118 ,0.508 ,  19.925 },
	{14 , 0.0 ,   0.252 ,0.502 ,  20.269 },
	{14 , 0.0 ,   0.252 ,0.493 ,  20.606 },
	{16 , 0.0 ,   0.288 ,0.497 ,  20.944 },
	{20 , 0.0 ,   0.572 ,0.506 ,  21.288 },
	{20 , 0.0 ,   0.572 ,0.510 ,  21.635 },
	{23 , 0.0 ,   0.658 ,0.504 ,  21.980 },
	{27 , 0.0 ,   2.441 ,0.496 ,  22.319 },
	{27 , 0.0 ,   2.441 ,0.493 ,  22.656 },
	{32 , 0.0 ,   2.893 ,0.490 ,  22.993 },
	{37 , 0.0 ,  33.458 ,0.482 ,  23.326 },
	{37 , 0.0 ,  33.458 ,0.458 ,  23.656 },
	{12 , 0.0 ,  10.851 ,0.500 ,  23.937 } 
};


psyDataElem2			psy_shortBlock_48000_37[38] =
{
	{ 1 ,   4.532 ,1.000 ,-8.240 ,   0.000 },
	{ 1 ,   0.904 ,0.989 ,-8.240 ,   1.875 },
	{ 1 ,   0.029 ,0.989 ,-8.240 ,   3.750 },
	{ 1 ,   0.009 ,0.981 ,-8.240 ,   5.438 },
	{ 1 ,   0.009 ,0.985 ,-8.240 ,   6.857 },
	{ 1 ,   0.009 ,0.984 ,-8.240 ,   8.109 },
	{ 1 ,   0.009 ,0.980 ,-8.240 ,   9.237 },
	{ 1 ,   0.009 ,0.968 ,-8.240 ,  10.202 },
	{ 1 ,   0.009 ,0.954 ,-8.240 ,  11.083 },
	{ 1 ,   0.009 ,0.929 ,-8.240 ,  11.865 },
	{ 1 ,   0.009 ,0.906 ,-7.447 ,  12.554 },
	{ 1 ,   0.009 ,0.883 ,-7.447 ,  13.195 },
	{ 1 ,   0.009 ,0.844 ,-7.447 ,  13.781 },
	{ 1 ,   0.009 ,0.792 ,-7.447 ,  14.309 },
	{ 1 ,   0.009 ,0.747 ,-7.447 ,  14.803 },
	{ 1 ,   0.009 ,0.689 ,-7.447 ,  15.250 },
	{ 1 ,   0.009 ,0.644 ,-7.447 ,  15.667 },
	{ 1 ,   0.009 ,0.592 ,-7.447 ,  16.068 },
	{ 1 ,   0.009 ,0.553 ,-7.447 ,  16.409 },
	{ 2 ,   0.018 ,0.850 ,-7.447 ,  17.045 },
	{ 2 ,   0.018 ,0.811 ,-6.990 ,  17.607 },
	{ 2 ,   0.018 ,0.736 ,-6.990 ,  18.097 },
	{ 2 ,   0.018 ,0.665 ,-6.990 ,  18.528 },
	{ 2 ,   0.018 ,0.610 ,-6.990 ,  18.931 },
	{ 2 ,   0.018 ,0.544 ,-6.990 ,  19.295 },
	{ 2 ,   0.018 ,0.528 ,-6.990 ,  19.636 },
	{ 3 ,   0.054 ,0.621 ,-6.990 ,  20.038 },
	{ 3 ,   0.054 ,0.673 ,-6.990 ,  20.486 },
	{ 3 ,   0.054 ,0.635 ,-6.990 ,  20.900 },
	{ 4 ,   0.114 ,0.626 ,-6.990 ,  21.306 },
	{ 4 ,   0.114 ,0.636 ,-6.020 ,  21.722 },
	{ 5 ,   0.452 ,0.615 ,-6.020 ,  22.128 },
	{ 5 ,   0.452 ,0.579 ,-6.020 ,  22.513 },
	{ 5 ,   0.452 ,0.551 ,-6.020 ,  22.877 },
	{ 7 ,   6.330 ,0.552 ,-5.229 ,  23.241 },
	{ 7 ,   6.330 ,0.559 ,-5.229 ,  23.616 },
	{11 ,   9.947 ,0.528 ,-5.229 ,  23.974 },
	{17 , 153.727 ,0.479 ,-5.229 ,  24.313 }
};

psyDataElem2			psy_shortBlock_44100_38[39] =
{
	{ 1 ,   4.532 ,1.000 ,-8.240 ,   0.000 },
	{ 1 ,   0.904 ,0.983 ,-8.240 ,   1.723 },
	{ 1 ,   0.029 ,0.983 ,-8.240 ,   3.445 },
	{ 1 ,   0.009 ,0.982 ,-8.240 ,   5.057 },
	{ 1 ,   0.009 ,0.985 ,-8.240 ,   6.422 },
	{ 1 ,   0.009 ,0.983 ,-8.240 ,   7.609 },
	{ 1 ,   0.009 ,0.978 ,-8.240 ,   8.710 },
	{ 1 ,   0.009 ,0.967 ,-8.240 ,   9.662 },
	{ 1 ,   0.009 ,0.948 ,-8.240 ,  10.515 },
	{ 1 ,   0.009 ,0.930 ,-8.240 ,  11.293 },
	{ 1 ,   0.009 ,0.914 ,-7.447 ,  12.009 },
	{ 1 ,   0.009 ,0.870 ,-7.447 ,  12.625 },
	{ 1 ,   0.009 ,0.845 ,-7.447 ,  13.210 },
	{ 1 ,   0.009 ,0.800 ,-7.447 ,  13.748 },
	{ 1 ,   0.009 ,0.749 ,-7.447 ,  14.241 },
	{ 1 ,   0.009 ,0.701 ,-7.447 ,  14.695 },
	{ 1 ,   0.009 ,0.653 ,-7.447 ,  15.125 },
	{ 1 ,   0.009 ,0.590 ,-7.447 ,  15.508 },
	{ 1 ,   0.009 ,0.616 ,-7.447 ,  15.891 },
	{ 2 ,   0.018 ,0.860 ,-7.447 ,  16.537 },
	{ 2 ,   0.018 ,0.823 ,-6.990 ,  17.112 },
	{ 2 ,   0.018 ,0.762 ,-6.990 ,  17.621 },
	{ 2 ,   0.018 ,0.688 ,-6.990 ,  18.073 },
	{ 2 ,   0.018 ,0.612 ,-6.990 ,  18.470 },
	{ 2 ,   0.018 ,0.594 ,-6.990 ,  18.849 },
	{ 3 ,   0.027 ,0.658 ,-6.990 ,  19.271 },
	{ 3 ,   0.027 ,0.706 ,-6.990 ,  19.741 },
	{ 3 ,   0.054 ,0.660 ,-6.990 ,  20.177 },
	{ 3 ,   0.054 ,0.606 ,-6.990 ,  20.576 },
	{ 3 ,   0.054 ,0.565 ,-6.990 ,  20.950 },
	{ 4 ,   0.114 ,0.560 ,-6.020 ,  21.316 },
	{ 4 ,   0.114 ,0.579 ,-6.020 ,  21.699 },
	{ 5 ,   0.452 ,0.567 ,-6.020 ,  22.078 },
	{ 5 ,   0.452 ,0.534 ,-6.020 ,  22.438 },
	{ 5 ,   0.452 ,0.514 ,-5.229 ,  22.782 },
	{ 7 ,   6.330 ,0.520 ,-5.229 ,  23.133 },
	{ 7 ,   6.330 ,0.518 ,-5.229 ,  23.484 },
	{ 7 ,   6.330 ,0.507 ,-5.229 ,  23.828 },
	{19 , 171.813 ,0.447 ,-4.559 ,  24.173 }
};

psyDataElem2			psy_shortBlock_32000_41[42] =
{
	{ 1 ,   4.532 ,1.000 ,-8.240 ,   0.000 },
	{ 1 ,   0.904 ,0.985 ,-8.240 ,   1.250 },
	{ 1 ,   0.090 ,0.983 ,-8.240 ,   2.500 },
	{ 1 ,   0.029 ,0.983 ,-8.240 ,   3.750 },
	{ 1 ,   0.009 ,0.981 ,-8.240 ,   4.909 },
	{ 1 ,   0.009 ,0.975 ,-8.240 ,   5.958 },
	{ 1 ,   0.009 ,0.959 ,-8.240 ,   6.857 },
	{ 1 ,   0.009 ,0.944 ,-8.240 ,   7.700 },
	{ 1 ,   0.009 ,0.933 ,-8.240 ,   8.500 },
	{ 1 ,   0.009 ,0.920 ,-8.240 ,   9.237 },
	{ 1 ,   0.009 ,0.892 ,-7.447 ,   9.895 },
	{ 1 ,   0.009 ,0.863 ,-7.447 ,  10.500 },
	{ 1 ,   0.009 ,0.839 ,-7.447 ,  11.083 },
	{ 1 ,   0.009 ,0.786 ,-7.447 ,  11.604 },
	{ 1 ,   0.009 ,0.755 ,-7.447 ,  12.107 },
	{ 1 ,   0.009 ,0.698 ,-7.447 ,  12.554 },
	{ 1 ,   0.009 ,0.673 ,-7.447 ,  13.000 },
	{ 1 ,   0.009 ,0.605 ,-7.447 ,  13.391 },
	{ 1 ,   0.009 ,0.629 ,-7.447 ,  13.781 },
	{ 2 ,   0.018 ,0.883 ,-7.447 ,  14.474 },
	{ 2 ,   0.018 ,0.858 ,-6.990 ,  15.096 },
	{ 2 ,   0.018 ,0.829 ,-6.990 ,  15.667 },
	{ 2 ,   0.018 ,0.767 ,-6.990 ,  16.177 },
	{ 2 ,   0.018 ,0.705 ,-6.990 ,  16.636 },
	{ 2 ,   0.018 ,0.637 ,-6.990 ,  17.057 },
	{ 2 ,   0.018 ,0.564 ,-6.990 ,  17.429 },
	{ 2 ,   0.018 ,0.550 ,-6.990 ,  17.786 },
	{ 3 ,   0.027 ,0.603 ,-6.990 ,  18.177 },
	{ 3 ,   0.027 ,0.635 ,-6.990 ,  18.597 },
	{ 3 ,   0.027 ,0.592 ,-6.990 ,  18.994 },
	{ 3 ,   0.027 ,0.533 ,-6.020 ,  19.352 },
	{ 3 ,   0.027 ,0.518 ,-6.020 ,  19.693 },
	{ 4 ,   0.072 ,0.568 ,-6.020 ,  20.066 },
	{ 4 ,   0.072 ,0.594 ,-6.020 ,  20.462 },
	{ 4 ,   0.072 ,0.568 ,-5.229 ,  20.841 },
	{ 5 ,   0.143 ,0.536 ,-5.229 ,  21.201 },
	{ 5 ,   0.143 ,0.522 ,-5.229 ,  21.549 },
	{ 6 ,   0.172 ,0.542 ,-5.229 ,  21.911 },
	{ 7 ,   0.633 ,0.539 ,-4.559 ,  22.275 },
	{ 7 ,   0.633 ,0.519 ,-4.559 ,  22.625 },
	{ 8 ,   0.723 ,0.514 ,-3.980 ,  22.971 },
	{10 ,   9.043 ,0.518 ,-3.980 ,  23.321 }
};


psyDataElem3			psy_data3_48000_20[21] =
{
	{ 3 , 0 , 4 ,1.000 ,0.056 },
	{ 3 , 4 , 7 ,0.944 ,0.611 },
	{ 4 , 7 ,11 ,0.389 ,0.167 },
	{ 3 ,11 ,14 ,0.833 ,0.722 },
	{ 3 ,14 ,17 ,0.278 ,0.639 },
	{ 2 ,17 ,19 ,0.361 ,0.417 },
	{ 3 ,19 ,22 ,0.583 ,0.083 },
	{ 2 ,22 ,24 ,0.917 ,0.750 },
	{ 3 ,24 ,27 ,0.250 ,0.417 },
	{ 3 ,27 ,30 ,0.583 ,0.648 },
	{ 3 ,30 ,33 ,0.352 ,0.611 },
	{ 3 ,33 ,36 ,0.389 ,0.625 },
	{ 4 ,36 ,40 ,0.375 ,0.144 },
	{ 3 ,40 ,43 ,0.856 ,0.389 },
	{ 3 ,43 ,46 ,0.611 ,0.160 },
	{ 3 ,46 ,49 ,0.840 ,0.217 },
	{ 3 ,49 ,52 ,0.783 ,0.184 },
	{ 2 ,52 ,54 ,0.816 ,0.886 },
	{ 3 ,54 ,57 ,0.114 ,0.313 },
	{ 2 ,57 ,59 ,0.687 ,0.452 },
	{ 1 ,59 ,60 ,0.548 ,0.908 }
};

psyDataElem3			psy_data3_44100_20[21] =
{
	{ 3 , 0 , 4 ,1.000 ,0.056 },
	{ 3 , 4 , 7 ,0.944 ,0.611 },
	{ 4 , 7 ,11 ,0.389 ,0.167 },
	{ 3 ,11 ,14 ,0.833 ,0.722 },
	{ 3 ,14 ,17 ,0.278 ,0.139 },
	{ 1 ,17 ,18 ,0.861 ,0.917 },
	{ 3 ,18 ,21 ,0.083 ,0.583 },
	{ 3 ,21 ,24 ,0.417 ,0.250 },
	{ 3 ,24 ,27 ,0.750 ,0.805 },
	{ 3 ,27 ,30 ,0.194 ,0.574 },
	{ 3 ,30 ,33 ,0.426 ,0.537 },
	{ 3 ,33 ,36 ,0.463 ,0.819 },
	{ 4 ,36 ,40 ,0.180 ,0.100 },
	{ 3 ,40 ,43 ,0.900 ,0.468 },
	{ 3 ,43 ,46 ,0.532 ,0.623 },
	{ 3 ,46 ,49 ,0.376 ,0.450 },
	{ 3 ,49 ,52 ,0.550 ,0.552 },
	{ 3 ,52 ,55 ,0.448 ,0.403 },
	{ 2 ,55 ,57 ,0.597 ,0.643 },
	{ 2 ,57 ,59 ,0.357 ,0.722 },
	{ 2 ,59 ,61 ,0.278 ,0.960 }
};

psyDataElem3			psy_data3_32000_20[21] =
{
	{ 1 , 0 , 2 ,1.000 ,0.528 },
	{ 2 , 2 , 4 ,0.472 ,0.305 },
	{ 2 , 4 , 6 ,0.694 ,0.083 },
	{ 1 , 6 , 7 ,0.917 ,0.861 },
	{ 2 , 7 , 9 ,0.139 ,0.639 },
	{ 2 , 9 ,11 ,0.361 ,0.417 },
	{ 3 ,11 ,14 ,0.583 ,0.083 },
	{ 2 ,14 ,16 ,0.917 ,0.750 },
	{ 3 ,16 ,19 ,0.250 ,0.870 },
	{ 3 ,19 ,22 ,0.130 ,0.833 },
	{ 4 ,22 ,26 ,0.167 ,0.389 },
	{ 4 ,26 ,30 ,0.611 ,0.478 },
	{ 4 ,30 ,34 ,0.522 ,0.033 },
	{ 3 ,34 ,37 ,0.967 ,0.917 },
	{ 4 ,37 ,41 ,0.083 ,0.617 },
	{ 3 ,41 ,44 ,0.383 ,0.995 },
	{ 4 ,44 ,48 ,0.005 ,0.274 },
	{ 3 ,48 ,51 ,0.726 ,0.480 },
	{ 3 ,51 ,54 ,0.519 ,0.261 },
	{ 2 ,54 ,56 ,0.739 ,0.884 },
	{ 2 ,56 ,58 ,0.116 ,1.000 }
};


psyDataElem3			psy_data4_48000_11[12] =
{
	{ 2 , 0 , 2 ,1.000 ,0.167 },
	{ 2 , 3 , 5 ,0.833 ,0.833 },
	{ 3 , 5 , 8 ,0.167 ,0.500 },
	{ 3 , 8 ,11 ,0.500 ,0.167 },
	{ 4 ,11 ,15 ,0.833 ,0.167 },
	{ 4 ,15 ,19 ,0.833 ,0.583 },
	{ 3 ,19 ,22 ,0.417 ,0.917 },
	{ 4 ,22 ,26 ,0.083 ,0.944 },
	{ 4 ,26 ,30 ,0.055 ,0.042 },
	{ 2 ,30 ,32 ,0.958 ,0.567 },
	{ 3 ,32 ,35 ,0.433 ,0.167 },
	{ 2 ,35 ,37 ,0.833 ,0.618 }
};

psyDataElem3			psy_data4_44100_11[12] =
{
	{ 2 , 0 , 2 ,1.000 ,0.167 },
	{ 2 , 3 , 5 ,0.833 ,0.833 },
	{ 3 , 5 , 8 ,0.167 ,0.500 },
	{ 3 , 8 ,11 ,0.500 ,0.167 },
	{ 4 ,11 ,15 ,0.833 ,0.167 },
	{ 5 ,15 ,20 ,0.833 ,0.250 },
	{ 3 ,20 ,23 ,0.750 ,0.583 },
	{ 4 ,23 ,27 ,0.417 ,0.055 },
	{ 3 ,27 ,30 ,0.944 ,0.375 },
	{ 3 ,30 ,33 ,0.625 ,0.300 },
	{ 3 ,33 ,36 ,0.700 ,0.167 },
	{ 2 ,36 ,38 ,0.833 ,1.000 }
};

psyDataElem3			psy_data4_32000_11[12] =
{
	{ 2 , 0 , 2 ,1.000 ,0.167 },
	{ 2 , 3 , 5 ,0.833 ,0.833 },
	{ 3 , 5 , 8 ,0.167 ,0.500 },
	{ 3 , 8 ,11 ,0.500 ,0.167 },
	{ 4 ,11 ,15 ,0.833 ,0.167 },
	{ 5 ,15 ,20 ,0.833 ,0.250 },
	{ 4 ,20 ,24 ,0.750 ,0.250 },
	{ 5 ,24 ,29 ,0.750 ,0.055 },
	{ 4 ,29 ,33 ,0.944 ,0.375 },
	{ 4 ,33 ,37 ,0.625 ,0.472 },
	{ 3 ,37 ,40 ,0.528 ,0.937 },
	{ 1 ,40 ,41 ,0.062 ,1.000 }
};

#endif   /* NEW_L3PARM_TABLES */





/*=============================================================================*/





#if 1   /* WIND_SB_CHANGE_LEVEL == 3 */

double					enwindow[512] =
{
	 0.000000000, 0.000101566, 0.000971317, 0.003134727, 0.035780907, 0.003134727, 0.000971317, 0.000101566,
	-0.000000477, 0.000103951, 0.000953674, 0.002841473, 0.035758972, 0.003401756, 0.000983715, 0.000099182,
	-0.000000477, 0.000105858, 0.000930786, 0.002521515, 0.035694122, 0.003643036, 0.000991821, 0.000096321,
	-0.000000477, 0.000107288, 0.000902653, 0.002174854, 0.035586357, 0.003858566, 0.000995159, 0.000093460,
	-0.000000477, 0.000108242, 0.000868797, 0.001800537, 0.035435200, 0.004049301, 0.000994205, 0.000090599,
	-0.000000477, 0.000108719, 0.000829220, 0.001399517, 0.035242081, 0.004215240, 0.000989437, 0.000087261,
	-0.000000477, 0.000108719, 0.000783920, 0.000971317, 0.035007000, 0.004357815, 0.000980854, 0.000083923,
	-0.000000954, 0.000108242, 0.000731945, 0.000515938, 0.034730434, 0.004477024, 0.000968933, 0.000080585,

	-0.000000954, 0.000106812, 0.000674248, 0.000033379, 0.034412861, 0.004573822, 0.000954151, 0.000076771,
	-0.000000954, 0.000105381, 0.000610352,-0.000475883, 0.034055710, 0.004649162, 0.000935555, 0.000073433,
	-0.000000954, 0.000102520, 0.000539303,-0.001011848, 0.033659935, 0.004703045, 0.000915051, 0.000070095,
	-0.000001431, 0.000099182, 0.000462532,-0.001573563, 0.033225536, 0.004737377, 0.000891685, 0.000066280,
	-0.000001431, 0.000095367, 0.000378609,-0.002161503, 0.032754898, 0.004752159, 0.000866413, 0.000062943,
	-0.000001907, 0.000090122, 0.000288486,-0.002774239, 0.032248020, 0.004748821, 0.000838757, 0.000059605,
	-0.000001907, 0.000084400, 0.000191689,-0.003411293, 0.031706810, 0.004728317, 0.000809669, 0.000055790,
	-0.000002384, 0.000077724, 0.000088215,-0.004072189, 0.031132698, 0.004691124, 0.000779152, 0.000052929,

	-0.000002384, 0.000069618,-0.000021458,-0.004756451, 0.030526638, 0.004638195, 0.000747204, 0.000049591,
	-0.000002861, 0.000060558,-0.000137329,-0.005462170, 0.029890060, 0.004570484, 0.000714302, 0.000046253,
	-0.000003338, 0.000050545,-0.000259876,-0.006189346, 0.029224873, 0.004489899, 0.000680923, 0.000043392,
	-0.000003338, 0.000039577,-0.000388145,-0.006937027, 0.028532982, 0.004395962, 0.000646591, 0.000040531,
	-0.000003815, 0.000027180,-0.000522137,-0.007703304, 0.027815342, 0.004290581, 0.000611782, 0.000037670,
	-0.000004292, 0.000013828,-0.000661850,-0.008487225, 0.027073860, 0.004174709, 0.000576973, 0.000034809,
	-0.000004768,-0.000000954,-0.000806808,-0.009287834, 0.026310921, 0.004048824, 0.000542164, 0.000032425,
	-0.000005245,-0.000017166,-0.000956535,-0.010103703, 0.025527000, 0.003914356, 0.000507355, 0.000030041,

	-0.000006199,-0.000034332,-0.001111031,-0.010933399, 0.024725437, 0.003771782, 0.000472546, 0.000027657,
	-0.000006676,-0.000052929,-0.001269817,-0.011775017, 0.023907185, 0.003622532, 0.000438213, 0.000025272,
	-0.000007629,-0.000072956,-0.001432419,-0.012627602, 0.023074150, 0.003467083, 0.000404358, 0.000023365,
	-0.000008106,-0.000093937,-0.001597881,-0.013489246, 0.022228718, 0.003306866, 0.000371456, 0.000021458,
	-0.000009060,-0.000116348,-0.001766682,-0.014358521, 0.021372318, 0.003141880, 0.000339031, 0.000019550,
	-0.000010014,-0.000140190,-0.001937389,-0.015233517, 0.020506859, 0.002974033, 0.000307560, 0.000018120,
	-0.000011444,-0.000165462,-0.002110004,-0.016112804, 0.019634247, 0.002803326, 0.000277042, 0.000016689,
	-0.000012398,-0.000191212,-0.002283096,-0.016994476, 0.018756866, 0.002630711, 0.000247478, 0.000014782,

	-0.000013828,-0.000218868,-0.002457142,-0.017876148, 0.017876148, 0.002457142, 0.000218868, 0.000013828,
	-0.000014782,-0.000247478,-0.002630711,-0.018756866, 0.016994476, 0.002283096, 0.000191212, 0.000012398,
	-0.000016689,-0.000277042,-0.002803326,-0.019634247, 0.016112804, 0.002110004, 0.000165462, 0.000011444,
	-0.000018120,-0.000307560,-0.002974033,-0.020506859, 0.015233517, 0.001937389, 0.000140190, 0.000010014,
	-0.000019550,-0.000339031,-0.003141880,-0.021372318, 0.014358521, 0.001766682, 0.000116348, 0.000009060,
	-0.000021458,-0.000371456,-0.003306866,-0.022228718, 0.013489246, 0.001597881, 0.000093937, 0.000008106,
	-0.000023365,-0.000404358,-0.003467083,-0.023074150, 0.012627602, 0.001432419, 0.000072956, 0.000007629,
	-0.000025272,-0.000438213,-0.003622532,-0.023907185, 0.011775017, 0.001269817, 0.000052929, 0.000006676,

	-0.000027657,-0.000472546,-0.003771782,-0.024725437, 0.010933399, 0.001111031, 0.000034332, 0.000006199,
	-0.000030041,-0.000507355,-0.003914356,-0.025527000, 0.010103703, 0.000956535, 0.000017166, 0.000005245,
	-0.000032425,-0.000542164,-0.004048824,-0.026310921, 0.009287834, 0.000806808, 0.000000954, 0.000004768,
	-0.000034809,-0.000576973,-0.004174709,-0.027073860, 0.008487225, 0.000661850,-0.000013828, 0.000004292,
	-0.000037670,-0.000611782,-0.004290581,-0.027815342, 0.007703304, 0.000522137,-0.000027180, 0.000003815,
	-0.000040531,-0.000646591,-0.004395962,-0.028532982, 0.006937027, 0.000388145,-0.000039577, 0.000003338,
	-0.000043392,-0.000680923,-0.004489899,-0.029224873, 0.006189346, 0.000259876,-0.000050545, 0.000003338,
	-0.000046253,-0.000714302,-0.004570484,-0.029890060, 0.005462170, 0.000137329,-0.000060558, 0.000002861,

	-0.000049591,-0.000747204,-0.004638195,-0.030526638, 0.004756451, 0.000021458,-0.000069618, 0.000002384,
	-0.000052929,-0.000779152,-0.004691124,-0.031132698, 0.004072189,-0.000088215,-0.000077724, 0.000002384,
	-0.000055790,-0.000809669,-0.004728317,-0.031706810, 0.003411293,-0.000191689,-0.000084400, 0.000001907,
	-0.000059605,-0.000838757,-0.004748821,-0.032248020, 0.002774239,-0.000288486,-0.000090122, 0.000001907,
	-0.000062943,-0.000866413,-0.004752159,-0.032754898, 0.002161503,-0.000378609,-0.000095367, 0.000001431,
	-0.000066280,-0.000891685,-0.004737377,-0.033225536, 0.001573563,-0.000462532,-0.000099182, 0.000001431,
	-0.000070095,-0.000915051,-0.004703045,-0.033659935, 0.001011848,-0.000539303,-0.000102520, 0.000000954,
	-0.000073433,-0.000935555,-0.004649162,-0.034055710, 0.000475883,-0.000610352,-0.000105381, 0.000000954,

	-0.000076771,-0.000954151,-0.004573822,-0.034412861,-0.000033379,-0.000674248,-0.000106812, 0.000000954,
	-0.000080585,-0.000968933,-0.004477024,-0.034730434,-0.000515938,-0.000731945,-0.000108242, 0.000000954,
	-0.000083923,-0.000980854,-0.004357815,-0.035007000,-0.000971317,-0.000783920,-0.000108719, 0.000000477,
	-0.000087261,-0.000989437,-0.004215240,-0.035242081,-0.001399517,-0.000829220,-0.000108719, 0.000000477,
	-0.000090599,-0.000994205,-0.004049301,-0.035435200,-0.001800537,-0.000868797,-0.000108242, 0.000000477,
	-0.000093460,-0.000995159,-0.003858566,-0.035586357,-0.002174854,-0.000902653,-0.000107288, 0.000000477,
	-0.000096321,-0.000991821,-0.003643036,-0.035694122,-0.002521515,-0.000930786,-0.000105858, 0.000000477,
	-0.000099182,-0.000983715,-0.003401756,-0.035758972,-0.002841473,-0.000953674,-0.000103951, 0.000000477
};

#else   /* WIND_SB_CHANGE_LEVEL < 3 */

double					enwindow[512] =
{
	 0.000000000,-0.000000477,-0.000000477,-0.000000477,-0.000000477,-0.000000477,-0.000000477,-0.000000954,
	-0.000000954,-0.000000954,-0.000000954,-0.000001431,-0.000001431,-0.000001907,-0.000001907,-0.000002384,
	-0.000002384,-0.000002861,-0.000003338,-0.000003338,-0.000003815,-0.000004292,-0.000004768,-0.000005245,
	-0.000006199,-0.000006676,-0.000007629,-0.000008106,-0.000009060,-0.000010014,-0.000011444,-0.000012398,
	-0.000013828,-0.000014782,-0.000016689,-0.000018120,-0.000019550,-0.000021458,-0.000023365,-0.000025272,
	-0.000027657,-0.000030041,-0.000032425,-0.000034809,-0.000037670,-0.000040531,-0.000043392,-0.000046253,
	-0.000049591,-0.000052929,-0.000055790,-0.000059605,-0.000062943,-0.000066280,-0.000070095,-0.000073433,
	-0.000076771,-0.000080585,-0.000083923,-0.000087261,-0.000090599,-0.000093460,-0.000096321,-0.000099182,

	 0.000101566, 0.000103951, 0.000105858, 0.000107288, 0.000108242, 0.000108719, 0.000108719, 0.000108242,
	 0.000106812, 0.000105381, 0.000102520, 0.000099182, 0.000095367, 0.000090122, 0.000084400, 0.000077724,
	 0.000069618, 0.000060558, 0.000050545, 0.000039577, 0.000027180, 0.000013828,-0.000000954,-0.000017166,
	-0.000034332,-0.000052929,-0.000072956,-0.000093937,-0.000116348,-0.000140190,-0.000165462,-0.000191212,
	-0.000218868,-0.000247478,-0.000277042,-0.000307560,-0.000339031,-0.000371456,-0.000404358,-0.000438213,
	-0.000472546,-0.000507355,-0.000542164,-0.000576973,-0.000611782,-0.000646591,-0.000680923,-0.000714302,
	-0.000747204,-0.000779152,-0.000809669,-0.000838757,-0.000866413,-0.000891685,-0.000915051,-0.000935555,
	-0.000954151,-0.000968933,-0.000980854,-0.000989437,-0.000994205,-0.000995159,-0.000991821,-0.000983715,

	 0.000971317, 0.000953674, 0.000930786, 0.000902653, 0.000868797, 0.000829220, 0.000783920, 0.000731945,
	 0.000674248, 0.000610352, 0.000539303, 0.000462532, 0.000378609, 0.000288486, 0.000191689, 0.000088215,
	-0.000021458,-0.000137329,-0.000259876,-0.000388145,-0.000522137,-0.000661850,-0.000806808,-0.000956535,
	-0.001111031,-0.001269817,-0.001432419,-0.001597881,-0.001766682,-0.001937389,-0.002110004,-0.002283096,
	-0.002457142,-0.002630711,-0.002803326,-0.002974033,-0.003141880,-0.003306866,-0.003467083,-0.003622532,
	-0.003771782,-0.003914356,-0.004048824,-0.004174709,-0.004290581,-0.004395962,-0.004489899,-0.004570484,
	-0.004638195,-0.004691124,-0.004728317,-0.004748821,-0.004752159,-0.004737377,-0.004703045,-0.004649162,
	-0.004573822,-0.004477024,-0.004357815,-0.004215240,-0.004049301,-0.003858566,-0.003643036,-0.003401756,

	 0.003134727, 0.002841473, 0.002521515, 0.002174854, 0.001800537, 0.001399517, 0.000971317, 0.000515938,
	 0.000033379,-0.000475883,-0.001011848,-0.001573563,-0.002161503,-0.002774239,-0.003411293,-0.004072189,
	-0.004756451,-0.005462170,-0.006189346,-0.006937027,-0.007703304,-0.008487225,-0.009287834,-0.010103703,
	-0.010933399,-0.011775017,-0.012627602,-0.013489246,-0.014358521,-0.015233517,-0.016112804,-0.016994476,
	-0.017876148,-0.018756866,-0.019634247,-0.020506859,-0.021372318,-0.022228718,-0.023074150,-0.023907185,
	-0.024725437,-0.025527000,-0.026310921,-0.027073860,-0.027815342,-0.028532982,-0.029224873,-0.029890060,
	-0.030526638,-0.031132698,-0.031706810,-0.032248020,-0.032754898,-0.033225536,-0.033659935,-0.034055710,
	-0.034412861,-0.034730434,-0.035007000,-0.035242081,-0.035435200,-0.035586357,-0.035694122,-0.035758972,

	 0.035780907, 0.035758972, 0.035694122, 0.035586357, 0.035435200, 0.035242081, 0.035007000, 0.034730434,
	 0.034412861, 0.034055710, 0.033659935, 0.033225536, 0.032754898, 0.032248020, 0.031706810, 0.031132698,
	 0.030526638, 0.029890060, 0.029224873, 0.028532982, 0.027815342, 0.027073860, 0.026310921, 0.025527000,
	 0.024725437, 0.023907185, 0.023074150, 0.022228718, 0.021372318, 0.020506859, 0.019634247, 0.018756866,
	 0.017876148, 0.016994476, 0.016112804, 0.015233517, 0.014358521, 0.013489246, 0.012627602, 0.011775017,
	 0.010933399, 0.010103703, 0.009287834, 0.008487225, 0.007703304, 0.006937027, 0.006189346, 0.005462170,
	 0.004756451, 0.004072189, 0.003411293, 0.002774239, 0.002161503, 0.001573563, 0.001011848, 0.000475883,
	-0.000033379,-0.000515938,-0.000971317,-0.001399517,-0.001800537,-0.002174854,-0.002521515,-0.002841473,

	 0.003134727, 0.003401756, 0.003643036, 0.003858566, 0.004049301, 0.004215240, 0.004357815, 0.004477024,
	 0.004573822, 0.004649162, 0.004703045, 0.004737377, 0.004752159, 0.004748821, 0.004728317, 0.004691124,
	 0.004638195, 0.004570484, 0.004489899, 0.004395962, 0.004290581, 0.004174709, 0.004048824, 0.003914356,
	 0.003771782, 0.003622532, 0.003467083, 0.003306866, 0.003141880, 0.002974033, 0.002803326, 0.002630711,
	 0.002457142, 0.002283096, 0.002110004, 0.001937389, 0.001766682, 0.001597881, 0.001432419, 0.001269817,
	 0.001111031, 0.000956535, 0.000806808, 0.000661850, 0.000522137, 0.000388145, 0.000259876, 0.000137329,
	 0.000021458,-0.000088215,-0.000191689,-0.000288486,-0.000378609,-0.000462532,-0.000539303,-0.000610352,
	-0.000674248,-0.000731945,-0.000783920,-0.000829220,-0.000868797,-0.000902653,-0.000930786,-0.000953674,

	 0.000971317, 0.000983715, 0.000991821, 0.000995159, 0.000994205, 0.000989437, 0.000980854, 0.000968933,
	 0.000954151, 0.000935555, 0.000915051, 0.000891685, 0.000866413, 0.000838757, 0.000809669, 0.000779152,
	 0.000747204, 0.000714302, 0.000680923, 0.000646591, 0.000611782, 0.000576973, 0.000542164, 0.000507355,
	 0.000472546, 0.000438213, 0.000404358, 0.000371456, 0.000339031, 0.000307560, 0.000277042, 0.000247478,
	 0.000218868, 0.000191212, 0.000165462, 0.000140190, 0.000116348, 0.000093937, 0.000072956, 0.000052929,
	 0.000034332, 0.000017166, 0.000000954,-0.000013828,-0.000027180,-0.000039577,-0.000050545,-0.000060558,
	-0.000069618,-0.000077724,-0.000084400,-0.000090122,-0.000095367,-0.000099182,-0.000102520,-0.000105381,
	-0.000106812,-0.000108242,-0.000108719,-0.000108719,-0.000108242,-0.000107288,-0.000105858,-0.000103951,

	 0.000101566, 0.000099182, 0.000096321, 0.000093460, 0.000090599, 0.000087261, 0.000083923, 0.000080585,
	 0.000076771, 0.000073433, 0.000070095, 0.000066280, 0.000062943, 0.000059605, 0.000055790, 0.000052929,
	 0.000049591, 0.000046253, 0.000043392, 0.000040531, 0.000037670, 0.000034809, 0.000032425, 0.000030041,
	 0.000027657, 0.000025272, 0.000023365, 0.000021458, 0.000019550, 0.000018120, 0.000016689, 0.000014782,
	 0.000013828, 0.000012398, 0.000011444, 0.000010014, 0.000009060, 0.000008106, 0.000007629, 0.000006676,
	 0.000006199, 0.000005245, 0.000004768, 0.000004292, 0.000003815, 0.000003338, 0.000003338, 0.000002861,
	 0.000002384, 0.000002384, 0.000001907, 0.000001907, 0.000001431, 0.000001431, 0.000000954, 0.000000954,
	 0.000000954, 0.000000954, 0.000000477, 0.000000477, 0.000000477, 0.000000477, 0.000000477, 0.000000477
};

#endif





/*=============================================================================*/
/* 					 >>> HUFFMAN ENCODING RELATED TABLES <<<				   */
/*=============================================================================*/


unsigned int huff_tab1[2*2] = {
  1, 1,
  1, 0
};

unsigned int huff_tab2[3*3] = {
    1, 2, 1,
    3, 1, 1,
    3, 2, 0
};

unsigned int huff_tab3[3*3] = {
    3, 2, 1,
    1, 1, 1,
    3, 2, 0
};

unsigned int huff_tab5[4*4] = {
    1, 2, 6, 5,
    3, 1, 4, 4,
    7, 5, 7, 1,
    6, 1, 1, 0
};

unsigned int huff_tab6[4*4] = {
    7, 3, 5, 1,
    6, 2, 3, 2,
    5, 4, 4, 1,
    3, 3, 2, 0
};

unsigned int huff_tab7[6*6] = {
    1, 2, 10, 19, 16, 10,
    3, 3, 7, 10, 5, 3,
    11, 4, 13, 17, 8, 4,
    12, 11, 18, 15, 11, 2,
    7, 6, 9, 14, 3, 1,
    6, 4, 5, 3, 2, 0
};

unsigned int huff_tab8[6*6] = {
    3, 4, 6, 18, 12, 5,
    5, 1, 2, 16, 9, 3,
    7, 3, 5, 14, 7, 3,
    19, 17, 15, 13, 10, 4,
    13, 5, 8, 11, 5, 1,
    12, 4, 4, 1, 1, 0
};

unsigned int huff_tab9[6*6] = {
    7, 5, 9, 14, 15, 7,
    6, 4, 5, 5, 6, 7,
    7, 6, 8, 8, 8, 5,
    15, 6, 9, 10, 5, 1,
    11, 7, 9, 6, 4, 1,
    14, 4, 6, 2, 6, 0
};

unsigned int huff_tab10[8*8] = {
    1, 2, 10, 23, 35, 30, 12, 17,
    3, 3, 8, 12, 18, 21, 12, 7,
    11, 9, 15, 21, 32, 40, 19, 6,
    14, 13, 22, 34, 46, 23, 18, 7,
    20, 19, 33, 47, 27, 22, 9, 3,
    31, 22, 41, 26, 21, 20, 5, 3,
    14, 13, 10, 11, 16, 6, 5, 1,
    9, 8, 7, 8, 4, 4, 2, 0
};

unsigned int huff_tab11[8*8] = {
    3, 4, 10, 24, 34, 33, 21, 15,
    5, 3, 4, 10, 32, 17, 11, 10,
    11, 7, 13, 18, 30, 31, 20, 5,
    25, 11, 19, 59, 27, 18, 12, 5,
    35, 33, 31, 58, 30, 16, 7, 5,
    28, 26, 32, 19, 17, 15, 8, 14,
    14, 12, 9, 13, 14, 9, 4, 1,
    11, 4, 6, 6, 6, 3, 2, 0
};

unsigned int huff_tab12[8*8] = {
    9, 6, 16, 33, 41, 39, 38, 26,
    7, 5, 6, 9, 23, 16, 26, 11,
    17, 7, 11, 14, 21, 30, 10, 7,
    17, 10, 15, 12, 18, 28, 14, 5,
    32, 13, 22, 19, 18, 16, 9, 5,
    40, 17, 31, 29, 17, 13, 4, 2,
    27, 12, 11, 15, 10, 7, 4, 1,
    27, 12, 8, 12, 6, 3, 1, 0
};

unsigned int huff_tab13[16*16] = {
    1, 5, 14, 21, 34, 51, 46, 71, 42, 52, 68, 52, 67, 44, 43, 19,
    3, 4, 12, 19, 31, 26, 44, 33, 31, 24, 32, 24, 31, 35, 22, 14,
    15, 13, 23, 36, 59, 49, 77, 65, 29, 40, 30, 40, 27, 33, 42, 16,
    22, 20, 37, 61, 56, 79, 73, 64, 43, 76, 56, 37, 26, 31, 25, 14,
    35, 16, 60, 57, 97, 75, 114, 91, 54, 73, 55, 41, 48, 53, 23, 24,
    58, 27, 50, 96, 76, 70, 93, 84, 77, 58, 79, 29, 74, 49, 41, 17,
    47, 45, 78, 74, 115, 94, 90, 79, 69, 83, 71, 50, 59, 38, 36, 15,
    72, 34, 56, 95, 92, 85, 91, 90, 86, 73, 77, 65, 51, 44, 43, 42,
    43, 20, 30, 44, 55, 78, 72, 87, 78, 61, 46, 54, 37, 30, 20, 16,
    53, 25, 41, 37, 44, 59, 54, 81, 66, 76, 57, 54, 37, 18, 39, 11,
    35, 33, 31, 57, 42, 82, 72, 80, 47, 58, 55, 21, 22, 26, 38, 22,
    53, 25, 23, 38, 70, 60, 51, 36, 55, 26, 34, 23, 27, 14, 9, 7,
    34, 32, 28, 39, 49, 75, 30, 52, 48, 40, 52, 28, 18, 17, 9, 5,
    45, 21, 34, 64, 56, 50, 49, 45, 31, 19, 12, 15, 10, 7, 6, 3,
    48, 23, 20, 39, 36, 35, 53, 21, 16, 23, 13, 10, 6, 1, 4, 2,
    16, 15, 17, 27, 25, 20, 29, 11, 17, 12, 16, 8, 1, 1, 0, 1
};

unsigned int huff_tab15[16*16] = {
    7, 12, 18, 53, 47, 76, 124, 108, 89, 123, 108, 119, 107, 81, 122, 63,
    13, 5, 16, 27, 46, 36, 61, 51, 42, 70, 52, 83, 65, 41, 59, 36,
    19, 17, 15, 24, 41, 34, 59, 48, 40, 64, 50, 78, 62, 80, 56, 33,
    29, 28, 25, 43, 39, 63, 55, 93, 76, 59, 93, 72, 54, 75, 50, 29,
    52, 22, 42, 40, 67, 57, 95, 79, 72, 57, 89, 69, 49, 66, 46, 27,
    77, 37, 35, 66, 58, 52, 91, 74, 62, 48, 79, 63, 90, 62, 40, 38,
    125, 32, 60, 56, 50, 92, 78, 65, 55, 87, 71, 51, 73, 51, 70, 30,
    109, 53, 49, 94, 88, 75, 66, 122, 91, 73, 56, 42, 64, 44, 21, 25,
    90, 43, 41, 77, 73, 63, 56, 92, 77, 66, 47, 67, 48, 53, 36, 20,
    71, 34, 67, 60, 58, 49, 88, 76, 67, 106, 71, 54, 38, 39, 23, 15,
    109, 53, 51, 47, 90, 82, 58, 57, 48, 72, 57, 41, 23, 27, 62, 9,
    86, 42, 40, 37, 70, 64, 52, 43, 70, 55, 42, 25, 29, 18, 11, 11,
    118, 68, 30, 55, 50, 46, 74, 65, 49, 39, 24, 16, 22, 13, 14, 7,
    91, 44, 39, 38, 34, 63, 52, 45, 31, 52, 28, 19, 14, 8, 9, 3,
    123, 60, 58, 53, 47, 43, 32, 22, 37, 24, 17, 12, 15, 10, 2, 1,
    71, 37, 34, 30, 28, 20, 17, 26, 21, 16, 10, 6, 8, 6, 2, 0
};

unsigned int huff_tab16[16*16] = {
    1, 5, 14, 44, 74, 63, 110, 93, 172, 149, 138, 242, 225, 195, 376, 17,
    3, 4, 12, 20, 35, 62, 53, 47, 83, 75, 68, 119, 201, 107, 207, 9,
    15, 13, 23, 38, 67, 58, 103, 90, 161, 72, 127, 117, 110, 209, 206, 16,
    45, 21, 39, 69, 64, 114, 99, 87, 158, 140, 252, 212, 199, 387, 365, 26,
    75, 36, 68, 65, 115, 101, 179, 164, 155, 264, 246, 226, 395, 382, 362, 9,
    66, 30, 59, 56, 102, 185, 173, 265, 142, 253, 232, 400, 388, 378, 445, 16,
    111, 54, 52, 100, 184, 178, 160, 133, 257, 244, 228, 217, 385, 366, 715, 10,
    98, 48, 91, 88, 165, 157, 148, 261, 248, 407, 397, 372, 380, 889, 884, 8,
    85, 84, 81, 159, 156, 143, 260, 249, 427, 401, 392, 383, 727, 713, 708, 7,
    154, 76, 73, 141, 131, 256, 245, 426, 406, 394, 384, 735, 359, 710, 352, 11,
    139, 129, 67, 125, 247, 233, 229, 219, 393, 743, 737, 720, 885, 882, 439, 4,
    243, 120, 118, 115, 227, 223, 396, 746, 742, 736, 721, 712, 706, 223, 436, 6,
    202, 224, 222, 218, 216, 389, 386, 381, 364, 888, 443, 707, 440, 437, 1728, 4,
    747, 211, 210, 208, 370, 379, 734, 723, 714, 1735, 883, 877, 876, 3459, 865, 2,
    377, 369, 102, 187, 726, 722, 358, 711, 709, 866, 1734, 871, 3458, 870, 434, 0,
    12, 10, 7, 11, 10, 17, 11, 9, 13, 12, 10, 7, 5, 3, 1, 3
};

unsigned int huff_tab24[16*16] = {
    15, 13, 46, 80, 146, 262, 248, 434, 426, 669, 653, 649, 621, 517, 1032, 88,
    14, 12, 21, 38, 71, 130, 122, 216, 209, 198, 327, 345, 319, 297, 279, 42,
    47, 22, 41, 74, 68, 128, 120, 221, 207, 194, 182, 340, 315, 295, 541, 18,
    81, 39, 75, 70, 134, 125, 116, 220, 204, 190, 178, 325, 311, 293, 271, 16,
    147, 72, 69, 135, 127, 118, 112, 210, 200, 188, 352, 323, 306, 285, 540, 14,
    263, 66, 129, 126, 119, 114, 214, 202, 192, 180, 341, 317, 301, 281, 262, 12,
    249, 123, 121, 117, 113, 215, 206, 195, 185, 347, 330, 308, 291, 272, 520, 10,
    435, 115, 111, 109, 211, 203, 196, 187, 353, 332, 313, 298, 283, 531, 381, 17,
    427, 212, 208, 205, 201, 193, 186, 177, 169, 320, 303, 286, 268, 514, 377, 16,
    335, 199, 197, 191, 189, 181, 174, 333, 321, 305, 289, 275, 521, 379, 371, 11,
    668, 184, 183, 179, 175, 344, 331, 314, 304, 290, 277, 530, 383, 373, 366, 10,
    652, 346, 171, 168, 164, 318, 309, 299, 287, 276, 263, 513, 375, 368, 362, 6,
    648, 322, 316, 312, 307, 302, 292, 284, 269, 261, 512, 376, 370, 364, 359, 4,
    620, 300, 296, 294, 288, 282, 273, 266, 515, 380, 374, 369, 365, 361, 357, 2,
    1033, 280, 278, 274, 267, 264, 259, 382, 378, 372, 367, 363, 360, 358, 356, 0,
    43, 20, 19, 17, 15, 13, 11, 9, 7, 6, 4, 7, 5, 3, 1, 3
};

unsigned int huff_tab32[16*1] = {
    1,
    5,
    4,
    5,
    6,
    5,
    4,
    4,
    7,
    3,
    6,
    0,
    7,
    2,
    3,
    1
};

unsigned int huff_tab33[16*1] = {
    15,
    14,
    13,
    12,
    11,
    10,
    9,
    8,
    7,
    6,
    5,
    4,
    3,
    2,
    1,
    0
};

unsigned char huff_hlen1[2*2] = {
    1, 3,
    2, 3
};

unsigned char huff_hlen2[3*3] = {
    1, 3, 6,
    3, 3, 5,
    5, 5, 6
};

unsigned char huff_hlen3[3*3] = {
    2, 2, 6,
    3, 2, 5,
    5, 5, 6
};

unsigned char huff_hlen5[4*4] = {
    1, 3, 6, 7,
    3, 3, 6, 7,
    6, 6, 7, 8,
    7, 6, 7, 8
};

unsigned char huff_hlen6[4*4] = {
    3, 3, 5, 7,
    3, 2, 4, 5,
    4, 4, 5, 6,
    6, 5, 6, 7
};

unsigned char huff_hlen7[6*6] = {
    1, 3, 6, 8, 8, 9,
    3, 4, 6, 7, 7, 8,
    6, 5, 7, 8, 8, 9,
    7, 7, 8, 9, 9, 9,
    7, 7, 8, 9, 9, 10,
    8, 8, 9, 10, 10, 10
};

unsigned char huff_hlen8[6*6] = {
    2, 3, 6, 8, 8, 9,
    3, 2, 4, 8, 8, 8,
    6, 4, 6, 8, 8, 9,
    8, 8, 8, 9, 9, 10,
    8, 7, 8, 9, 10, 10,
    9, 8, 9, 9, 11, 11
};

unsigned char huff_hlen9[6*6] = {
    3, 3, 5, 6, 8, 9,
    3, 3, 4, 5, 6, 8,
    4, 4, 5, 6, 7, 8,
    6, 5, 6, 7, 7, 8,
    7, 6, 7, 7, 8, 9,
    8, 7, 8, 8, 9, 9
};

unsigned char huff_hlen10[8*8] = {
    1, 3, 6, 8, 9, 9, 9, 10,
    3, 4, 6, 7, 8, 9, 8, 8,
    6, 6, 7, 8, 9, 10, 9, 9,
    7, 7, 8, 9, 10, 10, 9, 10,
    8, 8, 9, 10, 10, 10, 10, 10,
    9, 9, 10, 10, 11, 11, 10, 11,
    8, 8, 9, 10, 10, 10, 11, 11,
    9, 8, 9, 10, 10, 11, 11, 11
};

unsigned char huff_hlen11[8*8] = {
    2, 3, 5, 7, 8, 9, 8, 9,
    3, 3, 4, 6, 8, 8, 7, 8,
    5, 5, 6, 7, 8, 9, 8, 8,
    7, 6, 7, 9, 8, 10, 8, 9,
    8, 8, 8, 9, 9, 10, 9, 10,
    8, 8, 9, 10, 10, 11, 10, 11,
    8, 7, 7, 8, 9, 10, 10, 10,
    8, 7, 8, 9, 10, 10, 10, 10
};

unsigned char huff_hlen12[8*8] = {
    4, 3, 5, 7, 8, 9, 9, 9,
    3, 3, 4, 5, 7, 7, 8, 8,
    5, 4, 5, 6, 7, 8, 7, 8,
    6, 5, 6, 6, 7, 8, 8, 8,
    7, 6, 7, 7, 8, 8, 8, 9,
    8, 7, 8, 8, 8, 9, 8, 9,
    8, 7, 7, 8, 8, 9, 9, 10,
    9, 8, 8, 9, 9, 9, 9, 10
};

unsigned char huff_hlen13[16*16] = {
    1, 4, 6, 7, 8, 9, 9, 10, 9, 10, 11, 11, 12, 12, 13, 13,
    3, 4, 6, 7, 8, 8, 9, 9, 9, 9, 10, 10, 11, 12, 12, 12,
    6, 6, 7, 8, 9, 9, 10, 10, 9, 10, 10, 11, 11, 12, 13, 13,
    7, 7, 8, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 13, 13,
    8, 7, 9, 9, 10, 10, 11, 11, 10, 11, 11, 12, 12, 13, 13, 14,
    9, 8, 9, 10, 10, 10, 11, 11, 11, 11, 12, 11, 13, 13, 14, 14,
    9, 9, 10, 10, 11, 11, 11, 11, 11, 12, 12, 12, 13, 13, 14, 14,
    10, 9, 10, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 14, 16, 16,
    9, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 13, 13, 14, 15, 15,
    10, 9, 10, 10, 11, 11, 11, 13, 12, 13, 13, 14, 14, 14, 16, 15,
    10, 10, 10, 11, 11, 12, 12, 13, 12, 13, 14, 13, 14, 15, 16, 17,
    11, 10, 10, 11, 12, 12, 12, 12, 13, 13, 13, 14, 15, 15, 15, 16,
    11, 11, 11, 12, 12, 13, 12, 13, 14, 14, 15, 15, 15, 16, 16, 16,
    12, 11, 12, 13, 13, 13, 14, 14, 14, 14, 14, 15, 16, 15, 16, 16,
    13, 12, 12, 13, 13, 13, 15, 14, 14, 17, 15, 15, 15, 17, 16, 16,
    12, 12, 13, 14, 14, 14, 15, 14, 15, 15, 16, 16, 19, 18, 19, 16
};

unsigned char huff_hlen15[16*16] = {
    3, 4, 5, 7, 7, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12, 13,
    4, 3, 5, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11,
    5, 5, 5, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 11, 11, 11,
    6, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 10, 11, 11, 11,
    7, 6, 7, 7, 8, 8, 9, 9, 9, 9, 10, 10, 10, 11, 11, 11,
    8, 7, 7, 8, 8, 8, 9, 9, 9, 9, 10, 10, 11, 11, 11, 12,
    9, 7, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 11, 11, 12, 12,
    9, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 12,
    9, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 12, 12, 12,
    9, 8, 9, 9, 9, 9, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12,
    10, 9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 12, 13, 12,
    10, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 13,
    11, 10, 9, 10, 10, 10, 11, 11, 11, 11, 11, 11, 12, 12, 13, 13,
    11, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 12, 13, 13,
    12, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 12, 13,
    12, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 13, 13, 13, 13
};

unsigned char huff_hlen16[16*16] = {
    1, 4, 6, 8, 9, 9, 10, 10, 11, 11, 11, 12, 12, 12, 13, 9,
    3, 4, 6, 7, 8, 9, 9, 9, 10, 10, 10, 11, 12, 11, 12, 8,
    6, 6, 7, 8, 9, 9, 10, 10, 11, 10, 11, 11, 11, 12, 12, 9,
    8, 7, 8, 9, 9, 10, 10, 10, 11, 11, 12, 12, 12, 13, 13, 10,
    9, 8, 9, 9, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13, 13, 9,
    9, 8, 9, 9, 10, 11, 11, 12, 11, 12, 12, 13, 13, 13, 14, 10,
    10, 9, 9, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 14, 10,
    10, 9, 10, 10, 11, 11, 11, 12, 12, 13, 13, 13, 13, 15, 15, 10,
    10, 10, 10, 11, 11, 11, 12, 12, 13, 13, 13, 13, 14, 14, 14, 10,
    11, 10, 10, 11, 11, 12, 12, 13, 13, 13, 13, 14, 13, 14, 13, 11,
    11, 11, 10, 11, 12, 12, 12, 12, 13, 14, 14, 14, 15, 15, 14, 10,
    12, 11, 11, 11, 12, 12, 13, 14, 14, 14, 14, 14, 14, 13, 14, 11,
    12, 12, 12, 12, 12, 13, 13, 13, 13, 15, 14, 14, 14, 14, 16, 11,
    14, 12, 12, 12, 13, 13, 14, 14, 14, 16, 15, 15, 15, 17, 15, 11,
    13, 13, 11, 12, 14, 14, 13, 14, 14, 15, 16, 15, 17, 15, 14, 11,
    9, 8, 8, 9, 9, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 8
};

unsigned char huff_hlen24[16*16] = {
    4, 4, 6, 7, 8, 9, 9, 10, 10, 11, 11, 11, 11, 11, 12, 9,
    4, 4, 5, 6, 7, 8, 8, 9, 9, 9, 10, 10, 10, 10, 10, 8,
    6, 5, 6, 7, 7, 8, 8, 9, 9, 9, 9, 10, 10, 10, 11, 7,
    7, 6, 7, 7, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 7,
    8, 7, 7, 8, 8, 8, 8, 9, 9, 9, 10, 10, 10, 10, 11, 7,
    9, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 10, 7,
    9, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 10, 11, 7,
    10, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 8,
    10, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 8,
    10, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 8,
    11, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 8,
    11, 10, 9, 9, 9, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 8,
    11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 8,
    11, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 8,
    12, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 8,
    8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 4
};

unsigned char huff_hlen32[16*1] = {
    1,
    4,
    4,
    5,
    4,
    6,
    5,
    6,
    4,
    5,
    5,
    6,
    5,
    6,
    6,
    6
};

unsigned char huff_hlen33[16*1] = {
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4
};

struct huffcodetab ht[34] = {
    { 0, 0, 0, 0, -1, 0, 0 },
    { 2, 2, 0, 0, -1, huff_tab1, huff_hlen1 },
    { 3, 3, 0, 0, -1, huff_tab2, huff_hlen2 },
    { 3, 3, 0, 0, -1, huff_tab3, huff_hlen3 },
    { 0, 0, 0, 0, -1, 0, 0 },
    { 4, 4, 0, 0, -1, huff_tab5, huff_hlen5 },
    { 4, 4, 0, 0, -1, huff_tab6, huff_hlen6 },
    { 6, 6, 0, 0, -1, huff_tab7, huff_hlen7 },
    { 6, 6, 0, 0, -1, huff_tab8, huff_hlen8 },
    { 6, 6, 0, 0, -1, huff_tab9, huff_hlen9 },
    { 8, 8, 0, 0, -1, huff_tab10, huff_hlen10 },
    { 8, 8, 0, 0, -1, huff_tab11, huff_hlen11 },
    { 8, 8, 0, 0, -1, huff_tab12, huff_hlen12 },
    { 16, 16, 0, 0, -1, huff_tab13, huff_hlen13 },
    { 0, 0, 0, 0, -1, 0, 0 },
    { 16, 16, 0, 0, -1, huff_tab15, huff_hlen15 },
    { 16, 16, 1, 1, -1, huff_tab16, huff_hlen16 },
    { 16, 16, 2, 3, 16, huff_tab16, huff_hlen16 },
    { 16, 16, 3, 7, 16, huff_tab16, huff_hlen16 },
    { 16, 16, 4, 15, 16, huff_tab16, huff_hlen16 },
    { 16, 16, 6, 63, 16, huff_tab16, huff_hlen16 },
    { 16, 16, 8, 255, 16, huff_tab16, huff_hlen16 },
    { 16, 16, 10, 1023, 16, huff_tab16, huff_hlen16 },
    { 16, 16, 13, 8191, 16, huff_tab16, huff_hlen16 },
    { 16, 16, 4, 15, -1, huff_tab24, huff_hlen24 },
    { 16, 16, 5, 31, 24, huff_tab24, huff_hlen24 },
    { 16, 16, 6, 63, 24, huff_tab24, huff_hlen24 },
    { 16, 16, 7, 127, 24, huff_tab24, huff_hlen24 },
    { 16, 16, 8, 255, 24, huff_tab24, huff_hlen24 },
    { 16, 16, 9, 511, 24, huff_tab24, huff_hlen24 },
    { 16, 16, 11, 2047, 24, huff_tab24, huff_hlen24 },
    { 16, 16, 13, 8191, 24, huff_tab24, huff_hlen24 },
    { 1, 16, 0, 0, -1, huff_tab32, huff_hlen32 },
    { 1, 16, 0, 0, -1, huff_tab33, huff_hlen33 }
};
