/*
 * This file is part of the bladeRF project
 *
 * Copyright (C) 2013 Nuand LLC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
#include <stdio.h>
#include <limits.h>
#include <stdbool.h>
#include <conversions.h>
#include "cmd.h"

int cmd_jump_to_bootloader(struct cli_state *state, int argc, char **argv)
{
    int status;

    if (!cli_device_is_opened(state)) {
        return CLI_RET_NODEV;
    }

    if (argc != 1) {
        return CLI_RET_NARGS;
    }

    status = bladerf_jump_to_bootloader(state->dev);

    if (status == 0) {
        return CLI_RET_OK;
    } else {
        state->last_lib_error = status;
        return CLI_RET_LIBBLADERF;
    }
}

