;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: foreach %s %t wasm-opt --nominal --global-refining -all -S -o - | filecheck %s

(module
  ;; Globals with no assignments aside from their initial values. The first is
  ;; a null, so we have nothing concrete to improve with (though we could use
  ;; the type of the null perhaps, TODO). The second is a ref.func which lets
  ;; us refine.
  ;; CHECK:      (type $foo_t (func_subtype func))
  (type $foo_t (func))

  ;; CHECK:      (global $func-null-init (mut funcref) (ref.null nofunc))
  (global $func-null-init (mut funcref) (ref.null $foo_t))
  ;; CHECK:      (global $func-func-init (mut (ref $foo_t)) (ref.func $foo))
  (global $func-func-init (mut funcref) (ref.func $foo))
  ;; CHECK:      (func $foo (type $foo_t)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $foo (type $foo_t))
)

(module
  ;; Globals with later assignments of null. The global with a function in its
  ;; init will update the null to allow it to refine.

  ;; CHECK:      (type $foo_t (func_subtype func))
  (type $foo_t (func))

  ;; CHECK:      (global $func-null-init (mut funcref) (ref.null nofunc))
  (global $func-null-init (mut funcref) (ref.null $foo_t))
  ;; CHECK:      (global $func-func-init (mut (ref null $foo_t)) (ref.func $foo))
  (global $func-func-init (mut funcref) (ref.func $foo))

  ;; CHECK:      (func $foo (type $foo_t)
  ;; CHECK-NEXT:  (global.set $func-null-init
  ;; CHECK-NEXT:   (ref.null nofunc)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (global.set $func-func-init
  ;; CHECK-NEXT:   (ref.null nofunc)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $foo (type $foo_t)
   (global.set $func-null-init (ref.null func))
   (global.set $func-func-init (ref.null $foo_t))
  )
)

(module
  ;; Globals with later assignments of something non-null. Both can be refined,
  ;; and the one with a non-null initial value can even become non-nullable.

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (global $func-null-init (mut (ref null $none_=>_none)) (ref.null nofunc))
  (global $func-null-init (mut funcref) (ref.null func))
  ;; CHECK:      (global $func-func-init (mut (ref $none_=>_none)) (ref.func $foo))
  (global $func-func-init (mut funcref) (ref.func $foo))

  ;; CHECK:      (elem declare func $foo)

  ;; CHECK:      (func $foo (type $none_=>_none)
  ;; CHECK-NEXT:  (global.set $func-null-init
  ;; CHECK-NEXT:   (ref.func $foo)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (global.set $func-func-init
  ;; CHECK-NEXT:   (ref.func $foo)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $foo
   (global.set $func-null-init (ref.func $foo))
   (global.set $func-func-init (ref.func $foo))
  )
)

(module
  ;; A global with multiple later assignments. The refined type is more
  ;; specific than the original, but less than each of the non-null values.

  ;; CHECK:      (type $none_=>_none (func_subtype func))

  ;; CHECK:      (type $struct (struct_subtype  data))
  (type $struct (struct))
  (type $array (array i8))

  ;; CHECK:      (global $global (mut eqref) (ref.null none))
  (global $global (mut anyref) (ref.null any))

  ;; CHECK:      (func $foo (type $none_=>_none)
  ;; CHECK-NEXT:  (global.set $global
  ;; CHECK-NEXT:   (i31.new
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (global.set $global
  ;; CHECK-NEXT:   (struct.new_default $struct)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (global.set $global
  ;; CHECK-NEXT:   (ref.null none)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (global.set $global
  ;; CHECK-NEXT:   (ref.null none)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (global.set $global
  ;; CHECK-NEXT:   (ref.null none)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $foo
   (global.set $global (i31.new (i32.const 0)))
   (global.set $global (struct.new_default $struct))
   (global.set $global (ref.null eq))
   ;; These nulls will be updated.
   (global.set $global (ref.null i31))
   (global.set $global (ref.null $array))
  )
)
