/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/cucs2.c                 */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Sun May 18 08:35:34 1997                          */
/*    Last change :  Sun Dec 20 15:57:11 2009 (serrano)                */
/*    -------------------------------------------------------------    */
/*    UCS-2 Characters management.                                     */
/*    -------------------------------------------------------------    */
/*    The source code contained in the file are deeply inspired by     */
/*    the Java 1.1.1 Character implementation (so, many thanks         */
/*    to Lee Boynton, Guy Steele and Akira Tanaka).                    */
/*=====================================================================*/
#include <bigloo.h>
 
/*---------------------------------------------------------------------*/
/*    General Character category types                                 */
/*---------------------------------------------------------------------*/
#define	UNASSIGNED		0
#define	UPPERCASE_LETTER	1
#define	LOWERCASE_LETTER	2
#define	TITLECASE_LETTER	3
#define	MODIFIER_LETTER		4
#define	OTHER_LETTER		5
#define	NON_SPACING_MARK	6
#define	ENCLOSING_MARK		7
#define	COMBINING_SPACING_MARK	8
#define	DECIMAL_NUMBER	        9
#define	LETTER_NUMBER		10
#define	OTHER_NUMBER		11
#define	SPACE_SEPARATOR		12
#define	ENDLINE_SEPARATOR	13
#define	PARAGRAPH_SEPARATOR	14
#define	CONTROL			15
#define	FORMAT			16
#define	PRIVATE_USE		18
#define	SURROGATE		19
#define	DASH_PUNCTUATION	10
#define	START_PUNCTUATION	21
#define	END_PUNCTUATION		22
#define	CONNECTOR_PUNCTUATION	23
#define	OTHER_PUNCTUATION	24
#define	MATH_SYMBOL		25
#define	CURRENCY_SYMBOL		26
#define	MODIFIER_SYMBOL		27
#define	OTHER_SYMBOL		28
 
/*---------------------------------------------------------------------*/
/*    According the Java implementation, character properties are      */
/*    encoded into 32 bits:                                            */
/*       10 bits: signed offset used for converting case               */
/*       1  bit : if 1, adding the signed offset converts the          */
/*                the character to lowercase                           */
/*       1  bit : if 1, adding the signed offset converts the          */
/*                the character to uppercase                           */
/*       3  bits: unused                                               */
/*       2  bits: unused                                               */
/*       5  bits: digit offset (unused)                                */
/*       4  bits: unused                                               */
/*       5  bits: character type                                       */
/*---------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
/*    char X[]                                                         */
/*    -------------------------------------------------------------    */
/*    The X table has 1024 entries for a total of 1024 bytes.          */
/*---------------------------------------------------------------------*/
static char X[] = {
      0,   1,   2,   3,   4,   5,   6,   7,  /* 0x0000 */
      8,   9,  10,  11,  12,  13,  14,  15,  /* 0x0200 */
     16,  17,  18,  19,  20,  21,  22,  23,  /* 0x0400 */
     24,  25,  26,  27,  28,  28,  28,  28,  /* 0x0600 */
     28,  28,  28,  28,  29,  30,  31,  32,  /* 0x0800 */
     33,  34,  35,  36,  37,  38,  39,  40,  /* 0x0A00 */
     41,  42,  43,  44,  45,  46,  28,  28,  /* 0x0C00 */
     47,  48,  49,  50,  51,  52,  53,  28,  /* 0x0E00 */
     28,  28,  54,  55,  56,  57,  58,  59,  /* 0x1000 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x1200 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x1400 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x1600 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x1800 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x1A00 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x1C00 */
     60,  60,  61,  62,  63,  64,  65,  66,  /* 0x1E00 */
     67,  68,  69,  70,  71,  72,  73,  74,  /* 0x2000 */
     75,  75,  75,  76,  77,  78,  28,  28,  /* 0x2200 */
     79,  80,  81,  82,  83,  83,  84,  85,  /* 0x2400 */
     86,  85,  28,  28,  87,  88,  89,  28,  /* 0x2600 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x2800 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x2A00 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x2C00 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x2E00 */
     90,  91,  92,  93,  94,  56,  95,  28,  /* 0x3000 */
     96,  97,  98,  99,  83, 100,  83, 101,  /* 0x3200 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x3400 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x3600 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x3800 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x3A00 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x3C00 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x3E00 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x4000 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x4200 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x4400 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x4600 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x4800 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x4A00 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0x4C00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x4E00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x5000 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x5200 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x5400 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x5600 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x5800 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x5A00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x5C00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x5E00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x6000 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x6200 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x6400 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x6600 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x6800 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x6A00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x6C00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x6E00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x7000 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x7200 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x7400 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x7600 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x7800 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x7A00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x7C00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x7E00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x8000 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x8200 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x8400 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x8600 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x8800 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x8A00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x8C00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x8E00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x9000 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x9200 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x9400 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x9600 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x9800 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x9A00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0x9C00 */
     56,  56,  56,  56,  56,  56, 102,  28,  /* 0x9E00 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0xA000 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0xA200 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0xA400 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0xA600 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0xA800 */
     28,  28,  28,  28,  28,  28,  28,  28,  /* 0xAA00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xAC00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xAE00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xB000 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xB200 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xB400 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xB600 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xB800 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xBA00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xBC00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xBE00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xC000 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xC200 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xC400 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xC600 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xC800 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xCA00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xCC00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xCE00 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xD000 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xD200 */
     56,  56,  56,  56,  56,  56,  56,  56,  /* 0xD400 */
     56,  56,  56,  56,  56,  56, 103,  28,  /* 0xD600 */
    104, 104, 104, 104, 104, 104, 104, 104,  /* 0xD800 */
    104, 104, 104, 104, 104, 104, 104, 104,  /* 0xDA00 */
    104, 104, 104, 104, 104, 104, 104, 104,  /* 0xDC00 */
    104, 104, 104, 104, 104, 104, 104, 104,  /* 0xDE00 */
    105, 105, 105, 105, 105, 105, 105, 105,  /* 0xE000 */
    105, 105, 105, 105, 105, 105, 105, 105,  /* 0xE200 */
    105, 105, 105, 105, 105, 105, 105, 105,  /* 0xE400 */
    105, 105, 105, 105, 105, 105, 105, 105,  /* 0xE600 */
    105, 105, 105, 105, 105, 105, 105, 105,  /* 0xE800 */
    105, 105, 105, 105, 105, 105, 105, 105,  /* 0xEA00 */
    105, 105, 105, 105, 105, 105, 105, 105,  /* 0xEC00 */
    105, 105, 105, 105, 105, 105, 105, 105,  /* 0xEE00 */
    105, 105, 105, 105, 105, 105, 105, 105,  /* 0xF000 */
    105, 105, 105, 105, 105, 105, 105, 105,  /* 0xF200 */
    105, 105, 105, 105, 105, 105, 105, 105,  /* 0xF400 */
    105, 105, 105, 105, 105, 105, 105, 105,  /* 0xF600 */
    105, 105, 105, 105,  56,  56,  56,  56,  /* 0xF800 */
    106,  28,  28,  28, 107, 108, 109, 110,  /* 0xFA00 */
     56,  56,  56,  56, 111, 112, 113, 114,  /* 0xFC00 */
    115, 116,  56, 117, 118, 119, 120, 121   /* 0xFE00 */
};

/*---------------------------------------------------------------------*/
/*    char Y[]                                                         */
/*    -------------------------------------------------------------    */
/*    The Y table has 7808 entries for a total of 7808 bytes.          */
/*---------------------------------------------------------------------*/
static char Y[] = {
      0,   0,   0,   0,   0,   0,   0,   0,  /*   0 */
      0,   1,   1,   1,   1,   1,   0,   0,  /*   0 */
      0,   0,   0,   0,   0,   0,   0,   0,  /*   0 */
      0,   0,   0,   0,   1,   1,   1,   1,  /*   0 */
      2,   3,   3,   3,   4,   3,   3,   3,  /*   0 */
      5,   6,   3,   7,   3,   8,   3,   3,  /*   0 */
      9,   9,   9,   9,   9,   9,   9,   9,  /*   0 */
      9,   9,   3,   3,   7,   7,   7,   3,  /*   0 */
      3,  10,  10,  10,  10,  10,  10,  10,  /*   1 */
     10,  10,  10,  10,  10,  10,  10,  10,  /*   1 */
     10,  10,  10,  10,  10,  10,  10,  10,  /*   1 */
     10,  10,  10,   5,   3,   6,  11,  12,  /*   1 */
     11,  13,  13,  13,  13,  13,  13,  13,  /*   1 */
     13,  13,  13,  13,  13,  13,  13,  13,  /*   1 */
     13,  13,  13,  13,  13,  13,  13,  13,  /*   1 */
     13,  13,  13,   5,   7,   6,   7,   0,  /*   1 */
      0,   0,   0,   0,   0,   0,   0,   0,  /*   2 */
      0,   0,   0,   0,   0,   0,   0,   0,  /*   2 */
      0,   0,   0,   0,   0,   0,   0,   0,  /*   2 */
      0,   0,   0,   0,   0,   0,   0,   0,  /*   2 */
     14,   3,   4,   4,   4,   4,  15,  15,  /*   2 */
     11,  15,  16,   5,   7,   8,  15,  11,  /*   2 */
     15,   7,  17,  17,  11,  16,  15,   3,  /*   2 */
     11,  18,  16,   6,  19,  19,  19,   3,  /*   2 */
     20,  20,  20,  20,  20,  20,  20,  20,  /*   3 */
     20,  20,  20,  20,  20,  20,  20,  20,  /*   3 */
     20,  20,  20,  20,  20,  20,  20,   7,  /*   3 */
     20,  20,  20,  20,  20,  20,  20,  16,  /*   3 */
     21,  21,  21,  21,  21,  21,  21,  21,  /*   3 */
     21,  21,  21,  21,  21,  21,  21,  21,  /*   3 */
     21,  21,  21,  21,  21,  21,  21,   7,  /*   3 */
     21,  21,  21,  21,  21,  21,  21,  22,  /*   3 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   4 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   4 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   4 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   4 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   4 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   4 */
     25,  26,  23,  24,  23,  24,  23,  24,  /*   4 */
     16,  23,  24,  23,  24,  23,  24,  23,  /*   4 */
     24,  23,  24,  23,  24,  23,  24,  23,  /*   5 */
     24,  16,  23,  24,  23,  24,  23,  24,  /*   5 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   5 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   5 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   5 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   5 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   5 */
     27,  23,  24,  23,  24,  23,  24,  28,  /*   5 */
     16,  29,  23,  24,  23,  24,  30,  23,  /*   6 */
     24,  31,  31,  23,  24,  16,  32,  32,  /*   6 */
     33,  23,  24,  31,  34,  16,  35,  36,  /*   6 */
     23,  24,  16,  16,  35,  37,  16,  38,  /*   6 */
     23,  24,  23,  24,  23,  24,  38,  23,  /*   6 */
     24,  39,  40,  16,  23,  24,  39,  23,  /*   6 */
     24,  41,  41,  23,  24,  23,  24,  42,  /*   6 */
     23,  24,  16,  40,  23,  24,  40,  40,  /*   6 */
     40,  40,  40,  40,  43,  44,  45,  43,  /*   7 */
     44,  45,  43,  44,  45,  23,  24,  23,  /*   7 */
     24,  23,  24,  23,  24,  23,  24,  23,  /*   7 */
     24,  23,  24,  23,  24,  16,  23,  24,  /*   7 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   7 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   7 */
     16,  43,  44,  45,  23,  24,  46,  46,  /*   7 */
     46,  46,  23,  24,  23,  24,  23,  24,  /*   7 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   8 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   8 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*   8 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*   8 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*   8 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*   8 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*   8 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*   8 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*   9 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*   9 */
     16,  16,  16,  47,  48,  16,  49,  49,  /*   9 */
     50,  50,  16,  51,  16,  16,  16,  16,  /*   9 */
     49,  16,  16,  52,  16,  16,  16,  16,  /*   9 */
     53,  54,  16,  16,  16,  16,  16,  54,  /*   9 */
     16,  16,  55,  16,  16,  16,  16,  16,  /*   9 */
     16,  16,  16,  16,  16,  16,  16,  16,  /*   9 */
     16,  16,  16,  56,  16,  16,  16,  16,  /*  10 */
     56,  16,  57,  57,  16,  16,  16,  16,  /*  10 */
     16,  16,  58,  16,  16,  16,  16,  16,  /*  10 */
     16,  16,  16,  16,  16,  16,  16,  16,  /*  10 */
     16,  16,  16,  16,  16,  16,  16,  16,  /*  10 */
     16,  46,  46,  46,  46,  46,  46,  46,  /*  10 */
     59,  59,  59,  59,  59,  59,  59,  59,  /*  10 */
     59,  11,  11,  59,  59,  59,  59,  59,  /*  10 */
     59,  59,  11,  11,  11,  11,  11,  11,  /*  11 */
     11,  11,  11,  11,  11,  11,  11,  11,  /*  11 */
     59,  59,  11,  11,  11,  11,  11,  11,  /*  11 */
     11,  11,  11,  11,  11,  11,  11,  46,  /*  11 */
     59,  59,  59,  59,  59,  11,  11,  11,  /*  11 */
     11,  11,  46,  46,  46,  46,  46,  46,  /*  11 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  11 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  11 */
     60,  60,  60,  60,  60,  60,  60,  60,  /*  12 */
     60,  60,  60,  60,  60,  60,  60,  60,  /*  12 */
     60,  60,  60,  60,  60,  60,  60,  60,  /*  12 */
     60,  60,  60,  60,  60,  60,  60,  60,  /*  12 */
     60,  60,  60,  60,  60,  60,  60,  60,  /*  12 */
     60,  60,  60,  60,  60,  60,  60,  60,  /*  12 */
     60,  60,  60,  60,  60,  60,  60,  60,  /*  12 */
     60,  60,  60,  60,  60,  60,  60,  60,  /*  12 */
     60,  60,  60,  60,  60,  60,  46,  46,  /*  13 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  13 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  13 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  13 */
     60,  60,  46,  46,  46,  46,  46,  46,  /*  13 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  13 */
     46,  46,  46,  46,   3,   3,  46,  46,  /*  13 */
     46,  46,  59,  46,  46,  46,   3,  46,  /*  13 */
     46,  46,  46,  46,  11,  11,  61,   3,  /*  14 */
     62,  62,  62,  46,  63,  46,  64,  64,  /*  14 */
     16,  20,  20,  20,  20,  20,  20,  20,  /*  14 */
     20,  20,  20,  20,  20,  20,  20,  20,  /*  14 */
     20,  20,  46,  20,  20,  20,  20,  20,  /*  14 */
     20,  20,  20,  20,  65,  66,  66,  66,  /*  14 */
     16,  21,  21,  21,  21,  21,  21,  21,  /*  14 */
     21,  21,  21,  21,  21,  21,  21,  21,  /*  14 */
     21,  21,  16,  21,  21,  21,  21,  21,  /*  15 */
     21,  21,  21,  21,  67,  68,  68,  46,  /*  15 */
     69,  70,  38,  38,  38,  71,  72,  46,  /*  15 */
     46,  46,  38,  46,  38,  46,  38,  46,  /*  15 */
     38,  46,  23,  24,  23,  24,  23,  24,  /*  15 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  15 */
     73,  74,  16,  40,  46,  46,  46,  46,  /*  15 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  15 */
     46,  75,  75,  75,  75,  75,  75,  75,  /*  16 */
     75,  75,  75,  75,  75,  46,  75,  75,  /*  16 */
     20,  20,  20,  20,  20,  20,  20,  20,  /*  16 */
     20,  20,  20,  20,  20,  20,  20,  20,  /*  16 */
     20,  20,  20,  20,  20,  20,  20,  20,  /*  16 */
     20,  20,  20,  20,  20,  20,  20,  20,  /*  16 */
     21,  21,  21,  21,  21,  21,  21,  21,  /*  16 */
     21,  21,  21,  21,  21,  21,  21,  21,  /*  16 */
     21,  21,  21,  21,  21,  21,  21,  21,  /*  17 */
     21,  21,  21,  21,  21,  21,  21,  21,  /*  17 */
     46,  74,  74,  74,  74,  74,  74,  74,  /*  17 */
     74,  74,  74,  74,  74,  46,  74,  74,  /*  17 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  17 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  17 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  17 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  17 */
     23,  24,  15,  60,  60,  60,  60,  46,  /*  18 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  18 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  18 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  18 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  18 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  18 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  18 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  18 */
     40,  23,  24,  23,  24,  46,  46,  23,  /*  19 */
     24,  46,  46,  23,  24,  46,  46,  46,  /*  19 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  19 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  19 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  19 */
     23,  24,  23,  24,  46,  46,  23,  24,  /*  19 */
     23,  24,  23,  24,  23,  24,  46,  46,  /*  19 */
     23,  24,  46,  46,  46,  46,  46,  46,  /*  19 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  20 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  20 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  20 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  20 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  20 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  20 */
     46,  76,  76,  76,  76,  76,  76,  76,  /*  20 */
     76,  76,  76,  76,  76,  76,  76,  76,  /*  20 */
     76,  76,  76,  76,  76,  76,  76,  76,  /*  21 */
     76,  76,  76,  76,  76,  76,  76,  76,  /*  21 */
     76,  76,  76,  76,  76,  76,  76,  46,  /*  21 */
     46,  59,   3,   3,   3,   3,   3,   3,  /*  21 */
     46,  77,  77,  77,  77,  77,  77,  77,  /*  21 */
     77,  77,  77,  77,  77,  77,  77,  77,  /*  21 */
     77,  77,  77,  77,  77,  77,  77,  77,  /*  21 */
     77,  77,  77,  77,  77,  77,  77,  77,  /*  21 */
     77,  77,  77,  77,  77,  77,  77,  16,  /*  22 */
     46,   3,  46,  46,  46,  46,  46,  46,  /*  22 */
     46,  60,  60,  60,  60,  60,  60,  60,  /*  22 */
     60,  60,  60,  60,  60,  60,  60,  60,  /*  22 */
     60,  60,  46,  60,  60,  60,  60,  60,  /*  22 */
     60,  60,  60,  60,  60,  60,  60,  60,  /*  22 */
     60,  60,  60,  60,  60,  60,  60,  60,  /*  22 */
     60,  60,  46,  60,  60,  60,   3,  60,  /*  22 */
      3,  60,  60,   3,  60,  46,  46,  46,  /*  23 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  23 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  23 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  23 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  23 */
     40,  40,  40,  46,  46,  46,  46,  46,  /*  23 */
     40,  40,  40,   3,   3,  46,  46,  46,  /*  23 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  23 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  24 */
     46,  46,  46,  46,   3,  46,  46,  46,  /*  24 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  24 */
     46,  46,  46,   3,  46,  46,  46,   3,  /*  24 */
     46,  40,  40,  40,  40,  40,  40,  40,  /*  24 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  24 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  24 */
     40,  40,  40,  46,  46,  46,  46,  46,  /*  24 */
     59,  40,  40,  40,  40,  40,  40,  40,  /*  25 */
     40,  40,  40,  60,  60,  60,  60,  60,  /*  25 */
     60,  60,  60,  46,  46,  46,  46,  46,  /*  25 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  25 */
     78,  78,  78,  78,  78,  78,  78,  78,  /*  25 */
     78,  78,   3,   3,   3,   3,  46,  46,  /*  25 */
     60,  40,  40,  40,  40,  40,  40,  40,  /*  25 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  25 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  26 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  26 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  26 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  26 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  26 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  26 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  26 */
     46,  46,  40,  40,  40,  40,  40,  46,  /*  26 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  27 */
     40,  40,  40,  40,  40,  40,  40,  46,  /*  27 */
     40,  40,  40,  40,   3,  40,  60,  60,  /*  27 */
     60,  60,  60,  60,  60,  79,  79,  60,  /*  27 */
     60,  60,  60,  60,  60,  59,  59,  60,  /*  27 */
     60,  15,  60,  60,  60,  60,  46,  46,  /*  27 */
      9,   9,   9,   9,   9,   9,   9,   9,  /*  27 */
      9,   9,  46,  46,  46,  46,  46,  46,  /*  27 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  28 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  28 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  28 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  28 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  28 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  28 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  28 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  28 */
     46,  60,  60,  80,  46,  40,  40,  40,  /*  29 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  29 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  29 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  29 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  29 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  29 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  29 */
     40,  40,  46,  46,  60,  40,  80,  80,  /*  29 */
     80,  60,  60,  60,  60,  60,  60,  60,  /*  30 */
     60,  80,  80,  80,  80,  60,  46,  46,  /*  30 */
     15,  60,  60,  60,  60,  46,  46,  46,  /*  30 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  30 */
     40,  40,  60,  60,   3,   3,  81,  81,  /*  30 */
     81,  81,  81,  81,  81,  81,  81,  81,  /*  30 */
      3,  46,  46,  46,  46,  46,  46,  46,  /*  30 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  30 */
     46,  60,  80,  80,  46,  40,  40,  40,  /*  31 */
     40,  40,  40,  40,  40,  46,  46,  40,  /*  31 */
     40,  46,  46,  40,  40,  40,  40,  40,  /*  31 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  31 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  31 */
     40,  46,  40,  40,  40,  40,  40,  40,  /*  31 */
     40,  46,  40,  46,  46,  46,  40,  40,  /*  31 */
     40,  40,  46,  46,  60,  46,  80,  80,  /*  31 */
     80,  60,  60,  60,  60,  46,  46,  80,  /*  32 */
     80,  46,  46,  80,  80,  60,  46,  46,  /*  32 */
     46,  46,  46,  46,  46,  46,  46,  80,  /*  32 */
     46,  46,  46,  46,  40,  40,  46,  40,  /*  32 */
     40,  40,  60,  60,  46,  46,  81,  81,  /*  32 */
     81,  81,  81,  81,  81,  81,  81,  81,  /*  32 */
     40,  40,   4,   4,  82,  82,  82,  82,  /*  32 */
     19,  83,  15,  46,  46,  46,  46,  46,  /*  32 */
     46,  46,  60,  46,  46,  40,  40,  40,  /*  33 */
     40,  40,  40,  46,  46,  46,  46,  40,  /*  33 */
     40,  46,  46,  40,  40,  40,  40,  40,  /*  33 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  33 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  33 */
     40,  46,  40,  40,  40,  40,  40,  40,  /*  33 */
     40,  46,  40,  40,  46,  40,  40,  46,  /*  33 */
     40,  40,  46,  46,  60,  46,  80,  80,  /*  33 */
     80,  60,  60,  46,  46,  46,  46,  60,  /*  34 */
     60,  46,  46,  60,  60,  60,  46,  46,  /*  34 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  34 */
     46,  40,  40,  40,  40,  46,  40,  46,  /*  34 */
     46,  46,  46,  46,  46,  46,  81,  81,  /*  34 */
     81,  81,  81,  81,  81,  81,  81,  81,  /*  34 */
     60,  60,  40,  40,  40,  46,  46,  46,  /*  34 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  34 */
     46,  60,  60,  80,  46,  40,  40,  40,  /*  35 */
     40,  40,  40,  40,  46,  40,  46,  40,  /*  35 */
     40,  40,  46,  40,  40,  40,  40,  40,  /*  35 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  35 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  35 */
     40,  46,  40,  40,  40,  40,  40,  40,  /*  35 */
     40,  46,  40,  40,  46,  40,  40,  40,  /*  35 */
     40,  40,  46,  46,  60,  40,  80,  80,  /*  35 */
     80,  60,  60,  60,  60,  60,  46,  60,  /*  36 */
     60,  80,  46,  80,  80,  60,  46,  46,  /*  36 */
     15,  46,  46,  46,  46,  46,  46,  46,  /*  36 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  36 */
     40,  46,  46,  46,  46,  46,  81,  81,  /*  36 */
     81,  81,  81,  81,  81,  81,  81,  81,  /*  36 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  36 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  36 */
     46,  60,  80,  80,  46,  40,  40,  40,  /*  37 */
     40,  40,  40,  40,  40,  46,  46,  40,  /*  37 */
     40,  46,  46,  40,  40,  40,  40,  40,  /*  37 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  37 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  37 */
     40,  46,  40,  40,  40,  40,  40,  40,  /*  37 */
     40,  46,  40,  40,  46,  46,  40,  40,  /*  37 */
     40,  40,  46,  46,  60,  40,  80,  60,  /*  37 */
     80,  60,  60,  60,  46,  46,  46,  80,  /*  38 */
     80,  46,  46,  80,  80,  60,  46,  46,  /*  38 */
     46,  46,  46,  46,  46,  46,  60,  80,  /*  38 */
     46,  46,  46,  46,  40,  40,  46,  40,  /*  38 */
     40,  40,  46,  46,  46,  46,  81,  81,  /*  38 */
     81,  81,  81,  81,  81,  81,  81,  81,  /*  38 */
     15,  46,  46,  46,  46,  46,  46,  46,  /*  38 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  38 */
     46,  46,  60,  80,  46,  40,  40,  40,  /*  39 */
     40,  40,  40,  46,  46,  46,  40,  40,  /*  39 */
     40,  46,  40,  40,  40,  40,  46,  46,  /*  39 */
     46,  40,  40,  46,  40,  46,  40,  40,  /*  39 */
     46,  46,  46,  40,  40,  46,  46,  46,  /*  39 */
     40,  40,  40,  46,  46,  46,  40,  40,  /*  39 */
     40,  40,  40,  40,  40,  40,  46,  40,  /*  39 */
     40,  40,  46,  46,  46,  46,  80,  80,  /*  39 */
     60,  80,  80,  46,  46,  46,  80,  80,  /*  40 */
     80,  46,  80,  80,  80,  60,  46,  46,  /*  40 */
     46,  46,  46,  46,  46,  46,  46,  80,  /*  40 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  40 */
     46,  46,  46,  46,  46,  46,  46,  81,  /*  40 */
     81,  81,  81,  81,  81,  81,  81,  81,  /*  40 */
     84,  19,  19,  46,  46,  46,  46,  46,  /*  40 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  40 */
     46,  80,  80,  80,  46,  40,  40,  40,  /*  41 */
     40,  40,  40,  40,  40,  46,  40,  40,  /*  41 */
     40,  46,  40,  40,  40,  40,  40,  40,  /*  41 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  41 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  41 */
     40,  46,  40,  40,  40,  40,  40,  40,  /*  41 */
     40,  40,  40,  40,  46,  40,  40,  40,  /*  41 */
     40,  40,  46,  46,  46,  46,  60,  60,  /*  41 */
     60,  80,  80,  80,  80,  46,  60,  60,  /*  42 */
     60,  46,  60,  60,  60,  60,  46,  46,  /*  42 */
     46,  46,  46,  46,  46,  60,  60,  46,  /*  42 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  42 */
     40,  40,  46,  46,  46,  46,  81,  81,  /*  42 */
     81,  81,  81,  81,  81,  81,  81,  81,  /*  42 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  42 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  42 */
     46,  46,  80,  80,  46,  40,  40,  40,  /*  43 */
     40,  40,  40,  40,  40,  46,  40,  40,  /*  43 */
     40,  46,  40,  40,  40,  40,  40,  40,  /*  43 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  43 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  43 */
     40,  46,  40,  40,  40,  40,  40,  40,  /*  43 */
     40,  40,  40,  40,  46,  40,  40,  40,  /*  43 */
     40,  40,  46,  46,  46,  46,  80,  60,  /*  43 */
     80,  80,  80,  80,  80,  46,  60,  80,  /*  44 */
     80,  46,  80,  80,  60,  60,  46,  46,  /*  44 */
     46,  46,  46,  46,  46,  80,  80,  46,  /*  44 */
     46,  46,  46,  46,  46,  46,  40,  46,  /*  44 */
     40,  40,  46,  46,  46,  46,  81,  81,  /*  44 */
     81,  81,  81,  81,  81,  81,  81,  81,  /*  44 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  44 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  44 */
     46,  46,  80,  80,  46,  40,  40,  40,  /*  45 */
     40,  40,  40,  40,  40,  46,  40,  40,  /*  45 */
     40,  46,  40,  40,  40,  40,  40,  40,  /*  45 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  45 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  45 */
     40,  46,  40,  40,  40,  40,  40,  40,  /*  45 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  45 */
     40,  40,  46,  46,  46,  46,  80,  80,  /*  45 */
     80,  60,  60,  60,  46,  46,  80,  80,  /*  46 */
     80,  46,  80,  80,  80,  60,  46,  46,  /*  46 */
     46,  46,  46,  46,  46,  46,  46,  80,  /*  46 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  46 */
     40,  40,  46,  46,  46,  46,  81,  81,  /*  46 */
     81,  81,  81,  81,  81,  81,  81,  81,  /*  46 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  46 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  46 */
     46,  40,  40,  40,  40,  40,  40,  40,  /*  47 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  47 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  47 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  47 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  47 */
     40,  40,  40,  40,  40,  40,  40,   3,  /*  47 */
     40,  60,  40,  40,  60,  60,  60,  60,  /*  47 */
     60,  60,  60,  46,  46,  46,  46,   4,  /*  47 */
     40,  40,  40,  40,  40,  40,  59,  60,  /*  48 */
     60,  60,  60,  60,  60,  60,  60,  15,  /*  48 */
      9,   9,   9,   9,   9,   9,   9,   9,  /*  48 */
      9,   9,   3,   3,  46,  46,  46,  46,  /*  48 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  48 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  48 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  48 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  48 */
     46,  40,  40,  46,  40,  46,  46,  40,  /*  49 */
     40,  46,  40,  46,  46,  40,  46,  46,  /*  49 */
     46,  46,  46,  46,  40,  40,  40,  40,  /*  49 */
     46,  40,  40,  40,  40,  40,  40,  40,  /*  49 */
     46,  40,  40,  40,  46,  40,  46,  40,  /*  49 */
     46,  46,  40,  40,  46,  40,  40,   3,  /*  49 */
     40,  60,  40,  40,  60,  60,  60,  60,  /*  49 */
     60,  60,  46,  60,  60,  40,  46,  46,  /*  49 */
     40,  40,  40,  40,  40,  46,  59,  46,  /*  50 */
     60,  60,  60,  60,  60,  60,  46,  46,  /*  50 */
      9,   9,   9,   9,   9,   9,   9,   9,  /*  50 */
      9,   9,  46,  46,  40,  40,  46,  46,  /*  50 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  50 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  50 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  50 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  50 */
     15,  15,  15,  15,   3,   3,   3,   3,  /*  51 */
      3,   3,   3,   3,   3,   3,   3,   3,  /*  51 */
      3,   3,   3,  15,  15,  15,  15,  15,  /*  51 */
     60,  60,  15,  15,  15,  15,  15,  15,  /*  51 */
     78,  78,  78,  78,  78,  78,  78,  78,  /*  51 */
     78,  78,  85,  85,  85,  85,  85,  85,  /*  51 */
     85,  85,  85,  85,  15,  60,  15,  60,  /*  51 */
     15,  60,   5,   6,   5,   6,  80,  80,  /*  51 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  52 */
     46,  40,  40,  40,  40,  40,  40,  40,  /*  52 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  52 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  52 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  52 */
     40,  40,  46,  46,  46,  46,  46,  46,  /*  52 */
     46,  60,  60,  60,  60,  60,  60,  60,  /*  52 */
     60,  60,  60,  60,  60,  60,  60,  80,  /*  52 */
     60,  60,  60,  60,  60,   3,  60,  60,  /*  53 */
     60,  60,  60,  60,  46,  46,  46,  46,  /*  53 */
     60,  60,  60,  60,  60,  60,  46,  60,  /*  53 */
     46,  60,  60,  60,  60,  60,  60,  60,  /*  53 */
     60,  60,  60,  60,  60,  60,  60,  60,  /*  53 */
     60,  60,  60,  60,  60,  60,  46,  46,  /*  53 */
     46,  60,  60,  60,  60,  60,  60,  60,  /*  53 */
     46,  60,  46,  46,  46,  46,  46,  46,  /*  53 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  54 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  54 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  54 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  54 */
     76,  76,  76,  76,  76,  76,  76,  76,  /*  54 */
     76,  76,  76,  76,  76,  76,  76,  76,  /*  54 */
     76,  76,  76,  76,  76,  76,  76,  76,  /*  54 */
     76,  76,  76,  76,  76,  76,  76,  76,  /*  54 */
     76,  76,  76,  76,  76,  76,  46,  46,  /*  55 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  55 */
     16,  16,  16,  16,  16,  16,  16,  16,  /*  55 */
     16,  16,  16,  16,  16,  16,  16,  16,  /*  55 */
     16,  16,  16,  16,  16,  16,  16,  16,  /*  55 */
     16,  16,  16,  16,  16,  16,  16,  16,  /*  55 */
     16,  16,  16,  16,  16,  16,  16,  46,  /*  55 */
     46,  46,  46,   3,  46,  46,  46,  46,  /*  55 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  56 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  56 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  56 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  56 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  56 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  56 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  56 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  56 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  57 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  57 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  57 */
     40,  40,  46,  46,  46,  46,  46,  40,  /*  57 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  57 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  57 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  57 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  57 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  58 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  58 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  58 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  58 */
     40,  40,  40,  46,  46,  46,  46,  46,  /*  58 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  58 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  58 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  58 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  59 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  59 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  59 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  59 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  59 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  59 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  59 */
     40,  40,  46,  46,  46,  46,  46,  46,  /*  59 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  60 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  60 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  60 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  60 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  60 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  60 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  60 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  60 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  61 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  61 */
     23,  24,  23,  24,  23,  24,  16,  16,  /*  61 */
     16,  16,  16,  16,  46,  46,  46,  46,  /*  61 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  61 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  61 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  61 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  61 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  62 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  62 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  62 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  62 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  62 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  62 */
     23,  24,  23,  24,  23,  24,  23,  24,  /*  62 */
     23,  24,  46,  46,  46,  46,  46,  46,  /*  62 */
     86,  86,  86,  86,  86,  86,  86,  86,  /*  63 */
     87,  87,  87,  87,  87,  87,  87,  87,  /*  63 */
     86,  86,  86,  86,  86,  86,  46,  46,  /*  63 */
     87,  87,  87,  87,  87,  87,  46,  46,  /*  63 */
     86,  86,  86,  86,  86,  86,  86,  86,  /*  63 */
     87,  87,  87,  87,  87,  87,  87,  87,  /*  63 */
     86,  86,  86,  86,  86,  86,  86,  86,  /*  63 */
     87,  87,  87,  87,  87,  87,  87,  87,  /*  63 */
     86,  86,  86,  86,  86,  86,  46,  46,  /*  64 */
     87,  87,  87,  87,  87,  87,  46,  46,  /*  64 */
     16,  86,  16,  86,  16,  86,  16,  86,  /*  64 */
     46,  87,  46,  87,  46,  87,  46,  87,  /*  64 */
     86,  86,  86,  86,  86,  86,  86,  86,  /*  64 */
     87,  87,  87,  87,  87,  87,  87,  87,  /*  64 */
     88,  88,  89,  89,  89,  89,  90,  90,  /*  64 */
     91,  91,  92,  92,  93,  93,  46,  46,  /*  64 */
     86,  86,  86,  86,  86,  86,  86,  86,  /*  65 */
     87,  87,  87,  87,  87,  87,  87,  87,  /*  65 */
     86,  86,  86,  86,  86,  86,  86,  86,  /*  65 */
     87,  87,  87,  87,  87,  87,  87,  87,  /*  65 */
     86,  86,  86,  86,  86,  86,  86,  86,  /*  65 */
     87,  87,  87,  87,  87,  87,  87,  87,  /*  65 */
     86,  86,  16,  94,  16,  46,  16,  16,  /*  65 */
     87,  87,  95,  95,  96,  11,  38,  11,  /*  65 */
     11,  11,  16,  94,  16,  46,  16,  16,  /*  66 */
     97,  97,  97,  97,  96,  11,  11,  11,  /*  66 */
     86,  86,  16,  16,  46,  46,  16,  16,  /*  66 */
     87,  87,  98,  98,  46,  11,  11,  11,  /*  66 */
     86,  86,  16,  16,  16,  99,  16,  16,  /*  66 */
     87,  87, 100, 100, 101,  11,  11,  11,  /*  66 */
     46,  46,  16,  94,  16,  46,  16,  16,  /*  66 */
    102, 102, 103, 103,  96,  11,  11,  46,  /*  66 */
      2,   2,   2,   2,   2,   2,   2,   2,  /*  67 */
      2,   2,   2,   2, 104, 104, 104, 104,  /*  67 */
      8,   8,   8,   8,   8,   8,   3,   3,  /*  67 */
      5,   6,   5,   5,   5,   6,   5,   5,  /*  67 */
      3,   3,   3,   3,   3,   3,   3,   3,  /*  67 */
    105, 106, 104, 104, 104, 104, 104,  46,  /*  67 */
      3,   3,   3,   3,   3,   3,   3,   3,  /*  67 */
      3,   5,   6,   3,   3,   3,   3,  12,  /*  67 */
     12,   3,   3,   3,   7,   5,   6,  46,  /*  68 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  68 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  68 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  68 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  68 */
     46,  46, 104, 104, 104, 104, 104, 104,  /*  68 */
     17,  46,  46,  46,  17,  17,  17,  17,  /*  68 */
     17,  17,   7,   7,   7,   5,   6,  16,  /*  68 */
    107, 107, 107, 107, 107, 107, 107, 107,  /*  69 */
    107, 107,   7,   7,   7,   5,   6,  46,  /*  69 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  69 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  69 */
      4,   4,   4,   4,   4,   4,   4,   4,  /*  69 */
      4,   4,   4,   4,  46,  46,  46,  46,  /*  69 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  69 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  69 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  70 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  70 */
     60,  60,  60,  60,  60,  60,  60,  60,  /*  70 */
     60,  60,  60,  60,  60,  79,  79,  79,  /*  70 */
     79,  60,  46,  46,  46,  46,  46,  46,  /*  70 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  70 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  70 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  70 */
     15,  15,  38,  15,  15,  15,  15,  38,  /*  71 */
     15,  15,  16,  38,  38,  38,  16,  16,  /*  71 */
     38,  38,  38,  16,  15,  38,  15,  15,  /*  71 */
     38,  38,  38,  38,  38,  38,  15,  15,  /*  71 */
     15,  15,  15,  15,  38,  15,  38,  15,  /*  71 */
     38,  15,  38,  38,  38,  38,  16,  16,  /*  71 */
     38,  38,  15,  38,  16,  40,  40,  40,  /*  71 */
     40,  46,  46,  46,  46,  46,  46,  46,  /*  71 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  72 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  72 */
     46,  46,  46,  19,  19,  19,  19,  19,  /*  72 */
     19,  19,  19,  19,  19,  19,  19, 108,  /*  72 */
    109, 109, 109, 109, 109, 109, 109, 109,  /*  72 */
    109, 109, 109, 109, 110, 110, 110, 110,  /*  72 */
    111, 111, 111, 111, 111, 111, 111, 111,  /*  72 */
    111, 111, 111, 111, 112, 112, 112, 112,  /*  72 */
    113, 113, 113,  46,  46,  46,  46,  46,  /*  73 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  73 */
      7,   7,   7,   7,   7,  15,  15,  15,  /*  73 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  73 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  73 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  73 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  73 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  73 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  74 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  74 */
     15,  15,   7,  15,   7,  15,  15,  15,  /*  74 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  74 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  74 */
     15,  15,  15,  46,  46,  46,  46,  46,  /*  74 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  74 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  74 */
      7,   7,   7,   7,   7,   7,   7,   7,  /*  75 */
      7,   7,   7,   7,   7,   7,   7,   7,  /*  75 */
      7,   7,   7,   7,   7,   7,   7,   7,  /*  75 */
      7,   7,   7,   7,   7,   7,   7,   7,  /*  75 */
      7,   7,   7,   7,   7,   7,   7,   7,  /*  75 */
      7,   7,   7,   7,   7,   7,   7,   7,  /*  75 */
      7,   7,   7,   7,   7,   7,   7,   7,  /*  75 */
      7,   7,   7,   7,   7,   7,   7,   7,  /*  75 */
      7,   7,   7,   7,   7,   7,   7,   7,  /*  76 */
      7,   7,   7,   7,   7,   7,   7,   7,  /*  76 */
      7,   7,   7,   7,   7,   7,   7,   7,  /*  76 */
      7,   7,   7,   7,   7,   7,   7,   7,  /*  76 */
      7,   7,   7,   7,   7,   7,   7,   7,  /*  76 */
      7,   7,   7,   7,   7,   7,   7,   7,  /*  76 */
      7,   7,  46,  46,  46,  46,  46,  46,  /*  76 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  76 */
     15,  46,  15,  15,  15,  15,  15,  15,  /*  77 */
      7,   7,   7,   7,  15,  15,  15,  15,  /*  77 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  77 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  77 */
      7,   7,  15,  15,  15,  15,  15,  15,  /*  77 */
     15,   5,   6,  15,  15,  15,  15,  15,  /*  77 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  77 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  77 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  78 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  78 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  78 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  78 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  78 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  78 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  78 */
     15,  15,  15,  46,  46,  46,  46,  46,  /*  78 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  79 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  79 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  79 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  79 */
     15,  15,  15,  15,  15,  46,  46,  46,  /*  79 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  79 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  79 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  79 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  80 */
     15,  15,  15,  46,  46,  46,  46,  46,  /*  80 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  80 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  80 */
    114, 114, 114, 114, 114, 114, 114, 114,  /*  80 */
    114, 114, 114, 114, 114, 114, 114, 114,  /*  80 */
    114, 114, 114, 114,  82,  82,  82,  82,  /*  80 */
     82,  82,  82,  82,  82,  82,  82,  82,  /*  80 */
     82,  82,  82,  82,  82,  82,  82,  82,  /*  81 */
    115, 115, 115, 115, 115, 115, 115, 115,  /*  81 */
    115, 115, 115, 115, 115, 115, 115, 115,  /*  81 */
    115, 115, 115, 115,  15,  15,  15,  15,  /*  81 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  81 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  81 */
     15,  15,  15,  15,  15,  15, 116, 116,  /*  81 */
    116, 116, 116, 116, 116, 116, 116, 116,  /*  81 */
    116, 116, 116, 116, 116, 116, 116, 116,  /*  82 */
    116, 116, 116, 116, 116, 116, 116, 116,  /*  82 */
    117, 117, 117, 117, 117, 117, 117, 117,  /*  82 */
    117, 117, 117, 117, 117, 117, 117, 117,  /*  82 */
    117, 117, 117, 117, 117, 117, 117, 117,  /*  82 */
    117, 117, 118,  46,  46,  46,  46,  46,  /*  82 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  82 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  82 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  83 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  83 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  83 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  83 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  83 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  83 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  83 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  83 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  84 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  84 */
     15,  15,  15,  15,  15,  15,  46,  46,  /*  84 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  84 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  84 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  84 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  84 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  84 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  85 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  85 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  85 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  85 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  85 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  85 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  85 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  85 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  86 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  86 */
     15,  15,  15,  15,  46,  46,  46,  46,  /*  86 */
     46,  46,  15,  15,  15,  15,  15,  15,  /*  86 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  86 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  86 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  86 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  86 */
     46,  15,  15,  15,  15,  46,  15,  15,  /*  87 */
     15,  15,  46,  46,  15,  15,  15,  15,  /*  87 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  87 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  87 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  87 */
     46,  15,  15,  15,  15,  15,  15,  15,  /*  87 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  87 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  87 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  88 */
     15,  15,  15,  15,  46,  15,  46,  15,  /*  88 */
     15,  15,  15,  46,  46,  46,  15,  46,  /*  88 */
     15,  15,  15,  15,  15,  15,  15,  46,  /*  88 */
     46,  15,  15,  15,  15,  15,  15,  15,  /*  88 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  88 */
     46,  46,  46,  46,  46,  46, 119, 119,  /*  88 */
    119, 119, 119, 119, 119, 119, 119, 119,  /*  88 */
    114, 114, 114, 114, 114, 114, 114, 114,  /*  89 */
    114, 114,  83,  83,  83,  83,  83,  83,  /*  89 */
     83,  83,  83,  83,  15,  46,  46,  46,  /*  89 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  89 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  89 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  89 */
     46,  15,  15,  15,  15,  15,  15,  15,  /*  89 */
     15,  15,  15,  15,  15,  15,  15,  46,  /*  89 */
      2,   3,   3,   3,  15,  59,   3, 120,  /*  90 */
      5,   6,   5,   6,   5,   6,   5,   6,  /*  90 */
      5,   6,  15,  15,   5,   6,   5,   6,  /*  90 */
      5,   6,   5,   6,   8,   5,   6,   5,  /*  90 */
     15, 121, 121, 121, 121, 121, 121, 121,  /*  90 */
    121, 121,  60,  60,  60,  60,  60,  60,  /*  90 */
      8,  59,  59,  59,  59,  59,  15,  15,  /*  90 */
     46,  46,  46,  46,  46,  46,  46,  15,  /*  90 */
     46,  40,  40,  40,  40,  40,  40,  40,  /*  91 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  91 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  91 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  91 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  91 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  91 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  91 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  91 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  92 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  92 */
     40,  40,  40,  40,  40,  46,  46,  46,  /*  92 */
     46,  60,  60,  59,  59,  59,  59,  46,  /*  92 */
     46,  40,  40,  40,  40,  40,  40,  40,  /*  92 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  92 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  92 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  92 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  93 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  93 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  93 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  93 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  93 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  93 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  93 */
     40,  40,  40,   3,  59,  59,  59,  46,  /*  93 */
     46,  46,  46,  46,  46,  40,  40,  40,  /*  94 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  94 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  94 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  94 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  94 */
     40,  40,  40,  40,  40,  46,  46,  46,  /*  94 */
     46,  40,  40,  40,  40,  40,  40,  40,  /*  94 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  94 */
     40,  40,  40,  40,  40,  40,  40,  40,  /*  95 */
     40,  40,  40,  40,  40,  40,  40,  46,  /*  95 */
     15,  15,  85,  85,  85,  85,  15,  15,  /*  95 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  95 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  95 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  95 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  95 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  95 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  96 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  96 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  96 */
     15,  15,  15,  15,  15,  46,  46,  46,  /*  96 */
     85,  85,  85,  85,  85,  85,  85,  85,  /*  96 */
     85,  85,  15,  15,  15,  15,  15,  15,  /*  96 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  96 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  96 */
     15,  15,  15,  15,  46,  46,  46,  46,  /*  97 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  97 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  97 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  97 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  97 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  97 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  97 */
     15,  15,  15,  15,  46,  46,  46,  15,  /*  97 */
    114, 114, 114, 114, 114, 114, 114, 114,  /*  98 */
    114, 114,  15,  15,  15,  15,  15,  15,  /*  98 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  98 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  98 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  98 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  98 */
     15,  46,  46,  46,  46,  46,  46,  46,  /*  98 */
     46,  46,  46,  46,  46,  46,  46,  46,  /*  98 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  99 */
     15,  15,  15,  15,  46,  46,  46,  46,  /*  99 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  99 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  99 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  99 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  99 */
     15,  15,  15,  15,  15,  15,  15,  15,  /*  99 */
     15,  15,  15,  15,  15,  15,  15,  46,  /*  99 */
     15,  15,  15,  15,  15,  15,  15,  15,  /* 100 */
     15,  15,  15,  15,  15,  15,  15,  15,  /* 100 */
     15,  15,  15,  15,  15,  15,  15,  15,  /* 100 */
     15,  15,  15,  15,  15,  15,  15,  15,  /* 100 */
     15,  15,  15,  15,  15,  15,  15,  15,  /* 100 */
     15,  15,  15,  15,  15,  15,  15,  15,  /* 100 */
     15,  15,  15,  15,  15,  15,  15,  46,  /* 100 */
     46,  46,  46,  15,  15,  15,  15,  15,  /* 100 */
     15,  15,  15,  15,  15,  15,  15,  15,  /* 101 */
     15,  15,  15,  15,  15,  15,  15,  15,  /* 101 */
     15,  15,  15,  15,  15,  15,  15,  15,  /* 101 */
     15,  15,  15,  15,  15,  15,  46,  46,  /* 101 */
     15,  15,  15,  15,  15,  15,  15,  15,  /* 101 */
     15,  15,  15,  15,  15,  15,  15,  15,  /* 101 */
     15,  15,  15,  15,  15,  15,  15,  15,  /* 101 */
     15,  15,  15,  15,  15,  15,  15,  46,  /* 101 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 102 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 102 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 102 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 102 */
     40,  40,  40,  40,  40,  40,  46,  46,  /* 102 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 102 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 102 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 102 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 103 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 103 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 103 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 103 */
     40,  40,  40,  40,  46,  46,  46,  46,  /* 103 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 103 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 103 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 103 */
    122, 122, 122, 122, 122, 122, 122, 122,  /* 104 */
    122, 122, 122, 122, 122, 122, 122, 122,  /* 104 */
    122, 122, 122, 122, 122, 122, 122, 122,  /* 104 */
    122, 122, 122, 122, 122, 122, 122, 122,  /* 104 */
    122, 122, 122, 122, 122, 122, 122, 122,  /* 104 */
    122, 122, 122, 122, 122, 122, 122, 122,  /* 104 */
    122, 122, 122, 122, 122, 122, 122, 122,  /* 104 */
    122, 122, 122, 122, 122, 122, 122, 122,  /* 104 */
    123, 123, 123, 123, 123, 123, 123, 123,  /* 105 */
    123, 123, 123, 123, 123, 123, 123, 123,  /* 105 */
    123, 123, 123, 123, 123, 123, 123, 123,  /* 105 */
    123, 123, 123, 123, 123, 123, 123, 123,  /* 105 */
    123, 123, 123, 123, 123, 123, 123, 123,  /* 105 */
    123, 123, 123, 123, 123, 123, 123, 123,  /* 105 */
    123, 123, 123, 123, 123, 123, 123, 123,  /* 105 */
    123, 123, 123, 123, 123, 123, 123, 123,  /* 105 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 106 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 106 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 106 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 106 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 106 */
     40,  40,  40,  40,  40,  40,  46,  46,  /* 106 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 106 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 106 */
     16,  16,  16,  16,  16,  16,  16,  46,  /* 107 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 107 */
     46,  46,  46,  16,  16,  16,  16,  16,  /* 107 */
     46,  46,  46,  46,  46,  46,  60,  40,  /* 107 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 107 */
     40,   7,  40,  40,  40,  40,  40,  40,  /* 107 */
     40,  40,  40,  40,  40,  40,  40,  46,  /* 107 */
     40,  40,  40,  40,  40,  46,  40,  46,  /* 107 */
     40,  40,  46,  40,  40,  46,  40,  40,  /* 108 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 108 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 108 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 108 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 108 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 108 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 108 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 108 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 109 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 109 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 109 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 109 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 109 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 109 */
     40,  40,  46,  46,  46,  46,  46,  46,  /* 109 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 109 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 110 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 110 */
     46,  46,  46,  40,  40,  40,  40,  40,  /* 110 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 110 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 110 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 110 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 110 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 110 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 111 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 111 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 111 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 111 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 111 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 111 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 111 */
     40,  40,  40,  40,  40,  40,   5,   6,  /* 111 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 112 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 112 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 112 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 112 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 112 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 112 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 112 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 112 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 113 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 113 */
     46,  46,  40,  40,  40,  40,  40,  40,  /* 113 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 113 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 113 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 113 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 113 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 113 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 114 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 114 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 114 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 114 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 114 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 114 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 114 */
     40,  40,  40,  40,  46,  46,  46,  46,  /* 114 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 115 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 115 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 115 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 115 */
     60,  60,  60,  60,  46,  46,  46,  46,  /* 115 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 115 */
      3,   8,   8,  12,  12,   5,   6,   5,  /* 115 */
      6,   5,   6,   5,   6,   5,   6,   5,  /* 115 */
      6,   5,   6,   5,   6,  46,  46,  46,  /* 116 */
     46,   3,   3,   3,   3,  12,  12,  12,  /* 116 */
      3,   3,   3,  46,   3,   3,   3,   3,  /* 116 */
      8,   5,   6,   5,   6,   5,   6,   3,  /* 116 */
      3,   3,   7,   8,   7,   7,   7,  46,  /* 116 */
      3,   4,   3,   3,  46,  46,  46,  46,  /* 116 */
     40,  40,  40,  46,  40,  46,  40,  40,  /* 116 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 116 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 117 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 117 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 117 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 117 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 117 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 117 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 117 */
     40,  40,  40,  40,  40,  46,  46, 104,  /* 117 */
     46,   3,   3,   3,   4,   3,   3,   3,  /* 118 */
      5,   6,   3,   7,   3,   8,   3,   3,  /* 118 */
      9,   9,   9,   9,   9,   9,   9,   9,  /* 118 */
      9,   9,   3,   3,   7,   7,   7,   3,  /* 118 */
      3,  10,  10,  10,  10,  10,  10,  10,  /* 118 */
     10,  10,  10,  10,  10,  10,  10,  10,  /* 118 */
     10,  10,  10,  10,  10,  10,  10,  10,  /* 118 */
     10,  10,  10,   5,   3,   6,  11,  12,  /* 118 */
     11,  13,  13,  13,  13,  13,  13,  13,  /* 119 */
     13,  13,  13,  13,  13,  13,  13,  13,  /* 119 */
     13,  13,  13,  13,  13,  13,  13,  13,  /* 119 */
     13,  13,  13,   5,   7,   6,   7,  46,  /* 119 */
     46,   3,   5,   6,   3,   3,  40,  40,  /* 119 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 119 */
     59,  40,  40,  40,  40,  40,  40,  40,  /* 119 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 119 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 120 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 120 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 120 */
     40,  40,  40,  40,  40,  40,  59,  59,  /* 120 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 120 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 120 */
     40,  40,  40,  40,  40,  40,  40,  40,  /* 120 */
     40,  40,  40,  40,  40,  40,  40,  46,  /* 120 */
     46,  46,  40,  40,  40,  40,  40,  40,  /* 121 */
     46,  46,  40,  40,  40,  40,  40,  40,  /* 121 */
     46,  46,  40,  40,  40,  40,  40,  40,  /* 121 */
     46,  46,  40,  40,  40,  46,  46,  46,  /* 121 */
      4,   4,   7,  11,  15,   4,   4,  46,  /* 121 */
      7,   7,   7,   7,   7,  15,  15,  46,  /* 121 */
     46,  46,  46,  46,  46,  46,  46,  46,  /* 121 */
     46,  46,  46,  46,  46,  15,  46,  46   /* 121 */
};

/*---------------------------------------------------------------------*/
/*    unsigned int A[]                                                 */
/*    -------------------------------------------------------------    */
/*    The A table has 124 entries for a total of 496 bytes.            */
/*---------------------------------------------------------------------*/
static unsigned int A[] = {
    0x0001000F,  /*   0   Cc, ignorable */
    0x0004000F,  /*   1   Cc, whitespace */
    0x0004000C,  /*   2   Zs, whitespace */
    0x00000018,  /*   3   Po */
    0x0006001A,  /*   4   Sc, currency */
    0x00000015,  /*   5   Ps */
    0x00000016,  /*   6   Pe */
    0x00000019,  /*   7   Sm */
    0x00000014,  /*   8   Pd */
    0x00036009,  /*   9   Nd, identifier part, decimal 16 */
    0x0827FE01,  /*  10   Lu, hasLower (add 32), identifier start, supradecimal 31 */
    0x0000001B,  /*  11   Sk */
    0x00050017,  /*  12   Pc, underscore */
    0x0817FE02,  /*  13   Ll, hasUpper (subtract 32), identifier start, supradecimal 31 */
    0x0000000C,  /*  14   Zs */
    0x0000001C,  /*  15   So */
    0x00070002,  /*  16   Ll, identifier start */
    0x0000600B,  /*  17   No, decimal 16 */
    0x0000500B,  /*  18   No, decimal 8 */
    0x0000800B,  /*  19   No, strange */
    0x08270001,  /*  20   Lu, hasLower (add 32), identifier start */
    0x08170002,  /*  21   Ll, hasUpper (subtract 32), identifier start */
    0xE1D70002,  /*  22   Ll, hasUpper (subtract -121), identifier start */
    0x00670001,  /*  23   Lu, hasLower (add 1), identifier start */
    0x00570002,  /*  24   Ll, hasUpper (subtract 1), identifier start */
    0xCE670001,  /*  25   Lu, hasLower (add -199), identifier start */
    0x3A170002,  /*  26   Ll, hasUpper (subtract 232), identifier start */
    0xE1E70001,  /*  27   Lu, hasLower (add -121), identifier start */
    0x4B170002,  /*  28   Ll, hasUpper (subtract 300), identifier start */
    0x34A70001,  /*  29   Lu, hasLower (add 210), identifier start */
    0x33A70001,  /*  30   Lu, hasLower (add 206), identifier start */
    0x33670001,  /*  31   Lu, hasLower (add 205), identifier start */
    0x32A70001,  /*  32   Lu, hasLower (add 202), identifier start */
    0x32E70001,  /*  33   Lu, hasLower (add 203), identifier start */
    0x33E70001,  /*  34   Lu, hasLower (add 207), identifier start */
    0x34E70001,  /*  35   Lu, hasLower (add 211), identifier start */
    0x34670001,  /*  36   Lu, hasLower (add 209), identifier start */
    0x35670001,  /*  37   Lu, hasLower (add 213), identifier start */
    0x00070001,  /*  38   Lu, identifier start */
    0x36A70001,  /*  39   Lu, hasLower (add 218), identifier start */
    0x00070005,  /*  40   Lo, identifier start */
    0x36670001,  /*  41   Lu, hasLower (add 217), identifier start */
    0x36E70001,  /*  42   Lu, hasLower (add 219), identifier start */
    0x00AF0001,  /*  43   Lu, hasLower (add 2), hasTitle, identifier start */
    0x007F0003,  /*  44   Lt, hasUpper (subtract 1), hasLower (add 1), hasTitle, identifier start */
    0x009F0002,  /*  45   Ll, hasUpper (subtract 2), hasTitle, identifier start */
    0x0000001A,  /*  46   currency (MS 20dec09) */
    0x34970002,  /*  47   Ll, hasUpper (subtract 210), identifier start */
    0x33970002,  /*  48   Ll, hasUpper (subtract 206), identifier start */
    0x33570002,  /*  49   Ll, hasUpper (subtract 205), identifier start */
    0x32970002,  /*  50   Ll, hasUpper (subtract 202), identifier start */
    0x32D70002,  /*  51   Ll, hasUpper (subtract 203), identifier start */
    0x33D70002,  /*  52   Ll, hasUpper (subtract 207), identifier start */
    0x34570002,  /*  53   Ll, hasUpper (subtract 209), identifier start */
    0x34D70002,  /*  54   Ll, hasUpper (subtract 211), identifier start */
    0x35570002,  /*  55   Ll, hasUpper (subtract 213), identifier start */
    0x36970002,  /*  56   Ll, hasUpper (subtract 218), identifier start */
    0x36570002,  /*  57   Ll, hasUpper (subtract 217), identifier start */
    0x36D70002,  /*  58   Ll, hasUpper (subtract 219), identifier start */
    0x00070004,  /*  59   Lm, identifier start */
    0x00030006,  /*  60   Mn, identifier part */
    0x09A70001,  /*  61   Lu, hasLower (add 38), identifier start */
    0x09670001,  /*  62   Lu, hasLower (add 37), identifier start */
    0x10270001,  /*  63   Lu, hasLower (add 64), identifier start */
    0x0FE70001,  /*  64   Lu, hasLower (add 63), identifier start */
    0x09970002,  /*  65   Ll, hasUpper (subtract 38), identifier start */
    0x09570002,  /*  66   Ll, hasUpper (subtract 37), identifier start */
    0x10170002,  /*  67   Ll, hasUpper (subtract 64), identifier start */
    0x0FD70002,  /*  68   Ll, hasUpper (subtract 63), identifier start */
    0x0F970002,  /*  69   Ll, hasUpper (subtract 62), identifier start */
    0x0E570002,  /*  70   Ll, hasUpper (subtract 57), identifier start */
    0x0BD70002,  /*  71   Ll, hasUpper (subtract 47), identifier start */
    0x0D970002,  /*  72   Ll, hasUpper (subtract 54), identifier start */
    0x15970002,  /*  73   Ll, hasUpper (subtract 86), identifier start */
    0x14170002,  /*  74   Ll, hasUpper (subtract 80), identifier start */
    0x14270001,  /*  75   Lu, hasLower (add 80), identifier start */
    0x0C270001,  /*  76   Lu, hasLower (add 48), identifier start */
    0x0C170002,  /*  77   Ll, hasUpper (subtract 48), identifier start */
    0x00034009,  /*  78   Nd, identifier part, decimal 0 */
    0x00000007,  /*  79   Me */
    0x00030008,  /*  80   Mc, identifier part */
    0x00037409,  /*  81   Nd, identifier part, decimal 26 */
    0x00005A0B,  /*  82   No, decimal 13 */
    0x00006E0B,  /*  83   No, decimal 23 */
    0x0000740B,  /*  84   No, decimal 26 */
    0x0000000B,  /*  85   No */
    0xFE170002,  /*  86   Ll, hasUpper (subtract -8), identifier start */
    0xFE270001,  /*  87   Lu, hasLower (add -8), identifier start */
    0xED970002,  /*  88   Ll, hasUpper (subtract -74), identifier start */
    0xEA970002,  /*  89   Ll, hasUpper (subtract -86), identifier start */
    0xE7170002,  /*  90   Ll, hasUpper (subtract -100), identifier start */
    0xE0170002,  /*  91   Ll, hasUpper (subtract -128), identifier start */
    0xE4170002,  /*  92   Ll, hasUpper (subtract -112), identifier start */
    0xE0970002,  /*  93   Ll, hasUpper (subtract -126), identifier start */
    0xFDD70002,  /*  94   Ll, hasUpper (subtract -9), identifier start */
    0xEDA70001,  /*  95   Lu, hasLower (add -74), identifier start */
    0xFDE70001,  /*  96   Lu, hasLower (add -9), identifier start */
    0xEAA70001,  /*  97   Lu, hasLower (add -86), identifier start */
    0xE7270001,  /*  98   Lu, hasLower (add -100), identifier start */
    0xFE570002,  /*  99   Ll, hasUpper (subtract -7), identifier start */
    0xE4270001,  /* 100   Lu, hasLower (add -112), identifier start */
    0xFE670001,  /* 101   Lu, hasLower (add -7), identifier start */
    0xE0270001,  /* 102   Lu, hasLower (add -128), identifier start */
    0xE0A70001,  /* 103   Lu, hasLower (add -126), identifier start */
    0x00010010,  /* 104   Cf, ignorable */
    0x0004000D,  /* 105   Zl, whitespace */
    0x0004000E,  /* 106   Zp, whitespace */
    0x0000400B,  /* 107   No, decimal 0 */
    0x0000440B,  /* 108   No, decimal 2 */
    0x0427420A,  /* 109   Nl, hasLower (add 16), identifier start, decimal 1 */
    0x0427800A,  /* 110   Nl, hasLower (add 16), identifier start, strange */
    0x0417620A,  /* 111   Nl, hasUpper (subtract 16), identifier start, decimal 17 */
    0x0417800A,  /* 112   Nl, hasUpper (subtract 16), identifier start, strange */
    0x0007800A,  /* 113   Nl, identifier start, strange */
    0x0000420B,  /* 114   No, decimal 1 */
    0x0000720B,  /* 115   No, decimal 25 */
    0x06A0001C,  /* 116   So, hasLower (add 26) */
    0x0690001C,  /* 117   So, hasUpper (subtract 26) */
    0x00006C0B,  /* 118   No, decimal 22 */
    0x0000560B,  /* 119   No, decimal 11 */
    0x0007720A,  /* 120   Nl, identifier start, decimal 25 */
    0x0007400A,  /* 121   Nl, identifier start, decimal 0 */
    0x00000013,  /* 122   Cs */
    0x00000012   /* 123   Co */
};


/*---------------------------------------------------------------------*/
/*    bool_t                                                           */
/*    ucs2_definedp ...                                                */
/*    -------------------------------------------------------------    */
/*    Is an ucs2 character defined? It is if the character has an      */
/*    entry in the Unicode attribute table.                            */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
bool_t
ucs2_definedp( int ch ) {
   return (A[ (int)Y[ (X[ ch>>6 ]<<6) | (ch&0x3F) ] ] & 0x1F) != UNASSIGNED;
}

/*---------------------------------------------------------------------*/
/*    bool_t                                                           */
/*    ucs2_lowerp ...                                                  */
/*    -------------------------------------------------------------    */
/*    A character is considered to be lowercase if and only if it      */
/*    is specified to be lowercase by the Unicode 2.0 standard         */
/*    (category "Ll" in the Unicode specififaction data file).         */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
bool_t
ucs2_lowerp( ucs2_t ch ) {
   return (A[ (int)Y[ (X[ ch>>6 ]<<6) | (ch & 0x3F) ] ] & 0x1F) == LOWERCASE_LETTER;
}

/*---------------------------------------------------------------------*/
/*    bool_t                                                           */
/*    ucs2_upperp ...                                                  */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
bool_t
ucs2_upperp( ucs2_t ch ) {
   return (A[ (int)Y[ (X[ ch>>6 ]<<6) | (ch&0x3F) ] ] & 0x1F) == UPPERCASE_LETTER;
}

/*---------------------------------------------------------------------*/
/*    bool_t                                                           */
/*    ucs2_digitp ...                                                  */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
bool_t
ucs2_digitp( ucs2_t ch )
{
   return (A[ (int)Y[ (X[ ch>>6 ]<<6) | (ch&0x3F) ] ] & 0x1F) == DECIMAL_NUMBER;
}

/*---------------------------------------------------------------------*/
/*    bool_t                                                           */
/*    ucs2_letterp ...                                                 */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
bool_t
ucs2_letterp( ucs2_t ch ) {
   return (((((1 << UPPERCASE_LETTER) |
	      (1 << LOWERCASE_LETTER) |
	      (1 << TITLECASE_LETTER) |
	      (1 << MODIFIER_LETTER)  |
	      (1 << OTHER_LETTER))
	     >> (A[ (int)Y[ (X[ ch>>6 ]<<6) | (ch&0x3F) ] ] & 0x1F)) & 1) != 0);
}

/*---------------------------------------------------------------------*/
/*    bool_t                                                           */
/*    ucs2_whitespacep ...                                             */
/*    -------------------------------------------------------------    */
/*    A character is a whitespace if and only if it satisfies one      */
/*    of the following criteria:                                       */
/*       - It is a unicode space separator (category "Zs") byt is      */
/*         not a no-break space #u00a0 #ufeff                          */
/*       - It is a unicode line separator ("Zl")                       */
/*       - It is a unicode paragraph separator ("Zp")                  */
/*       - It is #u0009 or #u000a #u000b #u000c #u000d #u001c          */
/*               #u001d #u001e #u001f.                                 */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
bool_t
ucs2_whitespacep( ucs2_t ch ) {
   return (A[ (int)Y[ (X[ ch>>6 ]<<6) | (ch&0x3F) ] ] & 0x00070000) == 0x00040000;
}

/*---------------------------------------------------------------------*/
/*    ucs2_t                                                           */
/*    ucs2_toupper ...                                                 */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
ucs2_t
ucs2_toupper( ucs2_t ch ) {
   unsigned int val = A[ (int)Y[ (X[ ch>>6 ]<<6) | (ch&0x3F) ] ];
   
   if( (val & 0x00100000) != 0 )
      return (ucs2_t)(ch - (val >> 22));
   else
      return ch;
}

/*---------------------------------------------------------------------*/
/*    ucs2_t                                                           */
/*    ucs2_tolower ...                                                 */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
ucs2_t
ucs2_tolower( ucs2_t ch ) {
   unsigned int val = A[ (int)Y[ (X[ ch>>6 ]<<6) | (ch & 0x3F) ] ];
   
   if ((val & 0x00200000) != 0)
      return (ucs2_t)(ch + (val >> 22));
   else
      return ch;
}


