/*
 * Decompiled with CFR 0.152.
 */
package scalax.file.ramfs;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$any2stringadd$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0$mcJ$sp;
import scala.runtime.java8.JFunction0$mcZ$sp;
import scalax.file.BasicPathSet;
import scalax.file.LinkOption;
import scalax.file.NotDirectoryException;
import scalax.file.Path;
import scalax.file.Path$;
import scalax.file.Path$AccessModes$Execute$;
import scalax.file.Path$AccessModes$Read$;
import scalax.file.Path$AccessModes$Write$;
import scalax.file.PathMatcher;
import scalax.file.PathMatcherFactory;
import scalax.file.ramfs.DirNode;
import scalax.file.ramfs.DirNode$;
import scalax.file.ramfs.FileNode;
import scalax.file.ramfs.FileNode$;
import scalax.file.ramfs.Node;
import scalax.file.ramfs.RamFileOps;
import scalax.file.ramfs.RamFileSystem;
import scalax.io.ArrayBufferSeekableChannel;
import scalax.io.OpenOption;
import scalax.io.ResourceContext;
import scalax.io.Seekable;
import scalax.io.managed.InputStreamResource;
import scalax.io.managed.OutputStreamResource;
import scalax.io.managed.SeekableByteChannelResource;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0001\u0003\u0001%\u0011qAU1n!\u0006$\bN\u0003\u0002\u0004\t\u0005)!/Y7gg*\u0011QAB\u0001\u0005M&dWMC\u0001\b\u0003\u0019\u00198-\u00197bq\u000e\u00011c\u0001\u0001\u000b\u001dA\u00111\u0002D\u0007\u0002\t%\u0011Q\u0002\u0002\u0002\u0005!\u0006$\b\u000e\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\tQ!+Y7GS2,w\n]:\t\u0011M\u0001!\u0011!Q\u0001\nQ\t!B]3mCRLg/\u001a+p!\t)bD\u0004\u0002\u00179A\u0011qCG\u0007\u00021)\u0011\u0011\u0004C\u0001\u0007yI|w\u000e\u001e \u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0002\rA\u0013X\rZ3g\u0013\ty\u0002E\u0001\u0004TiJLgn\u001a\u0006\u0003;iA\u0001B\t\u0001\u0003\u0006\u0004%\taI\u0001\u0005a\u0006$\b.F\u0001\u0015\u0011!)\u0003A!A!\u0002\u0013!\u0012!\u00029bi\"\u0004\u0003\u0002C\u0014\u0001\u0005\u000b\u0007I\u0011\t\u0015\u0002\u0015\u0019LG.Z*zgR,W.F\u0001*!\ty!&\u0003\u0002,\u0005\ti!+Y7GS2,7+_:uK6D\u0011\"\f\u0001\u0003\u0002\u0003\u0006I!\u000b\u0018\u0002\u0017\u0019LG.Z*zgR,W\u000eI\u0005\u0003O1AQ\u0001\r\u0001\u0005\u0002E\na\u0001P5oSRtD\u0003\u0002\u001a4iU\u0002\"a\u0004\u0001\t\u000bMy\u0003\u0019\u0001\u000b\t\u000b\tz\u0003\u0019\u0001\u000b\t\u000b\u001dz\u0003\u0019A\u0015\t\u000b]\u0002A\u0011\u0001\u001d\u0002\t9|G-Z\u000b\u0002sA\u0019!hO\u001f\u000e\u0003iI!\u0001\u0010\u000e\u0003\r=\u0003H/[8o!\tya(\u0003\u0002@\u0005\t!aj\u001c3f\u0011!\t\u0005\u0001#b\u0001\n\u0003\u0011\u0015A\u0003;p\u0003\n\u001cx\u000e\\;uKV\t!\u0007\u0003\u0005E\u0001!\u0015\r\u0011\"\u0001F\u0003\u0015!x.\u0016*J+\u00051\u0005CA$M\u001b\u0005A%BA%K\u0003\rqW\r\u001e\u0006\u0002\u0017\u0006!!.\u0019<b\u0013\ti\u0005JA\u0002V%&CQa\u0014\u0001\u0005\u0002A\u000bA\u0001\n3jmR\u0011!'\u0015\u0005\u0006%:\u0003\r\u0001F\u0001\u0006G\"LG\u000e\u001a\u0005\t)\u0002A)\u0019!C\u0001G\u0005!a.Y7f\u0011\u00151\u0006\u0001\"\u0001X\u0003)!xNU3bYB\u000bG\u000f\u001b\u000b\u00031z\u0003\"!\u0017/\u000f\u0005i3cBA.A\u001b\u0005\u0001\u0011BA/+\u0005!\u0001\u0016\r\u001e5UsB,\u0007\"B0V\u0001\u0004\u0001\u0017a\u00037j].|\u0005\u000f^5p]N\u00042AO1d\u0013\t\u0011'D\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002\"a\u00033\n\u0005\u0015$!A\u0003'j].|\u0005\u000f^5p]\"Aq\r\u0001EC\u0002\u0013\u0005\u0001.\u0001\u0004qCJ,g\u000e^\u000b\u0002SB\u0019!h\u000f\u001a\t\u000b-\u0004A\u0011\u00017\u0002\u0017\rDWmY6BG\u000e,7o\u001d\u000b\u0003[B\u0004\"A\u000f8\n\u0005=T\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006c*\u0004\rA]\u0001\u0006[>$Wm\u001d\t\u0004u\u0005\u001c\bC\u0001;|\u001d\t)\bP\u0004\u0002\fm&\u0011q\u000fB\u0001\u0005!\u0006$\b.\u0003\u0002zu\u0006Y\u0011iY2fgNlu\u000eZ3t\u0015\t9H!\u0003\u0002}{\nQ\u0011iY2fgNlu\u000eZ3\u000b\u0005eT\bBB@\u0001\t\u0003\t\t!\u0001\u0004fq&\u001cHo]\u000b\u0002[\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u0005\u0011AB5t\r&dW\rC\u0004\u0002\n\u0001!\t!!\u0001\u0002\u0017%\u001cH)\u001b:fGR|'/\u001f\u0005\b\u0003\u001b\u0001A\u0011AA\u0001\u0003)I7/\u00112t_2,H/\u001a\u0005\b\u0003#\u0001A\u0011AA\u0001\u0003!I7\u000fS5eI\u0016t\u0007bBA\u000b\u0001\u0011\u0005\u0011qC\u0001\rY\u0006\u001cH/T8eS\u001aLW\rZ\u000b\u0003\u00033\u00012AOA\u000e\u0013\r\tiB\u0007\u0002\u0005\u0019>tw\rC\u0004\u0002\"\u0001!\t!a\t\u0002!1\f7\u000f^'pI&4\u0017.\u001a3`I\u0015\fH\u0003BA\r\u0003KA\u0001\"a\n\u0002 \u0001\u0007\u0011\u0011D\u0001\u0005i&lW\rC\u0004\u0002,\u0001!\t!!\f\u0002\tML'0Z\u000b\u0003\u0003_\u0001BAO\u001e\u0002\u001a!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0012AC1dG\u0016\u001c8o\u0018\u0013fcR!\u0011qGA\u001f!\rQ\u0014\u0011H\u0005\u0004\u0003wQ\"\u0001B+oSRD\u0001\"a\u0010\u00022\u0001\u0007\u0011\u0011I\u0001\fC\u000e\u001cWm]:N_\u0012,7\u000fE\u0003\u0002D\u000553O\u0004\u0003\u0002F\u0005%cbA\f\u0002H%\t1$C\u0002\u0002Li\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002P\u0005E#\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005-#\u0004C\u0004\u0002V\u0001!\t!a\u0016\u0002\u0019\u0011|7I]3bi\u00164\u0015\u000e\\3\u0015\u00035Dq!a\u0017\u0001\t\u0003\t9&A\te_\u000e\u0013X-\u0019;f\t&\u0014Xm\u0019;pefDq!a\u0018\u0001\t\u0003\t\t'A\be_\u000e\u0013X-\u0019;f!\u0006\u0014XM\u001c;t)\t\t9\u0004C\u0004\u0002f\u0001!\t!a\u001a\u0002\r\u0011,G.\u001a;f)\rY\u0016\u0011\u000e\u0005\n\u0003W\n\u0019\u0007%AA\u00025\fQAZ8sG\u0016Dq!a\u001c\u0001\t#\t\t(\u0001\u0005n_Z,g)\u001b7f)\u0019\t9$a\u001d\u0002x!9\u0011QOA7\u0001\u0004Q\u0011A\u0002;be\u001e,G\u000fC\u0004\u0002z\u00055\u0004\u0019A7\u0002\u0015\u0005$x.\\5d\u001b>4X\rC\u0004\u0002~\u0001!\t\"a \u0002\u001b5|g/\u001a#je\u0016\u001cGo\u001c:z)\u0019\t9$!!\u0002\u0004\"9\u0011QOA>\u0001\u0004Q\u0001bBA=\u0003w\u0002\r!\u001c\u0005\b\u0003\u000f\u0003A\u0011IAE\u0003!!xn\u0015;sS:<G#\u0001\u000b\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\u0006YA-Z:dK:$\u0017M\u001c;t+\u0019\t\t*a5\u0002*RA\u00111SA^\u0003\u007f\u000bI\r\u0006\u0003\u0002\u0016\u0006m\u0005\u0003B\u0006\u0002\u0018JJ1!!'\u0005\u00051\u0011\u0015m]5d!\u0006$\bnU3u\u0011!\ti*a#A\u0004\u0005}\u0015a\u00024bGR|'/\u001f\t\u0006\u0017\u0005\u0005\u0016QU\u0005\u0004\u0003G#!A\u0005)bi\"l\u0015\r^2iKJ4\u0015m\u0019;pef\u0004B!a*\u0002*2\u0001A\u0001CAV\u0003\u0017\u0013\r!!,\u0003\u0003\u0019\u000bB!a,\u00026B\u0019!(!-\n\u0007\u0005M&DA\u0004O_RD\u0017N\\4\u0011\u0007i\n9,C\u0002\u0002:j\u00111!\u00118z\u0011)\ti,a#\u0011\u0002\u0003\u0007\u0011QU\u0001\u0007M&dG/\u001a:\t\u0015\u0005\u0005\u00171\u0012I\u0001\u0002\u0004\t\u0019-A\u0003eKB$\b\u000eE\u0002;\u0003\u000bL1!a2\u001b\u0005\rIe\u000e\u001e\u0005\u000b\u0003\u0017\fY\t%AA\u0002\u00055\u0017aB8qi&|gn\u001d\t\u0006\u0003\u0007\nymY\u0005\u0005\u0003#\f\tFA\u0006Ue\u00064XM]:bE2,G\u0001CAk\u0003\u0017\u0013\r!a6\u0003\u0003U\u000b2ACA[\u0001")
public class RamPath
extends Path
implements RamFileOps {
    private RamPath toAbsolute;
    private URI toURI;
    private String name;
    private Option<RamPath> parent;
    private final String relativeTo;
    private final String path;
    private volatile byte bitmap$0;

    @Override
    public InputStreamResource<InputStream> inputStream() {
        return RamFileOps.inputStream$(this);
    }

    @Override
    public OutputStreamResource<OutputStream> outputStream(Seq<OpenOption> openOptions) {
        return RamFileOps.outputStream$(this, openOptions);
    }

    @Override
    public SeekableByteChannelResource<ArrayBufferSeekableChannel> channel(Seq<OpenOption> openOptions) {
        return RamFileOps.channel$(this, openOptions);
    }

    @Override
    public None$ fileChannel(Seq<OpenOption> openOptions) {
        return RamFileOps.fileChannel$(this, openOptions);
    }

    @Override
    public <R> Option<R> withLock(long start, long size2, boolean shared, ResourceContext context, Function1<Seekable, R> block) {
        return RamFileOps.withLock$(this, start, size2, shared, context, block);
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public RamFileSystem fileSystem() {
        return (RamFileSystem)super.fileSystem();
    }

    public Option<Node> node() {
        return this.fileSystem().lookup(this);
    }

    private RamPath toAbsolute$lzycompute() {
        RamPath ramPath = this;
        synchronized (ramPath) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.toAbsolute = this.fileSystem().fromStrings("", this.relativeTo + this.separator() + this.path());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.toAbsolute;
    }

    @Override
    public RamPath toAbsolute() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.toAbsolute$lzycompute() : this.toAbsolute;
    }

    private URI toURI$lzycompute() {
        RamPath ramPath = this;
        synchronized (ramPath) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.toURI = this.fileSystem().uri(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.toURI;
    }

    @Override
    public URI toURI() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.toURI$lzycompute() : this.toURI;
    }

    @Override
    public RamPath $div(String child) {
        this.fileSystem().checkSegmentForSeparators(child);
        return this.fileSystem().fromStrings(this.relativeTo, this.path() + this.separator() + child);
    }

    private String name$lzycompute() {
        RamPath ramPath = this;
        synchronized (ramPath) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.name = (String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.path().split(Pattern.quote(this.separator())))).lastOption().getOrElse((Function0<String> & java.io.Serializable & Serializable)() -> this.path());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.name;
    }

    @Override
    public String name() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.name$lzycompute() : this.name;
    }

    @Override
    public RamPath toRealPath(Seq<LinkOption> linkOptions) {
        return (RamPath)this.toAbsolute().normalize();
    }

    private Option<RamPath> parent$lzycompute() {
        RamPath ramPath = this;
        synchronized (ramPath) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                List<?> list;
                List<Object> raw = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.path().split(Pattern.quote(this.separator())))).toList();
                List<?> noEmpty = (List<?>)raw.filterNot((Function1<String, Object> & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isEmpty()));
                if (raw.headOption().exists((Function1<String, Object> & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.isEmpty()))) {
                    String string = this.separator();
                    list = noEmpty.$plus$colon(string, List$.MODULE$.canBuildFrom());
                } else {
                    list = noEmpty;
                }
                List<?> segs = list;
                List list2 = (List)segs.dropRight(1);
                Option option = ((Object)Nil$.MODULE$).equals(list2) ? None$.MODULE$ : new Some<RamPath>(this.fileSystem().apply(this.relativeTo, list2));
                this.parent = option;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.parent;
    }

    public Option<RamPath> parent() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.parent$lzycompute() : this.parent;
    }

    @Override
    public boolean checkAccess(Seq<Path.AccessModes.AccessMode> modes) {
        boolean bl;
        Option<Node> option = this.node();
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Node node = (Node)some.value();
            bl = modes.forall((Function1<Path.AccessModes.AccessMode, Object> & java.io.Serializable & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(RamPath.$anonfun$checkAccess$1(node, x0$1)));
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    @Override
    public boolean exists() {
        return this.node().isDefined();
    }

    @Override
    public boolean isFile() {
        return BoxesRunTime.unboxToBoolean(this.node().map((Function1<Node, Object> & java.io.Serializable & Serializable)node -> BoxesRunTime.boxToBoolean(FileNode$.MODULE$.accepts(node))).getOrElse((JFunction0$mcZ$sp & Serializable)() -> false));
    }

    @Override
    public boolean isDirectory() {
        return BoxesRunTime.unboxToBoolean(this.node().map((Function1<Node, Object> & java.io.Serializable & Serializable)node -> BoxesRunTime.boxToBoolean(DirNode$.MODULE$.accepts(node))).getOrElse((JFunction0$mcZ$sp & Serializable)() -> false));
    }

    @Override
    public boolean isAbsolute() {
        String string = this.relativeTo;
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public long lastModified() {
        return BoxesRunTime.unboxToLong(this.node().map((Function1<Node, Object> & java.io.Serializable & Serializable)x$4 -> BoxesRunTime.boxToLong(x$4.lastModified())).getOrElse((JFunction0$mcJ$sp & Serializable)() -> 0L));
    }

    @Override
    public long lastModified_$eq(long time) {
        this.node().foreach((Function1<Node, Object> & java.io.Serializable & Serializable)x$5 -> {
            x$5.lastModified_$eq(time);
            return BoxedUnit.UNIT;
        });
        return time;
    }

    @Override
    public Option<Object> size() {
        return this.node().collect(new Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Node, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof FileNode) {
                    FileNode fileNode = (FileNode)A1;
                    object = BoxesRunTime.boxToLong(fileNode.data().size());
                } else {
                    object = function1.apply(x1);
                }
                return object;
            }

            public final boolean isDefinedAt(Node x1) {
                Node node = x1;
                boolean bl = node instanceof FileNode;
                return bl;
            }
        });
    }

    @Override
    public void access_$eq(Iterable<Path.AccessModes.AccessMode> accessModes) {
        Option<Node> option = this.node();
        if (None$.MODULE$.equals(option)) {
            throw Path$.MODULE$.fail(new StringOps(Predef$.MODULE$.augmentString("Path %s does not exist")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.path()})));
        }
        if (!(option instanceof Some)) {
            throw new MatchError(option);
        }
        Some some = (Some)option;
        Node node = (Node)some.value();
        node.canRead_$eq(accessModes.exists((Function1<Path.AccessModes.AccessMode, Object> & java.io.Serializable & Serializable)x$6 -> BoxesRunTime.boxToBoolean(RamPath.$anonfun$access_$eq$1(x$6))));
        node.canWrite_$eq(accessModes.exists((Function1<Path.AccessModes.AccessMode, Object> & java.io.Serializable & Serializable)x$7 -> BoxesRunTime.boxToBoolean(RamPath.$anonfun$access_$eq$2(x$7))));
        node.canExecute_$eq(accessModes.exists((Function1<Path.AccessModes.AccessMode, Object> & java.io.Serializable & Serializable)x$8 -> BoxesRunTime.boxToBoolean(RamPath.$anonfun$access_$eq$3(x$8))));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public boolean doCreateFile() {
        return this.fileSystem().create(this, FileNode$.MODULE$, false);
    }

    @Override
    public boolean doCreateDirectory() {
        return this.fileSystem().create(this, DirNode$.MODULE$, false);
    }

    @Override
    public void doCreateParents() {
        this.toAbsolute().parent().foreach((Function1<RamPath, Object> & java.io.Serializable & Serializable)x$9 -> BoxesRunTime.boxToBoolean(RamPath.$anonfun$doCreateParents$1(this, x$9)));
    }

    @Override
    public RamPath delete(boolean force) {
        Option<Node> n2 = this.node();
        if (this.node().forall((Function1<Node, Object> & java.io.Serializable & Serializable)n -> BoxesRunTime.boxToBoolean(RamPath.$anonfun$delete$1(n)))) {
            if (this.exists() && !this.fileSystem().delete(this, force)) {
                throw Path$.MODULE$.fail("Could not delete " + this.path());
            }
        } else {
            throw Path$.MODULE$.fail("Directory is not empty, cannot delete");
        }
        return this;
    }

    @Override
    public void moveFile(Path target, boolean atomicMove) {
        this.fileSystem().move(this, (RamPath)target);
    }

    @Override
    public void moveDirectory(Path target, boolean atomicMove) {
        this.fileSystem().move(this, (RamPath)target);
    }

    @Override
    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("RamPath(%s)")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.path()}));
    }

    public <U, F> BasicPathSet<RamPath> descendants(F filter, int depth, Traversable<LinkOption> options, PathMatcherFactory<F> factory) {
        if (!this.isDirectory()) {
            throw new NotDirectoryException(Predef$any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(this), " is not a directory so descendants can not be called on it"));
        }
        return new BasicPathSet<RamPath>(this, (PathMatcher)factory.apply(filter), depth, false, (Function2<PathMatcher, RamPath, Iterator> & java.io.Serializable & Serializable)(pathFilter, parent) -> {
            Option<ArrayBuffer<RamPath>> c = parent.node().collect(new Serializable(null, (RamPath)parent){
                public static final long serialVersionUID = 0L;
                private final RamPath parent$1;

                public final <A1 extends Node, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (!(A1 instanceof DirNode)) {
                        throw new NotDirectoryException(Predef$any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(A1), " is not a directory so descendants can not be called on it"));
                    }
                    DirNode dirNode = (DirNode)A1;
                    ArrayBuffer<A> arrayBuffer = dirNode.children().map((Function1<Node, RamPath> & java.io.Serializable & Serializable)n -> $this.parent$1.$div(n.name()), ArrayBuffer$.MODULE$.canBuildFrom());
                    return (B1)arrayBuffer;
                }

                public final boolean isDefinedAt(Node x2) {
                    Node node = x2;
                    boolean bl = node instanceof DirNode ? true : true;
                    return bl;
                }
                {
                    this.parent$1 = parent$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scalax.file.ramfs.RamPath$$anonfun$1 scalax.file.ramfs.Node )}, serializedLambda);
                }
            });
            return TraversableOnce$.MODULE$.flattenTraversableOnce(Option$.MODULE$.option2Iterable(c).toIterator(), Predef$.MODULE$.$conforms()).flatten();
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkAccess$1(Node node$1, Path.AccessModes.AccessMode x0$1) {
        boolean bl;
        Path.AccessModes.AccessMode accessMode = x0$1;
        if (Path$AccessModes$Execute$.MODULE$.equals(accessMode)) {
            bl = node$1.canExecute();
        } else if (Path$AccessModes$Read$.MODULE$.equals(accessMode)) {
            bl = node$1.canRead();
        } else if (Path$AccessModes$Write$.MODULE$.equals(accessMode)) {
            bl = node$1.canWrite();
        } else {
            throw new MatchError(accessMode);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$access_$eq$1(Path.AccessModes.AccessMode x$6) {
        Path.AccessModes.AccessMode accessMode = x$6;
        Path$AccessModes$Read$ path$AccessModes$Read$ = Path$AccessModes$Read$.MODULE$;
        return !(accessMode != null ? !accessMode.equals(path$AccessModes$Read$) : path$AccessModes$Read$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$access_$eq$2(Path.AccessModes.AccessMode x$7) {
        Path.AccessModes.AccessMode accessMode = x$7;
        Path$AccessModes$Write$ path$AccessModes$Write$ = Path$AccessModes$Write$.MODULE$;
        return !(accessMode != null ? !accessMode.equals(path$AccessModes$Write$) : path$AccessModes$Write$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$access_$eq$3(Path.AccessModes.AccessMode x$8) {
        Path.AccessModes.AccessMode accessMode = x$8;
        Path$AccessModes$Execute$ path$AccessModes$Execute$ = Path$AccessModes$Execute$.MODULE$;
        return !(accessMode != null ? !accessMode.equals(path$AccessModes$Execute$) : path$AccessModes$Execute$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$doCreateParents$1(RamPath $this, RamPath x$9) {
        return $this.fileSystem().create(x$9, DirNode$.MODULE$, true);
    }

    public static final /* synthetic */ boolean $anonfun$delete$1(Node n) {
        return n instanceof FileNode || ((DirNode)n).children().isEmpty();
    }

    public RamPath(String relativeTo, String path, RamFileSystem fileSystem) {
        this.relativeTo = relativeTo;
        this.path = path;
        super(fileSystem);
        RamFileOps.$init$(this);
    }
}

