!================================================================================
!
! Modules:
!
! (1) svninfo_m      Originally By gsm       Last Modified 11/08/2010 (gsm)
!
! Returns information on svn repository name, version, and revision number.
!
! Set the following svn properties on this file:
! % svn propset svn:keywords "Date Revision Author HeadURL" Common/svninfo.f90
!
! Use pre-commit hook to ensure this file is modified before each commit.
! Modify text here before making a commit --> Here we go!
!
!================================================================================

#include "f_defs.h"
  
module svninfo_m

  use global_m
  implicit none
      
  private

  character(len=64), parameter :: svndate = &
    '$Date: 2018-06-01 08:54:31 +0000 (Fri, 01 Jun 2018) $'
  character(len=64), parameter :: svnrevision = '$Revision: 7293 $'
  character(len=64), parameter :: svnauthor = '$Author: buildbot $'
  character(len=256), parameter :: svnheadurl = &
    '$HeadURL: https://civet.berkeley.edu/svn/BerkeleyGW/trunk/Common/svninfo.f90 $'

  public :: getsvninfo

contains

!-------------------------------------------------------------------------------

  subroutine getsvninfo(asvninfo)
    character(len=256), intent(out) :: asvninfo

    integer :: j1,j2,l1,i1,i2,i3,i4,f1,f2,f3

    PUSH_SUB(getsvninfo)

    j1=scan(svnrevision,'$',.false.)+11
    j2=scan(svnrevision,'$',.true.)-2
    
    l1=len(svnheadurl)
    i1=index(svnheadurl,'svn')+4
    i2=index(svnheadurl(i1:l1),'/')+i1-2
    
    f1=index(svnheadurl(i2+2:l1),'branches')
    f2=index(svnheadurl(i2+2:l1),'tags')
    f3=index(svnheadurl(i2+2:l1),'trunk')

    if (f1 .ne. 0) then
      i3=index(svnheadurl(i2+2:l1),'/')+i2+2
      i4=index(svnheadurl(i3:l1),'/')+i3-2
      write(asvninfo,'("branch",1x,a,1x,"revision",1x,a)') &
        svnheadurl(i3:i4),svnrevision(j1:j2)
    elseif (f2 .ne. 0) then
      i3=index(svnheadurl(i2+2:l1),'-')+i2+2
      i4=index(svnheadurl(i3:l1),'/')+i3-2
      write(asvninfo,'("tag",1x,a,1x,"revision",1x,a)') &
        svnheadurl(i3:i4),svnrevision(j1:j2)
    elseif (f3 .ne. 0) then
      write(asvninfo,'("trunk",1x,"revision",1x,a)') &
        svnrevision(j1:j2)
    else
      write(asvninfo,'("Unknown")')
    endif

    i1=1
    do while (i1 .ne. 0)
      i1=index(asvninfo,'_')
      if (i1 .ne. 0) asvninfo(i1:i1)=' '
    enddo
    
    i1=1
    do while (i1 .ne. 0)
      i1=index(asvninfo,'-')
      if (i1 .ne. 0) asvninfo(i1:i1)=' '
    enddo

    POP_SUB(getsvninfo)

    return

  end subroutine getsvninfo

!-------------------------------------------------------------------------------

end module svninfo_m
