!==============================================================================
!
! Module: bessel_m   Originally By DAS 1/31/2011
!
!   Note that besj0 and besj1 are standard Fortran intrinsics, but the
!   modified functions are not available.
!
! Routines:
!
! (1) dbesk0(function)  Originally By JRD       Last Modified 1/1/2012 (JRD)
!
!     Returns the K0 Bessel function. From free software: 
!     http://www.kurims.kyoto-u.ac.jp/~ooura/bessel.html
!
!==============================================================================

#include "f_defs.h"

module bessel_m

  use global_m
  implicit none

  private

  public :: &
    dbesk0

contains

  real(DP) function dbesk0(x) result(k0)
      real(DP) :: x,t,y
      integer :: i,k
      real(DP) :: a(0 : 15), b(0 : 111), c(0 : 134), d(0 : 39)

      data (a(i), i = 0, 15) / &
         2.4307270476772195953d-12, 4.7091666363785304370d-10, &
         6.7816861334344265568d-8, 6.7816840204737508252d-6, &
         4.3402777777915334676d-4, 1.5624999999999872796d-2, &
         2.5000000000000000448d-1, 9.9999999999999999997d-1, &
         6.5878327432224993071d-12, 1.2083308769932888218d-9, &
         1.6271062073716412046d-7, 1.4914719278555277887d-5, &
         8.4603509071212245667d-4, 2.5248929932162333910d-2, &
         2.7898287891460312491d-1, 1.1593151565841244874d-1 / 
      data (b(i), i = 0, 13) / &
         -4.6430702971053162197d-13, 1.0377936059563728230d-11, &
         -1.0298475936392057807d-10, 5.3632747492333959219d-10, &
         -2.1674628861036068105d-10, -2.3316071545820437669d-8, & 
         2.2557819578691704059d-7, -9.2325694638587080009d-7, &
         -3.3569097781613661759d-6, 8.7355061305812582974d-5, &
         -6.8021202111645760475d-4, 2.7434654781323362319d-4, &
         1.0031787169953909561d-1, 4.2102443824070833334d-1 / 
      data (b(i), i = 14, 27) / &
         4.1447451117883103686d-12, -3.4026589638576604315d-11, & 
         9.3398790624638977468d-12, 1.5184181750799852630d-9, &
         -1.1364911665083029464d-8, 2.0619457602095915719d-8, &
         3.0431018037572243630d-7, -2.9749736264474555510d-6, &
         8.0143661611467038568d-6, 8.0937525149549218398d-5, &
         -1.0356346549612699886d-3, 2.8534806627578638795d-3, &
         9.7369634474060441807d-2, 3.2175066577856452683d-1 / 
      data (b(i), i = 28, 41) / &
         1.1170882570740727520d-13, -8.2865909408297066068d-11, &
         9.4656678749191182763d-10, -3.5832019841847883380d-9, &
         -9.5017955656904252761d-9, 1.5200595674883329093d-7, &
         -3.8663262571356059980d-7, -3.3350340828235103499d-6, &
         2.9359886663960844231d-5, -1.1266401822556801563d-5, &
         -1.2113572742435576205d-3, 6.3158973673701376253d-3, &
         8.8291790250128171341d-2, 2.2833982383240512262d-1 / 
      data (b(i), i = 42, 55) / &
         -3.2880638807053948433d-11, 4.3194884830465283512d-10, &
         -1.7455089683104033093d-9, -3.2437330799994764516d-9, &
         4.7393655539139519778d-8, -1.1929265603456272466d-8, &
         -1.3177845881013419388d-6, 3.3873375636197969526d-6, &
         3.2729835880668256625d-5, -1.8367283883002494561d-4, &
         -8.2830996454188084408d-4, 9.5512732229514251931d-3, &
         7.2233832113719266702d-2, 1.4753187103603405298d-1 / 
      data (b(i), i = 56, 69) / &
         7.9998492614150860098d-11, -7.0257346702686139490d-10, &
         7.8898821627084586270d-10, 1.1294796399671507085d-8, &
         -1.1360539648638059137d-8, -3.0346309115270564487d-7, &
         3.2235585426189451721d-7, 8.3575612102298214948d-6, &
         -8.5169628089198208211d-6, -2.5740175232173357342d-4, &
         1.2462734014689152770d-4, 1.0683232869192203450d-2, &
         5.1515690033637395779d-2, 8.5465862953544883657d-2 / 
      data (b(i), i = 70, 83) / &
         -8.6111506537356531608d-11, 5.1862926131024597823d-10, & 
         7.5884324949371110022d-10, -6.4011975813006767417d-9, &
         -4.1966181325111763156d-8, 9.1306285446881485314d-8, &
         1.3573638315827954034d-6, 4.8683213252735694701d-7, &
         -3.8805424608710197066d-5, -1.1838986468688980610d-4, & 
         9.2796213947750964945d-4, 8.9611057737319027776d-3, &
         3.1464453915862785606d-2, 4.4267648087536630780d-2 / 
      data (b(i), i = 84, 97) / &
         4.4400123834164610288d-11, -1.1411233140911074336d-10, &
         -8.8200670702467059830d-10, -1.9686735373323381456d-9, &
         1.9921120728941773855d-8, 1.4543974418584834740d-7, &
         1.8238418041265854754d-8, -4.5363700392899066037d-6, &
         -2.1688068222527688542d-5, 4.5496062166687034700d-5, &
         1.0435238076080528284d-3, 5.8374528996419979931d-3, &
         1.6611210710425455850d-2, 2.0756008367065750538d-2 / 
      data (b(i), i = 98, 111) / &
         -6.5166519951106397214d-12, -5.8572182858788539580d-11, &
         1.5550375065815375404d-10, 1.9526509484993563229d-9, &
         9.2637123346818426594d-9, -1.4136471501812055943d-8, &
         -4.3024895710889717172d-7, -2.3235612243330592076d-6, &
         4.0380616133862188804d-7, 9.2783767992909743602d-5, &
         7.2964887597817095035d-4, 3.1316245282223273413d-3, &
         7.8028233022066428316d-3, 9.0014807263791058095d-3 / 
      data (c(i), i = 0, 14) / &
         4.5161032649342790231d-11, -4.2774336988557091369d-11, &
         6.0998467173896677777d-10, 1.9845167242599996944d-9, &
         1.3097678767280215271d-8, 7.4505822268382641286d-8, &
         4.2893920879106814989d-7, 2.3900851955655303104d-6, &
         1.2533473009382380357d-5, 5.9693359063879871983d-5, &
         2.4775070661087304580d-4, 8.5106703131389516508d-4, &
         2.2500105115665788755d-3, 4.0446134454521634600d-3, &
         3.6910983340425942762d-3 / 
      data (c(i), i = 15, 29) / &
         3.5732826433251464989d-12, -3.2906649482312266258d-12, &
         7.0873811190464760555d-11, 2.9551320580484177120d-10, &
         2.2776940472505079894d-9, 1.5175463612815010036d-8, &
         9.9462487812170164133d-8, 6.1448757797853901100d-7, &
         3.4869531882907360750d-6, 1.7615836644757657443d-5, &
         7.6373536037879531886d-5, 2.7098571871205999668d-4, &
         7.3399047381788927036d-4, 1.3439197177355085297d-3, &
         1.2439943280131230863d-3 / 
      data (c(i), i = 30, 44) / &
         3.6343547836242523646d-13, 9.7997961751276137602d-14, &
         1.0184692699811569047d-11, 6.1495184828957652064d-11, &
         5.0238328349302602543d-10, 3.7498626376004337661d-9, &
         2.6689445483857236307d-8, 1.7591899737346368084d-7, &
         1.0486448307010701679d-6, 5.4986458466257148573d-6, &
         2.4521456351751345323d-5, 8.8900942259143832228d-5, &
         2.4483947714068300190d-4, 4.5418248688489693045d-4, &
         4.2479574186923180694d-4 / 
      data (c(i), i = 45, 59) / &
         5.2460389348163395857d-14, 7.4802063026503503540d-14, &
         2.0012201610651998417d-12, 1.4887306044735163359d-11, &
         1.2946705414232940350d-10, 1.0391628915892803144d-9, &
         7.8091180499677328456d-9, 5.3694223626907660084d-8, &
         3.3063914804658509029d-7, 1.7776972424421486506d-6, &
         8.0833148098458320202d-6, 2.9755556304448817780d-5, &
         8.2945928349220642178d-5, 1.5536921180500112883d-4, &
         1.4647070522281538711d-4 / 
      data (c(i), i = 60, 74) / &
         9.7531436733955514559d-15, 2.4084291220447154982d-14, &
         4.7654956400897494468d-13, 4.0200949504810597783d-12, &
         3.6726577109162191533d-11, 3.0939005665422637601d-10, &
         2.4122848979784500179d-9, 1.7071884462645525505d-8, &
         1.0752238955654933405d-7, 5.8844190041189462347d-7, &
         2.7136083303224014597d-6, 1.0102477728604441135d-5, &
         2.8420490721532571809d-5, 5.3637016379451944413d-5, &
         5.0881312956459247572d-5 / 
      data (c(i), i = 75, 89) / &
         2.1732049868189377260d-15, 7.2720052142815590531d-15, &
         1.2803083795536820100d-13, 1.1696825543787717167d-12, &
         1.1083298191597132094d-11, 9.6536661252658773139d-11, &
         7.7242553835198536397d-10, 5.5798366267110575620d-9, &
         3.5721345296543414370d-8, 1.9806931547193682466d-7, &
         9.2312964655319555313d-7, 3.4666258590861079959d-6, &
         9.8224698307751177077d-6, 1.8648773453825584428d-5, &
         1.7780062316167651812d-5 / 
      data (c(i), i = 90, 104) / &
         5.5012463763851934112d-16, 2.2254763392767319419d-15, &
         3.7187669817701214965d-14, 3.5819585377733489628d-13, &
         3.4866061263191556694d-12, 3.1101633450629652910d-11, &
         2.5358235662235617663d-10, 1.8597629779492599046d-9, &
         1.2052654739462999992d-8, 6.7501417351172136833d-8, &
         3.1720052198654584574d-7, 1.1993651363602981832d-6, &
         3.4179130317623363474d-6, 6.5208606745808860158d-6, &
         6.2430205476536771454d-6 / 
      data (c(i), i = 105, 119) / &
         1.5225407517829491689d-16, 6.9834820025664405161d-16, &
         1.1380182837138781431d-14, 1.1369488761077196511d-13, &
         1.1291168681618466716d-12, 1.0250757630526871007d-11, &
         8.4765287317253141514d-11, 6.2886627779402596211d-10, &
         4.1142865598366029316d-9, 2.3223773435632014408d-8, &
         1.0985095234166396934d-7, 4.1766260951820336228d-7, &
         1.1958609263543792991d-6, 2.2907574647671878055d-6, &
         2.2008253973114914005d-6 / 
      data (c(i), i = 120, 134) / &
         4.4863058691420695911d-17, 2.2437356594371819978d-16, &
         3.6107964803015652759d-15, 3.7031193629853392081d-14, &
         3.7341552790439784371d-13, 3.4355950129497564468d-12, &
         2.8719942600171304499d-11, 2.1499646844509516453d-10, &
         1.4171810843455227171d-9, 8.0501118772875784153d-9, &
         3.8281889106330295876d-8, 1.4621673458431979989d-7, &
         4.2029868696411098586d-7, 8.0785884122023473025d-7, &
         7.7845438614204963209d-7 / 
      data (d(i), i = 0, 7) / &
         -7.9737703860537066166d-14, 1.9543834380466766627d-12, &
         -4.7230794431646733538d-11, 1.4001773785771252004d-9, &
         -5.4864553020583098585d-8, 3.1601984250143742772d-6, &
         -3.3708783204090252161d-4, 1.6180215937964160437d-1 / 
      data (d(i), i = 8, 15) / &
         -5.2593898374798632343d-14, 1.7725913926973236457d-12, &
         -4.6672234858122387294d-11, 1.3991653503828889207d-9, &
         -5.4863400156413929639d-8, 3.1601976099900075541d-6, &
         -3.3708783171335864627d-4, 1.6180215937958433760d-1 / 
      data (d(i), i = 16, 23) / &
         -3.6135496189875398132d-14, 1.5466239429618130284d-12, &
         -4.5320259146602122624d-11, 1.3945974109459385552d-9, &
         -5.4853994841172088787d-8, 3.1601858228022739196d-6, &
         -3.3708782339998302320d-4, 1.6180215937704286491d-1 / 
      data (d(i), i = 24, 31) / &
         -2.5640663123518180635d-14, 1.3288079339404032671d-12, &
         -4.3368537955908371563d-11, 1.3848103653102203186d-9, &
         -5.4824335664256344123d-8, 3.1601315173126153586d-6, &
         -3.3708776779035695640d-4, 1.6180215935248373474d-1 / 
      data (d(i), i = 32, 39) / &
         -1.8678321325292127767d-14, 1.1354310934105733311d-12, &
         -4.1057197297998608931d-11, 1.3693990961296350970d-9, &
         -5.4762428935047089835d-8, 3.1599817092775027963d-6, &
         -3.3708756559715893599d-4, 1.6180215923508144240d-1 / 

      if (x .lt. 0.86d0) then
          t = x * x
          y = ((((((a(0) * t + a(1)) * t + &
             a(2)) * t + a(3)) * t + a(4)) * t + & 
             a(5)) * t + a(6)) * t + a(7)
          y = ((((((a(8) * t + a(9)) * t + &
             a(10)) * t + a(11)) * t + a(12)) * t + &
             a(13)) * t + a(14)) * t + a(15) - y * log(x)
      else if (x .lt. 4.15d0) then
          t = x - 5 / x
          k = int(t + 5)
          t = (k - 4) - t
          k = k * 14
          y = ((((((((((((b(k) * t + b(k + 1)) * t + &
             b(k + 2)) * t + b(k + 3)) * t + b(k + 4)) * t + & 
             b(k + 5)) * t + b(k + 6)) * t + b(k + 7)) * t + &
             b(k + 8)) * t + b(k + 9)) * t + b(k + 10)) * t + &
             b(k + 11)) * t + b(k + 12)) * t + b(k + 13)
      else if (x .lt. 12.5d0) then
          k = int(x)
          t = (k + 1) - x
          k = 15 * (k - 4)
          y = (((((((((((((c(k) * t + c(k + 1)) * t + &
             c(k + 2)) * t + c(k + 3)) * t + c(k + 4)) * t + &
             c(k + 5)) * t + c(k + 6)) * t + c(k + 7)) * t + &
             c(k + 8)) * t + c(k + 9)) * t + c(k + 10)) * t + &
             c(k + 11)) * t + c(k + 12)) * t + c(k + 13)) * t + &
             c(k + 14)
      else
          t = 60 / x
          k = 8 * (int(t))
          y = (((((((d(k) * t + d(k + 1)) * t + &
             d(k + 2)) * t + d(k + 3)) * t + d(k + 4)) * t + &
             d(k + 5)) * t + d(k + 6)) * t + d(k + 7)) * &
             sqrt(t) * exp(-x)
      end if
      k0 = y
  end function dbesk0
!

end module bessel_m
