# arch.mk for BerkeleyGW codes
#
# suitable for Stampede at TACC
# module swap mvapich2 impi
# all tests passed 7 Feb 2013, r5074
#
# Note: for parallel compilation, use -j 16
#
# D. Strubbe
# Feb 2013, MIT

COMPFLAG  = -DINTEL
PARAFLAG  = -DMPI
MATHFLAG  = -DUSESCALAPACK
# Only uncomment DEBUGFLAG if you need to develop/debug BerkeleyGW.
# The output will be much more verbose, and the code will slow down by ~20%.
#DEBUGFLAG = -DDEBUG -DVERBOSE

FCPP    = cpp -ansi
F90free = mpiifort -free
LINK    = mpiifort
FOPTS   = -g -O0
FNOOPTS = $(FOPTS)
MOD_OPT = -module 
INCFLAG = -I

C_PARAFLAG = -DPARA -DMPICH_IGNORE_CXX_SEEK
CC_COMP = mpiicpc
C_COMP  = mpiicc
C_LINK  = mpiicpc
C_OPTS  = -O0
C_DEBUGFLAG =

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWPATH     = /opt/apps/intel13/impi_4_1/fftw2/2.1.5
FFTWLIB      = -L$(FFTWPATH)/lib -ldfftw
FFTWINCLUDE  = $(FFTWPATH)/include
MKLPATH      = /opt/apps/intel/13/composer_xe_2013.1.117/mkl/lib/intel64
LAPACKLIB    = -Wl,--start-group $(MKLPATH)/libmkl_intel_lp64.a $(MKLPATH)/libmkl_sequential.a \
               $(MKLPATH)/libmkl_core.a $(MKLPATH)/libmkl_blacs_intelmpi_lp64.a -Wl,--end-group
# -lpthread
SCALAPACKLIB = $(MKLPATH)/libmkl_scalapack_lp64.a

TESTSCRIPT = sbatch stampede.scr
