# arch.mk for BerkeleyGW codes
#
# suitable for Hopper at NERSC with gfortran compiler
# module swap PrgEnv-pgi PrgEnv-gnu
# All tests passed 10/30/2014 r6481 (JRD)
#
# F. H. da Jornada
# Apr 2012, UCB
#
# This .mk file is non-ideal (it doesn't use OpenMP for example). You are encouraged to use hopper.nersc.gov.mk

COMPFLAG  = -DGNU
PARAFLAG  = -DMPI
MATHFLAG  = -DUSESCALAPACK #-DHDF5
# Only uncomment DEBUGFLAG if you need to develop/debug BerkeleyGW.
# The output will be much more verbose, and the code will slow down by ~20%.
#DEBUGFLAG = -DDEBUG -DVERBOSE

FCPP    = /usr/bin/cpp -ansi
F90free = ftn -ffree-form -ffree-line-length-none -fno-second-underscore
LINK    = ftn
FOPTS   = -O3 -march=native -msse -msse2 -msse3 -mfpmath=sse
FNOOPTS = $(FOPTS)
MOD_OPT = -J
INCFLAG = -I

# Use the below for debugging (catching segfaults, unused variables, etc)
#FOPTS   = -g3 -ggdb -fbounds-check  -fcheck=all -Wall 
#FNOOPTS = $(FOPTS)

C_PARAFLAG  = -DPARA -DMPICH_IGNORE_CXX_SEEK
CC_COMP = CC
C_COMP  = cc
C_LINK  = CC
C_OPTS  = -O3 -march=native -msse -msse2 -msse3 -mfpmath=sse
C_DEBUGFLAG =

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWPATH     = /opt/fftw/2.1.5.4
FFTWLIB      = -L$(FFTWPATH)/lib -ldfftw
FFTWINCLUDE  = $(FFTWPATH)/include
# to use HDF5, you'll need to `module load hdf5-parallel` and include -DHDF5 in MATHFLAG
HDF5LIB      = -lhdf5_fortran -lhdf5 -lz
HDF5INCLUDE  = $(HDF5_INCLUDE_OPTS)
#PERFORMANCE  = -L/usr/common/usg/ipm/0.921/lib -lipm
PERFORMANCE  = 

TESTSCRIPT = qsub hopper.scr
