# arch.mk for BerkeleyGW codes
#
# suitable for Hopper at NERSC
# module load cray-hdf5-parallel
#
# D. Strubbe
# Dec 2009, UC Berkeley
#
# Tested and Passed by JRD on 10/20/2014

COMPFLAG  = -DPGI
PARAFLAG  = -DMPI -DOMP
MATHFLAG  = -DUSESCALAPACK -DUNPACKED -DHDF5 -DUSEFFTW3
# Only uncomment DEBUGFLAG if you need to develop/debug BerkeleyGW.
# The output will be much more verbose, and the code will slow down by ~20%.
#DEBUGFLAG = -DDEBUG -DVERBOSE

FCPP    = /usr/bin/cpp -ansi
F90free = ftn -Mfree -mp
LINK    = ftn -mp
FOPTS   = -fast
FNOOPTS = $(FOPTS)
MOD_OPT = -module 
INCFLAG = -I

C_PARAFLAG  = -DPARA -DMPICH_IGNORE_CXX_SEEK
CC_COMP = CC
C_COMP  = cc
C_LINK  = CC
C_OPTS  = -fast
C_DEBUGFLAG =

REMOVE  = /bin/rm -f

# Math Libraries
#
HDF5LIB      = -lhdf5hl_fortran -lhdf5_hl -lhdf5_fortran -lhdf5 -lz
HDF5INCLUDE  = $(HDF5_INCLUDE_OPTS)
FFTWPATH     = /usr/common/usg/fftw-mp/3.3.1
FFTWLIB      = -L$(FFTWPATH)/lib -lfftw3_omp -lfftw3
FFTWINCLUDE  = $(FFTWPATH)/include

PERFORMANCE  = 
#PERFORMANCE  = -L/usr/common/usg/ipm/2.00/lib -lipm 

TESTSCRIPT = qsub hopper.scr
