# arch.mk for BerkeleyGW codes
#
# suitable for Edison at NERSC
# module swap PrgEnv-intel PrgEnv-gnu
#
# JRD
# 2013, NERSC
#
# This version currently does not pass testsuite due to issue with MKL ScaLAPACK and Cray MPICH
# We recommend you use edison.nersc.gov_gnu_libsci.mk or edison.nersc.gov_gnu_libsci_hdf5.mk

# Precompiler options
#
COMPFLAG  = -DGNU
PARAFLAG  = -DMPI -DOMP
MATHFLAG  = -DUSESCALAPACK -DUNPACKED -DUSEFFTW3
# Only uncomment DEBUGFLAG if you need to develop/debug BerkeleyGW.
# The output will be much more verbose, and the code will slow down by ~20%.
#DEBUGFLAG = -DDEBUG -DVERBOSE

FCPP    = /usr/bin/cpp -ansi
F90free = ftn -ffree-form -ffree-line-length-none -fopenmp -fno-second-underscore
LINK    = ftn -fopenmp
FOPTS   = -O3 -ffast-math
FNOOPTS = $(FOPTS)
MOD_OPT = -J 
INCFLAG = -I

C_PARAFLAG  = -DPARA -DMPICH_IGNORE_CXX_SEEK
CC_COMP = CC
C_COMP  = cc
C_LINK  = CC
C_OPTS  = -O3 -ffast-math
C_DEBUGFLAG =

REMOVE  = /bin/rm -f

# Math Libraries
#
MKLROOT            = /opt/intel/composer_xe_2013.1.117/mkl
FFTWLIB     =  $(MKLROOT)/lib/intel64/libmkl_scalapack_lp64.a -Wl,--start-group  $(MKLROOT)/lib/intel64/libmkl_gf_lp64.a $(MKLROOT)/lib/intel64/libmkl_gnu_thread.a $(MKLROOT)/lib/intel64/libmkl_core.a $(MKLROOT)/lib/intel64/libmkl_blacs_intelmpi_lp64.a -Wl,--end-group -ldl -lpthread -lm
FFTWINCLUDE  = /opt/intel/composer_xe_2013.1.117/mkl/include/fftw/
PERFORMANCE  = 

LAPACKLIB = 
TESTSCRIPT = qsub edison.scr
