# arch.mk for BerkeleyGW codes
#
# suitable for Edison at NERSC
# module swap PrgEnv-intel PrgEnv-gnu
#
# JRD
# 2013, NERSC
#
# Do module load cray-hdf5-parallel
# Passes Testsuite as of 10/01/2014

# Precompiler options
#
COMPFLAG  = -DGNU
PARAFLAG  = -DMPI -DOMP
MATHFLAG  = -DUSESCALAPACK -DUNPACKED -DUSEFFTW3 -DHDF5
# Only uncomment DEBUGFLAG if you need to develop/debug BerkeleyGW.
# The output will be much more verbose, and the code will slow down by ~20%.
#DEBUGFLAG = -DDEBUG -DVERBOSE

FCPP    = /usr/bin/cpp -ansi
F90free = ftn -ffree-form -ffree-line-length-none -fopenmp -fno-second-underscore
LINK    = ftn -fopenmp
FOPTS   = -O3
FNOOPTS = $(FOPTS)
MOD_OPT = -J 
INCFLAG = -I

C_PARAFLAG  = -DPARA -DMPICH_IGNORE_CXX_SEEK
CC_COMP = CC
C_COMP  = cc
C_LINK  = CC
C_OPTS  = -O3 -ffast-math
C_DEBUGFLAG =

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWPATH     = /usr/common/usg/fftw/gnu
FFTWLIB      = -L$(FFTWPATH)/lib -lfftw3_omp -lfftw3
FFTWINCLUDE  = /usr/common/usg/fftw/gnu/include
PERFORMANCE  = 

HDF5PATH     =  /opt/cray/hdf5-parallel/1.8.13/GNU/49/
#HDF5PATH     =  /opt/cray/hdf5-parallel/1.8.12/GNU/48/
HDF5LIB      =  $(HDF5PATH)/lib/libhdf5hl_fortran.a \
                $(HDF5PATH)/lib/libhdf5_hl.a \
                $(HDF5PATH)/lib/libhdf5_fortran.a \
                $(HDF5PATH)/lib/libhdf5.a -lz -ldl
HDF5INCLUDE  = $(HDF5PATH)/include

LAPACKLIB = 

TESTSCRIPT = qsub edison.scr
