#!/usr/bin/env python

# Felipe Homrich da Jornada, September 2011

# Python script for updating a test suite given its result.
# It can also help one develop a new test suite: just create the test skeleton
# and the fields you would like to match, and enter zero for the matched
# values. The script will update these numbers accordingly.

import sys

if len(sys.argv)!=4:
	print 'Usage: %s test_result test_input fixed_output'%(sys.argv[0])
	sys.exit()

f_result = open(sys.argv[1])
f_in  = open(sys.argv[2])
f_out = open(sys.argv[3], 'w')

def get_next_match():
	global f_in, f_out
	while 1:
		line = f_in.readline()
		if not line: break
		if line.lstrip()[:5]=='match':
			return line
		f_out.write(line)
	raise Exception('Read past end of file!')

n_fine=0
n_cor=0
for line in f_result.readlines():
	if line[:20] == '   Calculated value ':
		calc_val = line[21:]
	if line[:20] == '   Reference value  ':
		ref_val = line[21:]

	if line[:10] == ' Execution':
		continue

	if '[   OK   ]' in line:
		n_fine += 1
		f_out.write(get_next_match())

	elif '[  FAIL  ]' in line:
		n_cor += 1
		buf = get_next_match()
		idx = buf.rfind(';')
		buf = buf[:idx] + '; ' + calc_val #includes \n!
		f_out.write(buf)

f_out.write(f_in.read())

print 'Summary:'
print '  %d values were fine'%(n_fine)
print '  %d values were corrected'%(n_cor)

f_result.close()
f_in.close()
f_out.close()
