!===============================================================================
!
! Program:
!
! (1) scalapack_main              Originally By gsm        Last Modified 1/29/2009 (gsm)
!
! This program tests the performance of ScaLAPACK library by generating
! a distributed identity matrix times the scaling factor and inverting
! it with ScaLAPACK routines. The matrix size and the scaling factor
! are read from file matrix.inp
!
!===============================================================================

#include "f_defs.h"

program scalapack_main

  use global_m
  use inversion_m
  use scalapack_m
  implicit none

  integer :: itape, nmtx, ii, jj
  character*11 :: mydate
  character*14 :: mytime
  real(DP) :: lambda,diff,dummy
  SCALAR, allocatable :: amat(:,:),bmat(:,:)
  type(scalapack) :: scal
  
  call peinfo_init()
  
  if (peinf%inode .eq. 0) write(6,*) 'number of processors = ', peinf%npes
  
  itape = 25
  
  if (peinf%inode .eq. 0) then
    call open_file(itape, file='matrix.inp', status='old', form='formatted')
    read(itape, *)nmtx
    read(itape, *)lambda
    call close_file(itape)
    write(6,*) 'matrix size nmtx = ', nmtx
    write(6,*) 'scaling factor lambda = ', lambda
  endif
  
#ifdef MPI
  call MPI_BCAST(nmtx,1,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
  call MPI_BCAST(lambda,1,MPI_REAL_DP,0,MPI_COMM_WORLD,mpierr)
#endif
  
  call blacs_setup(scal, nmtx, .true.)
  
  SAFE_ALLOCATE(amat, (scal%npr, scal%npc))
  SAFE_ALLOCATE(bmat, (scal%npr, scal%npc))
  
  if (peinf%inode .eq. 0) then
    call date_time(mydate, mytime)
    write(6,101) mydate, mytime
  endif
  
  if (peinf%inode .eq. 0) write(6,*) 'start generating matrix'
  
  call generate_matrix_d(scal, amat, nmtx, lambda)
  bmat(:,:)=amat(:,:)
  if (peinf%inode.eq.0) then
    write(6,*) 'A = lambda * I where I is identity matrix of size nmtx'
  endif
  
  if (peinf%inode.eq.0) write(6,*) 'done generating matrix'
  
  if (peinf%inode.eq.0) then
    call date_time(mydate, mytime)
    write(6,101) mydate, mytime
  endif
  
  if (peinf%inode.eq.0) write(6,*) 'start inverting matrix'
  
#ifdef USESCALAPACK
  call X(invert_with_scalapack)(nmtx, scal, bmat)
#else
  call X(invert_serial)(nmtx, bmat)
#endif
  
  if (peinf%inode.eq.0) write(6,*) 'done inverting matrix'
  
  if (peinf%inode.eq.0) then
    call date_time(mydate, mytime)
    write(6,101) mydate, mytime
  endif
  
  diff=0.0d0
  do ii=1,scal%npc
    do jj=1,scal%npr
      dummy=abs(bmat(jj,ii)*lambda**2-amat(jj,ii))
      if (dummy.gt.diff) diff=dummy
    enddo
  enddo
#ifdef MPI
  call MPI_Allreduce(diff,dummy,1,MPI_REAL_DP,MPI_MAX,MPI_COMM_WORLD,mpierr)
  diff = dummy
#endif
  if (peinf%inode.eq.0) then
    write(6,*) 'max | A - lambda^2 * A^-1 | = ', diff
  endif
  if (diff .gt. TOL_Zero) call die('matrix inversion failed')
  
  SAFE_DEALLOCATE(amat)
  SAFE_DEALLOCATE(bmat)
  
#ifdef MPI
  call MPI_Finalize(mpierr)
#endif

101 format(1x,'timestamp:',1x,a11,1x,a14)

end program scalapack_main
