
!=================================================================================
!
! Routines:
!
! generate_matrix_d()        Originally by gsm        Last Modified 1/29/2009 (gsm)
!
! This subroutine generates a distributed identity matrix multiplied by lambda
! using scalapack layout. Adapted from subroutine read_matrix_d.
!
!=================================================================================

#include "f_defs.h"

subroutine generate_matrix_d(scal, matrix, nmtx, lambda)

  use global_m
  use scalapack_m
  implicit none

  type (scalapack), intent(in) :: scal
  SCALAR, intent(out) :: matrix(scal%npr,scal%npc)
  integer, intent(in) :: nmtx
  real(DP), intent(in) :: lambda

  integer :: ii, jj

#ifdef USESCALAPACK
  SCALAR, allocatable :: tempcol(:)
  integer :: irow, icol, irowm, icolm
  integer :: icurr
#endif

  PUSH_SUB(generate_matrix_d)

#ifdef USESCALAPACK
  SAFE_ALLOCATE(tempcol, (nmtx))

  icurr=0

  do jj = 1, nmtx
    
    tempcol(:) = ZERO
    tempcol(jj) = lambda
    
    icol=MOD(INT(((jj-1)/scal%nbl)+TOL_SMALL),scal%npcol)
    if (icol .eq. scal%mypcol) then
      do ii = 1, nmtx
        irow=MOD(INT(((ii-1)/scal%nbl)+TOL_SMALL),scal%nprow)
        if (irow .eq. scal%myprow) then
          icurr=icurr+1
          icolm=INT((icurr-1)/scal%npr+TOL_SMALL)+1
          irowm=MOD((icurr-1),scal%npr)+1
          matrix(irowm,icolm)=tempcol(ii)
        endif
      enddo
    endif
    
    call MPI_barrier(MPI_COMM_WORLD,mpierr)
    
  enddo
  
  SAFE_DEALLOCATE(tempcol)

#else

  if(peinf%inode .eq. 0) then
    matrix(:, :) = ZERO
    do jj = 1, nmtx
      matrix(jj, jj) = lambda
    enddo
  endif
  
#endif

  POP_SUB(generate_matrix_d)
  return
  
end subroutine generate_matrix_d
