# arch.mk for BerkeleyGW codes
#
# FORMERLY suitable for Hopper at NERSC with Pathscale compiler
# libsci is no longer supported with Pathscale, so linking will fail
#
# module swap PrgEnv-pgi PrgEnv-pathscale
# module swap pathscale pathscale/4.0.9
# All tests passed 1 Nov 2011 r3493
#
# D. Strubbe
# Feb 2011, UCB

# Precompiler options
#
COMPFLAG  = -DPATH
PARAFLAG  = -DMPI
MATHFLAG  = -DUSESCALAPACK
DEBUGFLAG = -DDEBUG -DVERBOSE

FCPP    = /usr/bin/cpp -ansi
F90free = ftn -freeform -intrinsic=EVERY
LINK    = ftn
FOPTS   = -O3
FNOOPTS = -O2
# -O3 generates correct code, but takes forever
MOD_OPT = -module 
INCFLAG = -I

C_PARAFLAG  = -DPARA -DMPICH_IGNORE_CXX_SEEK
CC_COMP = CC
C_COMP  = cc
C_LINK  = CC
# surface.cpp with pathCC -O3 gives garbage results
C_OPTS  = -O3

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWPATH     = /opt/fftw/2.1.5.4
FFTWLIB      = -L$(FFTWPATH)/lib -ldfftw
FFTWINCLUDE  = $(FFTWPATH)/include
#PERFORMANCE  = -L/usr/common/usg/ipm/0.921/lib -lipm
PERFORMANCE  = 

TESTSCRIPT = qsub hopper.scr
