# arch.mk for BerkeleyGW codes
#
# suitable for hodduk.mit.edu
# openmpi-1.4/intel
#
# D. Strubbe
# Oct 2012, MIT

COMPFLAG  = -DINTEL
PARAFLAG  = -DMPI
MATHFLAG  = -DUSESCALAPACK
DEBUGFLAG = -DDEBUG -DVERBOSE

FCPP    = cpp -ansi
F90free = mpif90 -free
LINK    = mpif90 -i-static -openmp
FOPTS   = -O3 -no-prec-div
FNOOPTS = -O2 -no-prec-div
MOD_OPT = -module 
INCFLAG = -I

C_PARAFLAG = -DPARA
CC_COMP = mpiCC
C_COMP  = mpicc
C_LINK  = mpiCC
C_OPTS  = -O3

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWPATH     = /usr/local
FFTWLIB      = $(FFTWPATH)/lib/libfftw.a
FFTWINCLUDE  = /opt/intel/mkl/include/fftw
MKLPATH      = /opt/intel/mkl/lib/intel64
LAPACKLIB    = -Wl,--start-group $(MKLPATH)/libmkl_intel_lp64.a $(MKLPATH)/libmkl_sequential.a \
               $(MKLPATH)/libmkl_core.a $(MKLPATH)/libmkl_blacs_openmpi_lp64.a -Wl,--end-group -lpthread
SCALAPACKLIB = $(MKLPATH)/libmkl_scalapack_lp64.a

TESTSCRIPT = qsub hodduk.scr
