!==============================================================================
!
! Routines()
!
! (1) write_xct()       Originally By MLT       Last Modified 6/2008 FJR
!
!     Writes out the wavefunction.
!
!=============================================================================

#include "f_defs.h"

subroutine write_xct(es_eV,rh_avec,avec_a0,pstate,nk,nfft,scfft)

  use global_m
  implicit none

  real(DP), intent(in) :: es_eV
  real(DP), intent(in) :: rh_avec(3)
  real(DP), intent(in) :: avec_a0(3,3)
  integer, intent(in) :: pstate
  integer, intent(in) :: nk(3)
  integer, intent(in) :: nfft(3)
  complex(DPC), intent(in) :: scfft(nk(1)*nfft(1),nk(2)*nfft(2),nk(3)*nfft(3))
  
  integer :: i1,i2,i3
  integer :: nw(3)
  character :: fn*13
  real(DP) :: rh_a0(3)

  PUSH_SUB(write_xct)
  
  nw(:) = nfft(:) * nk(:)
  rh_a0 = matmul(rh_avec, avec_a0)
  
  write(6,*) 'Enter write_xct'

!-----------------------------
! Print output data

  write(fn,'(a,i3.3,a)') 'xct.', pstate, '.a3Dr'
  
  write(6,'(a,a,a,3i8)') 'Writing data set to "', fn, '" with nw = ',nw(:)
  
  call open_file(30,file=fn,form='formatted',status='replace')
  
  write(30, '(a,i3)') '# ie = ', pstate
  write(30, '(a,f12.4,a)') '# e  = ', es_eV, ' eV'
  write(30, '(a,3f14.6,a)') '# rh = ', rh_a0, ' a0'
  write(30, '(a)') '#'
  write(30, '(a)') '# unit cell'
  write(30, '(a,3f14.6,a)') '# a1 = ', nk(1) * avec_a0(1,1:3), ' a0'
  write(30, '(a,3f14.6,a)') '# a2 = ', nk(2) * avec_a0(2,1:3), ' a0'
  write(30, '(a,3f14.6,a)') '# a3 = ', nk(3) * avec_a0(3,1:3), ' a0'
  write(30, '(a)') '#'
  ! only write 1/8 = (1/2)^3 of the full data to save disk space
  write(30, '(a,3i8)') '# ni = ', (nw(:)+1) / 2
  write(30, '(a)') '#'
  write(30, '(a)') '#    real         imag        abs^2'
  
  do i3 = 1, nw(3), 2
    do i2 = 1, nw(2), 2
      do i1 = 1, nw(1), 2
        write(30, '(3es13.5)') scfft(i1, i2, i3),abs(scfft(i1, i2, i3))**2
      enddo
      write(30,*)
    enddo
    write(30,*)
  enddo
  
  call close_file(30)
  
  POP_SUB(write_xct)
  
  return
end subroutine write_xct
