
#include "f_defs.h"

!-----------------------------------------------------------------------
subroutine input_q(crys,gvec,kg,kgq,syms,xct,indexq)
!-----------------------------------------------------------------------
!
!     input: crys, gvec, kg,  syms, xct types
!
!     output: kgq type
!             indexq(1:xct%nkpt_fi) : mapping of points in shifted grid
!             INT_VWFNQ_* files
!
  use global_m
  use fullbz_m
  use misc_m
  use wfn_rho_vxc_io_m
  implicit none

  type (crystal), intent(in) :: crys
  type (gspace), intent(in) :: gvec
  type (grid), intent(in) :: kg
  type (grid), intent(out) :: kgq
  type (symmetry), intent(in) :: syms
  type (xctinfo), intent(inout) :: xct
  integer, intent(out) :: indexq(xct%nkpt)

  type (crystal) :: crysq
  type (wavefunction) :: wfnv
  type (kpoints) :: kpq
  type (symmetry) :: symsq
  character :: filenamev*20
  character :: tmpfn*16, errmsg*100
  integer :: itpv,iwrite
  integer :: ii,jj,kk,ik,ikq,irkq
  integer :: dest,tag
  integer :: nofullbz
  real(DP) :: delta,qq(3),tol
  integer, allocatable :: isend(:)
  SCALAR, allocatable :: cg(:,:)

  character(len=3) :: sheader
  integer :: iflavor
  type(gspace) :: gvecq, gvec_kpt
  logical :: irkq_match

  logical :: skip_checkbz
  
  PUSH_SUB(input_q)

!-----------------------------------------------------------------------
!     Read data in WFNq_fi

  if(peinf%inode.eq.0) call open_file(unit=26,file='WFNq_fi',form='unformatted',status='old')

  sheader = 'WFN'
  iflavor = 0
  call read_binary_header_type(26, sheader, iflavor, kpq, gvecq, symsq, crysq, warn = .false.)

  call check_header('WFN_fi', kpq, gvec, syms, crys, 'WFNq_fi', kpq, gvecq, symsq, crysq, is_wfn = .true.)
  ! there is no kp object in this code??

  kpq%nvband=minval(kpq%ifmax(:,:)-kpq%ifmin(:,:))+1
  if(xct%nvband.gt.kpq%nvband) then
    write(errmsg,'(a,i6,a,i6,a)') 'You requested ', xct%nvband, ' valence bands but WFNq_fi contains only ', kpq%nvband, '.'
    call die(errmsg, only_root_writes = .true.)
  endif
  
  SAFE_ALLOCATE(gvecq%k, (3, gvec%ng))
  call read_binary_gvectors(26, gvec%ng, gvec%ng, gvecq%k, dont_read = .true.)
  SAFE_DEALLOCATE_P(gvecq%k)

!
!     Define shifted irreducible BZ, kgq%r, and define the shift vector
!     (if not done before). Make sure it is right!
!
  kgq%nr=kpq%nrk
  SAFE_ALLOCATE(kgq%r, (3,kgq%nr))
  kgq%r(1:3,1:kgq%nr)=kpq%rk(1:3,1:kpq%nrk)
  xct%qshift= sqrt( DOT_PRODUCT(xct%shift(:), &
    MATMUL(crys%bdot,xct%shift(:) )) )
  if (xct%qshift.eq.0.d0) then
    xct%shift(:)=kgq%r(:,1)-kg%r(:,1)
    xct%qshift= sqrt( DOT_PRODUCT(xct%shift(:), &
      MATMUL(crys%bdot,xct%shift(:) )) )
  endif
  if(peinf%inode.eq.0) write(6,90) xct%shift(:),xct%qshift
90 format(/,2x,'Shift vector : ',3f9.5,2x,'Length =',f8.5,/)

!-----------------------------------------------------------------------
!     Generate full brillouin zone from irreducible wedge, rk -> fk
!      (nofullbz has the same meaning as in input.f90)

  nofullbz=0
  if (nofullbz.eq.1) then
    call fullbz(crys,symsq,kgq,1,skip_checkbz,wigner_seitz=.true.,paranoid=.true.)
  else
    call fullbz(crys,symsq,kgq,symsq%ntran,skip_checkbz,wigner_seitz=.true.,paranoid=.true.)
  endif
  tmpfn='WFNq_fi'
  if (.not. skip_checkbz) then
    call checkbz(kgq%nf,kgq%f,kpq%kgrid,kpq%shift,crys%bdot, &
      tmpfn,'k',.true.,xct%freplacebz,xct%fwritebz)
  endif

!-----------------------------------------------------------------------
!     Find correspondence with fk from WFNq_fi
!
!     indexq : correspondence between a k-point in the full BZ, kg%f, and
!       its shifted vector, in kgq%f
!     tol : tolerance

  tol = 1.d-6
  do ik=1,kg%nf
    ikq=0
    delta=0.1d0
    do while((delta.gt.tol).and.(ikq.lt.kgq%nf))
      ikq=ikq+1
      qq(:) = kg%f(:,ik)-(kgq%f(:,ikq)-xct%shift(:))
      do kk=1,3
        qq(kk) = qq(kk) - anint( qq(kk) )
      enddo
      delta=sqrt((qq(1))**2+(qq(2))**2+(qq(3))**2)
    enddo
    if(delta.gt.tol) then
      if(peinf%inode.eq.0) then
        write(0,'(a,3f12.6)') 'Could not find point equivalent to ', (kg%f(ii,ik),ii=1,3)
      endif
      call die('k-point mismatch between WFN_fi and WFNq_fi.', only_root_writes = .true.)
    else
!
!     make sure that kgq%f(:,ikq)-kg%f(:,ik) = shift vector
!     Near the zone edge, they may differ by a lattice vector
!
      do jj=1,3
        ii = nint( kgq%f(jj,ikq)-kg%f(jj,ik) )
        kgq%f(jj,ikq) = kgq%f(jj,ikq) - dble(ii)
        kgq%kg0(jj,ikq) = kgq%kg0(jj,ikq) - ii
      enddo
      qq(:) = kg%f(:,ik)-(kgq%f(:,ikq)-xct%shift(:))
      delta=sqrt((qq(1))**2+(qq(2))**2+(qq(3))**2)
      if (delta.gt.tol) then
        call die('k-point mismatch between WFN_fi and WFNq_fi. Wrong shift', only_root_writes = .true.)
      endif
      indexq(ik)=ikq
    endif
  enddo

!-----------------------------------------------------------------------
!     Read the wavefunctions and create INT_VWFNQ_*

  wfnv%nband=xct%nvband
  wfnv%nspin=kpq%nspin
  
  if(peinf%inode.lt.10000) then
    write(filenamev,'(a,i4.4)') 'INT_VWFNQ_', peinf%inode
  else
    call die('input_q: cannot use more than 10000 nodes')
  endif
  itpv=128+(2*peinf%inode)+2
  call open_file(itpv,file=filenamev,form='unformatted',status='replace')
  
  SAFE_ALLOCATE(wfnv%isort, (gvec%ng))
  do irkq = 1, kpq%nrk
    irkq_match = .false.
    do ii=1,kg%nf
      if (irkq == kgq%indr(indexq(ii))) then
        irkq_match = .true.
        exit
      endif
    enddo
    
    SAFE_ALLOCATE(gvec_kpt%k, (3, kpq%ngk(irkq)))
    call read_binary_gvectors(26, kpq%ngk(irkq), kpq%ngk(irkq), gvec_kpt%k)
    
    SAFE_ALLOCATE(cg, (kpq%ngk(irkq), kpq%nspin))
    if(irkq_match) then
      do ii = 1, kpq%ngk(irkq)
        call findvector(wfnv%isort(ii), gvec_kpt%k(1, ii), gvec_kpt%k(2, ii), gvec_kpt%k(3, ii), gvec)
        if(wfnv%isort(ii) == 0) call die('input_q: could not find gvec')
      enddo
!
      wfnv%ng = kpq%ngk(irkq)
      SAFE_ALLOCATE(wfnv%cg, (wfnv%ng,wfnv%nband,wfnv%nspin))

!       Determine which PEs will write the valence bands for this k-point
      iwrite=0
      do ii=1, peinf%ikt(peinf%inode+1)
        if(kgq%indr(indexq(peinf%ik(peinf%inode+1,ii))) == irkq) then
          iwrite=1
          exit
        endif
      enddo
      
!       Determine to which PEs the valence bands for this k-point
!       need to be sent...
      SAFE_ALLOCATE(isend, (peinf%npes))
      isend=0
      if(peinf%inode.eq.0) then
        do jj=2,peinf%npes
          do ii=1, peinf%ikt(jj)
            if(kgq%indr(indexq(peinf%ik(jj,ii))).eq.irkq) then
              isend(jj)=1
              exit
            endif
          enddo
        enddo
      endif
    endif
!
!       Loop over the bands
!
    do ii=1,kpq%mnband
      call read_binary_data(26, kpq%ngk(irkq), kpq%ngk(irkq), kpq%nspin, cg)
      
      if(.not. irkq_match) cycle
      
      if(peinf%inode.eq.0) then
!           Check normalization of this band
        do kk=1,kpq%nspin
          call checknorm('WFNq_fi',ii,irkq,kk,kpq%ngk(irkq),cg(:, kk))
        enddo
      endif
      
!         If ii is one of the selected valence band...
      if((ii.le.kpq%nvband).and.(ii.gt.kpq%nvband-xct%nvband)) then
#ifdef MPI
        if(peinf%inode.eq.0) then
          do jj=2,peinf%npes
            if(isend(jj).eq.1) then
              dest=jj-1
              tag=1000+dest
              call MPI_SEND(cg,kpq%ngk(irkq)*kpq%nspin,MPI_SCALAR, &
                dest,tag,MPI_COMM_WORLD,mpierr)
            endif
          enddo
        else
          if(iwrite.eq.1) then
            tag=1000+peinf%inode
            call MPI_RECV(cg,kpq%ngk(irkq)*kpq%nspin,MPI_SCALAR, &
              0,tag,MPI_COMM_WORLD,mpistatus,mpierr)
          endif
        endif
#endif
        
        if(iwrite.eq.1) &
          wfnv%cg(1:wfnv%ng,kpq%nvband-ii+1,1:wfnv%nspin)=cg(1:wfnv%ng,1:wfnv%nspin)
        
      endif !ii is one of the selected valence band
      
    enddo

    SAFE_DEALLOCATE(cg)
    if(.not. irkq_match) cycle

    if(iwrite.eq.1) then
      
      write(itpv) irkq,wfnv%ng,wfnv%nband,wfnv%nspin
      write(itpv) (wfnv%isort(ii),ii=1,gvec%ng), &
        (((wfnv%cg(ii,jj,kk),ii=1,wfnv%ng),jj=1,wfnv%nband), kk=1,wfnv%nspin)
    endif
    
    SAFE_DEALLOCATE(isend)
    SAFE_DEALLOCATE_P(wfnv%cg)
    
  enddo !end loop over k-points

  SAFE_DEALLOCATE_P(wfnv%isort)
  
  if (peinf%inode.eq.0) then
    SAFE_DEALLOCATE_P(kpq%rk)
    SAFE_DEALLOCATE_P(kpq%ifmin)
    SAFE_DEALLOCATE_P(kpq%ifmax)
    SAFE_DEALLOCATE_P(kpq%el)
  endif
  
!-------------------------------
! Write out info about xtal

  if(peinf%inode.eq.0) then
    write(6,4004)
4004 format(/,2x,'crystal wavefunctions read from tape WFNq_fi')
    write(6,3007) kgq%nr
3007 format(/,6x,'nrk= ',i6,26x)
    write(6,3070) kgq%nf,kgq%sz
3070 format(/,6x,'  fine grid     nfk= ',i6,4x,'ksz=',f10.5)
    
    call close_file(26)
  endif !end if(inode.eq.0)
  
  call close_file(itpv)

  ! only needed for comm_disk
#ifdef MPI
  call MPI_Barrier(MPI_COMM_WORLD, mpierr)
#endif

  POP_SUB(input_q)

  return
end subroutine input_q
