!===========================================================================
!
! Module mtxelmultiply_m
!
! (1) mtxelMultiply()   Refactored from main.f90 By (PWD)     
!                                           Last Modified 10/21/2010 (PWD)
!
!     Combine the <v,k+q|e^(-i(q+G).r)|c,k><c,k|e^(i(q+G).r)|v,k+q>
!                 -------------------------------------------------
!                                  energy denominator
!     On exit,
!       pol%eden(band,spin) = 1/(e_val-e_cond) = energy denominators
!       pol%gme(band,g-vector,spin) = plane wave matrix elements
!       pol%gmeExtra(band,g-vector,spin) = plane wave matrix elements
!                                          for the extrapolar correction
!       pol%isrtx   orders the |G(i)|^2   i=1,pol%nmtx
!       vwfn%isort  orders |qk+g|^2    (in vwfn type)
!
!       energies are apparently assumed in Rydbergs.
!
!===========================================================================

#include "f_defs.h"

module mtxelmultiply_m

  use global_m
  use blas_m
  use scalapack_m
  implicit none

  public :: &
    mtxelMultiply

contains

  subroutine mtxelMultiply(scal,ntot,nrq,nst,fact,vwfn,gmetempn,gmetempr,gmetempc,xilocal, &
    polgme,pol,indt,pht,ipe,ispin,tsec)
    type (scalapack), intent(in) :: scal
    integer, intent(in) :: ntot
    integer, intent(in) :: nrq
    integer, dimension(nrq), intent(in) :: nst  
    real(DP), intent(in) :: fact
    type (valence_wfns), intent(in) :: vwfn
    SCALAR, dimension(:), intent(inout) :: gmetempn(:)
    SCALAR, dimension(:,:), intent(inout) :: gmetempr(:,:),gmetempc(:,:)
    SCALAR, dimension(:,:), intent(inout) :: xilocal(:,:)
    SCALAR, intent(in) :: polgme(:,:,:,:,:)
    type (polarizability), intent(inout) :: pol
    integer, dimension(:,:,:), intent(in) :: indt
    SCALAR, dimension(:,:,:), intent(in) :: pht
    integer, intent(in) :: ipe
    integer, intent(in) :: ispin
    real(DP), dimension(2), intent(inout) :: tsec
    
    integer :: irq, iv, ilimit, j, it, icurr, itot
    
    PUSH_SUB(mtxelMultiply)
    
    itot=0
    
    if (peinf%inode.eq.0) call timacc(31,1,tsec)
    
    do irq = 1, nrq
      do iv = 1,vwfn%nband+pol%ncrit
        if (peinf%doiownv(iv) .eq. 1) then
          ilimit = peinf%ncownt
        else
          ilimit = 0
        endif
        do j = 1, ilimit 
          
          gmetempn(:) = polgme(:,j,peinf%indexv(iv), &
            ispin,irq) * sqrt(fact)
          
          do it = 1, nst(irq) 
            itot = itot + 1
            
            do icurr=1,scal%nprd(ipe)
              gmetempr(icurr,itot)=gmetempn( &
                indt(scal%imyrowd(icurr,ipe),it,irq))*pht( &
                scal%imyrowd(icurr,ipe),it,irq)
              
            enddo
            
            do icurr=1,scal%npcd(ipe)
              gmetempc(itot,icurr)= &
                MYCONJG(gmetempn(indt(scal%imycold(icurr,ipe),it,irq))*pht(scal%imycold(icurr,ipe),it,irq))
              
            enddo
          enddo ! it
        enddo ! j
      enddo ! iv
    enddo ! irq
    
    if (peinf%inode.eq.0) call timacc(31,2,tsec)
    
    if (peinf%inode.eq.0) call timacc(30,1,tsec)
    
    if (ntot.ne.0) then
      call X(GEMM)('n','n',scal%nprd(ipe),scal%npcd(ipe),ntot, &
        -ONE,gmetempr,scal%nprd(ipe),gmetempc,ntot,ZERO,xilocal,scal%nprd(ipe))
    end if
    
    if (peinf%inode.eq.0) call timacc(30,2,tsec)
    
    POP_SUB(mtxelMultiply)
    
    return
    
  end subroutine mtxelMultiply
  
end module mtxelmultiply_m
