!===========================================================================
!
! Routines()
!
! (1) mtxel()   Originally By (?)               Last Modified 5/9/2008 (JRD)
!
!     Compute matrix elements for valence state iv with all
!     conduction bands and for all g-vectors.
!
!                <c rq spinc|exp(-ig.r)|v rq spinv>
!
!     On exit,
!       pol%eden(band,spin) = 1/(e_val-e_cond) = energy denominators
!       pol%gme(band,g-vector,spin) = plane wave matrix elements
!       pol%gmeExtra(band,g-vector,spin) = plane wave matrix elements
!                                          for the extrapolar correction
!       pol%isrtx   orders the |G(i)|^2   i=1,pol%nmtx
!       vwfn%isort  orders |qk+g|^2    (in vwfn type)
!
!       energies are apparently assumed in Rydbergs.
!
!===========================================================================

#include "f_defs.h"

subroutine mtxel(iv,gvec,vwfn,cwfn,pol,ispin,irq)

  use global_m
  use fftw_m
  use misc_m
  implicit none
  
  integer, intent(in) :: iv
  type (gspace), intent(in) :: gvec
  type (valence_wfns), intent(in) :: vwfn
  type (conduction_wfns), intent(in) :: cwfn
  type (polarizability), intent(inout) :: pol
  integer, intent(in) :: ispin, irq

  integer :: j, iband,jcad
  real(DP), allocatable :: edenTemp(:)
  real(DP) :: eval,econd,ecbar,tsec(2),occ_v,occ_c,occ_diff
      
  integer, dimension(3) :: Nfft
  real(DP) :: scale
  complex(DPC), dimension(:,:,:), allocatable :: fftbox1,fftbox2
  SCALAR, dimension(:), allocatable :: tmparray

  PUSH_SUB(mtxel)

!-----------------------
! Compute energy denominators; eden depends on which iv we treat

  if(peinf%inode.eq.0) call timacc(25,1,tsec)
  if (pol%freq_dep .eq. 2) then
    SAFE_ALLOCATE(edenTemp, (cwfn%nband-vwfn%nband))
    edentemp(:)=0D0
  endif

  do j=vwfn%nband+1,cwfn%nband
    
    iband=j-vwfn%nband
    eval=vwfn%ev(iv,ispin)
    
    econd=cwfn%ec(j,ispin)
    
    ! guess occupations based on efermi; eventually this should be replaced by use of kp%occ
    if(eval*ryd > pol%efermi + TOL_Degeneracy) then
      occ_v = 0d0
    else if (eval*ryd < pol%efermi - TOL_Degeneracy) then
      occ_v = 1d0
    else
      occ_v = 0.5  ! within TOL_Degeneracy of the Fermi level, use FD(E_F) = 1/2
    endif

    if(econd*ryd > pol%efermi + TOL_Degeneracy) then
      occ_c = 0d0
    else if (econd*ryd < pol%efermi - TOL_Degeneracy) then
      occ_c = 1d0
    else
      occ_c = 0.5  ! within TOL_Degeneracy of the Fermi level, use FD(E_F) = 1/2
    endif

    occ_diff = occ_v - occ_c

! JRD/JBN: If ncrit is specified we have a metal

    if(pol%freq_dep .eq. 0) then
      if(pol%extrapolarmethod.eq.1) then
        ecbar = cwfn%ec(cwfn%nband,ispin) + pol%extraPolarEnergy
      endif
      if(eval - econd < TOL_Degeneracy .and. occ_diff > TOL_Zero) then
        ! avoid dividing by zero or making eden > 0
        pol%eden(iv,iband,ispin) = occ_diff / (eval - econd)
      else
        pol%eden(iv,iband,ispin) = 0d0 ! in this case, occ_diff = 0 too
      endif
      
      if(pol%extrapolarmethod.eq.1) then
        if(eval - ecbar < TOL_Degeneracy .and. occ_diff > TOL_Zero) then
          pol%edenExtraPolar(iv,ispin) = occ_diff / (eval - ecbar)
        else
          pol%edenExtraPolar(iv,ispin) = 0d0
        endif
      endif
    endif
    
    if(pol%freq_dep .eq. 2) then
      if (peinf%doiownv(iv) .eq. 0) then
        POP_SUB(mtxel)
        return
      endif

      if(eval - econd < TOL_Degeneracy .and. occ_diff > TOL_Zero) then
        edenTemp(iband) = (eval - econd) / occ_diff
      else
        edenTemp(iband) = 0.0d0
        !!write(6,*) peinf%inode,' In a O band pair',iv,iband
      endif
    endif
  enddo

  if (pol%freq_dep .eq. 2) then
    if (peinf%doiownv(iv) .eq. 1) then
      do j = 1, peinf%ncownt
        pol%edenDyn(peinf%indexv(iv),j,ispin,irq) = edenTemp(peinf%invindexc(j))
      enddo
    endif
    SAFE_DEALLOCATE(edenTemp)
  endif
  
  if(peinf%inode.eq.0) call timacc(25,2,tsec)
  
  if (peinf%doiownv(iv) .eq. 0) then
    POP_SUB(mtxel)
    return
  endif

  if(peinf%inode.eq.0) call timacc(26,1,tsec)

!-------------------- Calculate Matrix Elements -------------------------------


!--------------------------
! Use FFTs to calculate matrix elements

! Compute size of FFT box we need

  call setup_FFT_sizes(gvec%kmax,Nfft,scale)

! Allocate FFT boxes

  SAFE_ALLOCATE(fftbox1, (Nfft(1),Nfft(2),Nfft(3)))
  SAFE_ALLOCATE(fftbox2, (Nfft(1),Nfft(2),Nfft(3)))

! Put the data for valence band iv into FFT box 1 and do the FFT

  call put_into_fftbox(vwfn%nkptv,vwfn%zv(:,ispin),gvec%ng,gvec%k,vwfn%isort,fftbox1,Nfft)

  call do_FFT(fftbox1,Nfft,1)

! We need the complex conjugate of the |ivk> band actually

  call conjg_fftbox(fftbox1,Nfft)

! Now we loop over the conduction states and get the matrix elements:
! 1. Get conduction wave function and put it into box 2,
! 2. do FFT,
! 3. multiply by box1 contents,
! 4. do FFT again, and extract the resulting matrix elements and put the into pol
! We conjugate the final result since we really want <c|e^(-ig.r)|v>
! but we have calculated <v|e^(ig.r)|c>.

  SAFE_ALLOCATE(tmparray, (pol%nmtx))
  
  do j=1,peinf%ncownt
    iband = peinf%invindexc(j)
    jcad = (j-1)*cwfn%nkptc
    call put_into_fftbox(cwfn%nkptc,cwfn%zc(jcad+1:,ispin),gvec%ng,gvec%k,cwfn%isort,fftbox2,Nfft)

    call do_FFT(fftbox2,Nfft,1)

    call multiply_fftboxes(fftbox1,fftbox2,Nfft)
    
    call do_FFT(fftbox2,Nfft,1)
    
    call get_from_fftbox(pol%nmtx,tmparray,gvec%ng,gvec%k,pol%isrtx,fftbox2,Nfft,scale)

    pol%gme(1:pol%nmtx,j,peinf%indexv(iv),ispin,irq) = MYCONJG(tmparray)

! JRD: Debugging of mtxel symmetries

!    do ijk = 1, pol%nmtx
!      call findvector(ijkm,-gvec%k(1,pol%isrtx(ijk)),-gvec%k(2,pol%isrtx(ijk)),-gvec%k(3,pol%isrtx(ijk)),gvec)
!      ijkm=pol%isrtxi(ijkm)
!      if (ijkm .le. pol%nmtx) then
!        write(3003,*) iv,j,ijk,ijkm,Abs(pol%gme(ijk,j,peinf%indexv(iv),ispin,irq))-Abs(pol%gme(ijkm,j,peinf%indexv(iv),ispin,irq))
!      endif
!    enddo
     
    if (pol%freq_dep .eq. 0) then
      pol%gme(1:pol%nmtx,j,peinf%indexv(iv),ispin,irq) = &
        pol%gme(1:pol%nmtx,j,peinf%indexv(iv),ispin,irq) * &
        sqrt(-1D0*pol%eden(iv,iband,ispin))

      if(pol%extrapolarmethod.eq.1) then
        pol%gmeExtra(1:pol%nmtx,j,peinf%indexv(iv),ispin,irq) = MYCONJG(tmparray)
        pol%gmeExtra(1:pol%nmtx,j,peinf%indexv(iv),ispin,irq) = &
          pol%gmeExtra(1:pol%nmtx,j,peinf%indexv(iv),ispin,irq) * &
          sqrt(-1D0*pol%edenExtraPolar(iv,ispin))
      endif
    endif
    
  enddo
  
  SAFE_DEALLOCATE(tmparray)

! We are done, so deallocate FFT boxes

  SAFE_DEALLOCATE(fftbox1)
  SAFE_DEALLOCATE(fftbox2)


! End FFT Case
!---------------------------

! End Calculation of matrix elements
!----------------------------------------------------------------------------

!--------- Renormalize q-->0 matrix elements by q0norm -----------------------

! SIB: gvec%k(:,isave) is the null vector.  Used to scale by 1/q0
! at the end.
! JRD:  The set of entries in gme with g-vector index isave (g=0)
! are divided by q0norm.  JRD: But if we truncate, we will include
! this factor in epsinv.f90

  if(peinf%inode.eq.0) call timacc(26,2,tsec)

  POP_SUB(mtxel)

  return
end subroutine mtxel
