!===========================================================================
!
! Module extrapolar_m
!
! (1) mtxelGpGExtraPolar()   Originally By (PWD)
!                                         Last Modified 5/9/2008 (PWD)
!
!     Derived in part from mtxel.f90
!
!     Compute matrix elements for first term of extrapolar correction
!     valence state iv with all for all g-vectors.
!
!                <v spinv|exp(i(gp-g).r)|v spinv>
!
!     On exit,
!       pol%gpgExtraPolar(iv,gp-g-vector,spin) = plane wave matrix elements
!       pol%edenExtraPolar(iv, spin) = 1/(e_val-e_cavg)
!
!       energies are apparently assumed in Rydbergs.
!
! (2) applyExtrapolarDeltaTerm()   Refactored from main.f90 By (PWD)     
!                                           Last Modified 10/26/2010 (PWD)
!
!     apply the <v,k+q|e^(i(Gp-G).r)|v,k+q>
!                 ------------------------------
!                     energy denominator
!     On exit,
!       pol%eden(band,spin) = 1/(e_val-e_cond) = energy denominators
!       pol%gme(band,g-vector,spin) = plane wave matrix elements
!       pol%gmeExtra(band,g-vector,spin) = plane wave matrix elements
!                                          for the extrapolar correction
!       pol%isrtx   orders the |G(i)|^2   i=1,pol%nmtx
!       vwfn%isort  orders |qk+g|^2    (in vwfn type)
!
!       energies are apparently assumed in Rydbergs.
!
!===========================================================================

#include "f_defs.h"

module extrapolar_m

  use global_m
  use fftw_m
  use misc_m
  use scalapack_m

  implicit none

  public ::                   &
    mtxelGpGExtraPolar,       &
    applyExtrapolarDeltaTerm

contains

  subroutine mtxelGpGExtraPolar(iv, gvec, vwfn, cwfn, pol, ispin, irq)
    integer, intent(in) :: iv
    type (gspace), intent(in) :: gvec
    type (valence_wfns), intent(in) :: vwfn
    type (conduction_wfns), intent(in) :: cwfn
    type (polarizability), intent(inout) :: pol
    integer, intent(in) :: ispin, irq
    
    real(DP) :: eval,econd,ecbar,tsec(2)
    integer, dimension(3) :: Nfft
    integer :: GMinusGP
    real(DP) :: scale
    
    complex(DPC), dimension(:,:,:), allocatable :: fftbox1,fftbox2
    SCALAR, dimension(:), allocatable :: tmparray
    
    PUSH_SUB(mtxelGpGExtraPolar)
    
    if(peinf%inode.eq.0) call timacc(32,1,tsec)
    
    if(peinf%inode.eq.0) write (6,*) 'called mtxelGpG for irq', irq

! PWD: extrapolar Energy Denominator
!      hopefully still supporting the scissors

    eval=vwfn%ev(iv,ispin)
    econd=cwfn%ec(cwfn%nband,ispin)
    eval=eval+vwfn%evs/ryd+vwfn%evdel*(eval-vwfn%ev0/ryd)
    ecbar=econd + pol%extraPolarEnergy
    
    if(pol%ncrit .eq. 0) then
      pol%edenExtraPolar(iv,ispin) = 1.0d0/(eval-ecbar)
    else
      if (eval*ryd.gt.pol%efermi) then
        pol%edenExtraPolar(iv,ispin) = 0.0d0
      else
        pol%edenExtraPolar(iv,ispin) = 1.0d0/(eval-ecbar)
      endif
    endif
    
    if(peinf%inode.eq.0) call timacc(32,2,tsec)
    
    if (peinf%doiownv(iv) .eq. 0) then
      POP_SUB(mtxelGpGExtraPolar)
      return !we`re done here
    endif
    
    if(peinf%inode.eq.0) call timacc(33,1,tsec)

!-------------------- Calculate Matrix Elements ---------------------------


!--------------------------
! Use FFTs to calculate matrix elements

! Compute size of FFT box we need

    call setup_FFT_sizes(gvec%kmax,Nfft,scale)

! Allocate FFT boxes
! PWD:  Do we really nead two here we are doing a diagonal matrix element
    SAFE_ALLOCATE(fftbox1, (Nfft(1),Nfft(2),Nfft(3)))
    SAFE_ALLOCATE(fftbox2, (Nfft(1),Nfft(2),Nfft(3)))


!   SAFE_ALLOCATE(vwfnTemp, (vwfn%nkptv))
!   SAFE_ALLOCATE(vwfnTemp2, (vwfn%nkptv))
!   vwfnTemp(:) = vwfn%zv(:,ispin)

! Put the data for valence band iv into FFT box 1 and do the FFT

    call put_into_fftbox(vwfn%nkptv,vwfn%zv(:,ispin), &
      gvec%ng,gvec%k,vwfn%isort,fftbox1,Nfft)

!   call put_into_fftbox(vwfn%nkptv,vwfnTemp, &
!    gvec%ng,gvec%k,vwfn%isort,fftbox1,Nfft)


    call do_FFT(fftbox1,Nfft,1)
! We need the complex conjugate of the |ivk> band actually

    call conjg_fftbox(fftbox1,Nfft)

! Diagonal so the same thing goes in box 2

    call put_into_fftbox(vwfn%nkptv,vwfn%zv(:,ispin), &
      gvec%ng,gvec%k,vwfn%isort,fftbox2,Nfft)

    call do_FFT(fftbox2,Nfft,1)

    SAFE_ALLOCATE(tmparray, (pol%nGGpnmtx))

    call multiply_fftboxes(fftbox1,fftbox2,Nfft)
    
    call do_FFT(fftbox2,Nfft,1)
    
    call get_from_fftbox(pol%nGGpnmtx,tmparray, &
      gvec%ng,gvec%k,pol%isrtxExtra,fftbox2,Nfft,scale)
    
    pol%gpgExtraPolar(peinf%indexv(iv),1:pol%nGGpnmtx,ispin,irq) &
      = MYCONJG(tmparray)

!So here we apply the energy denominator
!   if(peinf%inode.eq.0) then
!     GMinusGP = 1
!     write(6,*) 'GMinusGP, gx, gy, gz, gpg Term', GMinusGP, gvec%k(1,pol%isrtxExtra(GMinusGP)),& 
!      gvec%k(2,pol%isrtxExtra(GMinusGP)),gvec%k(3,pol%isrtxExtra(GMinusGP)), &
!      pol%gpgExtraPolar(peinf%indexv(iv),GMinusGP,ispin,irq)
!   endif
  
    pol%gpgExtraPolar(peinf%indexv(iv),1:pol%nGGpnmtx,ispin,irq) = &
      pol%gpgExtraPolar(peinf%indexv(iv),1:pol%nGGpnmtx,ispin,irq) * &
      pol%edenExtraPolar(iv,ispin)

    if(peinf%inode.eq.0) then
      GMinusGP = 1
      write(6,*) 'GMinusGP=1 with energy', pol%gpgExtraPolar(peinf%indexv(iv),GMinusGP,ispin,irq) 
      write(6,*) 'GMinusGP=0 with energy', pol%gpgExtraPolar(peinf%indexv(iv),GMinusGP,ispin,irq) 
    endif
    
    SAFE_DEALLOCATE(tmparray)

! We are done, so deallocate FFT boxes

    SAFE_DEALLOCATE(fftbox1)
    SAFE_DEALLOCATE(fftbox2)

! End FFT Case
!---------------------------

! End Calculation of matrix elements
!----------------------------------------------------------------------------

    if(peinf%inode.eq.0) call timacc(33,2,tsec)
    
    POP_SUB(mtxelGpGExtraPolar) 
    return
  end subroutine mtxelGpGExtraPolar

!----------------------------------------------------------------------------
  subroutine applyExtrapolarDeltaTerm(kp,nrq,nst,fact,vwfn,scal,gvec,indtExtra,phtExtra,pol,xilocal,deltaCount,ipe)
    type (kpoints), intent(in) :: kp
    integer, intent(in) :: nrq
    integer, intent(in) :: nst(:)
    real(DP), intent(in) :: fact
    type (valence_wfns), intent(in) :: vwfn
    type (scalapack), intent(in) :: scal
    type (gspace), intent(in) :: gvec
    integer, intent(in) :: indtExtra(:,:,:)
    SCALAR, intent(in):: phtExtra(:,:,:)
    type (polarizability), intent(in) :: pol
    SCALAR, intent(inout) :: xilocal(:,:)
    integer, intent(inout) :: deltaCount(:,:)
    integer, intent(in) :: ipe

    integer :: ispin,irq,iv,it,iGExP,iGpExP,GPMinusG
    integer :: gval(3)
    integer :: actualG, actualGp

    PUSH_SUB(applyExtrapolarDeltaTerm)
    
    do ispin=1,kp%nspin
      do irq = 1,nrq
        do iv=1,vwfn%nband+pol%ncrit
!         if(peinf%inode.eq.0) then
!           write(6,*) 'ispin, iv', ispin, iv
!         endif
          if (1.eq.1) then !peinf%doiownv(iv).eq.1) then !.AND.peinf%doiownc(1).eq.1) then
            do it= 1, nst(irq)
              do iGExP=1,scal%npr
                do iGpExP=1,scal%npc
                  actualG = pol%isrtxExtra(indtExtra( &
                    scal%imyrow(iGExP),it,irq))
                  actualGp = pol%isrtxExtra(indtExtra( &
                    scal%imycol(iGpExP),it,irq))
                  
                  gval(:) = gvec%k(:,actualGp) & 
                    - gvec%k(:,actualG)
                  
                  call findvector(GpMinusG, gval(1), &
                    gval(2), gval(3), gvec)
                  GpMinusG=pol%isrtxiExtra(GpMinusG)
                  
                  if(peinf%inode.eq.0) then
!                   if(gval(1).eq.0.and.gval(2).eq.0.and.gval(3).eq.0) then
!                     write(6,*) 'gval(1)' , gval(1) , 'gval(2)', gval(2), 'gval(3)', gval(3)
!                     write(6,*) 'GpMinusG is', GpMinusG
!                   endif
                  endif

                
!                 if(peinf%inode.eq.0) then
!                   write(6,*) 'actualG =', actualG, 'actualGp=', actualGp
!                 endif
                
                  if(GpMinusG.lt.pol%nGGpnmtx.and.actualG.le.pol%nmtx.and. &
                    actualGp.le.pol%nmtx) then
                    deltaCount(actualGp,actualG) = deltaCount(actualGp,actualG)+1
                  endif

                  if(GpMinusG.lt.pol%nGGpnmtx.and. &
                    iGpExP.le.scal%nprd(ipe).and.iGExP.le.scal%npcd(ipe) ) then
                  
!                   xilocal2(pol%isrtxExtra(indtExtra( &
!                  scal%imycol(iGpExP),it,irq)),pol%isrtxExtra(indtExtra( &
!                  scal%imyrow(iGExP),it,irq)),ispin) = &
!                    xilocal2(pol%isrtxExtra(indtExtra( &
!                  scal%imycol(iGpExP),it,irq)),pol%isrtxExtra(indtExtra( &
!                  scal%imyrow(iGExP),it,irq)),ispin) &
!                    + fact*pol%gpgExtraPolar(iv, &
!                    GpMinusG,ispin,irq)*phtExtra( &
!                    pol%isrtxExtra(GpMinusG),it,irq)
                  ! if(peinf%inode.eq.0) then
!                     write (6,*) 'GpMinusG', GpMinusG, 'ispin', ispin, 'irq', irq, 'pol%gpgExtra', pol%gpgExtraPolar(iv, &
!                    GpMinusG,ispin,irq)
!                   end if
                    xilocal(iGpExP,iGExP) = &
                      xilocal(iGpExP,iGExP)&
                      + fact*pol%gpgExtraPolar(iv, &
                      GpMinusG,ispin,irq)*phtExtra( &
                      GpMinusG,it,irq)
                  endif
                enddo
              enddo
            enddo
          endif
        enddo
      enddo
    enddo

    POP_SUB(applyExtrapolarDeltaTerm)
    return
  end subroutine applyExtrapolarDeltaTerm
  
end module extrapolar_m
