!=================================================================================
!
! Module write_matrix_m
!
! (1) write_matrix_d()          Originally by JRD       Last Modified 5/1/2008 (JRD)
!
! This program writes a distributed matrix like ximat or epsmat to file.
!
! (2) write_matrix_f()          Originally by JRD       Last Modified 2/5/2009 (CHP)
!
! Modification of write_matrix_d for full-frequency.
!
!=================================================================================

#include "f_defs.h"

module write_matrix_m

  use global_m
  use scalapack_m
  implicit none

  public :: &
    write_matrix_d, &
    write_matrix_f

contains

subroutine write_matrix_d(scal,matrix,nmtx,itape)
  type(scalapack), intent(in) :: scal
  SCALAR, intent(in) :: matrix(scal%npr,scal%npc)
  integer, intent(in) :: nmtx
  integer, intent(in) :: itape
  
  integer :: ii, jj
#ifdef USESCALAPACK
  SCALAR, allocatable :: tempcol(:),tempcol2(:)
  integer :: irow, icol, irowm, icolm
  integer :: icurr
#endif

  PUSH_SUB(write_matrix_d)

#ifdef VERBOSE
  if(peinf%inode .eq. 0) then
    write(6,*) ' Writing matrix: ', nmtx, itape
    write(6,*) ' '
  endif
#endif

#ifdef USESCALAPACK
  SAFE_ALLOCATE(tempcol, (nmtx))
  SAFE_ALLOCATE(tempcol2, (nmtx))
  
  icurr=0
  
  do jj = 1, nmtx
!        if (peinf%inode .eq. 0) then
!          write(6,*) ' In loop: ', ii
!        endif
    icol=MOD(INT(((jj-1)/scal%nbl)+TOL_SMALL),scal%npcol)
    tempcol=0d0
    if (icol .eq. scal%mypcol) then
      do ii = 1, nmtx
        irow=MOD(INT(((ii-1)/scal%nbl)+TOL_SMALL),scal%nprow)
        if (irow .eq. scal%myprow) then
          icurr=icurr+1
          icolm=INT((icurr-1)/scal%npr+TOL_SMALL)+1
          irowm=MOD((icurr-1),scal%npr)+1
          tempcol(ii)=matrix(irowm,icolm)
          
!                if (icolm .gt. scal%npc .or. irowm.gt.scal%npr) then
!                  write(6,*) 'Error: ', scal%npc,scal%npr,icolm,irowm
!                endif

        endif
      enddo
    endif
    if (peinf%inode .eq. 0) then
      tempcol2=0d0
    endif
    call MPI_REDUCE(tempcol,tempcol2,nmtx,MPI_SCALAR,MPI_SUM,0, &
      MPI_COMM_WORLD,mpierr)
    if (peinf%inode .eq. 0) then
      write(itape) (tempcol2(ii),ii=1,nmtx)
    endif
    
    call MPI_barrier(MPI_COMM_WORLD,mpierr)
    
  enddo
  
  SAFE_DEALLOCATE(tempcol)
  SAFE_DEALLOCATE(tempcol2)

!      if(peinf%inode .eq. 0) then
!        write(6,*) ' Done Writing ximat: '
!      endif

#else

  if (peinf%inode .eq. 0) then
    do jj = 1, nmtx
      write(itape) (matrix(ii, jj), ii = 1, nmtx)
    enddo
  endif
  
#endif
  
  POP_SUB(write_matrix_d)
  
  return
end subroutine write_matrix_d

!=================================================================================

subroutine write_matrix_f(scal,nfreq,retarded,&
#ifdef CPLX
  advanced,&
#endif
nmtx,itape)
  type(scalapack), intent(in) :: scal
  integer, intent(in) :: nfreq
  complex(DPC), intent(in) :: retarded(nfreq,scal%npr,scal%npc)
#ifdef CPLX
  complex(DPC), intent(in) :: advanced(nfreq,scal%npr,scal%npc)
#endif
  integer, intent(in) :: nmtx
  integer, intent(in) :: itape
  
  integer :: ii, jj, ifreq
#ifdef USESCALAPACK
  complex(DPC), allocatable :: tempcolR(:,:),tempcolR2(:,:)
  complex(DPC), allocatable :: tempcolA(:,:),tempcolA2(:,:)
  integer :: irow, icol, irowm, icolm
  integer :: icurr
#endif

  PUSH_SUB(write_matrix_f)
  
#ifdef VERBOSE
  if(peinf%inode .eq. 0) then
    write(6,*) ' Writing matrix: ', nfreq, nmtx, itape
    write(6,*) ' '
  endif
#endif
  
#ifdef USESCALAPACK
  
  SAFE_ALLOCATE(tempcolR, (nfreq,nmtx))
  SAFE_ALLOCATE(tempcolR2, (nfreq,nmtx))
#ifdef CPLX
  SAFE_ALLOCATE(tempcolA, (nfreq,nmtx))
  SAFE_ALLOCATE(tempcolA2, (nfreq,nmtx))
#endif

  icurr=0
  
  do jj = 1, nmtx
!        if (peinf%inode .eq. 0) then
!          write(6,*) ' In loop: ', ii
!        endif
    icol=MOD(INT(((jj-1)/scal%nbl)+TOL_SMALL),scal%npcol)
    tempcolR=0d0
#ifdef CPLX
    tempcolA=0d0
#endif
    if (icol .eq. scal%mypcol) then
      do ii = 1, nmtx
        irow=MOD(INT(((ii-1)/scal%nbl)+TOL_SMALL),scal%nprow)
        if (irow .eq. scal%myprow) then
          icurr=icurr+1
          icolm=INT((icurr-1)/scal%npr+TOL_SMALL)+1
          irowm=MOD((icurr-1),scal%npr)+1
          tempcolR(:,ii)=retarded(:,irowm,icolm)
#ifdef CPLX
          tempcolA(:,ii)=advanced(:,irowm,icolm)
#endif
          
!                if (icolm .gt. scal%npc .or. irowm.gt.scal%npr) then
!                  write(6,*) 'Error: ', scal%npc,scal%npr,icolm,irowm
!                endif

        endif
      enddo
    endif
    if (peinf%inode .eq. 0) then
      tempcolR2=0d0
#ifdef CPLX
      tempcolA2=0d0
#endif
    endif
    call MPI_REDUCE(tempcolR(1,1),tempcolR2(1,1),nfreq*nmtx, &
      MPI_COMPLEX_DPC,MPI_SUM,0,MPI_COMM_WORLD,mpierr)
#ifdef CPLX
    call MPI_REDUCE(tempcolA(1,1),tempcolA2(1,1),nfreq*nmtx, &
      MPI_COMPLEX_DPC,MPI_SUM,0,MPI_COMM_WORLD,mpierr)
#endif
    if (peinf%inode .eq. 0) then
      do ii = 1, nmtx
        write(itape) (tempcolR2(ifreq,ii),ifreq=1,nfreq)
      enddo
#ifdef CPLX
      do ii = 1, nmtx
        write(itape) (tempcolA2(ifreq,ii),ifreq=1,nfreq)
      enddo
#endif
    endif
    
    call MPI_barrier(MPI_COMM_WORLD,mpierr)
    
  enddo
  
  SAFE_DEALLOCATE(tempcolR)
  SAFE_DEALLOCATE(tempcolR2)
#ifdef CPLX
  SAFE_DEALLOCATE(tempcolA)
  SAFE_DEALLOCATE(tempcolA2)
#endif

!      if(peinf%inode .eq. 0) then
!        write(6,*) ' Done Writing ximat: '
!      endif

#else

  if(peinf%inode .eq. 0) then
    do jj = 1, nmtx
      do ii = 1, nmtx
        write(itape) (retarded(ifreq, ii, jj), ifreq= 1, nfreq)
      enddo
#ifdef CPLX
      do ii = 1, nmtx
        write(itape) (advanced(ifreq, ii, jj),ifreq = 1, nfreq)
      enddo
#endif
    enddo
  endif
  
#endif
  
  POP_SUB(write_matrix_f)
  
  return
end subroutine write_matrix_f

end module write_matrix_m
