!==========================================================================
!
! Modules:
!
! (1) typedefs      Originally By GMR      Last Modified 7/8/2008 (JRD)
!
!>    Derived types that are used throughout the code.
!
!==========================================================================

#include "f_defs.h"

module typedefs_m

  use nrtype_m
  implicit none

!---------------------------

  type crystal
    real(DP) :: celvol !< cell volume in real space (a.u.)
    real(DP) :: recvol !< cell volume in reciprocal space (a.u.)
    real(DP) :: alat !< lattice constant in real space (a.u.)
    real(DP) :: blat !< lattice constant in reciprocal space (a.u.)
    real(DP) :: avec(3,3) !< lattice vectors in real space (alat)
    real(DP) :: bvec(3,3) !< lattice vectors in reciprocal space (blat)
    real(DP) :: adot(3,3) !< metric tensor in real space (a.u.)
    real(DP) :: bdot(3,3) !< metric tensor in reciprocal space (a.u.)
    integer :: nat !< number of atoms
    integer, pointer :: atyp(:) !< atomic species, atyp(1:nat)
    real(DP), pointer :: apos(:,:) !< atomic positions, apos(1:3,1:nat) (alat)
  end type crystal

!---------------------------

  type kpoints
    integer :: nspin   !< nspin = 1 or 2
    integer :: nrk     !< number of k-points
    integer :: mnband  !< max number of bands
    integer :: nvband  !< number of valence bands
    integer :: ncband  !< number of conduction bands
    integer  :: kgrid(3) !< Monkhorst-Pack number of k-points in each direction
    real(DP) :: shift(3) !< Monkhorst-Pack shift of grid
    real(DP) :: ecutwfc            !< wave-function cutoff, in Ry
    integer, pointer :: ngk(:)     !< number of g-vectors for each k-point
    integer :: ngkmax              !< max(ngk(:))
    integer, pointer :: ifmin(:,:) !< lowest occupied band (kpoint,spin)
    integer, pointer :: ifmax(:,:) !< highest occupied band (kpoint,spin)
    real(DP), pointer :: w(:)      !< weights (kpoint) (between 0 and 1)
    real(DP), pointer :: rk(:,:)   !< k-vector (3, kpoint) in crystal coords
    real(DP), pointer :: el(:,:,:) !< band energies (band, kpoint, spin)
    real(DP), pointer :: elda(:,:,:) !< band energies before eqp correction
    real(DP), pointer :: occ(:,:,:)  !< occupations (between 0 and 1)
    integer, pointer :: degeneracy(:,:,:) !< size of deg. subspace, only for sig%ndiag
  end type kpoints
  
!---------------------------
  
  type symmetry
    integer :: ntran         !< number of operations in full group
    integer :: ntranq        !< number of operations in small group of q
    real(DP) :: rq(3)        !< The q-point this ntranq belongs to
    integer :: mtrx(3,3,48)  !< symmetry matrix
    real(DP) :: tnp(3,48)    !< fractional translations
    integer :: indsub(48)    !< symmetry operations in subgroup of q
    integer :: kgzero(3,48)  !< Umklapp vectors for subgroup symmetry operations
    integer :: cell_symmetry !< 0 = cubic, 1 = hexagonal
  end type symmetry
      
!---------------------------

  type grid
    integer :: nr  !< number in reduced zone
    integer :: nf  !< number in full zone
    real(DP) :: sz !< radius of a spherical subzone equivalent to
                   !! one point in the set f
    integer, pointer :: itran(:) !< sym op to go from irrbz to fullbz
    integer, pointer :: indr(:)  !< irrbz k/q-point mapped to fullbz
    integer, pointer :: kg0(:,:) !< Umklapp vectors (for Wigner-Seitz cell)
    real(DP), pointer :: r(:,:)  !< k/q-points in reduce zone
    real(DP), pointer :: f(:,:)  !< k/q-points in full zone
  end type grid

!-----------------------------------

  type gspace
    integer :: ng       !< number of G-vectors
    integer :: nktot    !< number in FFT grid = product(kmax(1:3))
    real(DP) :: ecutrho !< charge-density cutoff, in Ry
    integer, pointer :: k(:,:) !< the G-vectors, in units of 2 pi / a
    integer :: kmax(3)  !< gsm: kmax is the size of the FFT grid, not the maximum G-vector   
    integer, pointer :: indv(:) ! mapping to FFT grid
    real(DP), pointer :: ekin(:) !< kinetic energy of G-vectors
  end type gspace

!---------------------------

  type wavefunction
    integer :: ng
    integer :: nband
    integer :: nspin
    integer, pointer :: isort(:)
    SCALAR, pointer :: cg(:,:,:)
  end type wavefunction

!---------------------------

  type int_wavefunction
    integer :: nspin
    integer, pointer ::  ng(:)
    integer, pointer :: isort(:,:)
    integer, pointer :: cbi(:)
    real(DP), pointer :: qk(:,:)
    real(DP), pointer :: el(:,:,:)
    SCALAR, pointer :: cg(:,:,:)
    SCALAR, pointer :: cgk(:,:,:,:)
  end type int_wavefunction

!------------------------------------

  type valence_wfns
    integer :: nband
    integer :: nkptv
    integer :: ngc
    integer, pointer :: isort(:)
    real(DP), pointer :: ev(:,:)
    real(DP) :: evs
    real(DP) :: ev0
    real(DP) :: evdel
    SCALAR, pointer :: zv(:,:)
  end type valence_wfns

!----------------------------

  !> splines knots and coefficients
  type spline_tck
    integer :: n              !< number of knots
    integer :: k              !< degree of spline (1=linear, etc.)
    real(DP), pointer :: t(:) !< position of knots
    real(DP), pointer :: c(:) !< splines coefficient
  end type spline_tck

!----------------------------

  type siginfo
    integer :: freq_dep    !< frequency dependence of the inverse dielectric matrix
    integer :: nFreq       !< number of frequencies used in full frequency calculation
    real(DP) :: dDeltaFreq !< frequency increment (eV) for polarization energy denominator
    real(DP) :: dBrdning   !< Lorentzian broadening (eV) for polarization energy denominator
    real(DP), pointer :: dFreqGrid(:)   !< Grid of Frequencies for Full Frequency
    complex(DP), pointer :: dFreqBrd(:) !< Corresponding Broadenings for Full Frequency
    integer :: exact_ch    !< compute the exact static CH
    integer :: fullConvLog !< logging CH convergence
    integer :: iwritecoul  !< flag to write vcoul
    integer :: ninter      !< number of points interpolated for full frequency
    real(DP) :: tol        !< energy tolerance for degeneracy
    integer :: ggpsum
    logical :: use_xdat     !< use saved exchange matrix elements from file x.dat
    logical :: use_vxcdat   !< use saved exchange-correlation matrix elements from file vxc.dat
    integer :: nkn          !< number of k-points on which to calculate Sigma (from sigma.inp)
    integer :: nfreqeval
    integer :: nq
    integer :: nvband
    integer :: ntband
    integer :: igamma       !< nonzero if Gamma is the only q-point, 0 otherwise
    integer :: nspin
    integer :: spin_index(2)
    integer :: icutv               !< icutv encodes presence and type of truncation
    integer :: iwriteint           !< = 0 for comm_disk, = 1 for comm_mpi
    integer :: iuseremainder
    integer :: qgrid(3)
    integer :: iscreen !< what type of screening is present
    integer :: fdf !< finite difference form for numerical derivative of Sigma
    integer, pointer :: indkn(:) !< mapping of k-points from sigma.inp to those in kp%rk from WFN files
    integer, pointer :: diag(:) !< energy bands for which Sigma diagonal matrix elements are calculated
    integer :: ndiag    !< number of bands contained in diag(:)
    integer :: noffdiag !< offdiag
    integer :: loff
    integer :: toff
    integer :: bmin
    integer :: bmax
    integer, pointer :: off1(:) !< offdiag <bra|
    integer, pointer :: off2(:) !< offdiag |ket>
    integer, pointer :: off3(:) !< offdiag energy at which to evaluate
    integer, pointer :: offmap(:,:)  !< sig%off1(ii) = sig%diag(sig%offmap(ii,1))
    integer, pointer :: band_index(:)
    real(DP) :: dw       !< finite difference spacing for numerical derivative of Sigma in eV
    real(DP) :: ecutb    !< energy cutoff of bare coulomb interaction in Ry
    real(DP) :: ecuts    !< energy cutoff of screened coulomb interaction in Ry
    real(DP) :: xfrac    !< fraction of bare exchange
    real(DP) :: gamma    !< GPP broadening
    real(DP) :: sexcut   !< GPP SX cutoff
    real(DP) :: q0vec(3)
    real(DP) :: freqevalmin
    real(DP) :: freqevalstep
    logical :: eqp_corrections !< are we using eqp.dat
    logical :: eqp_outer_corrections !< are we using eqp_outer.dat
    real(DP) :: evs            !
    real(DP) :: ecs            !< scissors operator (linear fit
    real(DP) :: evdel          !< of the quasiparticle energy
    real(DP) :: ecdel          !< corrections) for the bands
    real(DP) :: ev0            !< in WFN_inner
    real(DP) :: ec0            !
    logical  :: wfn_outer_present
    real(DP) :: evs_outer      !
    real(DP) :: ecs_outer      !< scissors operator (linear fit of the quasiparticle energy
    real(DP) :: evdel_outer    !! corrections) for the bands in WFN_outer
    real(DP) :: ecdel_outer    !
    real(DP) :: ev0_outer      !
    real(DP) :: ec0_outer      !
    type(spline_tck) :: spl_tck       !< scissors b-spline coefficients
    type(spline_tck) :: spl_tck_outer !< scissors b-spline coeffs for WFN_outer
    real(DP) :: avgpot
    real(DP) :: avgpot_outer
    real(DP) :: truncval(3)    !< in Bohr (au)
    real(DP) :: avgcut         !< Cut in which we do cell averages on
    real(DP), pointer :: kpt(:,:)
    real(DP), pointer :: qpt(:,:)
    integer :: ncrit           !< number of partially occupied bands
    real(DP) :: efermi         !< Fermi level
    real(DP) :: efermi_input   !< what is set in the input file
    logical :: rfermi          !< Fermi level relative to neutral system
    SCALAR, pointer :: vxc(:,:) !< Vxc(G)
    SCALAR :: wcoul0
    logical :: freplacebz
    logical :: fwritebz
    logical :: degeneracy_check_override
    logical :: offdiagsym
    logical :: qgridsym
    logical :: die_outside_sphere
    logical :: averagew
  end type siginfo

!---------------------------
  !> dielectric matrix info using comm_mpi
  type epsmpiinfo
    integer :: ngown
    integer, pointer :: isrtq(:,:)   !< These 3 arrays have a dimension of (1:gvec%ng,1:(nq+1)) where
    integer, pointer :: isrtqi(:,:)  !! (nq+1) is the total # of q`s including q0.
    real(DP), pointer :: eknq(:,:)
    
    integer, pointer :: igown(:)
    integer, pointer :: iggown(:)
    integer, pointer :: nmtx(:)      !< dimension of eps(q) for each q
    real(DP), pointer :: qk(:,:)
    SCALAR, pointer :: eps(:,:,:)    !< eps(1:gvec%ng,1:ngown,1:(nq+1))
    
    !> dimension of epsR and epsA (1:sig%nfreq,1:gvec%ng,1:ngown,1:(nq+1))
    complex(DPC), pointer :: epsR(:,:,:,:)
    complex(DPC), pointer :: epsA(:,:,:,:)
  end type epsmpiinfo

!---------------------------

  type wfnkqmpiinfo
    integer, pointer ::  nkptotal(:)
    integer, pointer :: isort(:,:)
    integer, pointer :: band_index(:,:)
    real(DP), pointer :: qk(:,:)
    real(DP), pointer :: el(:,:,:)
    SCALAR, pointer :: cg(:,:,:,:)
  end type wfnkqmpiinfo

!---------------------------

  type wfnkmpiinfo
    integer, pointer ::  nkptotal(:)
    integer, pointer :: isort(:,:)
    real(DP), pointer :: qk(:,:)
    real(DP), pointer :: el(:,:,:)
    real(DP), pointer :: elda(:,:,:)
    SCALAR, pointer :: cg(:,:,:)
  end type wfnkmpiinfo

!---------------------------

  type conduction_wfns
    integer :: nband
    integer :: nkptc
    real(DP), pointer :: ekin(:)
    integer, pointer :: isort(:)
    integer, pointer :: band_index(:)
    real(DP), pointer :: ec(:,:)
    real(DP) :: ecs
    real(DP) :: ec0
    real(DP) :: ecdel
    SCALAR, pointer :: zc(:,:)
  end type conduction_wfns

!-------------------------------

  type wpgen
    real(DP) :: wp(2) !< square of free el plasma freq for each spin
    real(DP) :: rhoave(2)
    SCALAR, pointer :: rho(:,:)
  end type wpgen

!---------------------------

  type polarizability
    integer :: freq_dep !< frequency dependence of the inverse dielectric matrix
    integer :: nFreq    !< number of frequencies used in full frequency calculation
    real(DP) :: dInitFreq  !< initial frequency (eV) for polarization energy denominator
    real(DP) :: dDeltaFreq !< frequency increment (eV) for polarization energy denominator
    real(DP) :: dBrdning   !< Lorentzian broadening (eV) for polarization energy denominator
    real(DP), pointer :: dFreqGrid(:) !< Grid of Frequencies for Full Frequency 
    real(DP) :: dFreqStepIncrease
    real(DP) :: dFreqCutoff1
    real(DP) :: dFreqCutoff2

    logical :: eqp_corrections !< are we using eqp.dat and eqp_q.dat files
    complex(DP), pointer :: dFreqBrd(:)  !< Corresponding Broadenings for Full Frequency
    integer :: fullConvLog !< logging pol matrix head & tail convergence
    integer :: extraPolarMethod  !< flag for extrapolar correction
    real(DP) :: extraPolarEnergy !< energy offset of extrapolar peak
    real(DP), pointer :: edenExtraPolar(:,:)
    integer :: iwritecoul !< flag to write vcoul
    integer :: nmtx
    integer :: nGGpnmtx !< number of elements for extrapolar G-Gp matrix element
    integer :: nq
    integer :: gcomm
    integer :: iwriteint            !< = 0 for comm_disk, = 1 for comm_mpi
    logical :: skip_epsilon
    logical :: skip_chi
    integer :: iqexactlyzero
    integer, pointer :: irow(:)
    integer, pointer :: isrtx(:)
    integer, pointer :: isrtxi(:)
    integer, pointer :: isrtxExtra(:)  !< extrapolar ekinx sort G not q+G necessary?
    integer, pointer :: isrtxiExtra(:) !< inverse
    integer, pointer :: kxi(:)
    integer :: icutv               !< icutv encodes presence and type of truncation
    real(DP) :: truncval(3)   !< in Bohr (au)
    real(DP), pointer :: eden(:,:,:)
    real(DP), pointer :: qpt(:,:)
    SCALAR, pointer :: gme(:,:,:,:,:)
    SCALAR, pointer :: gmeExtra(:,:,:,:,:)
    SCALAR, pointer :: gpgExtraPolar(:,:,:,:)
    SCALAR, pointer :: chi(:,:,:)
    integer :: ncrit
    real(DP) :: efermi
    real(DP) :: efermi_input
    logical :: rfermi
!> Reference regarding retarded/advanced functions: Catalin`s thesis, Eq. (1.44)
    complex(DPC), pointer :: chiRDyn(:,:,:,:) !< Retarded polarization
    complex(DPC), pointer :: chiADyn(:,:,:,:) !< Advanced polarization
    real(DP), pointer :: edenDyn(:,:,:,:) !< Dynamic energy denominator
    logical :: freplacebz
    logical :: fwritebz
    logical :: degeneracy_check_override
  end type polarizability

!--------------------------------

  type wfnkstates
    integer :: nkpt
    integer :: ndv
    integer, pointer :: isrtk(:)
    real(DP) :: k(3)
    real(DP), pointer :: ek(:,:)
    real(DP), pointer :: elda(:,:)
    SCALAR, pointer :: zk(:,:)
  end type wfnkstates

!---------------------------

  type wfnkqstates
    integer nkpt
    integer, pointer :: isrtkq(:)
    real(DP), pointer :: ekin(:)
    real(DP), pointer :: ekq(:,:)
    SCALAR, pointer :: zkq(:,:)
  end type wfnkqstates

!---------------------------------

! Used in haydock/diag only

  type epsinfo
    integer nq
    real(DP) :: emax
    real(DP), pointer :: q(:,:)
    real(DP), pointer :: eps(:)
  end type epsinfo

!------------------------------------

! Used in haydock/diag only

  type eqpinfo
    real(DP) :: evs
    real(DP) :: ecs
    real(DP) :: evdel
    real(DP) :: ecdel
    real(DP) :: ev0
    real(DP) :: ec0
    type(spline_tck) :: spl_tck       !< scissors spline coefficients
    real(DP), pointer :: evqp(:,:,:)
    real(DP), pointer :: ecqp(:,:,:)
    real(DP), pointer :: evqp_co(:,:,:)
    real(DP), pointer :: ecqp_co(:,:,:)
    real(DP), pointer :: evlda(:,:,:)
    real(DP), pointer :: eclda(:,:,:)
    real(DP), pointer :: evlda_co(:,:,:)
    real(DP), pointer :: eclda_co(:,:,:)
    real(DP), pointer :: evshift(:,:,:)
    real(DP), pointer :: ecshift(:,:,:)
    real(DP), pointer :: evshift_co(:,:,:)
    real(DP), pointer :: ecshift_co(:,:,:)
  end type eqpinfo

!------------------------------------

  type mmtsinfo
    integer nmax
    integer nmaxp
    real(DP) :: norm
    real(DP) :: vol
    real(DP), pointer :: an(:)
    real(DP), pointer :: bn(:)
  end type mmtsinfo
  
!-------------------------------------

  type xctinfo
    integer :: inteqp                !< whether we are interpolating
    integer :: iperiodic(3)          !< which dimensions are periodic
    integer :: idimensions           !< how many total periodic dimensions
    integer :: nvband
    integer :: nvbl                  !< lower band in the valence set (coarse grid)
    integer :: ncband
    integer :: ncbl                  !< lower band in the conduction set (coarse grid)
    integer :: nspin
    integer :: nkpt
    integer :: nkptq
    integer :: qflag                 !< int
    integer :: skpt                  !< 1 if read_kpoints option used, 0 otherwise
    integer :: ipar
    integer :: iscreen
    logical :: renorm_transf         !< renormalize the interpolation transformation?
    integer :: iwings
    integer :: iabsorp0              !< 1 mean noeh_only, 0 otherwise
    integer :: iwriteint             !< = 0 for comm_disk, = 1 for comm_mpi
    logical :: eqp_corrections       !< do we use eqp.dat and eqp_q.dat
    logical :: eqp_co_corrections    !< do we use eqp_co.dat
    
! For Coulomb interaction truncation

    integer :: iwritecoul
    integer :: icutv              !< icutv encodes presence and type of truncation
    real(DP) :: truncval(3)       !< in Bohr (au)
    integer :: nint               !< number of intervals used in
                                  !! double integral truncated_factor

    logical :: bLowComm       !< If this is true, each processor will store the entire epsilon matrix
    integer :: neps
    integer :: ilowmem
    integer :: iskipinterp    !< 0 = interpolate, 1 = do not.
    integer :: ivpar, icpar
    integer :: nqeps
    integer :: nn             !< PlotXct restrict_kpoints
    integer :: ng
    integer :: nktotal        !< total number of unit cells
    real(DP) :: eta           !< energy resolution
    real(DP) :: sigma         !< (used to calculate the optical spectrum)
    real(DP) :: gamma         !< (used to calculate the optical spectrum)
    real(DP) :: qshift
    real(DP) :: shift(3)      !< shift vector (this is the small shift,
                              !< used to generate WFNq_fi, referenced only if xct%skpt.eq.1)
    real(DP) :: lpol          !< norm of pol
    real(DP) :: pol(3)        !< light polarization for transition matrix elements
    integer :: ngq, nmtxmax, maxpet
    integer, pointer :: indexq(:), isrtq(:,:), isrtqi(:,:), nmtxa(:), epsown(:)
    integer, pointer :: maxpe(:), epsowni(:,:), ifmax(:,:), ifmaxq(:,:)
    real(DP) :: ecute         !< energy cutoff used in dielectric matrix
    real(DP) :: scaling       !< multiply kernel by arbitrary factor
    real(DP) :: ecutg         !< energy cutoff used in wavefunctions and interaction
                              !< kernel, see Rohlfing & Louie, PRB 62(8),p. 4938
                              !< (must be slightly longer than xct%ecute because of umklapp vectors)
    real(DP) :: efermi        !< computed efermi
    real(DP) :: efermi_input  !< as set in input file
    logical :: rfermi         !< relative or absolute Fermi level
    SCALAR, pointer :: epsdiag(:,:),epscol(:,:,:)

! Used in haydock/diag only

    integer :: nkpt_co
    integer :: nvb_co
    integer :: ncb_co
    integer :: dynamic_type
    logical :: dynamic_screening
    real(DP) :: dynamic_energy
    real(DP) :: avgcut         !< Cut in which we do cell averages on
    real(DP) :: wplasmon
    real(DP) :: q0vec(3)
    SCALAR :: wcoul0
    SCALAR :: epshead
    integer :: vmin,vmax
    integer :: rgrid(3) !< regular grid used to calculate qpt_averages (default is kgrid)
    logical :: freplacebz
    logical :: fwritebz
    logical :: degeneracy_check_override
    logical :: die_outside_sphere
    logical :: averagew
  end type xctinfo

!------------------------------------

  type flags

!>
!> Used in haydock, diag, nonlinearoptics
!>
!> Defined flags:
!>
!>  bz0  = 0 --> use symmetries to unfold the Brillouin zone in WFN_fi file
!>         1 --> do not unfold the BZ in WFN_fi file (default)
!>  bzq  = 0 --> use symmetries to unfold the BZ in WFNq_fi file
!>         1 --> do not unfold the BZ in WFNq_fi file (default)
!>  bzc  = 0 --> use symmetries to unfold the BZ in WFN_co file
!>         1 --> do not unfold the BZ in WFN_co file (default)
!>
!>  dtm = 0 --> calculate dcc,dvv matrices (default)
!>        1 --> take dcc,dvv matrices from file dtmat
!>
!>  eig = 0  --> do not write eigenvectors (default)
!>      < 0 --> write all eigenvectors
!>      > 0 --> write the first flag%eig eigenvectors
!>
!>  eps = 0 --> read files 'eps0mat'/'epsmat' (default)
!>        1 --> read file 'epsdiag'
!>
!>  krnl = 0 --> spin triplet kernel, direct kernel only
!>         1 --> spin singlet kernel (default)
!>         2 --> local-fields + RPA, exchange kernel only
!>
!>  opr = 0 --> use velocity operator
!>        1 --> use momentum operator
!>
!>  lor = 0 --> use Lorentzian broadening
!>        1 --> use Gaussian broadening
!>        2 --> use Voigt broadening
!>
!>  spec = 0 --> go through the whole exciton calculation (default)
!>         1 --> calculate only absorption spectrum (this option skips
!>               all calculation and goes right to the end of the code)
!>
!>  vm = 0 --> calculate velocity/momentum matrix elements (default)
!>       1 --> read velocity/momentum matrix elements from file vmtxel
!>       2 --> use vectors from previous iteration (Haydock only!)
!>
!>  job = 0 --> ultrafast calculation
!>  job = 1 --> two-photon calculation
!>

    integer :: bz0
    integer :: lor
    integer :: bzq
    integer :: bzc
    integer :: dtm
    integer :: eig
    integer :: eps
    integer :: krnl
    integer :: opr
    integer :: spec
    integer :: vm
    integer :: job
  end type flags

!---------------------------------

  type otherinfo
    integer :: ithreeD
    integer :: knx
    integer :: kny
    integer :: knz
    real(DP) :: keta
  end type otherinfo

!---------------------------------

  type windowinfo
    real(DP) :: evalue
    real(DP) :: emax
    real(DP), pointer :: cstates(:)
    real(DP), pointer :: estates(:)
    integer, pointer :: istates(:)
    integer :: nstates
  end type windowinfo

!-----------------------------
  !> coarse-grid wavefunctions for diag/haydock
  type tdistgwf
    
    integer :: ngm !< maximum number of G-vectors
    integer :: ngl !< local number of G-vectors
    integer :: tgl !< local to global translation

!> local to global index translation : ig_g = ig_l + tgl
!> ig_g = 1 ... ng(ik) is the global G-index
!> ig_l = 1 ... ngl is the local G-index

    integer :: nk !< number of k-points
    integer :: ns !< number of spin components
    integer :: nv !< number of valence bands
    integer :: nc !< number of conduction bands

    integer, pointer :: ng(:) !< (nk)
    integer, pointer :: isort(:,:) !< (ngl,nk)
    SCALAR, pointer :: zv(:,:,:,:) !< (ngl,nv,ns,nk) 
    SCALAR, pointer :: zc(:,:,:,:) !< (ngl,nc,ns,nk)

  end type tdistgwf

!-----------------------------
!> MJ: work arrays - getting rid of save statements

  type work_genwf
    integer :: ikold = 0
    integer :: ikoldq = 0
    integer :: nb
    integer :: ng
    integer :: ns
    SCALAR, pointer :: cg(:,:,:)
    SCALAR, pointer :: ph(:)
    integer, pointer :: ind(:)
    integer, pointer :: isort(:)
  end type work_genwf

!-----------------------------
!> (gsm) work arrays - getting rid of save statements

  type twork_scell
    integer :: dNfft(3)
    integer :: Nplane
    integer :: Nrod
    complex(DPC), pointer :: fftbox_1D(:,:)
  end type twork_scell

end module typedefs_m
