! This routine is based loosely on the one described below but
! has been rewritten within this package.
! Superfluous variable DATAP = DATA(INDEXP) removed.
! Tie-breaker parameter gvec introduced. -- DAS 2011

!===================================================================
! http://www.fortran.com/quick_sort2.f
! From Leonard J. Moss of SLAC:

! Here`s a hybrid QuickSort I wrote a number of years ago.  Its
! based on suggestions in Knuth, Volume 3, and performs much better
! than a pure QuickSort on short or partially ordered input arrays.  

!===================================================================
!
!     SORTRX -- SORT, Real input, indeX output
!
!
!     Input:  N     INTEGER
!             array  REAL
!
!     Output: order INTEGER (DIMENSION N)
!
! This routine performs an in-memory sort of the first N elements of
! 'array', returning into array order the indices of elements of
! 'array' arranged in ascending order.  Thus,
!
!    array(order(1)) will be the smallest number in 'array';
!    array(order(N)) will be the largest number in 'array'.
!
! The original data is not physically rearranged.  The original order
! of equal input values is not necessarily preserved.
!
!===================================================================
!
! SORTRX uses a hybrid QuickSort algorithm, based on several
! suggestions in Knuth, Volume 3, Section 5.2.2.  In particular, the
! pivot key [my term] for dividing each subsequence is chosen to be
! the median of the first, last, and middle values of the subsequence;
! and the QuickSort is cut off when a subsequence has 9 or fewer
! elements, and a straight insertion sort of the entire array is done
! at the end.  The result is comparable to a pure insertion sort for
! very short arrays, and very fast for very large arrays (of order 12
! micro-sec/element on the 3081K for arrays of 10K elements).  It is
! also not subject to the poor performance of the pure QuickSort on
! partially ordered data.
!
! Created:  15 Jul 1986  Len Moss
!===================================================================

subroutine LABEL (N,array,order,gvec)
  integer, intent(in) :: N
  DTYPE , intent(in) :: array(:) !< (N)
  integer,intent(out) :: order(:) !< (N)
  integer, optional, intent(in) :: gvec(:,:) !< (3, N)
  ! DAS: the optional parameter gvec is used to break ties for equal data

  integer :: LSTK(31),RSTK(31),ISTK
  integer :: L,R,I,J,P,orderp,ordert
  integer :: M
  parameter (M=9)
    
  PUSH_SUB( LABEL )
  do I=1,N
    order(I)=I
  enddo
  loop900: do
    IF (N.LE.M) exit loop900
    ISTK=0
    L=1
    R=N
    loop200: do
      I=L
      J=R
      P=(L+R)/2
      orderp=order(P)
      IF (is_greater(order(L), orderp)) THEN
        order(P)=order(L)
        order(L)=orderp
        orderp=order(P)
      ENDIF
      IF (is_greater(orderp, order(R))) THEN
        IF (is_greater(order(L), order(R))) THEN
          order(P)=order(L)
          order(L)=order(R)
        ELSE
          order(P)=order(R)
        ENDIF
        order(R)=orderp
        orderp=order(P)
      ENDIF
      
      do
        I=I+1
        IF (is_greater(orderp, order(I))) cycle
        do while (is_greater(order(J), orderp))
          J=J-1
        enddo
        IF (I.LT.J) THEN
          orderT=order(I)
          order(I)=order(J)
          order(J)=orderT
          cycle
        endif
        exit
      enddo
      
      IF (R-J .GE. I-L .AND. I-L .GT. M) THEN
        ISTK=ISTK+1
        LSTK(ISTK)=J+1
        RSTK(ISTK)=R
        R=I-1
      ELSE IF (I-L .GT. R-J .AND. R-J .GT. M) THEN
        ISTK=ISTK+1
        LSTK(ISTK)=L
        RSTK(ISTK)=I-1
        L=J+1
      ELSE IF (R-J .GT. M) THEN
        L=J+1
      ELSE IF (I-L .GT. M) THEN
        R=I-1
      ELSE
        IF (ISTK.LT.1) exit loop900
        L=LSTK(ISTK)
        R=RSTK(ISTK)
        ISTK=ISTK-1
      ENDIF
    enddo loop200
  enddo loop900
  
  do I=2,N
    IF (is_greater(order(I-1), order(I))) THEN
      orderp=order(I)
      P=I-1
      do
        order(P+1) = order(P)
        P=P-1
        IF (P.GT.0) THEN
          IF (is_greater(order(P), orderp)) cycle
        ENDIF
        order(P+1) = orderp
        exit
      enddo
    ENDIF
  enddo
  POP_SUB( LABEL )
  
contains
  
  logical function is_greater(aa, bb)
    integer, intent(in) :: aa, bb
    
    integer :: idim
    
    ! no push_sub, called too frequently
    
    ! an arbitrary choice
    if(aa == bb) then
      is_greater = .true.
      return
    endif
    
    if(.not. present(gvec)) then
      is_greater = array(aa) - array(bb) > 0
      return
    endif
    
    if (array(aa) - array(bb) < -TOL_Zero) then
      is_greater = .false.
      return
    else if (array(aa) - array(bb) > TOL_Zero) then
      is_greater = .true.
      return
    else
      do idim = 1, 3
        if (gvec(idim, aa) .ne. gvec(idim, bb)) then
          is_greater = gvec(idim, aa) > gvec(idim, bb)
          return
        endif
      enddo
      write(0,'(a,i6,a,3i6)') 'gvec ', aa, ' = ', gvec(1:3, aa)
      write(0,'(a,i6,a,3i6)') 'gvec ', bb, ' = ', gvec(1:3, bb)
      call die('Identical G-vectors found while sorting.')
    endif
  end function is_greater
  
end subroutine LABEL
