!=================================================================================
!
! Module read_matrix
!
! (1) read_matrix_d()           Originally by JRD       Last Modified 5/1/2008 (JRD)
!
! This program reads a distributed matrix like ximat or epsmat to file.
!
! (2) read_matrix_f()           Originally by JRD       Last Modified 9/10/2010 (gsm)
!
! Modification of read_matrix_d for full-frequency.
!
!=================================================================================

#include "f_defs.h"

module read_matrix_m

  use global_m
  use scalapack_m
  implicit none
  
  public :: &
    read_matrix_d, &
    read_matrix_f

contains

subroutine read_matrix_d(scal,matrix,nmtx,itape)
  type (scalapack), intent(in) :: scal
  SCALAR, intent(out) :: matrix(scal%npr,scal%npc)
  integer, intent(in) :: nmtx
  integer, intent(in) :: itape
  
  integer :: ii, jj
  
#ifdef USESCALAPACK
  SCALAR, allocatable :: tempcol(:)
  integer :: irow, icol, irowm, icolm
  integer :: icurr
#endif
  
  PUSH_SUB(read_matrix_d)

#ifdef VERBOSE
  if(peinf%inode .eq. 0) then
    write(6,*) ' Reading matrix: ', nmtx, itape
    write(6,*) ' '
  endif
#endif
  
#ifdef USESCALAPACK
  
  SAFE_ALLOCATE(tempcol, (nmtx))
  
  icurr=0
  
  do jj = 1, nmtx

!        if (peinf%inode .eq. 0) then
!          write(6,*) ' In loop: ', ii
!        endif

    if (peinf%inode .eq. 0) then
      read(itape) (tempcol(ii),ii=1,nmtx)
    endif
    
    call MPI_BCAST(tempcol,nmtx,MPI_SCALAR,0, &
      MPI_COMM_WORLD,mpierr)
    
    icol=MOD(INT(((jj-1)/scal%nbl)+TOL_SMALL),scal%npcol)
    if (icol .eq. scal%mypcol) then
      do ii = 1, nmtx
        irow=MOD(INT(((ii-1)/scal%nbl)+TOL_SMALL),scal%nprow)
        if (irow .eq. scal%myprow) then
          icurr=icurr+1
          icolm=INT((icurr-1)/scal%npr+TOL_SMALL)+1
          irowm=MOD((icurr-1),scal%npr)+1
          matrix(irowm,icolm)=tempcol(ii)
        endif
      enddo
    endif
    
    call MPI_barrier(MPI_COMM_WORLD,mpierr)
    
  enddo
  
  SAFE_DEALLOCATE(tempcol)
  
#else
  
  if(peinf%inode .eq. 0) then
    do jj = 1, nmtx
      read(itape) (matrix(ii, jj), ii = 1, nmtx)
    enddo
  endif
  
#endif
  
  POP_SUB(read_matrix_d)
  
  return
end subroutine read_matrix_d

!=================================================================================

subroutine read_matrix_f(scal,nfreq,retarded,advanced,nmtx,itape)
  type(scalapack), intent(in) :: scal
  integer, intent(in) :: nfreq
  complex(DPC), intent(out) :: retarded(nfreq,scal%npr,scal%npc)
#ifdef CPLX
  complex(DPC), intent(out) &
#else
  complex(DPC), intent(in)  &  ! no value is assigned if not CPLX
#endif
    :: advanced(nfreq,scal%npr,scal%npc)
  integer, intent(in) :: nmtx
  integer, intent(in) :: itape

  integer :: ii, jj, ifreq
#ifdef USESCALAPACK
  complex(DPC), allocatable :: tempcolR(:,:)
  complex(DPC), allocatable :: tempcolA(:,:)
  integer :: irow, icol, irowm, icolm
  integer :: icurr
#endif

  PUSH_SUB(read_matrix_f)
  
#ifdef VERBOSE
  if(peinf%inode .eq. 0) then
    write(6,*) ' Reading matrix: ', nfreq, nmtx, itape
    write(6,*) ' '
  endif
#endif
  
#ifdef USESCALAPACK
  
  SAFE_ALLOCATE(tempcolR, (nfreq,nmtx))
#ifdef CPLX
  SAFE_ALLOCATE(tempcolA, (nfreq,nmtx))
#endif
  
  icurr=0
  
  do jj = 1, nmtx

!        if (peinf%inode .eq. 0) then
!          write(6,*) ' In loop: ', i
!        endif

    if (peinf%inode .eq. 0) then
      do ii = 1, nmtx
        read(itape) (tempcolR(ifreq,ii),ifreq=1,nfreq)
      enddo
#ifdef CPLX
      do ii = 1, nmtx
        read(itape) (tempcolA(ifreq,ii),ifreq=1,nfreq)
      enddo
#endif
    endif
    
    call MPI_BCAST(tempcolR,nfreq*nmtx,MPI_COMPLEX_DPC,0, &
      MPI_COMM_WORLD,mpierr)
#ifdef CPLX
    call MPI_BCAST(tempcolA,nfreq*nmtx,MPI_COMPLEX_DPC,0, &
      MPI_COMM_WORLD,mpierr)
#endif
    
    icol=MOD(INT(((jj-1)/scal%nbl)+TOL_SMALL),scal%npcol)
    if (icol .eq. scal%mypcol) then
      do ii = 1, nmtx
        irow=MOD(INT(((ii-1)/scal%nbl)+TOL_SMALL),scal%nprow)
        if (irow .eq. scal%myprow) then
          icurr=icurr+1
          icolm=INT((icurr-1)/scal%npr+TOL_SMALL)+1
          irowm=MOD((icurr-1),scal%npr)+1
          retarded(:,irowm,icolm)=tempcolR(:,ii)
#ifdef CPLX
          advanced(:,irowm,icolm)=tempcolA(:,ii)
#endif
        endif
      enddo
    endif
    
    call MPI_barrier(MPI_COMM_WORLD,mpierr)
    
  enddo
  
  SAFE_DEALLOCATE(tempcolR)
#ifdef CPLX
  SAFE_DEALLOCATE(tempcolA)
#endif
  
#else
  
  if(peinf%inode .eq. 0) then
    do jj = 1, nmtx
      do ii = 1, nmtx
        read(itape) (retarded(ifreq, ii, jj), ifreq = 1, nfreq)
      enddo
#ifdef CPLX
      do ii = 1, nmtx
        read(itape) (advanced(ifreq, ii, jj), ifreq = 1, nfreq)
      enddo
#endif
    enddo
  endif
  
#endif
  
  POP_SUB(read_matrix_f)
  
  return
end subroutine read_matrix_f

end module read_matrix_m
