!================================================================================
!
! Modules:
!
! (1) nrtype_m      Originally By ?      Last Modified 8/22/2010 (gsm)
!
!     Global constants and parameters.
!
!================================================================================

#include "f_defs.h"

module nrtype_m
    
  implicit none

  public

! parameters for real-space resolution in cell-truncation schemes
  integer, parameter :: n_in_box = 2
  integer, parameter :: n_in_wire = 4

! number of Monte-Carlo integration points
  integer, parameter :: nmc_coarse = 250000
  integer, parameter :: nmc_fine = 2500000
  integer, parameter :: nmc = nmc_fine

! type definitions following the convention of Numerical Recipes
! do not ever use single-precision!!
!  integer, parameter :: SP = kind(1.0)
  integer, parameter :: DP = kind(1.0d0)
!  integer, parameter :: SPC = kind((1.0,1.0))
  integer, parameter :: DPC = kind((1.0d0,1.0d0))

! physical constants
!
! These are the "2010 CODATA recommended values" taken from
! "The NIST Reference on Constants, Units, and Uncertainty"
! http://physics.nist.gov/cuu/
!
! The following variables are used throughout the package:
!     'BOHR', 'bohr' is Bohr radius, in Angstrom
!     'RYD', 'ryd2eV', 'rydberg' is Rydberg constant times hc, in eV
!     'HARTREE', 'hartree' is Hartree energy, in eV
!     'LIGHTSPEED' is inverse alpha (fine-structure constant)
!
! These variables are defined in the following files:
!     Common/nrtype.f90
!     Common/svninfo.f90
!     Common/wfn_utils.cpp
!     MeanField/EPM/ff2vq.py
!     MeanField/EPM/sysParams.f90
!     MeanField/EPM/vca.py
!     MeanField/ICM/icm.cpp
!     Visual/common.py
!
  real(DP), parameter :: BOHR = 0.52917721092_dp
  real(DP), parameter :: RYD = 13.60569253_dp
  real(DP), parameter :: LIGHTSPEED = 137.035999074_dp

! mathematical constants
!  real(SP), parameter :: PI_S = 3.1415926535897932384626433832795_sp
  real(DP), parameter :: PI_D = 3.1415926535897932384626433832795_dp
  real(DP), parameter :: TOL_Small = 1.0d-6
  real(DP), parameter :: TOL_Zero = 1.0d-12
  real(DP), parameter :: TOL_Degeneracy = 1.0d-6
  real(DP), parameter :: INF = 1.0d12

! string constants appearing at output
  character(len=16) :: ondate = 'Run on'
  character(len=16) :: attime = 'at'

end module nrtype_m
