!===============================================================================
!
! Routines:
!
! 1. norm_wfng()        Originally By gsm        Last Modified 9/1/2010 (gsm)
!
!    Normalizes wavefunctions in G-space.
!
!===============================================================================

#include "f_defs.h"

subroutine norm_wfng(ngk_l,nbstart,nbend,nb,ns,nk,wfn_d)

  use global_m
  implicit none

  integer, intent(in) :: ngk_l,nbstart,nbend,nb,ns,nk
  SCALAR, intent(inout) :: wfn_d(ngk_l,nb,ns,nk)

  integer :: ig,ib,is,ik,nbnorm
  real(DP) :: norm2,norm
  character(len=16) :: s1,s2,s3
  real(DP), allocatable :: norm2band(:)
  real(DP), allocatable :: norm2dummy(:)

  PUSH_SUB(norm_wfng)

  nbnorm=nbend-nbstart+1
  SAFE_ALLOCATE(norm2band, (nbnorm))
#ifdef MPI
  SAFE_ALLOCATE(norm2dummy, (nbnorm))
#endif
  do ik=1,nk
    do is=1,ns
      do ib=nbstart,nbend
        norm2=0.0d0
        do ig=1,ngk_l
          norm2=norm2+abs(wfn_d(ig,ib,is,ik))**2
        enddo ! ig
        norm2band(ib-nbstart+1)=norm2
      enddo ! ib
#ifdef MPI
      norm2dummy=norm2band
      call MPI_Allreduce(norm2dummy,norm2band,nbnorm, &
        MPI_REAL_DP,MPI_SUM,MPI_COMM_WORLD,mpierr)
#endif
      do ib=nbstart,nbend
        norm2=norm2band(ib-nbstart+1)
        
        if (norm2.gt.TOL_Zero) then
          norm=sqrt(norm2)
          do ig=1,ngk_l
            wfn_d(ig,ib,is,ik)=wfn_d(ig,ib,is,ik)/norm
          enddo ! ig
        else ! norm2.gt.TOL_Zero
          if (peinf%inode.eq.0) then
            write(s1,111)ib
            write(s2,111)is
            write(s3,111)ik
            write(0,211)TRUNC(s1),TRUNC(s2),TRUNC(s3)
          endif ! peinf%inode.eq.0
        endif ! norm2.gt.TOL_Zero
      enddo ! ib
    enddo ! is
  enddo ! ik
  SAFE_DEALLOCATE(norm2band)
#ifdef MPI
  SAFE_DEALLOCATE(norm2dummy)
#endif
  
  POP_SUB(norm_wfng)
  
  return
  
111 format(i16)
  
211 format(1x,"WARNING: zero norm for k-point =",1x,a,1x,"spin =", &
      1x,a,1x,"band =",1x,a,/)
  
end subroutine norm_wfng
