!============================================================================
!
! Routines:
!
! (1) checkconsistency() Originally by JRD               Last Modified: 2/09/2009 (JRD)
!
!============================================================================

#include "f_defs.h"

subroutine checkconsistency(itruncflag,iscreen,q0vec,bdot,ifreq)

  use global_m
  implicit none

  integer, intent(in) :: itruncflag
  integer, intent(in) :: iscreen
  real(DP), intent(in) :: q0vec(3)
  real(DP), intent(in) :: bdot(3,3)
  integer, intent(in) :: ifreq
  
  real(DP) :: q0len

  PUSH_SUB(checkconsistency)

  q0len = sqrt(DOT_PRODUCT(q0vec,MATMUL(bdot,q0vec)))

!---------------------------
! JRD: Should we call people names? For inconsistent
! truncation parameters

  if (peinf%inode .eq. 0 .and. ifreq .ne. -1) then

    if (iscreen .eq. 2 .and. q0len .lt. TOL_Small) then
      write(0,*) ' '
      write(0,*) 'You want metallic screening but didn''t specify q0vec!!'
      call die('Inconsistent Screening')
    endif

    if (iscreen .eq. 1 .and. q0len .lt. TOL_Small &
      .and. itruncflag .eq. 0) then
      write(0,*) ' '
      write(0,*) 'You want graphene screening with no truncation'
      write(0,*) 'but didn''t specify q0vec!!'
      call die('Inconsistent Screening')
    endif

    if ((itruncflag .eq. 0 .or. itruncflag .eq. 4 .or. &
      itruncflag .eq. 6) .and. q0len .lt. TOL_Small) then
      write(0,*) ' '
      write(0,*) 'You have a divergent Coulomb interaction but didn''t specify q0vec!!'
      call die('Inconsistent Screening')
    endif

    if ((itruncflag .ne. 0 .and. itruncflag .ne. 4 .and. &
      itruncflag .ne. 6) .and. iscreen .ne. 2 .and. &
      q0len .ge. TOL_Small) then
      write(0,*) ''
      write(0,*) 'You want semiconductor or graphene screening with truncation'
      write(0,*) 'but specified nonzero q0vec!!'
      call die('Inconsistent Screening')
    endif
    
  endif
  
  POP_SUB(checkconsistency)

  return
end subroutine checkconsistency
