!==============================================================================
!
! Routines:
!
! (1) mtxel_t()         Originally By MLT       Last Modified 7/1/2008 (JRD)
!
!     Calculated matrix elements needed for interpolation of kernel (dcc,dvv)
!
!     input: gvec, wfnc_co, wfnc_fi, wfnv_co, wfnvq_fi types
!            igumk        index of umklapp, translation, vector
!            nkpt         number of k-points in the fine grid, FBZ
!            ikpt         index of the current k-point
!
!     output: dcc, dvv     transformation matrices between point ikpt
!                      and the point in the coarse grid closest to it
!
!==============================================================================

#include "f_defs.h"

subroutine mtxel_t(nkpt,gvec,wfnc_co,wfnc_fi,wfnv_co,wfnvq_fi,dcc,dvv,igumk,ikpt,igumkq)

  use global_m
  implicit none

  integer, intent(in) :: nkpt
  type (gspace), intent(in) :: gvec
  type (wavefunction), intent(in) :: wfnc_co,wfnc_fi,wfnv_co,wfnvq_fi
  SCALAR, intent(out) :: &
    dcc(nkpt,wfnc_fi%nband,wfnc_co%nband,wfnc_fi%nspin), &
    dvv(nkpt,wfnvq_fi%nband,wfnv_co%nband,wfnvq_fi%nspin)
  integer, intent(in) :: igumk,ikpt,igumkq

  integer :: ig,ign,ic_co,ic_fi,iv_co,iv_fi,isc,isv
  integer :: igadd,igaddn,kaddn,kn(3),km(3)
  integer, allocatable :: isorti(:), isortiq(:)

  PUSH_SUB(mtxel_t)

  dcc(ikpt,:,:,:)=0.0d0
  dvv(ikpt,:,:,:)=0.0d0

! Compute maximum size of the cube

  km(1:3)=gvec%kmax(1:3)

! Compute inverse array to wfnc_co%isort

  SAFE_ALLOCATE(isorti, (gvec%ng))
  isorti=0
  do ig=1,gvec%ng
    isorti(wfnc_co%isort(ig))=ig
  enddo
  
  SAFE_ALLOCATE(isortiq, (gvec%ng))
  isortiq=0
  do ig=1,gvec%ng
    isortiq(wfnv_co%isort(ig))=ig
  enddo

! Loop over G-vectors

  ig_loop: do ig=1,wfnc_fi%ng
    if (igumk.eq.1) then
      ign=isorti(wfnc_fi%isort(ig))
    else
      igadd=wfnc_fi%isort(ig)

! Compute address of gn=g+gumk:
! If the result is beyond planewaves included in wavefunction, skip

      kn(1:3)=gvec%k(1:3,igadd)+gvec%k(1:3,igumk)+gvec%kmax(1:3)/2+1
      if(any(kn(1:3) < 1) .or. any(kn(1:3) > km(1:3))) cycle ig_loop
      kaddn=((kn(1)-1)*km(2)+kn(2)-1)*km(3)+kn(3)
      igaddn=gvec%indv(kaddn) ! relate the cube to the sphere
      ign=isorti(igaddn)
    endif
    if(ign.gt.wfnc_co%ng) cycle ig_loop

! Compute matrix element <c_co,k_co|exp(i(k_co-k_fi).r)|c_fi,k_fi>

    do ic_fi=1,wfnc_fi%nband
      do ic_co=1,wfnc_co%nband
        do isc=1,wfnc_co%nspin
          dcc(ikpt,ic_fi,ic_co,isc)=dcc(ikpt,ic_fi,ic_co,isc)+ &
            wfnc_fi%cg(ig,ic_fi,isc)*MYCONJG(wfnc_co%cg(ign,ic_co,isc))
        enddo
      enddo
    enddo

  enddo ig_loop !loop ig

! Loop over G vectors

  ig2_loop: do ig=1,wfnvq_fi%ng
    if (igumkq.eq.1) then
      ign=isortiq(wfnvq_fi%isort(ig))
    else
      igadd=wfnvq_fi%isort(ig)
        
! Compute address of gn=g+gumk:
! If the result is beyond planewaves included in wavefunction, skip

      kn(1:3)=gvec%k(1:3,igadd)+gvec%k(1:3,igumkq)+gvec%kmax(1:3)/2+1
      if(any(kn(1:3) < 1) .or. any(kn(1:3) > km(1:3))) cycle ig2_loop
      kaddn=((kn(1) - 1) * km(2) + kn(2) - 1) * km(3) + kn(3)
      igaddn=gvec%indv(kaddn) ! relate the cube to the sphere
      ign=isortiq(igaddn)
    endif
    if(ign.gt.wfnv_co%ng) cycle ig2_loop

! Compute matrix element <v_co,k_co|exp(i(k_co-k_fi-Q).r)|v_fi,k_fi+Q>

    do iv_fi=1,wfnvq_fi%nband
      do iv_co=1,wfnv_co%nband
        do isv=1,wfnv_co%nspin
          dvv(ikpt,iv_fi,iv_co,isv)=dvv(ikpt,iv_fi,iv_co,isv)+ &
            wfnvq_fi%cg(ig,iv_fi,isv)*MYCONJG(wfnv_co%cg(ign,iv_co,isv))
        enddo
      enddo
    enddo

  enddo ig2_loop !loop ig
  
  SAFE_DEALLOCATE(isorti)
  SAFE_DEALLOCATE(isortiq)
  
  POP_SUB(mtxel_t)
  
  return
end subroutine mtxel_t
