
! This wretched derelict file is no longer compiled. --DAS

#include "f_defs.h"

! THIS IS BROKEN!!!!!!!! This is for Finite Q but doesn`t work with new code
! nckmem is not available for example
! This version is not usable for spin polarized systems

! This file has not been updated to new wfn format because the way it is
! written (reading WFN_co and WFNq_co instead of leaving WFN_co to input_kernel.f90)
! seems like a bad idea, and so updating is a waste of time.
! To make Finite Q work, start from scratch with input_kernel.f90. --DAS

!-----------------------------------------------------------------------
      subroutine input_kernel_q(crys,gvec,kg,kgq,kp,kpq, &
      syms,xct,flagbz)
!-----------------------------------------------------------------------
!
!     Read parameters from file WFN_co
!     Initialize k-points sampling, kg type
!     Initialize G-space, gvec
!
!     input: xct type
!
!     output: crys,gvec,syms,kg types
!             peinf type (from distrib.f90)
!             INT_VWFN_* and INT_CWFN_* files
!
      use global_m
      use fullbz_m
      use input_utils_m
      use misc_m
      use sort_m
      implicit none
!
!
      type (crystal) crys
      type (crystal) crysq
      type (gspace) gvec
      type (grid) kg
      type (grid) kgq
      type (kpoints) kp
      type (kpoints) kpq
      type (symmetry) syms
      type (xctinfo) xct
      integer flagbz
!
!     Local variables
!
      type (symmetry) symsq
      type (wavefunction) wfnc,wfnv,wfncq,wfnvq
      character filenamec*20,filenamev*20
      character tmpfn*16, errmsg*100
      integer itpv,itpc,iwritev,iwritec,iwriteb,ikq
      integer iadd,iaux(3),ickmem,icurr,invflag,iout, &
       irk,itest,ierr
      integer ii,ik,jj,kk,is,ll,nn,gv(3),gvq(3)
      integer dest,tag,ibc,ibv
      integer kx,ky,kz,ng,irks,ngq

      real(DP) diffvol,norm,vcell,tsec(2),raux,kt(3),div, &
         tol,qq(3),delta,xnorm

      real(DP), allocatable :: ek_tmp(:)
      integer, allocatable :: index(:),isendv(:),isendc(:), &
               indxk(:),indxkq(:),k_tmp(:,:)
      SCALAR, allocatable :: cg(:,:)
      logical :: skip_checkbz

!-----------------------------------------------------------------------
!     Read info for crystal from WFN_co

      PUSH_SUB(input_kernel_q)

      call logit('input_kernel_q:  reading wfn_co')
      call die("FIXME: new wfn format not implemented in input_kernel_q.f90")

      if(peinf%inode.eq.0) then

        call open_file(unit=25,file='WFN_co',form='unformatted',status='old')
!        rewind(25)
        read(25) ((crys%bdot(ii,jj),ii=1,3),jj=1,3)
        read(25) crys%celvol

! JRD Finite Q
        if (xct%qflag .eq. 0) then
          call open_file(unit=26,file='WFNq_co',form='unformatted',status='old')
!          rewind(26)
          read(26) ((crysq%bdot(ii,jj),ii=1,3),jj=1,3)
          read(26) crysq%celvol
        end if

      endif

#ifdef MPI
      call MPI_BCAST(crys%bdot,   9,     MPI_REAL_DP,0, &
       MPI_COMM_WORLD,mpierr)
      call MPI_BCAST(crys%celvol, 1,     MPI_REAL_DP,0, &
       MPI_COMM_WORLD,mpierr)
! JRD Finite Q
        if (xct%qflag .eq. 0) then
      call MPI_BCAST(crysq%bdot,   9,     MPI_REAL_DP,0, &
       MPI_COMM_WORLD,mpierr)
      call MPI_BCAST(crysq%celvol, 1,     MPI_REAL_DP,0, &
       MPI_COMM_WORLD,mpierr)
        end if
#endif

      call get_volume(vcell,crys%bdot)
      diffvol=abs(crys%celvol-vcell)
      if (diffvol.gt.TOL_Small) then
        call die('volume mismatch', only_root_writes = .true.)
      endif

!-----------------------------------------------------------------------
!     Read crystal symmetry operations from WFN_co

      if(peinf%inode.eq.0) then

        read(25) syms%ntran

!JRD Finite Q
        if (xct%qflag .eq. 0) then
          read(26) symsq%ntran

        if (syms%ntran .ne. symsq%ntran) then
           write(6,*) 'Mismatch of symmetry in files'
           call die('symsq does not equal syms')
        end if
        do nn=1,syms%ntran
          read(25) ((syms%mtrx(ii,jj,nn),ii=1,3),jj=1,3)
        enddo
        endif

!JRD Finite Q
        if (xct%qflag .eq. 0) then
        do nn=1,syms%ntran
          read(26) ((symsq%mtrx(ii,jj,nn),ii=1,3),jj=1,3)
        enddo

        do nn=1,syms%ntran
        do ii=1, 3
        do jj=1,3
         if (syms%mtrx(ii,jj,nn).ne.symsq%mtrx(ii,jj,nn)) then
           write(6,*) 'Mismatch of symmetry in files'
           call die('symsq does not equal syms')
         end if
        enddo
        enddo
        enddo
        end if

        do nn=1,syms%ntran
          read(25) (syms%tnp(kk,nn),kk=1,3)
        enddo

!JRD Finite Q
        if (xct%qflag .eq. 0) then
        do nn=1,symsq%ntran
          read(26) (symsq%tnp(kk,nn),kk=1,3)
        enddo

        do nn=1,syms%ntran
        do kk=1, 3
         if (syms%tnp(kk,nn).ne.symsq%tnp(kk,nn)) then
           write(6,*) 'Mismatch of symmetry in files'
           call die('symsq does not equal syms')
         end if
        enddo
        enddo

        endif
      endif ! node 0

#ifdef MPI
      call MPI_BCAST(syms%ntran, 1,     MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      call MPI_BCAST(syms%mtrx(1,1,1),  3*3*48,MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      call MPI_BCAST(syms%tnp,   3*48,  MPI_REAL_DP,0, &
       MPI_COMM_WORLD,mpierr)
#endif

!-----------------------------------------------------------------------
!     Read info for k-points from WFN_co

      if(peinf%inode.eq.0) then

        read(25) kp%nspin
        call check_inversion_type(0, syms, kp%nspin, .true., .false.)

        read(25) kp%nrk
        read(25) (kp%kgrid(ii),ii=1,3)
        read(25) (kp%shift(ii),ii=1,3)
        SAFE_ALLOCATE(kp%w, (kp%nrk))
        read(25) (kp%w(ii),ii=1,kp%nrk)
        SAFE_ALLOCATE(kp%rk, (3,kp%nrk))
        do jj=1,kp%nrk
          read(25) (kp%rk(ii,jj),ii=1,3)
        enddo
        read(25) kp%mnband
        SAFE_ALLOCATE(kp%ifmin, (kp%nrk,kp%nspin))
        read(25) ((kp%ifmin(ii,jj),ii=1,kp%nrk),jj=1,kp%nspin)
        SAFE_ALLOCATE(kp%ifmax, (kp%nrk,kp%nspin))
        read(25) ((kp%ifmax(ii,jj),ii=1,kp%nrk),jj=1,kp%nspin)
        SAFE_ALLOCATE(kp%el, (kp%mnband,kp%nrk,kp%nspin))
        do jj=1,kp%nspin
          do ii=1,kp%nrk
            read(25) (kp%el(kk,ii,jj),kk=1,kp%mnband)
          enddo
        enddo

!----------------------------------------------------------------
! JRD: Finite Q

        if (xct%qflag .eq. 0) then

          read(26) kpq%nspin
          read(26) kpq%nrk
          read(26) (kpq%kgrid(ii),ii=1,3)
          read(26) (kpq%shift(ii),ii=1,3)
          SAFE_ALLOCATE(kpq%w, (kpq%nrk))
          read(26) (kpq%w(ii),ii=1,kp%nrk)
          SAFE_ALLOCATE(kpq%rk, (3,kp%nrk))
          do jj=1,kpq%nrk
            read(26) (kpq%rk(ii,jj),ii=1,3)
          enddo
          read(26) kpq%mnband
          SAFE_ALLOCATE(kpq%ifmin, (kpq%nrk,kpq%nspin))
          read(26) ((kpq%ifmin(ii,jj),ii=1,kpq%nrk),jj=1,kpq%nspin)
          SAFE_ALLOCATE(kpq%ifmax, (kpq%nrk,kpq%nspin))
          read(26) ((kpq%ifmax(ii,jj),ii=1,kpq%nrk),jj=1,kpq%nspin)
          SAFE_ALLOCATE(kpq%el, (kpq%mnband,kpq%nrk,kpq%nspin))
          do jj=1,kpq%nspin
            do ii=1,kpq%nrk
              read(26) (kpq%el(kk,ii,jj),kk=1,kpq%mnband)
            enddo
          enddo

          call find_efermi(xct%rfermi, xct%efermi, xct%efermi_input, kpq, kpq%mnband, &
            "shifted coarse grid", should_search = .false., should_update = .false., write7 = .false.)

        endif ! finite q

      endif ! node 0

!----------------------------------------------------------------
! Distribute data read from wavefunction file

#ifdef MPI
      call MPI_BCAST(kp%nspin, 1,     MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      call MPI_BCAST(kp%nrk,   1,     MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      call MPI_BCAST(kp%kgrid, 3,     MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      if(peinf%inode.ne.0) then
         SAFE_ALLOCATE(kp%rk, (3,kp%nrk))
      endif
      call MPI_BCAST(kp%rk,    3*kp%nrk,MPI_REAL_DP,0, &
       MPI_COMM_WORLD,mpierr)
      call MPI_BCAST(kp%mnband,1,     MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      if(peinf%inode.ne.0) then
         SAFE_ALLOCATE(kp%ifmax, (kp%nrk,kp%nspin))
      endif
      call MPI_BCAST(kp%ifmax, kp%nrk*kp%nspin,MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      if(peinf%inode.ne.0) then
         SAFE_ALLOCATE(kp%ifmin, (kp%nrk,kp%nspin))
      endif
      call MPI_BCAST(kp%ifmin, kp%nrk*kp%nspin,MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      if(peinf%inode.ne.0) then
         SAFE_ALLOCATE(kp%el, (kp%mnband,kp%nrk,kp%nspin))
      endif
      call MPI_BCAST(kp%el(1,1,1),kp%mnband*kp%nrk*kp%nspin, &
      MPI_REAL_DP,0,MPI_COMM_WORLD,mpierr)

!JRD Finite Q

      if (xct%qflag .eq. 0) then
      call MPI_BCAST(kpq%nspin, 1,     MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      call MPI_BCAST(kpq%nrk,   1,     MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      call MPI_BCAST(kpq%kgrid, 3,     MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      if(peinf%inode.ne.0) then
         SAFE_ALLOCATE(kpq%rk, (3,kpq%nrk))
      endif
      call MPI_BCAST(kpq%rk,    3*kpq%nrk,MPI_REAL_DP,0, &
       MPI_COMM_WORLD,mpierr)
      call MPI_BCAST(kpq%mnband,1,     MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      if(peinf%inode.ne.0) then
         SAFE_ALLOCATE(kpq%ifmax, (kpq%nrk,kpq%nspin))
      endif
      call MPI_BCAST(kpq%ifmax, kpq%nrk*kpq%nspin,MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      if(peinf%inode.ne.0) then
         SAFE_ALLOCATE(kpq%ifmin, (kpq%nrk,kpq%nspin))
      endif
      call MPI_BCAST(kpq%ifmin, kpq%nrk*kpq%nspin,MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      if(peinf%inode.ne.0) then
         SAFE_ALLOCATE(kpq%el, (kpq%mnband,kpq%nrk,kpq%nspin))
      end if
      call MPI_BCAST(kpq%el(1,1,1),kpq%mnband*kpq%nrk*kpq%nspin, &
      MPI_REAL_DP,0,MPI_COMM_WORLD,mpierr)
      endif
#endif

      xct%nspin=kp%nspin

!-----------------------------------------------------------------------
!     Read the k-point sampling from kpoints (if it exists) or from
!     WFN_co

      if (xct%skpt.eq.1) then
         if (peinf%inode.eq.0) then
            call open_file(9,file='kpoints_co',form='formatted',status='old')
            read(9,*) kg%nr
            SAFE_ALLOCATE(kg%r, (3,kg%nr))
            do ii=1,kg%nr
               read(9,*) (kg%r(jj,ii),jj=1,3),div
               kg%r(:,ii) = kg%r(:,ii)/div
            enddo
            close(9)
         endif
#ifdef MPI
         call MPI_BCAST(kg%nr,   1,     MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
         if(peinf%inode.ne.0) then
            SAFE_ALLOCATE(kg%r, (3,kg%nr))
         endif
         call MPI_BCAST(kg%r,    3*kg%nr,MPI_REAL_DP,0, &
       MPI_COMM_WORLD,mpierr)
#endif

!----------------------------------------------------------------
!     indxk : stores the correspondence between k-points kg%r and kp%rk
!     (it is used to select the set of wavefunctions to be stored)
!     tol : tolerance in the coordinates of k-points

         tol = 1.d-4
         SAFE_ALLOCATE(indxk, (kg%nr))
         indxk=0
         do jj=1,kg%nr
           do ii=1,kp%nrk
              kt(:) = kg%r(:,jj) - kp%rk(:,ii)
              if ((abs(kt(1)).lt.tol).and.(abs(kt(2)).lt.tol) &
                   .and.(abs(kt(3)).lt.tol)) then
                 if (indxk(jj).ne.0) &
                   write(0,*) 'WARNING: multiple definition of k-point',jj,indxk(jj),kg%r(:,jj)
                 indxk(jj)=ii
              endif
           enddo
           if (indxk(jj).eq.0) write(0,*) 'WARNING: could not find vector ',kg%r(:,jj),' in WFN_co'
!
!     no need to stop here; if indxk.eq.0, the job will stop in genwf
!
         enddo
      else
         kg%nr=kp%nrk
         SAFE_ALLOCATE(kg%r, (3,kg%nr))
         kg%r(1:3,1:kg%nr)=kp%rk(1:3,1:kp%nrk)
         SAFE_ALLOCATE(indxk, (kg%nr))
         do ii=1,kg%nr
            indxk(ii) = ii
         enddo
      endif

!JRD Finite Q

        if (xct%qflag .eq. 0) then
         kgq%nr=kpq%nrk
         SAFE_ALLOCATE(kgq%r, (3,kgq%nr))
         kgq%r(1:3,1:kgq%nr)=kpq%rk(1:3,1:kpq%nrk)
         SAFE_ALLOCATE(indxkq, (kgq%nr))
         do ii=1,kgq%nr
            indxkq(ii) = ii
         enddo
        end if

!-----------------------------------------------------------------------
!     Read info for G-vectors from WFN_co
!
      call logit('input_kernel:  reading gvec info')
      if(peinf%inode.eq.0) then
        read(25) (gvec%kmax(ii),ii=1,3)
        read(25) gvec%ng
        SAFE_ALLOCATE(gvec%k, (3,gvec%ng))
        do ii=1,gvec%ng
          read(25) gvec%k(1,ii),gvec%k(2,ii),gvec%k(3,ii)
        enddo

!JRD Finite Q
       if (xct%qflag .eq. 0) then
         read(26) kx,ky,kz
         if (kx.ne.gvec%kmax(1).or.ky.ne.gvec%kmax(2).or.kz.ne. &
             gvec%kmax(3)) then
            write(0,*) &
                'WARNING: WFN_co and WFNq_co have different FFT grids. '
            write(0,*) gvec%kmax,kx,ky,kz
            write(0,*) 'FFT grid in WFNq_co is being ignored'
         endif
         read(26)
         do ii=1,gvec%ng
            read(26)
         enddo
       end if

      endif

#ifdef MPI
      call MPI_BCAST(gvec%kmax, 3,      MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      call MPI_BCAST(gvec%ng,   1,      MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)
      if(peinf%inode.ne.0) then
         SAFE_ALLOCATE(gvec%k, (3,gvec%ng))
      endif
      call MPI_BCAST(gvec%k,   3*gvec%ng,MPI_INTEGER,0, &
       MPI_COMM_WORLD,mpierr)

#endif
!-----------------------------------------------------------------------
!     Order g-vectors with respect to their kinetic energy
!
!     xct%ecute = energy cutoff used in dielectric matrix
!     xct%ecutg = energy cutoff used in wavefunctions and interaction
!                   kernel, see Rohlfing & Louie, PRB 62(8),p. 4938
!                   (must be slinghtly longer than xct%ecute because
!                   of umklapp vectors)
!
      call logit('input_kernel_q:  reordering gvecs')
      raux=0.d0
      do ii=1,3
         if (crys%bdot(ii,ii).gt.raux) raux=crys%bdot(ii,ii)
      enddo
      if (abs(xct%ecutg).lt.TOL_Zero) xct%ecutg = xct%ecute + raux

      SAFE_ALLOCATE(index, (gvec%ng))
      SAFE_ALLOCATE(gvec%ekin, (gvec%ng))
      xct%ng=0
      xct%neps=0
      do ii=1,gvec%ng
        norm=0.0
        gv(1)=gvec%k(1,ii)
        gv(2)=gvec%k(2,ii)
        gv(3)=gvec%k(3,ii)
        norm=norm+DOT_PRODUCT(gv,MATMUL(crys%bdot,gv))
        gvec%ekin(ii)=norm
        if(gvec%ekin(ii).lt.xct%ecutg) xct%ng=xct%ng+1
        if(gvec%ekin(ii).lt.xct%ecute) xct%neps=xct%neps+1
      enddo
      call sortrx_D(gvec%ng, gvec%ekin, index, gvec = gvec%k)
!
!      do 31 ii=1,gvec%ng-1
!        icurr=ii
!  30    if(index(icurr).ne.ii) then
!          iaux(:)=gvec%k(:,icurr)
!          gvec%k(:,icurr)=gvec%k(:,index(icurr))
!          gvec%k(:,index(icurr))=iaux(:)
!
!          raux=gvec%ekin(icurr)
!          gvec%ekin(icurr)=gvec%ekin(index(icurr))
!          gvec%ekin(index(icurr))=raux
!
!          jj=icurr
!          icurr=index(icurr)
!          index(jj)=jj
!
!          if(index(icurr).eq.ii) then
!            index(icurr)=icurr
!            goto 31
!          endif
!          goto 30
!        endif
!   31 continue
!
      SAFE_ALLOCATE(ek_tmp, (gvec%ng))
      ek_tmp = gvec%ekin
      SAFE_ALLOCATE(k_tmp, (3,gvec%ng))
      k_tmp = gvec%k
      do ii=1,gvec%ng
         gvec%ekin(ii) = ek_tmp(index(ii))
         gvec%k(:,ii) = k_tmp(:,index(ii))
      enddo
      SAFE_DEALLOCATE(ek_tmp)
      SAFE_DEALLOCATE(k_tmp)
      SAFE_DEALLOCATE(index)

!-----------------------------------------------------------------------
!     Need to create indv
!
      gvec%nktot=gvec%kmax(1)*gvec%kmax(2)*gvec%kmax(3)
      SAFE_ALLOCATE(gvec%indv, (gvec%nktot))
      do ii=1,gvec%nktot
         gvec%indv(ii)=0
      enddo
      do ii=1,gvec%ng
        iadd=((gvec%k(1,ii)+gvec%kmax(1)/2)*gvec%kmax(2)+gvec%k(2,ii)+ &
         gvec%kmax(2)/2)*gvec%kmax(3)+gvec%k(3,ii)+gvec%kmax(3)/2+1
        gvec%indv(iadd)=ii
      enddo

!-----------------------------------------------------------------------
!     Generate full brillouin zone from irreducible wedge, rk -> fk
!
!     If flagbz.eq.1, only Identity will be used as
!     symmetry operation. In this case, kg%r (irreducible BZ) and kg%f
!     (full BZ) will be identical.
!
      if (flagbz.eq.0.and.peinf%inode.eq.0) write(6,801)
      if (flagbz.eq.1.and.peinf%inode.eq.0) write(6,802)
  801 format(1x,'Using symmetries to expand the coarse grid sampling',/)
  802 format(1x,'No symmetries used in the coarse grid sampling',/)
!
      call timacc(7,1,tsec)
      if (flagbz.eq.1) then
         call fullbz(crys,syms,kg,1,skip_checkbz,wigner_seitz=.true.,paranoid=.true.)
      else
         call fullbz(crys,syms,kg,syms%ntran,skip_checkbz,wigner_seitz=.true.,paranoid=.true.)
      endif
      call timacc(7,2,tsec)
      xct%nkpt=kg%nf

! JRD Finite Q

      if (xct%qflag .eq. 0) then

!-----------------------------------------------------------------------
!     Generate full brillouin zone from irreducible wedge, rk -> fk
!
!     If flagbz.eq.1, only Identity will be used as
!     symmetry operation. In this case, kg%r (irreducible BZ) and kg%f
!     (full BZ) will be identical.
!
      if (flagbz.eq.0.and.peinf%inode.eq.0) write(6,*) 'Using ', &
         'symmetries to expand the coarse grid sampling'
      if (flagbz.eq.1.and.peinf%inode.eq.0) write(6,*) 'No  ', &
         'symmetries used in the coarse grid sampling'
      call timacc(7,1,tsec)
      if (flagbz.eq.1) then
         call fullbz(crysq,syms,kgq,1,skip_checkbz,wigner_seitz=.true.,paranoid=.true.)
      else
         call fullbz(crysq,syms,kgq,syms%ntran,skip_checkbz,wigner_seitz=.true.,paranoid=.true.)
      endif
      tmpfn='WFNq_co'
      if (.not. skip_checkbz) then
        call checkbz(kgq%nf,kgq%f,kpq%kgrid,kpq%shift,crys%bdot, &
          tmpfn,'k',.true.,xct%freplacebz,xct%fwritebz)
      endif
      call timacc(7,2,tsec)
      xct%nkptq=kgq%nf

      end if !qflag

#ifdef VERBOSE
      if (peinf%inode.eq.0) then
         write(6,*) 'xct%nkpt = ',xct%nkpt
         write(6,'(a5,3a9,2a7,5x,3a5)') &
             'i',' ','k',' ','indr','itran','kg0'
         do ii=1,kg%nf
            write(6,'(i5,3f9.4,2i7,5x,3i5)') &
                ii,kg%f(:,ii),kg%indr(ii),kg%itran(ii),kg%kg0(:,ii)
         enddo


        if (xct%qflag .eq. 0) then
         write(6,*) 'xct%nkptq = ',xct%nkptq
         write(6,'(a5,3a9,2a7,5x,3a5)') &
             'i',' ','k',' ','indr','itran','kg0'
         do ii=1,kgq%nf
            write(6,'(i5,3f9.4,2i7,5x,3i5)') &
                ii,kgq%f(:,ii),kgq%indr(ii),kgq%itran(ii),kgq%kg0(:,ii)
         enddo
        endif

      endif
#endif


        if (xct%qflag .eq. 0) then

       xct%qshift= sqrt( DOT_PRODUCT(xct%shift(:), &
              MATMUL(crys%bdot,xct%shift(:) )) )

!
!-----------------------------------------------------------------------
!     Find correspondence with betwen fk of WFN_co and WFNq_co
!
!     xct%indexq : correspondence between a k-point in the full BZ, kg%f, and
!       its shifted vector, in kgq%f
!     tol : tolerance
!
      SAFE_ALLOCATE(xct%indexq, (kg%nf))

      tol = TOL_Small
      do ik=1,kg%nf
        ikq=0
        delta=0.1d0
        do while((delta.gt.tol).and.(ikq.lt.kgq%nf))
          ikq=ikq+1
          qq(:) = kg%f(:,ik)-(kgq%f(:,ikq)-xct%shift(:))
          do kk=1,3
              qq(kk) = qq(kk) - anint( qq(kk) )
          enddo
          delta=sqrt((qq(1))**2+(qq(2))**2+(qq(3))**2)
        enddo
        if(delta.gt.tol) then
          if(peinf%inode.eq.0) then
            write(0,*) '  Could not find point equivalent to ', (kg%f(ii,ik),ii=1,3)
          endif
          call die('k-point mismatch between WFN_co and WFNq_co', only_root_writes = .true.)
        else
!
!     make sure that kgq%f(:,ikq)-kg%f(:,ik) = shift vector
!     Near the zone edge, they may differ by a lattice vector
!
          do jj=1,3
             ii = nint( kgq%f(jj,ikq)-kg%f(jj,ik) )
             kgq%f(jj,ikq) = kgq%f(jj,ikq) - dble(ii)
             kgq%kg0(jj,ikq) = kgq%kg0(jj,ikq) - ii
          enddo
          qq(:) = kg%f(:,ik)-(kgq%f(:,ikq)-xct%shift(:))
          delta=sqrt((qq(1))**2+(qq(2))**2+(qq(3))**2)
          if (delta.gt.tol) then
            if(peinf%inode.eq.0) then
              write(0,*) '  Could not find point equivalent to ', (kg%f(ii,ik),ii=1,3)
            endif
            call die('k-point mismatch (wrong shift) between WFN_co and WFNq_co', only_root_writes = .true.)
          endif
          xct%indexq(ik)=ikq
        endif
      enddo
        end if  ! qflag = 0


!

!
!-----------------------------------------------------------------------
!     Read the wavefunctions and create INT_VWFN_* and INT_CWFN_*
!
!JRD: We now do this is two loops: conduction and valence (Q shifted)
!
      call logit('input_kernel:  reading wavefunctions')
      if(peinf%inode.lt.10000) then
        write(filenamev,'(a,i4.4)') 'INT_VWFN_', peinf%inode
        write(filenamec,'(a,i4.4)') 'INT_CWFN_', peinf%inode
      else
        call die("input_kernel_q: cannot use more than 10000 nodes")
      endif
      itpv=128+(3*peinf%inode)
      itpc=128+(3*peinf%inode)+1
      call open_file(itpv,file=filenamev,form='unformatted')
      call open_file(itpc,file=filenamec,form='unformatted')
!

      do irk=1,kp%nrk

        do ii=1,kg%nr
           if (irk.eq.indxk(ii)) then
              irks=ii
              goto 250
           endif
        enddo
        if(peinf%inode.eq.0) then
          read(25) ng
          do ii=1,ng
             read(25)
          enddo
          do ii=1,kp%mnband
            read(25)
          enddo
        endif
        goto 500
 250    continue

        if(peinf%inode.eq.0) then
          read(25) ng
          SAFE_ALLOCATE(wfnc%isort, (gvec%ng))
          wfnc%isort=0
          do ii=1,ng
            read(25) kx,ky,kz
            call findvector(iout,kx,ky,kz,gvec)
            if(iout.eq.0) then
              call die('could not find gvec')
            endif
            wfnc%isort(ii)=iout
          enddo
        endif
#ifdef MPI
        call MPI_BCAST(ng,        1,      MPI_INTEGER,0, &
         MPI_COMM_WORLD,mpierr)
        if(peinf%inode.ne.0) then
           SAFE_ALLOCATE(wfnc%isort, (gvec%ng))
        endif
        call MPI_BCAST(wfnc%isort,gvec%ng,MPI_INTEGER,0, &
         MPI_COMM_WORLD,mpierr)
#endif

!
!         Distribute vcks-quadruplets among the PEs
!
        call logit('input_kernel_q:  calling distrib_kernel')
!        if(peinf%inode.eq.0) write(6,*) 'Enter distrib_kernel ii',
!     >    'irk,kp%nrk',irk,kp%nrk
! LINE BELOW MAY BE BROKEN, SOME ARGS MAYBE SHOULD BE KPG,KGQ,ETC.
        call distrib_kernel(xct,gvec%kmax,kp%ngkmax,kg,kg,gvec)
!        if(peinf%inode.eq.0) write(6,*) 'Exit distrib_kernel'

        wfnc%ng=ng
        wfnc%nband=peinf%nckmem
        wfnc%nspin=kp%nspin
        SAFE_ALLOCATE(wfnc%cg, (wfnc%ng,wfnc%nband,wfnc%nspin))
        SAFE_ALLOCATE(cg, (ng,kp%nspin))
        ickmem=0

!       Determine which PEs will write the valence bands for this k-point
        iwritev=0
        do ii=1,peinf%nckpe
          if(kg%indr(peinf%ik(peinf%inode+1,ii)).eq.irks) then
            iwritev=1
            goto 300
          endif
        enddo
  300   continue

!       Determine to which PEs the valence bands for this k-point
!       need to be sent...
!        allocate(isendv(peinf%npes))
!        isendv=0
!        if(peinf%inode.eq.0) then
!          do jj=2,peinf%npes
!            do ii=1,peinf%nckpe
!              if(kg%indr(peinf%ik(jj,ii)).eq.irks) then
!                isendv(jj)=1
!                goto 310
!              endif
!            enddo
!  310       continue
!          enddo
!        endif
!
!       Loop over the bands
!
        do ii=1,kp%mnband
          ! If we do not need this band, skip it...
          if((ii.le.(kpq%ifmax(irk,1)+1)) &
             .or.(ii.gt.(kpq%ifmax(irk,1)+xct%ncband))) then

            if (peinf%inode.eq.0) then
               read(25)
            endif
            cycle
          endif

          if(peinf%inode.eq.0) then
!           Read planewave coefficients for band ii
            read(25) ((cg(jj,kk),jj=1,ng),kk=1,kp%nspin)
!           Check normalization of this band
!            do kk=1,kp%nspin
              call checknorm('WFN_co',ii,irks,kp%nspin,ng,cg)
!            enddo
          endif

!         If ii is one of the selected conduction bands...
          if((ii.ge.(kpq%ifmax(irk,1)+1)) &
             .and.(ii.le.(kpq%ifmax(irk,1)+xct%ncband))) then

!           Determine which PEs will write this conduction band
!           for this k-point
            iwritec=0
            do jj=1,peinf%nckpe
!              if((kg%indr(peinf%ik(peinf%inode+1,jj)).eq.irks).and.
!     >          (peinf%ic(peinf%inode+1,jj).eq.ii-xct%ncbl+1)) then
              if((kg%indr(peinf%ik(peinf%inode+1,jj)).eq.irks).and. &
           (peinf%ic(peinf%inode+1,jj).eq.ii-kpq%ifmax(irk,1))) then

                iwritec=1
                iwriteb=peinf%ib(peinf%inode+1,jj)
                goto 320
              endif
            enddo
  320       continue

!           Determine to which PEs this conduction band for this k-point
!           need to be sent...
            SAFE_ALLOCATE(isendc, (peinf%npes))
            isendc=0
            if(peinf%inode.eq.0) then
              do kk=2,peinf%npes
                do jj=1,peinf%nckpe
!                  if((kg%indr(peinf%ik(kk,jj)).eq.irks).and.
!     >              (peinf%ic(kk,jj).eq.ii-xct%ncbl+1)) then
                  if((kg%indr(peinf%ik(kk,jj)).eq.irks).and. &
               (peinf%ic(kk,jj).eq.ii-kpq%ifmax(irk,1))) then

                    isendc(kk)=1
                    goto 330
                  endif
                enddo
  330           continue
              enddo
            endif

#ifdef MPI
            if(peinf%inode.eq.0) then
              do jj=2,peinf%npes
                if(isendc(jj).eq.1) then
                  dest=jj-1
                  tag=1000+dest
                  call MPI_SEND(cg,ng*kp%nspin,MPI_SCALAR, &
                   dest,tag,MPI_COMM_WORLD,mpierr)
                endif
              enddo
            else
              if(iwritec.eq.1) then
                tag=1000+peinf%inode
                call MPI_RECV(cg,ng*kp%nspin,MPI_SCALAR,0,tag, &
                 MPI_COMM_WORLD,mpistatus,mpierr)
              endif
            endif
#endif
            SAFE_DEALLOCATE(isendc)

            if(iwritec.eq.1) then
              wfnc%cg(1:wfnc%ng, &
                     mod(ickmem,peinf%nckmem)+1,1:wfnc%nspin)= &
               cg(1:wfnc%ng,1:wfnc%nspin)
              if(mod(ickmem,peinf%nckmem)+1.eq.peinf%nckmem) then
                write(itpc) irks,iwriteb, &
                 wfnc%ng,wfnc%nband,wfnc%nspin
                write(itpc) (wfnc%isort(jj),jj=1,gvec%ng), &
                 (((wfnc%cg(jj,kk,ll),jj=1,wfnc%ng), &
                                      kk=1,wfnc%nband), &
                                      ll=1,wfnc%nspin)

!JRD Check norm here
#ifdef VERBOSE
!               do ll = 1,wfnc%nspin
!               kk = mod(ickmem,peinf%nckmem)+1
!               xnorm=0.0d0
!               do jj = 1, wfnc%ng
!               xnorm= xnorm +
!     >           wfnc%cg(jj,kk,ll)*CONJG(wfnc%cg(jj,kk,ll))
!               end do
!               xnorm = sqrt(xnorm)
!               write(6,*) 'Node: ',peinf%inode,' p%nckmem: ',
!     >              peinf%nckmem,' ickmem: ',ickmem,' iwriteb',
!     >              iwriteb
!               write(6,*) 'Norm:',kk,' of ',wfnc%nband,xnorm
!               write(6,*) ' '
!               end do
#endif

             endif
              ickmem=ickmem+1
            endif

          endif !ii is one of the selected conduction bands
!
        enddo !ii (loop on bands)
        SAFE_DEALLOCATE(cg)

!        if(iwritev.eq.1) then
!          write(itpv) irks,wfnv%ng,wfnv%nband,wfnv%nspin
!          write(itpv) (wfnv%isort(ii),ii=1,gvec%ng),
!     >      (((wfnv%cg(ii,jj,kk),ii=1,wfnv%ng),
!     >                           jj=1,wfnv%nband),
!     >                           kk=1,wfnv%nspin)
!        endif

!        deallocate(isendv)
!        deallocate(wfnv%cg)
        SAFE_DEALLOCATE_P(wfnc%cg)
        SAFE_DEALLOCATE_P(wfnc%isort)
 500    continue

! Cheol Hwan Park(2006.5.1)
#ifdef MPI
!        call MPI_BARRIER(MPI_COMM_WORLD,mpierr)
#endif
! End of CHP

!
      enddo !end loop over k-points (Cond bands)


! JRD
!---- Begin loop for valence bands--------------------------


       if (peinf%inode .eq. 0) then
         write(6,*) 'Finished Reading Conduction Bands!'
         write(6,*) 'Starting Valence Bands from WFNq_co!'
         write(6,*) ' '
       end if

      do irk=1,kpq%nrk

!JRD VERBOSE
!        write(6,*) 'irk = ', irk

        do ii=1,kg%nf
           if (irk.eq.kgq%indr(xct%indexq(ii))) then
              irks=ii
              goto 350
           endif
        enddo

!JRD VERBOSE
!        write(6,*) 'set irks'

        if(peinf%inode.eq.0) then
          read(26) ngq
          do ii=1,ngq
             read(26)
          enddo
          do ii=1,kpq%mnband
            read(26)
          enddo
        endif
        goto 700
 350    continue

        if(peinf%inode.eq.0) then
          read(26) ngq
          SAFE_ALLOCATE(wfnvq%isort, (gvec%ng))
          wfnvq%isort=0
          do ii=1,ngq
            read(26) kx,ky,kz
            call findvector(iout,kx,ky,kz,gvec)
            if(iout.eq.0) then
              call die('could not find gvec')
            endif
            wfnvq%isort(ii)=iout
          enddo
        endif
#ifdef MPI
        call MPI_BCAST(ngq,        1,      MPI_INTEGER,0, &
         MPI_COMM_WORLD,mpierr)
        if(peinf%inode.ne.0) then
           SAFE_ALLOCATE(wfnvq%isort, (gvec%ng))
        endif
        call MPI_BCAST(wfnvq%isort,gvec%ng,MPI_INTEGER,0, &
         MPI_COMM_WORLD,mpierr)
#endif

        ng=ngq

!JRD VERBOSE
!        write(6,*) 'broadcasted ng, isort'


!
!         Distribute vcks-quadruplets among the PEs
!
!        call logit('input_kernel_q:  calling distrib_kernel')
!        call distrib_kernel(xct,ng,gvec%kmax)

!       if (peinf%inode .eq. 0) then
!          write(6,*) ' '
!       end if

!
        wfnvq%ng=ngq
!        wfncq%ng=ngq
        wfnvq%nband=xct%nvband
!        wfncq%nband=peinf%nckmem
        wfnvq%nspin=kpq%nspin
!        wfncq%nspin=kpq%nspin
        SAFE_ALLOCATE(wfnvq%cg, (wfnvq%ng,wfnvq%nband,wfnvq%nspin))
!        allocate(wfncq%cg(wfncq%ng,wfncq%nband,wfncq%nspin))
        SAFE_ALLOCATE(cg, (ng,kpq%nspin))
!        allocate(wfncq%isort(gvec%ng))
!        wfncq%isort(:)=wfnvq%isort(:)
        ickmem=0

!JRD VERBOSE
!        write(6,*) 'allocated cg'
!        write(6,*) 'broadcasted ng, isort'

!       Determine which PEs will write the valence bands for this k-point
        iwritev=0
        do ii=1,peinf%nckpe
          if(peinf%ik(peinf%inode+1,ii).eq.kg%indr(irks)) then
            iwritev=1
            goto 810
          endif
        enddo
  810   continue

!       Determine to which PEs the valence bands for this k-point
!       need to be sent...
        SAFE_ALLOCATE(isendv, (peinf%npes))
        isendv=0
        if(peinf%inode.eq.0) then
          do jj=2,peinf%npes
            do ii=1,peinf%nckpe
              if(peinf%ik(jj,ii).eq.kg%indr(irks)) then
                isendv(jj)=1
                goto 820
              endif
            enddo
  820       continue
          enddo
        endif

!JRD VERBOSE
!        write(6,*) 'Determined relevant PEs'

!       if (peinf%inode .eq. 0) then
!          write(6,*) 'About to Band Loop'
!       end if

!
!       Loop over the bands
!
        do ii=1,kpq%mnband

!JRD VERBOSE
!        write(6,*) 'ii =', ii

        ! If we do not need this band, skip it...

!       JackD
          if (ii.lt.xct%nvbl) then
            if (peinf%inode.eq.0) then
               read(26)
            endif
            cycle
          endif

!JRD VERBOSE
!        write(6,*) 'Valence band', ii

          if(peinf%inode.eq.0) then
!           Read planewave coefficients for band ii
            read(26) ((cg(jj,kk),jj=1,ng),kk=1,kpq%nspin)
!           Check normalization of this band

!           if (peinf%inode .eq. 0) then
!             write(6,*) 'Bout to check norm', ii
!           end if

            do kk=1,kpq%nspin
              call checknorm('WFNq_co',ii,irks,kk,ng,cg(:,kk))
            enddo

!JRD VERBOSE
!        write(6,*) 'Finished checknorm'


!           if (peinf%inode .eq. 0) then
!             write(6,*) 'done check norm', ii
!           end if

          endif

!           if (peinf%inode .eq. 0) then
!             write(6,*) 'About to check if valence band', ii
!           end if


!         If ii is one of the selected valence bands...
          if(ii.ge.xct%nvbl) then

!           if (peinf%inode .eq. 0) then
!             write(6,*) 'In valence band', ii
!           end if

!       JRD Check Norm Again
!           if (peinf%inode .eq. 0) then
!               do ll = 1,wfnvq%nspin
!               xnorm=0.0d0
!               do kk = 1, wfnvq%ng
!               xnorm= xnorm +
!     >           cg(kk,ll)*CONJG(cg(kk,ll))
!               end do
!               xnorm = sqrt(xnorm)
!               write(6,*) 'Node: ',peinf%inode,' Norm:',
!     >            ii+1,xnorm
!               end do
!               write(6,*) 'ng: ', ng,' wfn ng: ',wfnvq%ng
!               write(6,*) 'nspin: ', wfnvq%nspin,
!     >             kpq%nspin
!               write(6,*) ' '
!           end if

#ifdef MPI
            if(peinf%inode.eq.0) then
              do jj=2,peinf%npes
!               write(*,*) jj, isendv(jj)
                if(isendv(jj).eq.1) then
                  dest=jj-1
                  tag=2000+dest
                  call MPI_SEND(cg,ng*kpq%nspin,MPI_SCALAR, &
                   dest,tag,MPI_COMM_WORLD,mpierr)
                endif
              enddo

!             if (peinf%inode .eq. 0) then
!             write(6,*) 'sent cg'
!             end if

!JRD VERBOSE
!        write(6,*) 'sent v-band'


            else
              if(iwritev.eq.1) then
                tag=2000+peinf%inode
                call MPI_RECV(cg,ng*kpq%nspin,MPI_SCALAR,0,tag, &
                 MPI_COMM_WORLD,mpistatus,mpierr)
              endif
            endif
#endif

!           if (peinf%inode .eq. 0) then
!             write(6,*) 'Bout to define wfnv-cg', ii
!           end if



            if(iwritev.eq.1) then


             wfnvq%cg(1:wfnvq%ng,-ii+1,1:wfnvq%nspin)= &
             cg(1:wfnvq%ng,1:wfnvq%nspin)


!       JRD Check Norm Again
!               do ll = 1,wfnvq%nspin
!               xnorm=0.0d0
!               do kk = 1, wfnvq%ng
!               xnorm= xnorm +
!     >           wfnvq%cg(kk,-ii+1,ll)*
!     >           CONJG(wfnvq%cg(kk,-ii+1,ll))
!               end do
!               xnorm = sqrt(xnorm)
!               write(6,*) 'Node: ',peinf%inode,' Norm:',
!     >            -ii+1,xnorm
!               end do
!               write(6,*) 'ng: ', ng,' wfn ng: ',wfnvq%ng
!               write(6,*) 'nspin: ', wfnvq%nspin,
!     >             kpq%nspin
!               write(6,*) ' '

!JRD VERBOSE
!        write(6,*) 'set wfnvq%cg'

            end if



          endif !ii is one of the selected valence band

!           if (peinf%inode .eq. 0) then
!             write(6,*) 'done valence stuff!', ii
!             write(6,*)
!           end if




        enddo !ii (loop on bands)

!       if (peinf%inode .eq. 0) then
!          write(6,*) 'Out of bandloop!'
!       end if

        SAFE_DEALLOCATE(cg)

        if(iwritev.eq.1) then

          write(itpv) irk,wfnvq%ng,wfnvq%nband,wfnvq%nspin
          write(itpv) (wfnvq%isort(ii),ii=1,gvec%ng), &
           (((wfnvq%cg(ii,jj,kk),ii=1,wfnvq%ng), &
                                jj=1,wfnvq%nband), &
                                kk=1,wfnvq%nspin)


! JRD: Check Norm Again

!          do ll = 1,wfnc%nspin
!           write(6,*) 'Node: ',peinf%inode
!           do kk = 1,wfnvq%nband
!             xnorm=0.0d0
!             do jj = 1, wfnvq%ng
!               xnorm= xnorm +
!     >           wfnvq%cg(jj,kk,ll)*
!     >           CONJG(wfnvq%cg(jj,kk,ll))
!              end do
!             xnorm = sqrt(xnorm)
!             write(6,*) 'Node: ',peinf%inode ,'irk: ', irk,' Norm:'
!     >         ,kk,' of ', wfnvq%nband*wfnc%nspin, xnorm, wfnvq%ng
!           end do
!           write(6,*) ' '
!          end do

        endif

        SAFE_DEALLOCATE(isendv)
        SAFE_DEALLOCATE_P(wfnvq%cg)
        SAFE_DEALLOCATE_P(wfnvq%isort)
!        deallocate(wfncq%cg)
!        deallocate(wfncq%isort)
 700    continue

      enddo !end loop over k-points

      if (peinf%inode .eq. 0) then
        write(6,*) 'Finished reading valence bands'
      endif

      SAFE_DEALLOCATE(indxk)

! Write out info about xtal

      if(peinf%inode.eq.0) then
        write(6,3004)
 3004   format(/,2x,'crystal wavefunctions read from tape WFN_co')
        write(6,3007) kg%nr
 3007   format(/,6x,'nrk= ',i6,26x)
        write(6,'(12x,3f10.4)') ((kg%r(ii,jj),ii=1,3),jj=1,kg%nr)
        write(6,3070) kg%nf,kg%sz
 3070   format(/,6x,'nfk= ',i6,4x,'ksz=',f10.5)

        close(25)
      endif ! node 0

      close(itpc)
      call open_file(itpc,file=filenamec,form='unformatted')

      if(xct%iwriteint == 0) then
#ifdef MPI
        call MPI_Barrier(MPI_COMM_WORLD, mpierr)
#endif
      endif

      POP_SUB(input_kernel_q)

      return
      end subroutine input_kernel_q
