!==========================================================================
!
! Routines:
!
! (1) excwf     Originally By MLT               Last Modifed 7/1/2008 (JRD)
!
!     input: ipe (=label of "source" PE)
!            gvec, peinf types
!            wfnct, wfnvt = conduction/valence states stored by
!            processor ipe
!     output: wfncp, wfnvp = conduction/valence states sent from
!               processor ipe to all others
!
!     Send conduction/valence states from source PE, with label ipe, to
!     all other PEs.
!     The variables wfnct, wfnvt at PEs different from ipe remain untouched!
!
!=============================================================================

#include "f_defs.h"

subroutine excwf(gvec,wfncp,wfnct,wfnvp,wfnvt,ipe)

  use global_m
  implicit none

  type (gspace), intent(in) :: gvec
  type (wavefunction), intent(out) :: wfncp
  type (wavefunction), intent(in)  :: wfnct
  type (wavefunction), intent(out) :: wfnvp
  type (wavefunction), intent(in)  :: wfnvt
  integer, intent(in) :: ipe

  integer :: i, j, k
  
  PUSH_SUB(excwf)

  if(peinf%inode.eq.ipe) then
    wfnvp%ng=wfnvt%ng
    wfnvp%nband=wfnvt%nband
    wfnvp%nspin=wfnvt%nspin
    wfncp%ng=wfnct%ng
    wfncp%nband=wfnct%nband
    wfncp%nspin=wfnct%nspin
  endif

#ifdef MPI
  call MPI_BCAST(wfnvp%ng,    1,MPI_INTEGER,ipe, MPI_COMM_WORLD,mpierr)
  call MPI_BCAST(wfnvp%nband, 1,MPI_INTEGER,ipe, MPI_COMM_WORLD,mpierr)
  call MPI_BCAST(wfnvp%nspin, 1,MPI_INTEGER,ipe, MPI_COMM_WORLD,mpierr)
  call MPI_BCAST(wfncp%ng,    1,MPI_INTEGER,ipe, MPI_COMM_WORLD,mpierr)
  call MPI_BCAST(wfncp%nband, 1,MPI_INTEGER,ipe, MPI_COMM_WORLD,mpierr)
  call MPI_BCAST(wfncp%nspin, 1,MPI_INTEGER,ipe, MPI_COMM_WORLD,mpierr)
#endif
  
  if( peinf%inode.eq.0) then
    write(6,*) ' excwf - allocating ', &
      ((dble(wfnvp%ng)*dble(wfnvp%nband)*dble(wfnvp%nspin) &
      +dble(wfncp%ng)*dble(wfncp%nband)*dble(wfncp%nspin))*16.d0 &
      +(2.d0*dble(gvec%ng))*2.d0)/(1024.d0)**3.d0, ' GB'
    write(6,*) '      wfnvp,wfncp%ng = ', wfnvp%ng, wfncp%ng
    write(6,*) '   wfnvp,wfncp%nband = ', wfnvp%nband, wfncp%nband
    write(6,*) '   wfnvp,wfncp%nspin = ', wfnvp%nspin, wfncp%nspin
    write(6,*) '             gvec%ng = ', gvec%ng
  endif
  
  SAFE_ALLOCATE(wfnvp%cg, (wfnvp%ng,wfnvp%nband,wfnvp%nspin))
  SAFE_ALLOCATE(wfnvp%isort, (gvec%ng))
  SAFE_ALLOCATE(wfncp%cg, (wfncp%ng,wfncp%nband,wfncp%nspin))
  SAFE_ALLOCATE(wfncp%isort, (gvec%ng))
  
  if(peinf%inode.eq.ipe) then
    forall( i=1:size(wfnvp%cg,1), j=1:size(wfnvp%cg,2), k=1:size(wfnvp%cg,3) ) wfnvp%cg(i,j,k)=wfnvt%cg(i,j,k)
    forall( i=1:size(wfnvp%isort) ) wfnvp%isort(i)=wfnvt%isort(i)
    forall( i=1:size(wfncp%cg,1), j=1:size(wfncp%cg,2), k=1:size(wfncp%cg,3) ) wfncp%cg(i,j,k)=wfnct%cg(i,j,k)
    forall( i=1:size(wfncp%isort) ) wfncp%isort(i)=wfnct%isort(i)
  endif
  
#ifdef MPI
  
  call MPI_BCAST(wfnvp%isort,gvec%ng, MPI_INTEGER,ipe, MPI_COMM_WORLD,mpierr)
  call MPI_BCAST(wfncp%isort,gvec%ng, MPI_INTEGER,ipe, MPI_COMM_WORLD,mpierr)
  
  call MPI_BCAST(wfnvp%cg(1,1,1),wfnvp%ng*wfnvp%nband*wfnvp%nspin, MPI_SCALAR,ipe,MPI_COMM_WORLD,mpierr)
  
  call MPI_BCAST(wfncp%cg(1,1,1),wfncp%ng*wfncp%nband*wfncp%nspin, MPI_SCALAR,ipe,MPI_COMM_WORLD,mpierr)
  
#endif
  
  POP_SUB(excwf)
  
  return
end subroutine excwf
