!================================================================================
!
! Routines:
!
! (1) epscopy()  Originally By MLT               Last Modified: 5/5/2008 (JRD)
!
!     This routine reads in epsmat/eps0mat and creates temporary files INT_EPS_*
!     if comm_disk option is on.
!
!     Input: crys,gvec,syms types
!            xct%ecute
!            xct%ecutg
!
!     Output: qg type
!             INT_EPS_* files
!
!================================================================================

#include "f_defs.h"

subroutine epscopy(crys,gvec,syms,qg,xct,q0vec)

  use global_m
  use fullbz_m
  use misc_m
  implicit none

  type (crystal), intent(in) :: crys
  type (gspace), intent(in) :: gvec
  type (symmetry), intent(in) :: syms
  type (grid), intent(out) :: qg
  type (xctinfo), intent(inout) :: xct
  real(DP), intent(out) :: q0vec(3)

!---------------------------
! From tapes 10 and 11

  integer :: igamma,nrq0,nrq1,nmtx,ng,ngmax,iowner
  real(DP) :: q0(3),qk(3),q0len
  real(DP), allocatable :: q1(:,:),eknq(:)
  SCALAR, allocatable :: epscol(:)

!---------------------------
! Local stuff

  character :: ajname*6,adate*10
  character :: ajname2*6,adate2*10
  character :: filename*20,tmpstr*100
  character :: tmpfn*16
  integer :: ii,jj,kk,ll,nold,gx,gy,gz,ngt,nmtxt
  integer :: iout,irq,qgrid(3)
  real(DP) :: gmax_in,tsec(2),emax,qshift(3)

  integer, allocatable :: oldx(:),oldy(:),oldz(:),isrtold(:)
  real(DP), allocatable :: ekold(:)
  logical :: skip_checkbz

  PUSH_SUB(epscopy)

  qgrid(:)=0
  SAFE_ALLOCATE(eknq, (gvec%ng))

!----------------- Read information for inverse dielectric matrix for q->0 tape10 --

  if(peinf%inode.eq.0) then

    call open_file(unit=10,file='eps0mat',form='unformatted',status='old')
    call open_file(unit=11,file='epsmat',form='unformatted',status='old',iostat=igamma)
    
    read(10) 
    read(10) ii
    if (ii.ne.0) call die('epscopy: freq_dep')
    read(10)
    read(10)
    read(10)
    read(10)
    read(10)
    read(10)
    read(10) nold
    read(10) ng, nmtx
    call close_file(10)
    
    xct%nmtxmax = nmtx
    
    if(igamma.eq.0) then
      read(11) 
      read(11) ii
      if (ii.ne.0) call die('epscopy: freq_dep')
      read(11)
      read(11)
      read(11)
      read(11)
      read(11)
      read(11) nrq1
      read(11) nold
      ngmax= 0
      do ii=1,nrq1
        read(11) ngt, nmtxt
        read(11)
        read(11)
        do jj = 1, nmtxt
          read(11)
        enddo
        if (ngt.gt.ngmax) ngmax= ngt
        if (nmtxt.gt.xct%nmtxmax) xct%nmtxmax= nmtxt
      enddo
      call close_file(11)
    else
      nrq1=0
    endif
    
    call open_file(unit=10,file='eps0mat',form='unformatted',status='old')
    
    SAFE_ALLOCATE(oldx, (nold))
    SAFE_ALLOCATE(oldy, (nold))
    SAFE_ALLOCATE(oldz, (nold))
    SAFE_ALLOCATE(isrtold, (ng))
    SAFE_ALLOCATE(ekold, (ng))
    
    read(10) ajname,adate
    read(10)
    read(10) (qgrid(ii),ii=1,3)
    read(10)
    read(10)
    read(10)
    read(10) gmax_in
    read(10) nrq0,(q0(ii),ii=1,3)
    read(10) nold,(oldx(ii),oldy(ii),oldz(ii),ii=1,nold)
    if(nrq0.gt.1) then
      call die("There is more than one q-point in eps0mat.", only_root_writes = .true.)
    endif

    write(6,3002)
3002 format(/,2x,'epsilon matrix for q->0 read from eps0mat')
    write(6,3003) nrq0,gmax_in
3003 format(/,6x,'nrq0= ',i3, ' gmax= ',f10.3)
    write(6,'(12x,a,3f10.3)') 'q0 = ',(q0(ii),ii=1,3)
  endif
#ifdef MPI
  call MPI_BCAST(nrq0,1,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
  call MPI_BCAST(nrq1,1,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
  call MPI_BCAST(xct%nmtxmax,1,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
  call MPI_BCAST(igamma,1,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
  call MPI_BCAST(q0,3,MPI_REAL_DP,0,MPI_COMM_WORLD,mpierr)
#endif
  
  xct%maxpet=xct%nmtxmax/peinf%npes
  if (mod(xct%nmtxmax,peinf%npes) .ne. 0) then
    xct%maxpet=xct%maxpet+1
  endif

  SAFE_ALLOCATE(xct%nmtxa, (nrq1+1))
  if (peinf%inode .eq. 0 .or. xct%bLowComm) then
    SAFE_ALLOCATE(xct%isrtq, (gvec%ng,nrq1+1))
    SAFE_ALLOCATE(xct%isrtqi, (gvec%ng,nrq1+1))
  endif
  if (xct%iwriteint .eq. 1) then
    if (xct%bLowComm) then
      SAFE_ALLOCATE(xct%epscol, (xct%nmtxmax,xct%nmtxmax,nrq1+1))
    else 
      SAFE_ALLOCATE(xct%epscol, (xct%nmtxmax,xct%maxpet,nrq1+1))
    endif
    SAFE_ALLOCATE(xct%epsown, (xct%nmtxmax))
    SAFE_ALLOCATE(xct%epsowni, (xct%maxpet,peinf%npes))
  endif
  SAFE_ALLOCATE(xct%maxpe, (peinf%npes))
  
  xct%maxpe=0
  if (xct%iwriteint .eq. 0) then
    xct%maxpe(1) = xct%nmtxmax
  endif
  
  SAFE_ALLOCATE(xct%epsdiag, (xct%nmtxmax,nrq1+1))

! Read q->0 dielectric matrix

  if(peinf%inode.eq.0) then
!        write(6,*) ' '
!        call logit('epscopy:  Reading eps(ii,jj) from unit 10',
!     >   peinf)
    read(10) ng,nmtx,(isrtold(ii),jj,ii=1,ng)
    read(10) (ekold(ii),ii=1,ng)
    read(10) (qk(ii),ii=1,3)

    xct%isrtq(:,1)= 0
    xct%isrtqi(:,1)= 0

!---------------------
! Sort the eps. matrix elements according to gvec%.
! Emax is some large energy, bigger than xct%ecute (but it does not
! need to be as large as the ekmax used to write epsmat/eps0mat).
! Check if the value of emax is OK.

!        emax=xct%ecute + 5.d0*(xct%ecutg-xct%ecute)
!        if (emax.gt.gvec%ekin(gvec%ng)/4.d0) emax= &
!         gvec%ekin(gvec%ng)/4.d0
    emax=xct%ecutg

    do ii=1,ng
      if (ekold(isrtold(ii)).lt.emax) then
        gx=oldx(isrtold(ii))
        gy=oldy(isrtold(ii))
        gz=oldz(isrtold(ii))
        call findvector(iout,gx,gy,gz,gvec)
        if (iout.gt.gvec%ng) write(0,*) ' WARNING: eps ',iout,gvec%ng
        if (iout.le.0) write(0,*) ' WARNING: eps ',iout

!--------------------------------
! isrtq/isrtqi have the sorting of G-vectors: from gvec%k to
! eps (isrtq), and from eps to gvec%k (isrtqi)

        if (peinf%inode .eq. 0) then
          xct%isrtq(ii,1)=iout
          xct%isrtqi(iout,1)=ii
        endif
      endif
    enddo
    SAFE_DEALLOCATE(isrtold)
    SAFE_DEALLOCATE(ekold)
    SAFE_DEALLOCATE(oldx)
    SAFE_DEALLOCATE(oldy)
    SAFE_DEALLOCATE(oldz)
  endif

! JRD: The Below is commented because we currently don`t symmetrize eps

!! Find g=0 in main list
!
!      call findvector(iout,0,0,0,gvec)
!
!! Find g=0 in eps gvector list
!
!      iout = isrtqi(iout)
!
!! For each g, find -g in the gvector list
!
!      allocate(minusgidx(nmtx))
!      minusgidx = 0
!      do ii=1,nmtx
!        ioutt = isrtq(ii)
!        if (iout.eq.0) cycle
!        gx = gvec%k(1,ioutt)
!        gy = gvec%k(2,ioutt)
!        gz = gvec%k(3,ioutt)
!        call findvector(ioutt,-gx,-gy,-gz,gvec)
!        if (ioutt.gt.gvec%ng.or.iout.le.0) write(0,*)
!     >   'g to -g mapping for ii=',ii,' ioutt=',ioutt
!        minusgidx(ii) = isrtqi(ioutt)
!      enddo

! Write header for example elements

#ifdef VERBOSE
  if (peinf%inode .eq. 0) write(6,*) ' '
  if (peinf%inode .eq. 0) write(6,*) 'Example elements: '
#endif

  q0vec=q0
  q0 = 0.0d0
  q0len=0d0
  do ii = 1,3
    q0len=q0len+abs(q0vec(ii))
  enddo

! JRD: Write header of INT_EPS_*

  irq=0
  
  if (peinf%inode .eq. 0 .and. xct%iwriteint .eq. 0) then
    write(filename,'(a,i4.4)') 'INT_EPS_', irq
    call open_file(17,file=filename,form='unformatted',status='replace')
  endif

#ifdef MPI
  call MPI_BCAST(nmtx,1,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
#endif

  xct%nmtxa(1)=nmtx

!------------------------------
! JRD: Finally Read In Eps (Proc 0)

  SAFE_ALLOCATE(epscol, (nmtx))
  do jj =1,nmtx
    if (peinf%inode .eq. 0) then
      read(10) (epscol(ii),ii=1,nmtx)

!------------------------------
! SIB: print out a small section of the dielectric matrix for testing purposes

#ifdef VERBOSE
      if (jj .le. 4) then
        do ii=1,4
          kk = xct%isrtq(ii,1)
          ll = xct%isrtq(jj,1)
          write(tmpstr,'(3i3,1x,3i3,1x,2f10.5)') gvec%k(:,kk),gvec%k(:,ll),epscol(ii)
          call logit(tmpstr)
        enddo
      endif
#endif

! JRD: We now keep the wings, it isn`t too hard to deal with them
! and throwing them away is really poor for metals and graphene-type systems.

!! Zero wings
!
!          do ii=1,nmtx
!            if (ii.ne.iout) then
!              eps(ii,iout) = 0.0d0
!              eps(iout,ii) = 0.0d0
!            endif
!          enddo
!
!! SIB: if truncating the coulomb interaction, then the dielectric
!! constant is 1 exactly at q=0.
!
!! JRD: This should only done for semiconductors...
!
!           if (peinf%inode.eq.0) write(6,*)
!     >      'Coulomb truncation: eps(0,0) set to 1 for q->0'
!             eps(iout,iout) = 1.0d0
!           endif

! JRD: I had to comment out the entire section below because, if we don`t allocate
! eps(neps,neps) we don`t have all the opposite G vecs in memory.  We should think of
! a way to put this back in the future.

!!-------------------------------
!! Symmetrize Eps
!
!! SIB:  since we want the q=0 dielectric function but we have the
!! q0<>0 but small dielectric, we can average over q0 and -q0
!! to get a better dielectric (linear terms in q0 will be canceled)
!
!          if (peinf%inode.eq.0) write(6,*) 'After Averaging over q0',
!     >     ' and -q0 for q->0:'
!
!! Copy eps(q0) into a temporay
!
!          allocate(tempcol(nmtx))
!          tempeps = epscol
!
! Now add in contribution from -q0 which means CONJG(eps(-g,-gp))
!
!          do ii=1,nmtx
!
!            kk = minusgidx(ii)
!            ll = minusgidx(jj)
!            if (kk.eq.0 .or. ll.eq.0) then
!              tempeps(ii,jj) = 0.0d0
!              cycle
!            endif
!
!#ifdef CPLX
!            tempeps(ii,jj) = tempeps(ii,jj) + CONJG(eps(kk,ll))
!#else
!            tempeps(ii,jj) = tempeps(ii,jj) + eps(kk,ll)
!#endif
!
!          enddo
!
!! Average over q0 and -q0 and put back into eps
!
!          eps = 0.5d0*tempeps
!          deallocate(tempeps)
!
!#ifdef VERBOSE
!          do ii=1,4
!            do jj=1,4
!              kk = isrtq(ii)
!              ll = isrtq(jj)
!              write(tmpstr,'(3i3,x,3i3,x,2f10.5)')
!     >         gvec%k(:,kk),gvec%k(:,ll),eps(ii,jj)
!              call logit(tmpstr)
!            enddo
!          enddo
!#endif

! Report on dielectric constant

      if (jj .eq. 1) then
        write(6,*) ' '
        write(6,*) 'dielectric constant : ',1.d0/epscol(1)
        write(6,*) ' '
      endif
    endif

! Write dielectric matrix column for q->0 to tape17 unformatted

    if (xct%iwriteint .eq. 0) then
      if (peinf%inode .eq. 0) then
        write(17) epscol(1:nmtx)
      endif
    else
#ifdef MPI
      call MPI_BCAST(epscol,nmtx,MPI_SCALAR,0,MPI_COMM_WORLD,mpierr)
#endif
      xct%epsown(jj)=(jj/peinf%npes)
      if (mod(jj,peinf%npes).ne.0) xct%epsown(jj) = xct%epsown(jj) +1
      iowner=mod(jj,peinf%npes)
      xct%epsowni(xct%epsown(jj),iowner+1)=jj
      if (xct%maxpe(iowner+1) .lt. xct%epsown(jj)) xct%maxpe(iowner+1) = xct%epsown(jj)

      if (xct%bLowComm) then
        xct%epscol(1:nmtx,jj,1)=epscol(:)
      else
        if (iowner .eq. peinf%inode) then
          xct%epscol(1:nmtx,xct%epsown(jj),1)=epscol(:)
        endif
      endif
    endif
    if (peinf%inode .eq. 0) then
      xct%epsdiag(jj,1) = epscol(jj)  
    endif
  enddo
  SAFE_DEALLOCATE(epscol)
  
  if (xct%iwriteint .eq. 0 .and. peinf%inode .eq. 0) then
    call close_file(17)
  endif
  
  if (peinf%inode .eq. 0) then
    call close_file(10)
  endif


!----------------- Read dielectric matrices from tape11 for q<>0 --------------------


  if(igamma.ne.0) then
    nrq1=0
  else

! Have to allocate oldx,oldy, etc. again...

    if(peinf%inode.eq.0) then
      call open_file(unit=11,file='epsmat',form='unformatted',status='old')
      SAFE_ALLOCATE(oldx, (nold))
      SAFE_ALLOCATE(oldy, (nold))
      SAFE_ALLOCATE(oldz, (nold))
      SAFE_ALLOCATE(isrtold, (ngmax))
      SAFE_ALLOCATE(ekold, (ngmax))
      SAFE_ALLOCATE(q1, (3,nrq1))
      read(11) ajname2,adate2
      read(11)
      read(11) (qgrid(ii),ii=1,3)
      read(11)
      read(11)
      read(11)
      read(11) gmax_in
      read(11) nrq1,((q1(ii,jj),ii=1,3),jj=1,nrq1)
      read(11) nold,(oldx(ii),oldy(ii),oldz(ii),ii=1,nold)
    endif

#ifdef MPI
    call MPI_BCAST(nrq1,1,     MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
    if(peinf%inode.ne.0) then
      SAFE_ALLOCATE(q1, (3,nrq1))
    endif
    call MPI_BCAST(q1,3*nrq1,  MPI_REAL_DP,0,MPI_COMM_WORLD,mpierr)
#endif

    if(peinf%inode.eq.0) then
      write(6,3004)
3004  format(/,2x,'epsilon matrix for q<>0 read from epsmat')
      write(6,3005) nrq1,gmax_in
3005  format(/,6x,'nrq=  ',i3, ' gmax= ',f10.3)
      write(6,'(12x,3f10.4)') ((q1(ii,jj),ii=1,3),jj=1,nrq1)
    endif
    
  endif
  qg%nr=nrq1+1
  SAFE_ALLOCATE(qg%r, (3,qg%nr))
  qg%r(1:3,1)=q0
  if(nrq1.ne.0) then
    qg%r(1:3,2:qg%nr)=q1(1:3,1:nrq1)
    SAFE_DEALLOCATE(q1)
  endif

! Read inverse dielectric matrices from tape11 for q<>0

  if(igamma == 0) then

    do irq=1,nrq1
      if(peinf%inode.eq.0) then
        isrtold=0
        ekold=0.d0
        read(11) ng,nmtx,(isrtold(ii),jj,ii=1,ng)
        xct%isrtqi(:,irq+1)=0
        xct%isrtq(:,irq+1)=0
        read(11) (ekold(ii),ii=1,ng)
        read(11) (qk(ii),ii=1,3)
        
        do ii=1,ng
          if (ekold(isrtold(ii)).lt.emax) then
            gx=oldx(isrtold(ii))
            gy=oldy(isrtold(ii))
            gz=oldz(isrtold(ii))
            call findvector(iout,gx,gy,gz,gvec)
            if (iout.gt.gvec%ng) write(0,*) ' WARNING: eps ',iout,gvec%ng
            if (iout.le.0) write(0,*) ' WARNING: eps ',iout
            xct%isrtq(ii,irq+1)=iout
            xct%isrtqi(iout,irq+1)=ii
            eknq(ii)=ekold(isrtold(ii))
          endif
        enddo

!----------------------------
! Copy dielectric matrices to tape17 unformatted

! Actually, the dielectric matrix at each q-point is written
! in a separate INT_EPS_* file. INT_EPS_0000 has the q=0 point.
! q-points in IBZ = qg%nrk < 10001

        if (xct%iwriteint .eq. 0) then
          if (irq.lt.10000) then
            write(filename,'(a,i4.4)') 'INT_EPS_', irq
          else
            call die("irq > 9999")
          endif

          call open_file(17,file=filename,form='unformatted',status='replace')
        endif
      endif
      
#ifdef MPI
      call MPI_BCAST(nmtx,1,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
#endif
      
      xct%nmtxa(irq+1)=nmtx
      SAFE_ALLOCATE(epscol, (nmtx))
      
      do jj=1,nmtx
        if (peinf%inode .eq. 0) then
          read(11) (epscol(ii),ii=1,nmtx)
          xct%epsdiag(jj,irq+1)=epscol(jj)
        endif
        if (xct%iwriteint .eq. 0) then
          if (peinf%inode .eq. 0) write(17) epscol(1:nmtx)
        else
#ifdef MPI
          call MPI_BCAST(epscol,nmtx,MPI_SCALAR,0,MPI_COMM_WORLD,mpierr)
#endif
          xct%epsown(jj)=(jj/peinf%npes)
          if (mod(jj,peinf%npes).ne.0) xct%epsown(jj) = xct%epsown(jj) +1
          iowner=mod(jj,peinf%npes)
          xct%epsowni(xct%epsown(jj),iowner+1)=jj
          if (xct%maxpe(iowner+1) .lt. xct%epsown(jj)) xct%maxpe(iowner+1) = xct%epsown(jj)

          if (xct%bLowComm) then
            xct%epscol(1:nmtx,jj,irq+1)=epscol(:)
          else
            if (iowner .eq. peinf%inode) then
              xct%epscol(1:nmtx,xct%epsown(jj),irq+1)=epscol(:)
            endif
          endif

        endif
        
      enddo
      
      if (xct%iwriteint .eq. 0 .and. peinf%inode.eq.0) then
        call close_file(17)
      endif

      SAFE_DEALLOCATE(epscol)
    enddo
    
    if (peinf%inode .eq. 0) then
      SAFE_DEALLOCATE(isrtold)
      SAFE_DEALLOCATE(ekold)
      SAFE_DEALLOCATE(oldx)
      SAFE_DEALLOCATE(oldy)
      SAFE_DEALLOCATE(oldz)
      call close_file(11)
    endif
    
  endif
  
  SAFE_DEALLOCATE(eknq)

!-------------------------
! Generate full brillouin zone from irreducible wedge
! rq -> fq

  call timacc(7,1,tsec)
  call fullbz(crys,syms,qg,syms%ntran,skip_checkbz,wigner_seitz=.true.,paranoid=.true.)
  qshift(:)=0.0d0
  if (igamma.ne.0) then
    tmpfn='eps0mat'
  else
    tmpfn='epsmat'
  endif
  if (.not. skip_checkbz) then
    call checkbz(qg%nf,qg%f,qgrid,qshift,crys%bdot,tmpfn,'q',.true.,xct%freplacebz,xct%fwritebz)
  endif
  call timacc(7,2,tsec)
  
  if(peinf%inode.eq.0) then
    write(6,170) qg%nf,qg%sz
170 format(/,6x,'nfq=  ',i3,5x,'qsz=',f10.5)
    do ii=1,qg%nf
      write(6,'(i5,3f10.6)') ii, qg%f(:,ii)
    enddo
  endif
  
#ifdef MPI
  call MPI_Barrier(MPI_COMM_WORLD,mpierr)
  ! Doing the communication once here. Saves us a communication each time mtxel_kernel
  ! is called
  if (xct%bLowComm) then
    call MPI_BCAST(xct%isrtq,gvec%ng*(nrq1+1),MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
    call MPI_BCAST(xct%isrtqi,gvec%ng*(nrq1+1),MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
  endif
  call MPI_BCAST(xct%epsdiag,xct%nmtxmax*(nrq1+1),MPI_SCALAR,0,MPI_COMM_WORLD,mpierr)
#endif
  
  POP_SUB(epscopy)
  
  return
end subroutine epscopy
